/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edqs;

import com.google.protobuf.ByteString;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ObjectType;
import org.thingsboard.server.common.data.edqs.EdqsEventType;
import org.thingsboard.server.common.data.edqs.EdqsObject;
import org.thingsboard.server.common.data.edqs.EdqsState;
import org.thingsboard.server.common.data.edqs.EdqsSyncRequest;
import org.thingsboard.server.common.data.edqs.Entity;
import org.thingsboard.server.common.data.edqs.ToCoreEdqsMsg;
import org.thingsboard.server.common.data.edqs.ToCoreEdqsRequest;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.JsonDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.ota.DeviceGroupOtaPackage;
import org.thingsboard.server.common.msg.edqs.EdqsApiService;
import org.thingsboard.server.common.msg.edqs.EdqsService;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.edqs.processor.EdqsProducer;
import org.thingsboard.server.edqs.state.EdqsPartitionService;
import org.thingsboard.server.edqs.util.DefaultEdqsMapper;
import org.thingsboard.server.edqs.util.EdqsMapper;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.discovery.DiscoveryService;
import org.thingsboard.server.queue.discovery.HashPartitionService;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.environment.DistributedLock;
import org.thingsboard.server.queue.environment.DistributedLockService;
import org.thingsboard.server.queue.provider.EdqsClientQueueFactory;
import org.thingsboard.server.queue.util.AfterStartUp;
import org.thingsboard.server.service.edqs.DefaultEdqsService;
import org.thingsboard.server.service.edqs.EdqsSyncService;

@Service
@ConditionalOnProperty(value={"queue.edqs.sync.enabled"}, havingValue="true")
public class DefaultEdqsService
implements EdqsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultEdqsService.class);
    private final EdqsClientQueueFactory queueFactory;
    private final EdqsMapper edqsMapper;
    private final EdqsSyncService edqsSyncService;
    private final EdqsApiService edqsApiService;
    private final DistributedLockService distributedLockService;
    private final AttributesService attributesService;
    private final EdqsPartitionService edqsPartitionService;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final DiscoveryService discoveryService;
    @Autowired
    @Lazy
    private TbClusterService clusterService;
    @Autowired
    @Lazy
    private HashPartitionService hashPartitionService;
    @Value(value="${queue.edqs.api.auto_enable:true}")
    private boolean autoEnableApi;
    @Value(value="${queue.edqs.readiness_check_interval:60000}")
    private int edqsReadinessCheckInterval;
    private EdqsProducer eventsProducer;
    private ExecutorService executor;
    private ScheduledExecutorService scheduler;
    private DistributedLock syncLock;
    private EdqsState state;

    @PostConstruct
    private void init() {
        this.executor = ThingsBoardExecutors.newWorkStealingPool((int)12, this.getClass());
        this.scheduler = ThingsBoardExecutors.newSingleThreadScheduledExecutor((String)"edqs-check");
        this.eventsProducer = EdqsProducer.builder().producer(this.queueFactory.createEdqsEventsProducer()).partitionService(this.edqsPartitionService).build();
        this.syncLock = this.distributedLockService.getLock("edqs_sync");
        this.state = new EdqsState();
    }

    @AfterStartUp(order=11)
    public void onStartUp() {
        if (!this.serviceInfoProvider.isService(ServiceType.TB_CORE)) {
            return;
        }
        if (this.edqsApiService.isSupported()) {
            this.scheduler.scheduleWithFixedDelay(() -> {
                if (!this.hashPartitionService.isSystemPartitionMine(ServiceType.TB_CORE)) {
                    return;
                }
                ArrayList<TransportProtos.ServiceInfo> servers = new ArrayList<TransportProtos.ServiceInfo>(this.discoveryService.getOtherServers());
                servers.add(this.serviceInfoProvider.getServiceInfo());
                List<TransportProtos.ServiceInfo> readyEdqsServers = servers.stream().filter(serviceInfo -> serviceInfo.getServiceTypesList().contains((Object)ServiceType.EDQS.name())).filter(TransportProtos.ServiceInfo::getReady).toList();
                boolean changed = this.state.updateEdqsReady(!readyEdqsServers.isEmpty());
                if (changed) {
                    this.broadcastEdqsReady(this.state.getEdqsReady().booleanValue());
                }
            }, 0L, this.edqsReadinessCheckInterval, TimeUnit.MILLISECONDS);
        }
        this.executor.submit(() -> {
            try {
                EdqsSyncState syncState = this.getSyncState();
                if (this.edqsSyncService.isSyncNeeded() || syncState == null || syncState.getStatus() != EdqsState.EdqsSyncStatus.FINISHED) {
                    if (this.hashPartitionService.isSystemPartitionMine(ServiceType.TB_CORE)) {
                        this.processSystemRequest(ToCoreEdqsRequest.builder().syncRequest(new EdqsSyncRequest()).build());
                    }
                } else {
                    this.onSyncStatusUpdate(EdqsState.EdqsSyncStatus.FINISHED);
                }
            }
            catch (Throwable e) {
                log.error("Failed to start EDQS service", e);
            }
        });
    }

    public void processSystemRequest(ToCoreEdqsRequest request) {
        log.info("Processing system request {}", (Object)request);
        if (request.getSyncRequest() != null) {
            this.saveSyncState(EdqsState.EdqsSyncStatus.REQUESTED);
        }
        this.broadcast(ToCoreEdqsMsg.builder().syncRequest(request.getSyncRequest()).apiEnabled(request.getApiEnabled()).build());
    }

    public void processSystemMsg(ToCoreEdqsMsg msg) {
        this.executor.submit(() -> {
            block14: {
                log.info("Processing system msg {}", (Object)msg);
                try {
                    if (msg.getApiEnabled() != null) {
                        if (msg.getApiEnabled().booleanValue()) {
                            this.state.setApiMode(EdqsState.EdqsApiMode.ENABLED);
                        } else {
                            this.state.setApiMode(EdqsState.EdqsApiMode.DISABLED);
                        }
                        log.info("New state: {}", (Object)this.state);
                    }
                    if (msg.getEdqsReady() != null) {
                        this.onEdqsReady(msg.getEdqsReady().booleanValue());
                    }
                    if (msg.getSyncStatus() != null) {
                        this.onSyncStatusUpdate(msg.getSyncStatus());
                    }
                    if (msg.getSyncRequest() == null) break block14;
                    this.syncLock.lock();
                    try {
                        EdqsState.EdqsSyncStatus status;
                        EdqsSyncState syncState = this.getSyncState();
                        if (syncState != null && ((status = syncState.getStatus()) == EdqsState.EdqsSyncStatus.FINISHED || status == EdqsState.EdqsSyncStatus.FAILED)) {
                            log.info("EDQS sync is already " + String.valueOf(status) + ", ignoring the msg");
                            return;
                        }
                        this.saveSyncState(EdqsState.EdqsSyncStatus.STARTED);
                        this.edqsSyncService.sync();
                        this.saveSyncState(EdqsState.EdqsSyncStatus.FINISHED);
                        this.broadcastSyncStatusUpdate(EdqsState.EdqsSyncStatus.FINISHED);
                    }
                    catch (Exception e) {
                        log.error("Failed to complete sync", (Throwable)e);
                        this.saveSyncState(EdqsState.EdqsSyncStatus.FAILED);
                        this.broadcastSyncStatusUpdate(EdqsState.EdqsSyncStatus.FAILED);
                    }
                    finally {
                        this.syncLock.unlock();
                    }
                }
                catch (Throwable e) {
                    log.error("Failed to process msg {}", (Object)msg, (Object)e);
                }
            }
        });
    }

    private void broadcastEdqsReady(boolean ready) {
        this.broadcast(ToCoreEdqsMsg.builder().edqsReady(Boolean.valueOf(ready)).build());
    }

    private void onEdqsReady(boolean ready) {
        this.state.updateEdqsReady(ready);
        this.checkState();
    }

    private void broadcastSyncStatusUpdate(EdqsState.EdqsSyncStatus status) {
        this.broadcast(ToCoreEdqsMsg.builder().syncStatus(status).build());
    }

    private void onSyncStatusUpdate(EdqsState.EdqsSyncStatus status) {
        this.state.setSyncStatus(status);
        this.checkState();
    }

    private void checkState() {
        if (!this.edqsApiService.isSupported()) {
            log.info("New state: {}. EDQS API not supported", (Object)this.state);
            return;
        }
        if (this.state.isApiReady()) {
            if (this.autoEnableApi) {
                if (this.state.getApiMode() == null || this.state.getApiMode() == EdqsState.EdqsApiMode.AUTO_DISABLED) {
                    this.state.setApiMode(EdqsState.EdqsApiMode.AUTO_ENABLED);
                    log.info("New state: {}. Auto-enabled EDQS API", (Object)this.state);
                } else {
                    log.info("New state: {}. API mode left as is", (Object)this.state);
                }
            } else {
                log.info("New state: {}. API auto-enabling is disabled", (Object)this.state);
            }
        } else if (this.state.isApiEnabled()) {
            this.state.setApiMode(EdqsState.EdqsApiMode.AUTO_DISABLED);
            log.info("New state: {}. Disabled EDQS API", (Object)this.state);
        } else {
            log.info("New state: {}. API left disabled", (Object)this.state);
        }
    }

    public boolean isApiEnabled() {
        return this.state.isApiEnabled();
    }

    public void onUpdate(TenantId tenantId, EntityId entityId, Object entity) {
        EntityType entityType = entityId.getEntityType();
        ObjectType objectType = ObjectType.fromEntityType((EntityType)entityType);
        if (this.ignoreEvent(tenantId, entity, objectType)) {
            log.trace("[{}][{}] Ignoring update event, type {} not supported", new Object[]{tenantId, entityId, entityType});
            return;
        }
        this.onUpdate(tenantId, objectType, (EdqsObject)DefaultEdqsMapper.toEntity((EntityType)entityType, (Object)entity));
    }

    public void onUpdate(TenantId tenantId, ObjectType objectType, EdqsObject object) {
        this.processEvent(tenantId, objectType, EdqsEventType.UPDATED, object);
    }

    public void onDelete(TenantId tenantId, EntityId entityId, Object entity) {
        EntityType entityType = entityId.getEntityType();
        ObjectType objectType = ObjectType.fromEntityType((EntityType)entityType);
        if (this.ignoreEvent(tenantId, entity, objectType)) {
            log.trace("[{}][{}] Ignoring deletion event, type {} not supported", new Object[]{tenantId, entityId, entityType});
            return;
        }
        this.onDelete(tenantId, objectType, (EdqsObject)new Entity(entityType, entityId.getId(), Long.MAX_VALUE));
    }

    private boolean ignoreEvent(TenantId tenantId, Object entity, ObjectType objectType) {
        return !this.isEdqsType(tenantId, objectType) || entity instanceof DeviceGroupOtaPackage;
    }

    public void onDelete(TenantId tenantId, ObjectType objectType, EdqsObject object) {
        this.processEvent(tenantId, objectType, EdqsEventType.DELETED, object);
    }

    protected void processEvent(TenantId tenantId, ObjectType objectType, EdqsEventType eventType, EdqsObject object) {
        this.executor.submit(() -> {
            try {
                String key = object.stringKey();
                Long version = object.version();
                TransportProtos.EdqsEventMsg.Builder eventMsg = TransportProtos.EdqsEventMsg.newBuilder().setObjectType(objectType.name()).setData(ByteString.copyFrom((byte[])this.edqsMapper.serialize(object))).setEventType(eventType.name());
                if (version != null) {
                    eventMsg.setVersion(version.longValue());
                }
                this.eventsProducer.send(tenantId, objectType, key, TransportProtos.ToEdqsMsg.newBuilder().setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).setTs(System.currentTimeMillis()).setEventMsg(eventMsg).build());
            }
            catch (Throwable e) {
                log.error("[{}] Failed to push {} event for {} {}", new Object[]{tenantId, eventType, objectType, object, e});
            }
        });
    }

    private boolean isEdqsType(TenantId tenantId, ObjectType objectType) {
        if (objectType == null) {
            return false;
        }
        if (!tenantId.isSysTenantId()) {
            return ObjectType.edqsTypes.contains(objectType);
        }
        return ObjectType.edqsSystemTypes.contains(objectType);
    }

    private void broadcast(ToCoreEdqsMsg msg) {
        this.clusterService.broadcastToCore(TransportProtos.ToCoreNotificationMsg.newBuilder().setToEdqsCoreServiceMsg(TransportProtos.ToEdqsCoreServiceMsg.newBuilder().setValue(ByteString.copyFrom((byte[])JacksonUtil.writeValueAsBytes((Object)msg)))).build());
    }

    private EdqsSyncState getSyncState() {
        EdqsSyncState state = ((Optional)this.attributesService.find(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, AttributeScope.SERVER_SCOPE, "edqsSyncState").get(30L, TimeUnit.SECONDS)).flatMap(KvEntry::getJsonValue).map(value -> (EdqsSyncState)JacksonUtil.fromString((String)value, EdqsSyncState.class)).orElse(null);
        log.info("EDQS sync state: {}", (Object)state);
        return state;
    }

    private void saveSyncState(EdqsState.EdqsSyncStatus status) {
        EdqsSyncState state = new EdqsSyncState(status);
        log.info("New EDQS sync state: {}", (Object)state);
        this.attributesService.save(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, AttributeScope.SERVER_SCOPE, (AttributeKvEntry)new BaseAttributeKvEntry((KvEntry)new JsonDataEntry("edqsSyncState", JacksonUtil.toString((Object)state)), System.currentTimeMillis())).get(30L, TimeUnit.SECONDS);
    }

    @PreDestroy
    private void stop() {
        this.executor.shutdown();
        this.scheduler.shutdownNow();
        this.eventsProducer.stop();
    }

    @ConstructorProperties(value={"queueFactory", "edqsMapper", "edqsSyncService", "edqsApiService", "distributedLockService", "attributesService", "edqsPartitionService", "serviceInfoProvider", "discoveryService"})
    @Generated
    public DefaultEdqsService(EdqsClientQueueFactory queueFactory, EdqsMapper edqsMapper, EdqsSyncService edqsSyncService, EdqsApiService edqsApiService, DistributedLockService distributedLockService, AttributesService attributesService, EdqsPartitionService edqsPartitionService, TbServiceInfoProvider serviceInfoProvider, DiscoveryService discoveryService) {
        this.queueFactory = queueFactory;
        this.edqsMapper = edqsMapper;
        this.edqsSyncService = edqsSyncService;
        this.edqsApiService = edqsApiService;
        this.distributedLockService = distributedLockService;
        this.attributesService = attributesService;
        this.edqsPartitionService = edqsPartitionService;
        this.serviceInfoProvider = serviceInfoProvider;
        this.discoveryService = discoveryService;
    }

    @Generated
    public EdqsState getState() {
        return this.state;
    }
}

