/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.stats;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeSettings;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.dao.cloud.CloudEventService;
import org.thingsboard.server.dao.cloud.EdgeSettingsService;
import org.thingsboard.server.dao.edge.stats.CloudStatsCounterService;
import org.thingsboard.server.dao.edge.stats.CloudStatsKey;
import org.thingsboard.server.dao.edge.stats.MsgCounters;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.queue.discovery.TopicService;
import org.thingsboard.server.queue.kafka.KafkaAdmin;
import org.thingsboard.server.queue.util.TbCoreComponent;

@TbCoreComponent
@ConditionalOnProperty(prefix="cloud.stats", name={"enabled"}, havingValue="true", matchIfMissing=false)
@Service
public class CloudStatsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudStatsService.class);
    private static final String CLOUD_EVENT_CONSUMER = "-cloud-event-consumer";
    private static final String CLOUD_EVENT_TS_CONSUMER = "-cloud-event-ts-consumer";
    private final TimeseriesService tsService;
    private final CloudStatsCounterService statsCounterService;
    private final TopicService topicService;
    private final EdgeSettingsService edgeSettingsService;
    private final CloudEventService cloudEventService;
    private final Optional<KafkaAdmin> kafkaAdmin;
    private TenantId tenantId;
    private EdgeId edgeId;
    @Value(value="${cloud.stats.ttl:30}")
    private int cloudStatsTtlDays;
    @Value(value="${cloud.stats.report-interval-millis:600000}")
    private long reportIntervalMillis;
    @Value(value="${service.type:monolith}")
    private String serviceType;

    @Scheduled(fixedDelayString="${cloud.stats.report-interval-millis:600000}", initialDelayString="${cloud.stats.report-interval-millis:600000}")
    public void reportStats() {
        log.debug("Reporting cloud communication stats...");
        this.initTenantIdAndEdgeId();
        long ts = System.currentTimeMillis() / this.reportIntervalMillis * this.reportIntervalMillis;
        MsgCounters counters = this.statsCounterService.getCounter(this.tenantId);
        this.kafkaAdmin.ifPresent(arg_0 -> this.prepareUplinkLag(arg_0));
        List<BasicTsKvEntry> statsEntries = List.of(this.entry(ts, CloudStatsKey.UPLINK_MSGS_ADDED.getKey(), counters.getMsgsAdded().get()), this.entry(ts, CloudStatsKey.UPLINK_MSGS_PUSHED.getKey(), counters.getMsgsPushed().get()), this.entry(ts, CloudStatsKey.UPLINK_MSGS_PERMANENTLY_FAILED.getKey(), counters.getMsgsPermanentlyFailed().get()), this.entry(ts, CloudStatsKey.UPLINK_MSGS_TMP_FAILED.getKey(), counters.getMsgsTmpFailed().get()), this.entry(ts, CloudStatsKey.UPLINK_MSGS_LAG.getKey(), counters.getMsgsLag().get()));
        this.saveTs(ts, statsEntries);
    }

    private void initTenantIdAndEdgeId() {
        if (this.tenantId == null || this.edgeId == null) {
            EdgeSettings edgeSettings = this.edgeSettingsService.findEdgeSettings();
            this.tenantId = TenantId.fromUUID((UUID)UUID.fromString(edgeSettings.getTenantId()));
            this.edgeId = new EdgeId(UUID.fromString(edgeSettings.getEdgeId()));
        }
    }

    private void prepareUplinkLag(KafkaAdmin kafkaAdmin) {
        String cloudEventConsumerGroupId = this.topicService.buildTopicName(this.serviceType + CLOUD_EVENT_CONSUMER);
        String cloudEventTsConsumerGroupId = this.topicService.buildTopicName(this.serviceType + CLOUD_EVENT_TS_CONSUMER);
        Set<String> groupIds = Set.of(cloudEventConsumerGroupId, cloudEventTsConsumerGroupId);
        Map groupIdToLag = kafkaAdmin.getTotalLagForGroupsBulk(groupIds);
        long lagCloudEvent = groupIdToLag.getOrDefault(cloudEventConsumerGroupId, 0L);
        long lagCloudEventTs = groupIdToLag.getOrDefault(cloudEventTsConsumerGroupId, 0L);
        this.statsCounterService.setUplinkMsgsLag(this.tenantId, lagCloudEvent + lagCloudEventTs);
    }

    private BasicTsKvEntry entry(long ts, String key, long value) {
        return new BasicTsKvEntry(ts, (KvEntry)new LongDataEntry(key, Long.valueOf(value)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTs(long ts, List<TsKvEntry> statsEntries) {
        try {
            ObjectNode entityBody = this.buildStatsJson(ts, statsEntries);
            long telemetryTtlSeconds = TimeUnit.DAYS.toSeconds(this.cloudStatsTtlDays);
            this.tsService.save(this.tenantId, (EntityId)this.edgeId, statsEntries, telemetryTtlSeconds);
            CloudEvent cloudEvent = new CloudEvent(this.tenantId, EdgeEventActionType.TIMESERIES_UPDATED, this.edgeId.getId(), CloudEventType.EDGE, (JsonNode)entityBody, null);
            ListenableFuture future = this.cloudEventService.saveTsKvAsync(cloudEvent);
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)MoreExecutors.directExecutor());
        }
        finally {
            this.statsCounterService.clear();
        }
    }

    private ObjectNode buildStatsJson(long ts, List<TsKvEntry> statsEntries) {
        ObjectNode entityBody = JacksonUtil.newObjectNode();
        entityBody.put("ts", ts);
        ObjectNode data = JacksonUtil.newObjectNode();
        statsEntries.forEach(entry -> data.put(entry.getKey(), entry.getValueAsString()));
        entityBody.set("data", (JsonNode)data);
        return entityBody;
    }

    @ConstructorProperties(value={"tsService", "statsCounterService", "topicService", "edgeSettingsService", "cloudEventService", "kafkaAdmin"})
    @Generated
    public CloudStatsService(TimeseriesService tsService, CloudStatsCounterService statsCounterService, TopicService topicService, EdgeSettingsService edgeSettingsService, CloudEventService cloudEventService, Optional<KafkaAdmin> kafkaAdmin) {
        this.tsService = tsService;
        this.statsCounterService = statsCounterService;
        this.topicService = topicService;
        this.edgeSettingsService = edgeSettingsService;
        this.cloudEventService = cloudEventService;
        this.kafkaAdmin = kafkaAdmin;
    }
}

