/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.sync;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.DashboardInfo;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.GroupPermissionId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.id.WidgetsBundleId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.DataType;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.GroupPermission;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.EntityRelationsQuery;
import org.thingsboard.server.common.data.relation.EntitySearchDirection;
import org.thingsboard.server.common.data.relation.RelationsSearchParameters;
import org.thingsboard.server.common.data.role.RoleType;
import org.thingsboard.server.common.data.widget.WidgetType;
import org.thingsboard.server.common.data.widget.WidgetsBundle;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.edge.EdgeEventService;
import org.thingsboard.server.dao.exception.IncorrectParameterException;
import org.thingsboard.server.dao.group.EntityGroupService;
import org.thingsboard.server.dao.grouppermission.GroupPermissionService;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.dao.role.RoleService;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.dao.widget.WidgetTypeService;
import org.thingsboard.server.dao.widget.WidgetsBundleService;
import org.thingsboard.server.gen.edge.v1.AttributesRequestMsg;
import org.thingsboard.server.gen.edge.v1.CalculatedFieldRequestMsg;
import org.thingsboard.server.gen.edge.v1.DeviceCredentialsRequestMsg;
import org.thingsboard.server.gen.edge.v1.EntityGroupRequestMsg;
import org.thingsboard.server.gen.edge.v1.EntityViewsRequestMsg;
import org.thingsboard.server.gen.edge.v1.RelationRequestMsg;
import org.thingsboard.server.gen.edge.v1.RuleChainMetadataRequestMsg;
import org.thingsboard.server.gen.edge.v1.UserCredentialsRequestMsg;
import org.thingsboard.server.gen.edge.v1.WidgetBundleTypesRequestMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.rpc.sync.DefaultEdgeRequestsService;
import org.thingsboard.server.service.edge.rpc.sync.EdgeRequestsService;
import org.thingsboard.server.service.entitiy.entityview.TbEntityViewService;
import org.thingsboard.server.service.executors.DbCallbackExecutorService;
import org.thingsboard.server.service.state.DefaultDeviceStateService;

@Service
@TbCoreComponent
public class DefaultEdgeRequestsService
implements EdgeRequestsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultEdgeRequestsService.class);
    @Autowired
    private EdgeEventService edgeEventService;
    @Autowired
    private AttributesService attributesService;
    @Autowired
    private TimeseriesService timeseriesService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private AssetService assetService;
    @Autowired
    private RelationService relationService;
    @Autowired
    private UserService userService;
    @Autowired
    private DashboardService dashboardService;
    @Autowired
    private TbEntityViewService entityViewService;
    @Autowired
    private WidgetsBundleService widgetsBundleService;
    @Autowired
    private WidgetTypeService widgetTypeService;
    @Autowired
    private EntityGroupService entityGroupService;
    @Autowired
    private GroupPermissionService groupPermissionService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private CalculatedFieldService calculatedFieldService;
    @Autowired
    private DbCallbackExecutorService dbCallbackExecutorService;

    public ListenableFuture<Void> processRuleChainMetadataRequestMsg(TenantId tenantId, Edge edge, RuleChainMetadataRequestMsg ruleChainMetadataRequestMsg) {
        log.trace("[{}] processRuleChainMetadataRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), ruleChainMetadataRequestMsg});
        if (ruleChainMetadataRequestMsg.getRuleChainIdMSB() == 0L || ruleChainMetadataRequestMsg.getRuleChainIdLSB() == 0L) {
            return Futures.immediateFuture(null);
        }
        RuleChainId ruleChainId = new RuleChainId(new UUID(ruleChainMetadataRequestMsg.getRuleChainIdMSB(), ruleChainMetadataRequestMsg.getRuleChainIdLSB()));
        return this.saveEdgeEvent(tenantId, edge.getId(), EdgeEventType.RULE_CHAIN_METADATA, EdgeEventActionType.ADDED, (EntityId)ruleChainId, null);
    }

    public ListenableFuture<Void> processAttributesRequestMsg(TenantId tenantId, Edge edge, AttributesRequestMsg attributesRequestMsg) {
        log.trace("[{}] processAttributesRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), attributesRequestMsg});
        EntityId entityId = EntityIdFactory.getByTypeAndUuid((EntityType)EntityType.valueOf((String)attributesRequestMsg.getEntityType()), (UUID)new UUID(attributesRequestMsg.getEntityIdMSB(), attributesRequestMsg.getEntityIdLSB()));
        EdgeEventType entityType = EdgeUtils.getEdgeEventTypeByEntityType((EntityType)entityId.getEntityType());
        if (entityType == null) {
            log.warn("[{}] Type doesn't supported {}", (Object)tenantId, (Object)entityId.getEntityType());
            return Futures.immediateFuture(null);
        }
        String scope = attributesRequestMsg.getScope();
        ListenableFuture findAttrFuture = this.attributesService.findAll(tenantId, entityId, AttributeScope.valueOf((String)scope));
        return Futures.transformAsync((ListenableFuture)findAttrFuture, ssAttributes -> this.processEntityAttributesAndAddToEdgeQueue(tenantId, entityId, edge, entityType, scope, ssAttributes, attributesRequestMsg), (Executor)this.dbCallbackExecutorService);
    }

    private ListenableFuture<Void> processEntityAttributesAndAddToEdgeQueue(TenantId tenantId, EntityId entityId, Edge edge, EdgeEventType entityType, String scope, List<AttributeKvEntry> ssAttributes, AttributesRequestMsg attributesRequestMsg) {
        HashMap<String, Object> entityData = null;
        ObjectNode attributes = null;
        try {
            ListenableFuture future;
            if (ssAttributes == null || ssAttributes.isEmpty()) {
                log.trace("[{}][{}] No attributes found for entity {} [{}]", new Object[]{tenantId, edge.getName(), entityId.getEntityType(), entityId.getId()});
                future = Futures.immediateFuture(null);
            } else {
                entityData = new HashMap<String, Object>();
                attributes = JacksonUtil.newObjectNode();
                for (AttributeKvEntry attr : ssAttributes) {
                    if (DefaultDeviceStateService.ACTIVITY_KEYS_WITHOUT_INACTIVITY_TIMEOUT.contains(attr.getKey())) continue;
                    if (attr.getDataType() == DataType.BOOLEAN && attr.getBooleanValue().isPresent()) {
                        attributes.put(attr.getKey(), (Boolean)attr.getBooleanValue().get());
                        continue;
                    }
                    if (attr.getDataType() == DataType.DOUBLE && attr.getDoubleValue().isPresent()) {
                        attributes.put(attr.getKey(), (Double)attr.getDoubleValue().get());
                        continue;
                    }
                    if (attr.getDataType() == DataType.LONG && attr.getLongValue().isPresent()) {
                        attributes.put(attr.getKey(), (Long)attr.getLongValue().get());
                        continue;
                    }
                    if (attr.getDataType() == DataType.JSON && attr.getJsonValue().isPresent()) {
                        attributes.set(attr.getKey(), JacksonUtil.toJsonNode((String)((String)attr.getJsonValue().get())));
                        continue;
                    }
                    attributes.put(attr.getKey(), attr.getValueAsString());
                }
                if (!attributes.isEmpty()) {
                    entityData.put("kv", attributes);
                    entityData.put("scope", scope);
                    JsonNode body = JacksonUtil.valueToTree(entityData);
                    log.debug("[{}] Sending attributes data msg, entityId [{}], attributes [{}]", new Object[]{tenantId, entityId, body});
                    future = this.saveEdgeEvent(tenantId, edge.getId(), entityType, EdgeEventActionType.ATTRIBUTES_UPDATED, entityId, body, null);
                } else {
                    future = Futures.immediateFuture(null);
                }
            }
            return Futures.transformAsync((ListenableFuture)future, v -> this.processLatestTimeseriesAndAddToEdgeQueue(tenantId, entityId, edge, entityType), (Executor)this.dbCallbackExecutorService);
        }
        catch (Exception e) {
            String errMsg = String.format("[%s][%s] Failed to save attribute updates to the edge [%s], scope = %s, entityData = %s, attributes = %s", tenantId, edge.getId(), attributesRequestMsg, scope, entityData, attributes);
            log.error(errMsg, (Throwable)e);
            return Futures.immediateFailedFuture((Throwable)new RuntimeException(errMsg, e));
        }
    }

    private ListenableFuture<Void> processLatestTimeseriesAndAddToEdgeQueue(TenantId tenantId, EntityId entityId, Edge edge, EdgeEventType entityType) {
        ListenableFuture getAllLatestFuture = this.timeseriesService.findAllLatest(tenantId, entityId);
        return Futures.transformAsync((ListenableFuture)getAllLatestFuture, tsKvEntries -> {
            if (tsKvEntries == null || tsKvEntries.isEmpty()) {
                log.trace("[{}][{}] No timeseries found for entity {} [{}]", new Object[]{tenantId, edge.getName(), entityId.getEntityType(), entityId.getId()});
                return Futures.immediateFuture(null);
            }
            HashMap<Long, Map> tsData = new HashMap<Long, Map>();
            for (TsKvEntry tsKvEntry : tsKvEntries) {
                if (DefaultDeviceStateService.ACTIVITY_KEYS_WITH_INACTIVITY_TIMEOUT.contains(tsKvEntry.getKey()) || tsKvEntry.getKey().startsWith("RuleNodeState_")) continue;
                tsData.computeIfAbsent(tsKvEntry.getTs(), k -> new HashMap()).put(tsKvEntry.getKey(), tsKvEntry.getValue());
            }
            ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
            for (Map.Entry entry : tsData.entrySet()) {
                HashMap<String, Object> entityBody = new HashMap<String, Object>();
                entityBody.put("data", entry.getValue());
                entityBody.put("ts", entry.getKey());
                futures.add(this.saveEdgeEvent(tenantId, edge.getId(), entityType, EdgeEventActionType.TIMESERIES_UPDATED, entityId, JacksonUtil.valueToTree(entityBody)));
            }
            return Futures.transform((ListenableFuture)Futures.allAsList(futures), v -> null, (Executor)this.dbCallbackExecutorService);
        }, (Executor)this.dbCallbackExecutorService);
    }

    public ListenableFuture<Void> processRelationRequestMsg(TenantId tenantId, Edge edge, RelationRequestMsg relationRequestMsg) {
        log.trace("[{}] processRelationRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), relationRequestMsg});
        EntityId entityId = EntityIdFactory.getByTypeAndUuid((EntityType)EntityType.valueOf((String)relationRequestMsg.getEntityType()), (UUID)new UUID(relationRequestMsg.getEntityIdMSB(), relationRequestMsg.getEntityIdLSB()));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        futures.add(this.findRelationByQuery(tenantId, edge, entityId, EntitySearchDirection.FROM));
        futures.add(this.findRelationByQuery(tenantId, edge, entityId, EntitySearchDirection.TO));
        ListenableFuture relationsListFuture = Futures.allAsList(futures);
        SettableFuture futureToSet = SettableFuture.create();
        Futures.addCallback((ListenableFuture)relationsListFuture, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)this.dbCallbackExecutorService);
        return futureToSet;
    }

    public ListenableFuture<Void> processCalculatedFieldRequestMsg(TenantId tenantId, Edge edge, CalculatedFieldRequestMsg calculatedFieldRequestMsg) {
        log.trace("[{}] processCalculatedFieldRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), calculatedFieldRequestMsg});
        EntityId entityId = EntityIdFactory.getByTypeAndUuid((EntityType)EntityType.valueOf((String)calculatedFieldRequestMsg.getEntityType()), (UUID)new UUID(calculatedFieldRequestMsg.getEntityIdMSB(), calculatedFieldRequestMsg.getEntityIdLSB()));
        log.trace("[{}] processCalculatedField [{}][{}] for entity [{}][{}]", new Object[]{tenantId, edge.getName(), calculatedFieldRequestMsg, entityId.getEntityType(), entityId.getId()});
        return this.saveCalculatedFieldsToEdge(tenantId, edge.getId(), entityId);
    }

    private ListenableFuture<Void> saveCalculatedFieldsToEdge(TenantId tenantId, EdgeId edgeId, EntityId entityId) {
        return Futures.transformAsync((ListenableFuture)this.dbCallbackExecutorService.submit(() -> this.calculatedFieldService.findCalculatedFieldsByEntityId(tenantId, entityId)), calculatedFields -> {
            log.trace("[{}][{}][{}][{}] calculatedField(s) are going to be pushed to edge.", new Object[]{tenantId, edgeId, entityId, calculatedFields.size()});
            List<ListenableFuture> futures = calculatedFields.stream().map(calculatedField -> {
                try {
                    return this.saveEdgeEvent(tenantId, edgeId, EdgeEventType.CALCULATED_FIELD, EdgeEventActionType.ADDED, (EntityId)calculatedField.getId(), JacksonUtil.valueToTree((Object)calculatedField));
                }
                catch (Exception e) {
                    log.error("[{}][{}] Exception during loading calculatedField [{}] to edge on sync!", new Object[]{tenantId, edgeId, calculatedField, e});
                    return Futures.immediateFailedFuture((Throwable)e);
                }
            }).toList();
            return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)this.dbCallbackExecutorService);
        }, (Executor)this.dbCallbackExecutorService);
    }

    private ListenableFuture<List<EntityRelation>> findRelationByQuery(TenantId tenantId, Edge edge, EntityId entityId, EntitySearchDirection direction) {
        EntityRelationsQuery query = new EntityRelationsQuery();
        query.setParameters(new RelationsSearchParameters(entityId, direction, 1, false));
        return this.relationService.findByQuery(tenantId, query);
    }

    public ListenableFuture<Void> processDeviceCredentialsRequestMsg(TenantId tenantId, Edge edge, DeviceCredentialsRequestMsg deviceCredentialsRequestMsg) {
        log.trace("[{}] processDeviceCredentialsRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), deviceCredentialsRequestMsg});
        if (deviceCredentialsRequestMsg.getDeviceIdMSB() == 0L || deviceCredentialsRequestMsg.getDeviceIdLSB() == 0L) {
            return Futures.immediateFuture(null);
        }
        DeviceId deviceId = new DeviceId(new UUID(deviceCredentialsRequestMsg.getDeviceIdMSB(), deviceCredentialsRequestMsg.getDeviceIdLSB()));
        return this.saveEdgeEvent(tenantId, edge.getId(), EdgeEventType.DEVICE, EdgeEventActionType.CREDENTIALS_UPDATED, (EntityId)deviceId, null);
    }

    public ListenableFuture<Void> processUserCredentialsRequestMsg(TenantId tenantId, Edge edge, UserCredentialsRequestMsg userCredentialsRequestMsg) {
        log.trace("[{}] processUserCredentialsRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), userCredentialsRequestMsg});
        if (userCredentialsRequestMsg.getUserIdMSB() == 0L || userCredentialsRequestMsg.getUserIdLSB() == 0L) {
            return Futures.immediateFuture(null);
        }
        UserId userId = new UserId(new UUID(userCredentialsRequestMsg.getUserIdMSB(), userCredentialsRequestMsg.getUserIdLSB()));
        return this.saveEdgeEvent(tenantId, edge.getId(), EdgeEventType.USER, EdgeEventActionType.CREDENTIALS_UPDATED, (EntityId)userId, null);
    }

    public ListenableFuture<Void> processWidgetBundleTypesRequestMsg(TenantId tenantId, Edge edge, WidgetBundleTypesRequestMsg widgetBundleTypesRequestMsg) {
        WidgetsBundleId widgetsBundleId;
        WidgetsBundle widgetsBundleById;
        log.trace("[{}] processWidgetBundleTypesRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), widgetBundleTypesRequestMsg});
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        if (widgetBundleTypesRequestMsg.getWidgetBundleIdMSB() != 0L && widgetBundleTypesRequestMsg.getWidgetBundleIdLSB() != 0L && (widgetsBundleById = this.widgetsBundleService.findWidgetsBundleById(tenantId, widgetsBundleId = new WidgetsBundleId(new UUID(widgetBundleTypesRequestMsg.getWidgetBundleIdMSB(), widgetBundleTypesRequestMsg.getWidgetBundleIdLSB())))) != null) {
            List widgetTypesToPush = this.widgetTypeService.findWidgetTypesByWidgetsBundleId(widgetsBundleById.getTenantId(), widgetsBundleId);
            for (WidgetType widgetType : widgetTypesToPush) {
                futures.add(this.saveEdgeEvent(tenantId, edge.getId(), EdgeEventType.WIDGET_TYPE, EdgeEventActionType.ADDED, (EntityId)widgetType.getId(), null));
            }
        }
        return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)this.dbCallbackExecutorService);
    }

    public ListenableFuture<Void> processEntityViewsRequestMsg(TenantId tenantId, Edge edge, EntityViewsRequestMsg entityViewsRequestMsg) {
        log.trace("[{}] processEntityViewsRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), entityViewsRequestMsg});
        EntityId entityId = EntityIdFactory.getByTypeAndUuid((EntityType)EntityType.valueOf((String)entityViewsRequestMsg.getEntityType()), (UUID)new UUID(entityViewsRequestMsg.getEntityIdMSB(), entityViewsRequestMsg.getEntityIdLSB()));
        SettableFuture futureToSet = SettableFuture.create();
        Futures.addCallback((ListenableFuture)this.entityViewService.findEntityViewsByTenantIdAndEntityIdAsync(tenantId, entityId), (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)this.dbCallbackExecutorService);
        return futureToSet;
    }

    public ListenableFuture<Void> processEntityGroupEntitiesRequest(TenantId tenantId, Edge edge, EntityGroupRequestMsg entityGroupEntitiesRequestMsg) {
        log.trace("[{}] processEntityGroupEntitiesRequest [{}][{}]", new Object[]{tenantId, edge.getName(), entityGroupEntitiesRequestMsg});
        if (entityGroupEntitiesRequestMsg.getEntityGroupIdMSB() != 0L && entityGroupEntitiesRequestMsg.getEntityGroupIdLSB() != 0L) {
            ListenableFuture entityIdsFuture;
            EntityGroupId entityGroupId = new EntityGroupId(new UUID(entityGroupEntitiesRequestMsg.getEntityGroupIdMSB(), entityGroupEntitiesRequestMsg.getEntityGroupIdLSB()));
            try {
                entityIdsFuture = this.entityGroupService.findAllEntityIdsAsync(edge.getTenantId(), entityGroupId, new PageLink(Integer.MAX_VALUE));
            }
            catch (IncorrectParameterException e) {
                log.warn("[{}] Entity group not found to process entityGroupEntitiesRequestMsg {}", new Object[]{tenantId, entityGroupEntitiesRequestMsg, e});
                return Futures.immediateFuture(null);
            }
            return Futures.transformAsync((ListenableFuture)entityIdsFuture, entityIds -> {
                if (entityIds != null && !entityIds.isEmpty()) {
                    EntityType groupType = EntityType.valueOf((String)entityGroupEntitiesRequestMsg.getType());
                    return switch (3.$SwitchMap$org$thingsboard$server$common$data$EntityType[groupType.ordinal()]) {
                        case 1 -> this.syncDevices(edge, entityIds, entityGroupId);
                        case 2 -> this.syncAssets(edge, entityIds, entityGroupId);
                        case 3 -> this.syncEntityViews(edge, entityIds, entityGroupId);
                        case 4 -> this.syncDashboards(edge, entityIds, entityGroupId);
                        case 5 -> this.syncUsers(edge, entityIds, entityGroupId);
                        default -> Futures.immediateFuture(null);
                    };
                }
                log.trace("No entities found for the requested entity group {} [{}]", (Object)entityGroupId.getId(), (Object)entityGroupEntitiesRequestMsg.getType());
                return Futures.immediateFuture(null);
            }, (Executor)this.dbCallbackExecutorService);
        }
        return Futures.immediateFuture(null);
    }

    public ListenableFuture<Void> processEntityGroupPermissionsRequest(TenantId tenantId, Edge edge, EntityGroupRequestMsg entityGroupEntitiesRequestMsg) {
        log.trace("[{}] processEntityGroupPermissionsRequest [{}][{}]", new Object[]{tenantId, edge.getName(), entityGroupEntitiesRequestMsg});
        try {
            if (entityGroupEntitiesRequestMsg.getEntityGroupIdMSB() != 0L && entityGroupEntitiesRequestMsg.getEntityGroupIdLSB() != 0L) {
                EntityGroupId userGroupId = new EntityGroupId(new UUID(entityGroupEntitiesRequestMsg.getEntityGroupIdMSB(), entityGroupEntitiesRequestMsg.getEntityGroupIdLSB()));
                EntityType entityGroupType = EntityType.valueOf((String)entityGroupEntitiesRequestMsg.getType());
                if (EntityType.USER.equals((Object)entityGroupType)) {
                    return this.processUserGroupPermissionsRequest(edge, userGroupId);
                }
                return this.processEntityGroupPermissionsRequest(edge, userGroupId, entityGroupType);
            }
            log.warn("Received empty entity group ID MSG and LSB [{}]", (Object)entityGroupEntitiesRequestMsg);
            return Futures.immediateFuture(null);
        }
        catch (Exception e) {
            log.error("[{}] Failed to process entity group permission request [{}]", new Object[]{edge.getRoutingKey(), entityGroupEntitiesRequestMsg, e});
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    private ListenableFuture<Void> processUserGroupPermissionsRequest(Edge edge, EntityGroupId userGroupId) {
        PageData groupPermissionsData = this.groupPermissionService.findGroupPermissionByTenantIdAndUserGroupId(edge.getTenantId(), userGroupId, new PageLink(Integer.MAX_VALUE));
        if (!groupPermissionsData.getData().isEmpty()) {
            ArrayList<ListenableFuture> result = new ArrayList<ListenableFuture>();
            for (GroupPermission groupPermission : groupPermissionsData.getData()) {
                ListenableFuture roleFuture = this.roleService.findRoleByIdAsync(edge.getTenantId(), groupPermission.getRoleId());
                result.add(Futures.transformAsync((ListenableFuture)roleFuture, role -> {
                    if (role != null) {
                        if (RoleType.GENERIC.equals((Object)role.getType())) {
                            this.saveGroupPermissionEdgeEvent(edge.getTenantId(), edge.getId(), groupPermission.getId());
                        } else {
                            return this.checkAndSaveGroupPermissionEvent(edge, groupPermission.getEntityGroupId(), groupPermission.getEntityGroupType(), groupPermission.getId());
                        }
                    }
                    return Futures.immediateFuture(null);
                }, (Executor)this.dbCallbackExecutorService));
            }
            return Futures.transform((ListenableFuture)Futures.allAsList(result), voids -> null, (Executor)MoreExecutors.directExecutor());
        }
        return Futures.immediateFuture(null);
    }

    private ListenableFuture<Void> processEntityGroupPermissionsRequest(Edge edge, EntityGroupId entityGroupId, EntityType entityGroupType) {
        PageData groupPermissionsData = this.groupPermissionService.findGroupPermissionByTenantIdAndEntityGroupId(edge.getTenantId(), entityGroupId, new PageLink(Integer.MAX_VALUE));
        if (!groupPermissionsData.getData().isEmpty()) {
            ArrayList<ListenableFuture> result = new ArrayList<ListenableFuture>();
            for (GroupPermission groupPermission : groupPermissionsData.getData()) {
                if (groupPermission.isPublic()) {
                    this.saveGroupPermissionEdgeEvent(edge.getTenantId(), edge.getId(), groupPermission.getId());
                    continue;
                }
                result.add(this.checkAndSaveGroupPermissionEvent(edge, groupPermission.getUserGroupId(), EntityType.USER, groupPermission.getId()));
            }
            return Futures.transform((ListenableFuture)Futures.allAsList(result), voids -> null, (Executor)MoreExecutors.directExecutor());
        }
        return Futures.immediateFuture(null);
    }

    private ListenableFuture<Void> checkAndSaveGroupPermissionEvent(Edge edge, EntityGroupId entityGroupId, EntityType entityGroupType, GroupPermissionId groupPermissionId) {
        ListenableFuture checkFuture = this.entityGroupService.checkEntityGroupAssignedToEdgeAsync(edge.getTenantId(), edge.getId(), entityGroupId, entityGroupType);
        return Futures.transformAsync((ListenableFuture)checkFuture, exists -> {
            if (Boolean.TRUE.equals(exists)) {
                this.saveGroupPermissionEdgeEvent(edge.getTenantId(), edge.getId(), groupPermissionId);
            }
            return Futures.immediateFuture(null);
        }, (Executor)this.dbCallbackExecutorService);
    }

    private void saveGroupPermissionEdgeEvent(TenantId tenantId, EdgeId edgeId, GroupPermissionId groupPermissionId) {
        this.saveEdgeEvent(tenantId, edgeId, EdgeEventType.GROUP_PERMISSION, EdgeEventActionType.ADDED, (EntityId)groupPermissionId, null, null);
    }

    private ListenableFuture<Void> syncDevices(Edge edge, List<EntityId> entityIds, EntityGroupId entityGroupId) {
        try {
            if (entityIds != null && !entityIds.isEmpty()) {
                List deviceIds = entityIds.stream().map(e -> new DeviceId(e.getId())).collect(Collectors.toList());
                ListenableFuture devicesFuture = this.deviceService.findDevicesByTenantIdAndIdsAsync(edge.getTenantId(), deviceIds);
                return Futures.transform((ListenableFuture)devicesFuture, devices -> {
                    if (devices != null && !devices.isEmpty()) {
                        log.trace("[{}] [{}] device(s) are going to be pushed to edge.", (Object)edge.getId(), (Object)devices.size());
                        for (Device device : devices) {
                            this.saveEdgeEvent(edge.getTenantId(), edge.getId(), EdgeEventType.DEVICE, EdgeEventActionType.ADDED, (EntityId)device.getId(), null, (EntityId)entityGroupId);
                        }
                    }
                    return null;
                }, (Executor)this.dbCallbackExecutorService);
            }
        }
        catch (Exception e2) {
            log.error("Exception during loading edge device(s) on sync!", (Throwable)e2);
            return Futures.immediateFailedFuture((Throwable)new RuntimeException("Exception during loading edge device(s) on sync!", e2));
        }
        return Futures.immediateFuture(null);
    }

    private ListenableFuture<Void> syncAssets(Edge edge, List<EntityId> entityIds, EntityGroupId entityGroupId) {
        try {
            if (entityIds != null && !entityIds.isEmpty()) {
                List assetIds = entityIds.stream().map(e -> new AssetId(e.getId())).collect(Collectors.toList());
                ListenableFuture assetsFuture = this.assetService.findAssetsByTenantIdAndIdsAsync(edge.getTenantId(), assetIds);
                return Futures.transform((ListenableFuture)assetsFuture, assets -> {
                    if (assets != null && !assets.isEmpty()) {
                        log.trace("[{}] [{}] asset(s) are going to be pushed to edge.", (Object)edge.getId(), (Object)assets.size());
                        for (Asset asset : assets) {
                            this.saveEdgeEvent(edge.getTenantId(), edge.getId(), EdgeEventType.ASSET, EdgeEventActionType.ADDED, (EntityId)asset.getId(), null, (EntityId)entityGroupId);
                        }
                    }
                    return null;
                }, (Executor)this.dbCallbackExecutorService);
            }
        }
        catch (Exception e2) {
            log.error("Exception during loading edge asset(s) on sync!", (Throwable)e2);
            return Futures.immediateFailedFuture((Throwable)new RuntimeException("Exception during loading edge asset(s) on sync!", e2));
        }
        return Futures.immediateFuture(null);
    }

    private ListenableFuture<Void> syncEntityViews(Edge edge, List<EntityId> entityIds, EntityGroupId entityGroupId) {
        try {
            if (entityIds != null && !entityIds.isEmpty()) {
                List entityViewIds = entityIds.stream().map(e -> new EntityViewId(e.getId())).collect(Collectors.toList());
                ListenableFuture entityViewsFuture = this.entityViewService.findEntityViewsByTenantIdAndIdsAsync(edge.getTenantId(), entityViewIds);
                return Futures.transform((ListenableFuture)entityViewsFuture, entityViews -> {
                    if (entityViews != null && !entityViews.isEmpty()) {
                        log.trace("[{}] [{}] entity view(s) are going to be pushed to edge.", (Object)edge.getId(), (Object)entityViews.size());
                        for (EntityView entityView : entityViews) {
                            this.saveEdgeEvent(edge.getTenantId(), edge.getId(), EdgeEventType.ENTITY_VIEW, EdgeEventActionType.ADDED, (EntityId)entityView.getId(), null, (EntityId)entityGroupId);
                        }
                    }
                    return null;
                }, (Executor)this.dbCallbackExecutorService);
            }
        }
        catch (Exception e2) {
            log.error("Exception during loading edge  entity view(s) on sync!", (Throwable)e2);
            return Futures.immediateFailedFuture((Throwable)new RuntimeException("Exception during loading edge  entity view(s) on sync!", e2));
        }
        return Futures.immediateFuture(null);
    }

    private ListenableFuture<Void> syncDashboards(Edge edge, List<EntityId> entityIds, EntityGroupId entityGroupId) {
        try {
            if (entityIds != null && !entityIds.isEmpty()) {
                List dashboardIds = entityIds.stream().map(e -> new DashboardId(e.getId())).collect(Collectors.toList());
                ListenableFuture dashboardInfosFuture = this.dashboardService.findDashboardInfoByIdsAsync(edge.getTenantId(), dashboardIds);
                return Futures.transform((ListenableFuture)dashboardInfosFuture, dashboardInfos -> {
                    if (dashboardInfos != null && !dashboardInfos.isEmpty()) {
                        log.trace("[{}] [{}] dashboard(s) are going to be pushed to edge.", (Object)edge.getId(), (Object)dashboardInfos.size());
                        for (DashboardInfo dashboardInfo : dashboardInfos) {
                            this.saveEdgeEvent(edge.getTenantId(), edge.getId(), EdgeEventType.DASHBOARD, EdgeEventActionType.ADDED, (EntityId)dashboardInfo.getId(), null, (EntityId)entityGroupId);
                        }
                    }
                    return null;
                }, (Executor)this.dbCallbackExecutorService);
            }
        }
        catch (Exception e2) {
            log.error("Exception during loading edge dashboard(s) on sync!", (Throwable)e2);
            return Futures.immediateFailedFuture((Throwable)new RuntimeException("Exception during loading edge dashboard(s) on sync!", e2));
        }
        return Futures.immediateFuture(null);
    }

    private ListenableFuture<Void> syncUsers(Edge edge, List<EntityId> entityIds, EntityGroupId entityGroupId) {
        try {
            if (entityIds != null && !entityIds.isEmpty()) {
                List userIds = entityIds.stream().map(e -> new UserId(e.getId())).collect(Collectors.toList());
                ListenableFuture usersFuture = this.userService.findUsersByTenantIdAndIdsAsync(edge.getTenantId(), userIds);
                return Futures.transform((ListenableFuture)usersFuture, users -> {
                    if (users != null && !users.isEmpty()) {
                        log.trace("[{}] [{}] user(s) are going to be pushed to edge.", (Object)edge.getId(), (Object)users.size());
                        for (User user : users) {
                            this.saveEdgeEvent(edge.getTenantId(), edge.getId(), EdgeEventType.USER, EdgeEventActionType.ADDED, (EntityId)user.getId(), null, (EntityId)entityGroupId);
                        }
                    }
                    return null;
                }, (Executor)this.dbCallbackExecutorService);
            }
        }
        catch (Exception e2) {
            log.error("Exception during loading edge user(s) on sync!", (Throwable)e2);
            return Futures.immediateFailedFuture((Throwable)new RuntimeException("Exception during loading edge user(s) on sync!", e2));
        }
        return Futures.immediateFuture(null);
    }

    private ListenableFuture<Void> saveEdgeEvent(TenantId tenantId, EdgeId edgeId, EdgeEventType type, EdgeEventActionType action, EntityId entityId, JsonNode body) {
        return this.saveEdgeEvent(tenantId, edgeId, type, action, entityId, body, null);
    }

    private ListenableFuture<Void> saveEdgeEvent(TenantId tenantId, EdgeId edgeId, EdgeEventType type, EdgeEventActionType action, EntityId entityId, JsonNode body, EntityId entityGroupId) {
        log.trace("Pushing edge event to edge queue. tenantId [{}], edgeId [{}], type [{}], action[{}], entityId [{}], body [{}], entityGroupId [{}]", new Object[]{tenantId, edgeId, type, action, entityId, body, entityGroupId});
        EdgeEvent edgeEvent = EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edgeId, (EdgeEventType)type, (EdgeEventActionType)action, (EntityId)entityId, (JsonNode)body, (EntityId)entityGroupId);
        return this.edgeEventService.saveAsync(edgeEvent);
    }
}

