/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.user;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.security.UserCredentials;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.edge.v1.UserCredentialsUpdateMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.user.UserEdgeProcessor;

@Component
@TbCoreComponent
public class UserEdgeProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserEdgeProcessor.class);

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        UserId userId = new UserId(edgeEvent.getEntityId());
        EntityGroupId entityGroupId = edgeEvent.getEntityGroupId() != null ? new EntityGroupId(edgeEvent.getEntityGroupId()) : null;
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[edgeEvent.getAction().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                User user = this.edgeCtx.getUserService().findUserById(edgeEvent.getTenantId(), userId);
                if (user == null) break;
                UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
                DownlinkMsg.Builder builder = DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addUserUpdateMsg(EdgeMsgConstructorUtils.constructUserUpdatedMsg((UpdateMsgType)msgType, (User)user, (EntityGroupId)entityGroupId));
                UserCredentials userCredentialsByUserId = this.edgeCtx.getUserService().findUserCredentialsByUserId(edgeEvent.getTenantId(), userId);
                if (userCredentialsByUserId != null && userCredentialsByUserId.isEnabled()) {
                    builder.addUserCredentialsUpdateMsg(EdgeMsgConstructorUtils.constructUserCredentialsUpdatedMsg((UserCredentials)userCredentialsByUserId));
                }
                return builder.build();
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addUserUpdateMsg(EdgeMsgConstructorUtils.constructUserDeleteMsg((UserId)userId, (EntityGroupId)entityGroupId)).build();
            }
            case 9: {
                UserCredentials userCredentialsByUserId = this.edgeCtx.getUserService().findUserCredentialsByUserId(edgeEvent.getTenantId(), userId);
                if (userCredentialsByUserId == null || !userCredentialsByUserId.isEnabled()) break;
                UserCredentialsUpdateMsg userCredentialsUpdateMsg = EdgeMsgConstructorUtils.constructUserCredentialsUpdatedMsg((UserCredentials)userCredentialsByUserId);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addUserCredentialsUpdateMsg(userCredentialsUpdateMsg).build();
            }
        }
        return null;
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.USER;
    }
}

