/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.tenant;

import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.TenantProfileUpdateMsg;
import org.thingsboard.server.gen.edge.v1.TenantUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
@TbCoreComponent
public class TenantEdgeProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantEdgeProcessor.class);

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        Tenant tenant;
        TenantId tenantId = TenantId.fromUUID((UUID)edgeEvent.getEntityId());
        if (EdgeEventActionType.UPDATED.equals((Object)edgeEvent.getAction()) && (tenant = this.edgeCtx.getTenantService().findTenantById(tenantId)) != null) {
            UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
            TenantUpdateMsg tenantUpdateMsg = EdgeMsgConstructorUtils.constructTenantUpdateMsg((UpdateMsgType)msgType, (Tenant)tenant);
            TenantProfile tenantProfile = this.edgeCtx.getTenantProfileService().findTenantProfileById(tenantId, tenant.getTenantProfileId());
            TenantProfileUpdateMsg tenantProfileUpdateMsg = EdgeMsgConstructorUtils.constructTenantProfileUpdateMsg((UpdateMsgType)msgType, (TenantProfile)tenantProfile);
            return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addTenantUpdateMsg(tenantUpdateMsg).addTenantProfileUpdateMsg(tenantProfileUpdateMsg).build();
        }
        return null;
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.TENANT;
    }
}

