/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.secret;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.SecretId;
import org.thingsboard.server.common.data.secret.Secret;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.SecretUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.secret.SecretEdgeProcessor;

@Component
@TbCoreComponent
public class SecretEdgeProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecretEdgeProcessor.class);

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        SecretId secretId = new SecretId(edgeEvent.getEntityId());
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[edgeEvent.getAction().ordinal()]) {
            case 1: 
            case 2: {
                Secret secret = this.edgeCtx.getSecretService().findSecretById(edgeEvent.getTenantId(), secretId);
                if (secret == null) break;
                UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
                SecretUpdateMsg secretUpdateMsg = EdgeMsgConstructorUtils.constructSecretUpdatedMsg((UpdateMsgType)msgType, (Secret)secret);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addSecretUpdateMsg(secretUpdateMsg).build();
            }
            case 3: {
                SecretUpdateMsg deleteMsg = EdgeMsgConstructorUtils.constructSecretDeleteMsg((SecretId)secretId);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addSecretUpdateMsg(deleteMsg).build();
            }
        }
        return null;
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.SECRET;
    }
}

