/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.role;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.RoleId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.role.Role;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.role.RoleEdgeProcessor;

@Component
@TbCoreComponent
public class RoleEdgeProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RoleEdgeProcessor.class);

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        RoleId roleId = new RoleId(edgeEvent.getEntityId());
        DownlinkMsg downlinkMsg = null;
        UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
        switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[msgType.ordinal()]) {
            case 1: 
            case 2: {
                Role role = this.edgeCtx.getRoleService().findRoleById(edgeEvent.getTenantId(), roleId);
                if (role == null) break;
                downlinkMsg = DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addRoleMsg(EdgeMsgConstructorUtils.constructRoleProto((UpdateMsgType)msgType, (Role)role)).build();
                break;
            }
            case 3: {
                downlinkMsg = DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addRoleMsg(EdgeMsgConstructorUtils.constructRoleDeleteMsg((RoleId)roleId)).build();
            }
        }
        return downlinkMsg;
    }

    public ListenableFuture<Void> processEntityNotification(TenantId tenantId, TransportProtos.EdgeNotificationMsgProto edgeNotificationMsg) {
        EdgeEventActionType actionType = EdgeEventActionType.valueOf((String)edgeNotificationMsg.getAction());
        EdgeEventType type = EdgeEventType.valueOf((String)edgeNotificationMsg.getType());
        EntityId entityId = EntityIdFactory.getByEdgeEventTypeAndUuid((EdgeEventType)type, (UUID)new UUID(edgeNotificationMsg.getEntityIdMSB(), edgeNotificationMsg.getEntityIdLSB()));
        EdgeId originatorEdgeId = this.safeGetEdgeId(edgeNotificationMsg.getOriginatorEdgeIdMSB(), edgeNotificationMsg.getOriginatorEdgeIdLSB());
        return switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[actionType.ordinal()]) {
            case 1, 2 -> {
                ListenableFuture roleFuture = this.edgeCtx.getRoleService().findRoleByIdAsync(tenantId, new RoleId(entityId.getId()));
                yield Futures.transformAsync((ListenableFuture)roleFuture, role -> {
                    if (role == null) {
                        return Futures.immediateFuture(null);
                    }
                    ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
                    PageDataIterable edges = new PageDataIterable(link -> this.edgeCtx.getEdgeService().findEdgesByTenantId(tenantId, link), 1024);
                    for (Edge edge : edges) {
                        if (!EntityType.TENANT.equals((Object)role.getOwnerId().getEntityType()) && !edge.getOwnerId().equals(role.getOwnerId())) continue;
                        futures.add(this.saveEdgeEvent(tenantId, edge.getId(), type, actionType, entityId, null));
                    }
                    return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)this.dbCallbackExecutorService);
                }, (Executor)this.dbCallbackExecutorService);
            }
            case 3 -> this.processActionForAllEdges(tenantId, type, actionType, entityId, null, originatorEdgeId);
            default -> Futures.immediateFuture(null);
        };
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.ROLE;
    }
}

