/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.integration;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.integration.IntegrationEdgeProcessor;

@Component
@TbCoreComponent
public class IntegrationEdgeProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegrationEdgeProcessor.class);

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        IntegrationId integrationId = new IntegrationId(edgeEvent.getEntityId());
        DownlinkMsg downlinkMsg = null;
        UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
        switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[msgType.ordinal()]) {
            case 1: 
            case 2: {
                Integration integration = this.edgeCtx.getIntegrationService().findIntegrationById(edgeEvent.getTenantId(), integrationId);
                if (integration == null) break;
                JsonNode updatedConfiguration = this.replaceAttributePlaceholders(edgeEvent, integration.getConfiguration());
                DownlinkMsg.Builder builder = DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addIntegrationMsg(EdgeMsgConstructorUtils.constructIntegrationUpdateMsg((UpdateMsgType)msgType, (Integration)integration, (JsonNode)updatedConfiguration));
                Converter uplinkConverter = this.edgeCtx.getConverterService().findConverterById(edgeEvent.getTenantId(), integration.getDefaultConverterId());
                builder.addConverterMsg(EdgeMsgConstructorUtils.constructConverterUpdateMsg((UpdateMsgType)msgType, (Converter)uplinkConverter));
                if (integration.getDownlinkConverterId() != null) {
                    Converter converter = this.edgeCtx.getConverterService().findConverterById(edgeEvent.getTenantId(), integration.getDownlinkConverterId());
                    builder.addConverterMsg(EdgeMsgConstructorUtils.constructConverterUpdateMsg((UpdateMsgType)msgType, (Converter)converter));
                }
                downlinkMsg = builder.build();
                break;
            }
            case 3: {
                downlinkMsg = DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addIntegrationMsg(EdgeMsgConstructorUtils.constructIntegrationDeleteMsg((IntegrationId)integrationId)).build();
            }
        }
        return downlinkMsg;
    }

    private JsonNode replaceAttributePlaceholders(EdgeEvent edgeEvent, JsonNode originalConfiguration) {
        try {
            Set attributeKeysFromConfiguration = EdgeUtils.getAttributeKeysFromConfiguration((String)originalConfiguration.toString());
            if (attributeKeysFromConfiguration.isEmpty()) {
                return originalConfiguration;
            }
            List attributeKvEntries = (List)this.edgeCtx.getAttributesService().find(edgeEvent.getTenantId(), (EntityId)edgeEvent.getEdgeId(), AttributeScope.SERVER_SCOPE, (Collection)attributeKeysFromConfiguration).get();
            String updatedConfiguration = originalConfiguration.toString();
            for (AttributeKvEntry attributeKvEntry : attributeKvEntries) {
                updatedConfiguration = updatedConfiguration.replaceAll(EdgeUtils.formatAttributeKeyToRegexpPlaceholderFormat((String)attributeKvEntry.getKey()), attributeKvEntry.getValueAsString());
            }
            return JacksonUtil.toJsonNode((String)updatedConfiguration);
        }
        catch (Exception e) {
            log.warn("Failed to replace attribute placeholders in configuration [{}]", (Object)originalConfiguration, (Object)e);
            return originalConfiguration;
        }
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.INTEGRATION;
    }
}

