/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.group;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.EntityGroupUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.group.EntityGroupEdgeProcessor;

@Component
@TbCoreComponent
public class EntityGroupEdgeProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityGroupEdgeProcessor.class);

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        EntityGroupId entityGroupId = new EntityGroupId(edgeEvent.getEntityId());
        DownlinkMsg downlinkMsg = null;
        UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
        switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[msgType.ordinal()]) {
            case 1: 
            case 2: {
                EntityGroup entityGroup = this.edgeCtx.getEntityGroupService().findEntityGroupById(edgeEvent.getTenantId(), entityGroupId);
                if (entityGroup == null) break;
                EntityGroupUpdateMsg entityGroupUpdateMsg = EdgeMsgConstructorUtils.constructEntityGroupUpdatedMsg((UpdateMsgType)msgType, (EntityGroup)entityGroup);
                downlinkMsg = DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addEntityGroupUpdateMsg(entityGroupUpdateMsg).build();
                break;
            }
            case 3: {
                downlinkMsg = DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addEntityGroupUpdateMsg(EdgeMsgConstructorUtils.constructEntityGroupDeleteMsg((EntityGroupId)entityGroupId)).build();
            }
        }
        return downlinkMsg;
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.ENTITY_GROUP;
    }
}

