/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.edge;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.role.Role;
import org.thingsboard.server.common.data.scheduler.SchedulerEventInfo;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeConfiguration;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.edge.EdgeEntityProcessor;

@Component
@TbCoreComponent
public class EdgeEntityProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdgeEntityProcessor.class);

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        Edge edge;
        EdgeId edgeId = new EdgeId(edgeEvent.getEntityId());
        if (EdgeEventActionType.CHANGE_OWNER.equals((Object)edgeEvent.getAction()) && (edge = this.edgeCtx.getEdgeService().findEdgeById(edgeEvent.getTenantId(), edgeId)) != null) {
            EdgeConfiguration edgeConfigMsg = EdgeMsgConstructorUtils.constructEdgeConfiguration((Edge)edge);
            return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).setEdgeConfiguration(edgeConfigMsg).build();
        }
        return null;
    }

    public ListenableFuture<Void> processEntityNotification(TenantId tenantId, TransportProtos.EdgeNotificationMsgProto edgeNotificationMsg) {
        EdgeId originatorEdgeId = this.safeGetEdgeId(edgeNotificationMsg.getOriginatorEdgeIdMSB(), edgeNotificationMsg.getOriginatorEdgeIdLSB());
        EdgeEventActionType actionType = EdgeEventActionType.valueOf((String)edgeNotificationMsg.getAction());
        EdgeId edgeId = new EdgeId(new UUID(edgeNotificationMsg.getEntityIdMSB(), edgeNotificationMsg.getEntityIdLSB()));
        if (edgeId.equals((Object)originatorEdgeId)) {
            return Futures.immediateFuture(null);
        }
        return switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[actionType.ordinal()]) {
            case 1 -> {
                ListenableFuture edgeFuture = this.edgeCtx.getEdgeService().findEdgeByIdAsync(tenantId, edgeId);
                yield Futures.transformAsync((ListenableFuture)edgeFuture, edge -> {
                    ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
                    try {
                        EntityId previousOwnerId = (EntityId)JacksonUtil.fromString((String)edgeNotificationMsg.getBody(), EntityId.class);
                        List previousOwnerCustomerHierarchy = new ArrayList();
                        if (previousOwnerId != null && EntityType.CUSTOMER.equals((Object)previousOwnerId.getEntityType())) {
                            previousOwnerCustomerHierarchy = this.edgeCtx.getCustomersHierarchyEdgeService().getCustomersHierarchy(tenantId, new CustomerId(previousOwnerId.getId()));
                        }
                        List ownerCustomerHierarchy = new ArrayList();
                        if (EntityType.CUSTOMER.equals((Object)edge.getOwnerId().getEntityType())) {
                            ownerCustomerHierarchy = this.edgeCtx.getCustomersHierarchyEdgeService().getCustomersHierarchy(tenantId, new CustomerId(edge.getOwnerId().getId()));
                        }
                        ArrayList removedCustomers = new ArrayList(previousOwnerCustomerHierarchy);
                        removedCustomers.removeAll(ownerCustomerHierarchy);
                        for (Customer removedCustomer : removedCustomers) {
                            if (removedCustomer.getId().isNullUid()) continue;
                            CustomerId removedCustomerId = removedCustomer.getId();
                            futures.add(this.saveEdgeEvent(edge.getTenantId(), edge.getId(), EdgeEventType.CUSTOMER, EdgeEventActionType.DELETED, (EntityId)removedCustomerId, null));
                            this.unassignEntityGroupsOfRemovedCustomer(tenantId, edgeId, EntityType.DEVICE, (EntityId)removedCustomerId);
                            this.unassignEntityGroupsOfRemovedCustomer(tenantId, edgeId, EntityType.ASSET, (EntityId)removedCustomerId);
                            this.unassignEntityGroupsOfRemovedCustomer(tenantId, edgeId, EntityType.ENTITY_VIEW, (EntityId)removedCustomerId);
                            this.unassignEntityGroupsOfRemovedCustomer(tenantId, edgeId, EntityType.USER, (EntityId)removedCustomerId);
                            this.unassignEntityGroupsOfRemovedCustomer(tenantId, edgeId, EntityType.DASHBOARD, (EntityId)removedCustomerId);
                            this.unassignSchedulerEventsOfRemovedCustomer(tenantId, edgeId, removedCustomerId);
                        }
                        ArrayList addedCustomers = new ArrayList(ownerCustomerHierarchy);
                        addedCustomers.removeAll(previousOwnerCustomerHierarchy);
                        for (Customer addedCustomer : addedCustomers) {
                            if (addedCustomer.getId().isNullUid()) continue;
                            futures.add(this.syncCustomer(tenantId, edge.getId(), addedCustomer));
                        }
                        this.edgeCtx.getCustomersHierarchyEdgeService().processEdgeChangeOwner(tenantId, edgeId, previousOwnerId);
                        futures.add(this.saveEdgeEvent(edge.getTenantId(), edgeId, EdgeEventType.EDGE, EdgeEventActionType.CHANGE_OWNER, (EntityId)edgeId, null));
                    }
                    catch (Exception e) {
                        log.error("[{}] Failed to switch owner for edge [{}]", new Object[]{tenantId, edge, e});
                        return Futures.immediateFailedFuture((Throwable)e);
                    }
                    return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)this.dbCallbackExecutorService);
                }, (Executor)this.dbCallbackExecutorService);
            }
            case 2 -> this.processAttributesUpdated(tenantId, edgeId, edgeNotificationMsg);
            default -> Futures.immediateFuture(null);
        };
    }

    private ListenableFuture<Void> processAttributesUpdated(TenantId tenantId, EdgeId edgeId, TransportProtos.EdgeNotificationMsgProto edgeNotificationMsg) {
        ArrayList<String> attributeKeys = new ArrayList<String>();
        try {
            ArrayNode attributes = (ArrayNode)JacksonUtil.toJsonNode((String)edgeNotificationMsg.getBody());
            for (Object attribute : attributes) {
                attributeKeys.add(attribute.get("key").asText());
            }
        }
        catch (Exception e) {
            log.warn("[{}][{}] Can't process attributes updated event {}", new Object[]{tenantId, edgeId, edgeNotificationMsg, e});
            return Futures.immediateFailedFuture((Throwable)e);
        }
        HashSet<IntegrationId> integrationIds = new HashSet<IntegrationId>();
        PageDataIterable integrationPageDataIterable = new PageDataIterable(link -> this.edgeCtx.getIntegrationService().findIntegrationsByTenantIdAndEdgeId(tenantId, edgeId, link), 1024);
        for (Integration integration : integrationPageDataIterable) {
            for (String attributeKey : attributeKeys) {
                if (!integration.getConfiguration().toString().contains(EdgeUtils.formatAttributeKeyToPlaceholderFormat((String)attributeKey))) continue;
                integrationIds.add(integration.getId());
            }
        }
        if (integrationIds.isEmpty()) {
            return Futures.immediateFuture(null);
        }
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        for (IntegrationId integrationId : integrationIds) {
            futures.add(this.saveEdgeEvent(tenantId, edgeId, EdgeEventType.INTEGRATION, EdgeEventActionType.UPDATED, (EntityId)integrationId, null));
        }
        return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)this.dbCallbackExecutorService);
    }

    private void unassignEntityGroupsOfRemovedCustomer(TenantId tenantId, EdgeId edgeId, EntityType groupType, EntityId customerId) {
        PageData toRemove;
        PageLink removalPageLink = new PageLink(1000, 0);
        do {
            toRemove = this.edgeCtx.getEntityGroupService().findEdgeEntityGroupsByOwnerIdAndType(tenantId, edgeId, customerId, groupType, removalPageLink);
            for (EntityGroup entityGroup : toRemove.getData()) {
                this.edgeCtx.getEntityGroupService().unassignEntityGroupFromEdge(tenantId, entityGroup.getId(), edgeId, groupType);
            }
        } while (toRemove.hasNext());
    }

    private void unassignSchedulerEventsOfRemovedCustomer(TenantId tenantId, EdgeId edgeId, CustomerId customerId) {
        PageData toRemove;
        PageLink removalPageLink = new PageLink(1000, 0);
        do {
            toRemove = this.edgeCtx.getSchedulerEventService().findSchedulerEventInfosByTenantIdAndEdgeIdAndCustomerId(tenantId, edgeId, customerId, removalPageLink);
            for (SchedulerEventInfo schedulerEventInfo : toRemove.getData()) {
                this.edgeCtx.getSchedulerEventService().unassignSchedulerEventFromEdge(tenantId, schedulerEventInfo.getId(), edgeId);
            }
        } while (toRemove.hasNext());
    }

    private ListenableFuture<Void> syncCustomer(TenantId tenantId, EdgeId edgeId, Customer customer) {
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        futures.add(this.saveEdgeEvent(tenantId, edgeId, EdgeEventType.CUSTOMER, EdgeEventActionType.ADDED, (EntityId)customer.getId(), null, null));
        PageDataIterable roles = new PageDataIterable(link -> this.edgeCtx.getRoleService().findRolesByTenantIdAndCustomerId(tenantId, customer.getId(), link), 1024);
        for (Role role : roles) {
            futures.add(this.saveEdgeEvent(tenantId, edgeId, EdgeEventType.ROLE, EdgeEventActionType.ADDED, (EntityId)role.getId(), null, null));
        }
        this.assignCustomerAdministratorsAndUsersGroupToEdge(tenantId, edgeId, customer.getId(), customer.getParentCustomerId());
        return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)this.dbCallbackExecutorService);
    }

    private void assignCustomerAdministratorsAndUsersGroupToEdge(TenantId tenantId, EdgeId edgeId, CustomerId customerId, CustomerId parentCustomerId) {
        EntityGroup customerAdmins = this.edgeCtx.getEntityGroupService().findOrCreateCustomerAdminsGroup(tenantId, customerId, parentCustomerId);
        this.edgeCtx.getEntityGroupService().assignEntityGroupToEdge(tenantId, customerAdmins.getId(), edgeId, customerAdmins.getType());
        EntityGroup customerUsers = this.edgeCtx.getEntityGroupService().findOrCreateCustomerUsersGroup(tenantId, customerId, parentCustomerId);
        this.edgeCtx.getEntityGroupService().assignEntityGroupToEdge(tenantId, customerUsers.getId(), edgeId, customerUsers.getType());
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.EDGE;
    }
}

