/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.device.profile;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.exception.DataValidationException;
import org.thingsboard.server.gen.edge.v1.DeviceProfileUpdateMsg;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.device.profile.BaseDeviceProfileProcessor;
import org.thingsboard.server.service.edge.rpc.processor.device.profile.DeviceProfileEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.device.profile.DeviceProfileProcessor;

@Component
@TbCoreComponent
public class DeviceProfileEdgeProcessor
extends BaseDeviceProfileProcessor
implements DeviceProfileProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceProfileEdgeProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processDeviceProfileMsgFromEdge(TenantId tenantId, Edge edge, DeviceProfileUpdateMsg deviceProfileUpdateMsg) {
        log.trace("[{}] executing processDeviceProfileMsgFromEdge [{}] from edge [{}]", new Object[]{tenantId, deviceProfileUpdateMsg, edge.getId()});
        DeviceProfileId deviceProfileId = new DeviceProfileId(new UUID(deviceProfileUpdateMsg.getIdMSB(), deviceProfileUpdateMsg.getIdLSB()));
        try {
            this.edgeSynchronizationManager.getEdgeId().set(edge.getId());
            ListenableFuture listenableFuture = switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[deviceProfileUpdateMsg.getMsgType().ordinal()]) {
                case 1, 2 -> {
                    this.saveOrUpdateDeviceProfile(tenantId, deviceProfileId, deviceProfileUpdateMsg, edge);
                    yield Futures.immediateFuture(null);
                }
                default -> this.handleUnsupportedMsgType(deviceProfileUpdateMsg.getMsgType());
            };
            return listenableFuture;
        }
        catch (DataValidationException e) {
            log.warn("[{}] Failed to process DeviceProfileUpdateMsg from Edge [{}]", new Object[]{tenantId, deviceProfileUpdateMsg, e});
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)e);
            return listenableFuture;
        }
        finally {
            this.edgeSynchronizationManager.getEdgeId().remove();
        }
    }

    private void saveOrUpdateDeviceProfile(TenantId tenantId, DeviceProfileId deviceProfileId, DeviceProfileUpdateMsg deviceProfileUpdateMsg, Edge edge) {
        Boolean deviceProfileNameUpdated;
        Pair resultPair = super.saveOrUpdateDeviceProfile(tenantId, deviceProfileId, deviceProfileUpdateMsg);
        Boolean created = (Boolean)resultPair.getFirst();
        if (created.booleanValue()) {
            this.createRelationFromEdge(tenantId, edge.getId(), (EntityId)deviceProfileId);
            this.pushDeviceProfileCreatedEventToRuleEngine(tenantId, edge, deviceProfileId);
        }
        if ((deviceProfileNameUpdated = (Boolean)resultPair.getSecond()).booleanValue()) {
            this.saveEdgeEvent(tenantId, edge.getId(), EdgeEventType.DEVICE_PROFILE, EdgeEventActionType.UPDATED, (EntityId)deviceProfileId, null);
        }
    }

    private void pushDeviceProfileCreatedEventToRuleEngine(TenantId tenantId, Edge edge, DeviceProfileId deviceProfileId) {
        try {
            DeviceProfile deviceProfile = this.edgeCtx.getDeviceProfileService().findDeviceProfileById(tenantId, deviceProfileId);
            String deviceProfileAsString = JacksonUtil.toString((Object)deviceProfile);
            TbMsgMetaData msgMetaData = this.getEdgeActionTbMsgMetaData(edge, null);
            this.pushEntityEventToRuleEngine(tenantId, (EntityId)deviceProfileId, null, TbMsgType.ENTITY_CREATED, deviceProfileAsString, msgMetaData);
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to push device profile action to rule engine: {}", new Object[]{tenantId, deviceProfileId, TbMsgType.ENTITY_CREATED.name(), e});
        }
    }

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        DeviceProfileId deviceProfileId = new DeviceProfileId(edgeEvent.getEntityId());
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[edgeEvent.getAction().ordinal()]) {
            case 1: 
            case 2: {
                DeviceProfile deviceProfile = this.edgeCtx.getDeviceProfileService().findDeviceProfileById(edgeEvent.getTenantId(), deviceProfileId);
                if (deviceProfile == null) break;
                UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
                DeviceProfileUpdateMsg deviceProfileUpdateMsg = EdgeMsgConstructorUtils.constructDeviceProfileUpdatedMsg((UpdateMsgType)msgType, (DeviceProfile)deviceProfile);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addDeviceProfileUpdateMsg(deviceProfileUpdateMsg).build();
            }
            case 3: {
                DeviceProfileUpdateMsg deviceProfileUpdateMsg = EdgeMsgConstructorUtils.constructDeviceProfileDeleteMsg((DeviceProfileId)deviceProfileId);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addDeviceProfileUpdateMsg(deviceProfileUpdateMsg).build();
            }
        }
        return null;
    }

    protected void setDefaultRuleChainId(TenantId tenantId, DeviceProfile deviceProfile, RuleChainId ruleChainId) {
        deviceProfile.setDefaultRuleChainId(ruleChainId);
    }

    protected void setDefaultEdgeRuleChainId(DeviceProfile deviceProfile, RuleChainId ruleChainId, DeviceProfileUpdateMsg deviceProfileUpdateMsg) {
        UUID defaultEdgeRuleChainUUID = ruleChainId != null ? ruleChainId.getId() : null;
        deviceProfile.setDefaultEdgeRuleChainId(defaultEdgeRuleChainUUID != null ? new RuleChainId(defaultEdgeRuleChainUUID) : null);
    }

    protected void setDefaultDashboardId(TenantId tenantId, DashboardId dashboardId, DeviceProfile deviceProfile, DeviceProfileUpdateMsg deviceProfileUpdateMsg) {
        UUID defaultDashboardUUID = deviceProfile.getDefaultDashboardId() != null ? deviceProfile.getDefaultDashboardId().getId() : (dashboardId != null ? dashboardId.getId() : null);
        deviceProfile.setDefaultDashboardId(defaultDashboardUUID != null ? new DashboardId(defaultDashboardUUID) : null);
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.DEVICE_PROFILE;
    }
}

