/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.device.profile;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.Pair;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.OtaPackageInfo;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.ota.OtaPackageType;
import org.thingsboard.server.dao.service.DataValidator;
import org.thingsboard.server.gen.edge.v1.DeviceProfileUpdateMsg;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

public abstract class BaseDeviceProfileProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseDeviceProfileProcessor.class);
    @Autowired
    private DataValidator<DeviceProfile> deviceProfileValidator;

    protected Pair<Boolean, Boolean> saveOrUpdateDeviceProfile(TenantId tenantId, DeviceProfileId deviceProfileId, DeviceProfileUpdateMsg deviceProfileUpdateMsg) {
        boolean created = false;
        boolean deviceProfileNameUpdated = false;
        deviceCreationLock.lock();
        try {
            DeviceProfile deviceProfile = (DeviceProfile)JacksonUtil.fromString((String)deviceProfileUpdateMsg.getEntity(), DeviceProfile.class, (boolean)true);
            if (deviceProfile == null) {
                throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] deviceProfileUpdateMsg {" + String.valueOf(deviceProfileUpdateMsg) + "} cannot be converted to device profile");
            }
            DeviceProfile deviceProfileById = this.edgeCtx.getDeviceProfileService().findDeviceProfileById(tenantId, deviceProfileId);
            if (deviceProfileById == null) {
                created = true;
                deviceProfile.setId(null);
                deviceProfile.setDefault(false);
            } else {
                deviceProfile.setId((UUIDBased)deviceProfileId);
                deviceProfile.setDefault(deviceProfileById.isDefault());
            }
            deviceProfile.setVersion(null);
            if (deviceProfile.equals((Object)deviceProfileById)) {
                Pair pair = Pair.of((Object)false, (Object)false);
                return pair;
            }
            Object deviceProfileName = deviceProfile.getName();
            DeviceProfile deviceProfileByName = this.edgeCtx.getDeviceProfileService().findDeviceProfileByName(tenantId, (String)deviceProfileName);
            if (deviceProfileByName != null && !deviceProfileByName.getId().equals((Object)deviceProfileId)) {
                deviceProfileName = (String)deviceProfileName + "_" + StringUtils.randomAlphabetic((int)15);
                log.warn("[{}] Device profile with name {} already exists. Renaming device profile name to {}", new Object[]{tenantId, deviceProfile.getName(), deviceProfileName});
                deviceProfileNameUpdated = true;
            }
            deviceProfile.setName((String)deviceProfileName);
            RuleChainId ruleChainId = deviceProfile.getDefaultRuleChainId();
            this.setDefaultRuleChainId(tenantId, deviceProfile, created ? null : deviceProfileById.getDefaultRuleChainId());
            this.setDefaultEdgeRuleChainId(deviceProfile, ruleChainId, deviceProfileUpdateMsg);
            this.setDefaultDashboardId(tenantId, created ? null : deviceProfileById.getDefaultDashboardId(), deviceProfile, deviceProfileUpdateMsg);
            this.unassignOtaPackageIfNotExist(tenantId, deviceProfile, OtaPackageType.FIRMWARE);
            this.unassignOtaPackageIfNotExist(tenantId, deviceProfile, OtaPackageType.SOFTWARE);
            this.deviceProfileValidator.validate((BaseData)deviceProfile, DeviceProfile::getTenantId);
            if (created) {
                deviceProfile.setId((UUIDBased)deviceProfileId);
            }
            this.edgeCtx.getDeviceProfileService().saveDeviceProfile(deviceProfile, false, true);
        }
        catch (Exception e) {
            log.error("[{}] Failed to process device profile update msg [{}]", new Object[]{tenantId, deviceProfileUpdateMsg, e});
            throw e;
        }
        finally {
            deviceCreationLock.unlock();
        }
        return Pair.of((Object)created, (Object)deviceProfileNameUpdated);
    }

    private void unassignOtaPackageIfNotExist(TenantId tenantId, DeviceProfile deviceProfile, OtaPackageType otaPackageType) {
        OtaPackageInfo otaPackageInfo;
        OtaPackageId otaPackageId;
        OtaPackageId otaPackageId2 = otaPackageId = OtaPackageType.FIRMWARE == otaPackageType ? deviceProfile.getFirmwareId() : deviceProfile.getSoftwareId();
        if (otaPackageId != null && (otaPackageInfo = this.edgeCtx.getOtaPackageService().findOtaPackageInfoById(tenantId, otaPackageId)) == null) {
            if (OtaPackageType.FIRMWARE == otaPackageType) {
                deviceProfile.setFirmwareId(null);
            } else {
                deviceProfile.setSoftwareId(null);
            }
            log.warn("OtaPackage with ID {} not found in DB, unassigned from device profile with id {}", (Object)otaPackageId, (Object)deviceProfile.getId());
        }
    }

    protected abstract void setDefaultRuleChainId(TenantId var1, DeviceProfile var2, RuleChainId var3);

    protected abstract void setDefaultEdgeRuleChainId(DeviceProfile var1, RuleChainId var2, DeviceProfileUpdateMsg var3);

    protected abstract void setDefaultDashboardId(TenantId var1, DashboardId var2, DeviceProfile var3, DeviceProfileUpdateMsg var4);
}

