/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.dashboard;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.exception.DataValidationException;
import org.thingsboard.server.gen.edge.v1.DashboardUpdateMsg;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.dashboard.BaseDashboardProcessor;
import org.thingsboard.server.service.edge.rpc.processor.dashboard.DashboardEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.dashboard.DashboardProcessor;

@Component
@TbCoreComponent
public class DashboardEdgeProcessor
extends BaseDashboardProcessor
implements DashboardProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DashboardEdgeProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processDashboardMsgFromEdge(TenantId tenantId, Edge edge, DashboardUpdateMsg dashboardUpdateMsg) {
        log.trace("[{}] executing processDashboardMsgFromEdge [{}] from edge [{}]", new Object[]{tenantId, dashboardUpdateMsg, edge.getId()});
        DashboardId dashboardId = new DashboardId(new UUID(dashboardUpdateMsg.getIdMSB(), dashboardUpdateMsg.getIdLSB()));
        try {
            ListenableFuture entityGroupId;
            this.edgeSynchronizationManager.getEdgeId().set(edge.getId());
            entityGroupId = switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[dashboardUpdateMsg.getMsgType().ordinal()]) {
                case 1, 2 -> {
                    this.saveOrUpdateDashboard(tenantId, dashboardId, dashboardUpdateMsg, edge);
                    yield Futures.immediateFuture(null);
                }
                case 3 -> {
                    if (dashboardUpdateMsg.hasEntityGroupIdMSB() && dashboardUpdateMsg.hasEntityGroupIdLSB()) {
                        entityGroupId = new EntityGroupId(new UUID(dashboardUpdateMsg.getEntityGroupIdMSB(), dashboardUpdateMsg.getEntityGroupIdLSB()));
                        this.edgeCtx.getEntityGroupService().removeEntityFromEntityGroup(tenantId, (EntityGroupId)entityGroupId, (EntityId)dashboardId);
                    } else {
                        this.removeDashboardFromEdgeAllDashboardGroup(tenantId, edge, dashboardId);
                    }
                    yield Futures.immediateFuture(null);
                }
                default -> this.handleUnsupportedMsgType(dashboardUpdateMsg.getMsgType());
            };
            return entityGroupId;
        }
        catch (ThingsboardException | DataValidationException e) {
            if (e.getMessage().contains("limit reached")) {
                log.warn("[{}] Number of allowed dashboard violated {}", new Object[]{tenantId, dashboardUpdateMsg, e});
                ListenableFuture listenableFuture = Futures.immediateFuture(null);
                return listenableFuture;
            }
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)e);
            return listenableFuture;
        }
        finally {
            this.edgeSynchronizationManager.getEdgeId().remove();
        }
    }

    private void saveOrUpdateDashboard(TenantId tenantId, DashboardId dashboardId, DashboardUpdateMsg dashboardUpdateMsg, Edge edge) throws ThingsboardException {
        boolean created = super.saveOrUpdateDashboard(tenantId, dashboardId, dashboardUpdateMsg);
        if (created) {
            this.createRelationFromEdge(tenantId, edge.getId(), (EntityId)dashboardId);
            this.pushDashboardCreatedEventToRuleEngine(tenantId, edge, dashboardId);
        }
        this.addDashboardToEdgeAllDashboardGroup(tenantId, edge, dashboardId);
    }

    private void pushDashboardCreatedEventToRuleEngine(TenantId tenantId, Edge edge, DashboardId dashboardId) {
        try {
            Dashboard dashboard = this.edgeCtx.getDashboardService().findDashboardById(tenantId, dashboardId);
            String dashboardAsString = JacksonUtil.toString((Object)dashboard);
            TbMsgMetaData msgMetaData = this.getEdgeActionTbMsgMetaData(edge, null);
            this.pushEntityEventToRuleEngine(tenantId, (EntityId)dashboardId, null, TbMsgType.ENTITY_CREATED, dashboardAsString, msgMetaData);
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to push dashboard action to rule engine: {}", new Object[]{tenantId, dashboardId, TbMsgType.ENTITY_CREATED.name(), e});
        }
    }

    private void removeDashboardFromEdgeAllDashboardGroup(TenantId tenantId, Edge edge, DashboardId dashboardId) {
        Dashboard dashboardToDelete = this.edgeCtx.getDashboardService().findDashboardById(tenantId, dashboardId);
        if (dashboardToDelete != null) {
            try {
                EntityGroup edgeDashboardGroup = (EntityGroup)this.edgeCtx.getEntityGroupService().findOrCreateEdgeAllGroupAsync(tenantId, edge, edge.getName(), dashboardToDelete.getOwnerId().getEntityType(), EntityType.DASHBOARD).get();
                if (edgeDashboardGroup != null) {
                    this.edgeCtx.getEntityGroupService().removeEntityFromEntityGroup(tenantId, edgeDashboardGroup.getId(), (EntityId)dashboardToDelete.getId());
                }
            }
            catch (Exception e) {
                log.warn("[{}] Can't delete dashboard from edge dashboard 'All' group, dashboard id [{}]", new Object[]{tenantId, dashboardToDelete, e});
                throw new RuntimeException(e);
            }
        }
    }

    private void addDashboardToEdgeAllDashboardGroup(TenantId tenantId, Edge edge, DashboardId dashboardId) {
        try {
            Dashboard dashboard = this.edgeCtx.getDashboardService().findDashboardById(tenantId, dashboardId);
            EntityGroup edgeDashboardGroup = (EntityGroup)this.edgeCtx.getEntityGroupService().findOrCreateEdgeAllGroupAsync(tenantId, edge, edge.getName(), dashboard.getOwnerId().getEntityType(), EntityType.DASHBOARD).get();
            if (edgeDashboardGroup != null) {
                this.edgeCtx.getEntityGroupService().addEntityToEntityGroup(tenantId, edgeDashboardGroup.getId(), (EntityId)dashboardId);
            }
        }
        catch (Exception e) {
            log.warn("[{}] Can't add dashboard to edge dashboard group, dashboard id [{}]", new Object[]{tenantId, dashboardId, e});
            throw new RuntimeException(e);
        }
    }

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        DashboardId dashboardId = new DashboardId(edgeEvent.getEntityId());
        EntityGroupId entityGroupId = edgeEvent.getEntityGroupId() != null ? new EntityGroupId(edgeEvent.getEntityGroupId()) : null;
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[edgeEvent.getAction().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                Dashboard dashboard = this.edgeCtx.getDashboardService().findDashboardById(edgeEvent.getTenantId(), dashboardId);
                if (dashboard == null) break;
                UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
                DashboardUpdateMsg dashboardUpdateMsg = EdgeMsgConstructorUtils.constructDashboardUpdatedMsg((UpdateMsgType)msgType, (Dashboard)dashboard, (EntityGroupId)entityGroupId);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addDashboardUpdateMsg(dashboardUpdateMsg).build();
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addDashboardUpdateMsg(EdgeMsgConstructorUtils.constructDashboardDeleteMsg((DashboardId)dashboardId, (EntityGroupId)entityGroupId)).build();
            }
        }
        return null;
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.DASHBOARD;
    }
}

