/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.dashboard;

import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.dao.service.DataValidator;
import org.thingsboard.server.gen.edge.v1.DashboardUpdateMsg;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

public abstract class BaseDashboardProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseDashboardProcessor.class);
    @Autowired
    private DataValidator<Dashboard> dashboardValidator;

    protected boolean saveOrUpdateDashboard(TenantId tenantId, DashboardId dashboardId, DashboardUpdateMsg dashboardUpdateMsg) throws ThingsboardException {
        boolean created = false;
        Dashboard dashboard = (Dashboard)JacksonUtil.fromString((String)dashboardUpdateMsg.getEntity(), Dashboard.class, (boolean)true);
        if (dashboard == null) {
            throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] dashboardUpdateMsg {" + String.valueOf(dashboardUpdateMsg) + "} cannot be converted to dashboard");
        }
        Dashboard dashboardById = this.edgeCtx.getDashboardService().findDashboardById(tenantId, dashboardId);
        if (dashboardById == null) {
            created = true;
            dashboard.setId(null);
        } else {
            dashboard.setId((UUIDBased)dashboardId);
            this.changeOwnerIfRequired(tenantId, null, (EntityId)dashboardId);
        }
        if (this.isCustomerNotExists(tenantId, dashboard.getCustomerId())) {
            dashboard.setCustomerId(null);
        }
        this.dashboardValidator.validate((BaseData)dashboard, Dashboard::getTenantId);
        if (created) {
            dashboard.setId((UUIDBased)dashboardId);
        }
        Dashboard savedDashboard = this.edgeCtx.getDashboardService().saveDashboard(dashboard, false);
        if (created) {
            this.edgeCtx.getEntityGroupService().addEntityToEntityGroupAll(savedDashboard.getTenantId(), savedDashboard.getOwnerId(), (EntityId)savedDashboard.getId());
        }
        this.safeAddToEntityGroup(tenantId, dashboardUpdateMsg, dashboardId);
        return created;
    }

    private void safeAddToEntityGroup(TenantId tenantId, DashboardUpdateMsg dashboardUpdateMsg, DashboardId dashboardId) {
        if (dashboardUpdateMsg.hasEntityGroupIdMSB() && dashboardUpdateMsg.hasEntityGroupIdLSB()) {
            UUID entityGroupUUID = this.safeGetUUID(dashboardUpdateMsg.getEntityGroupIdMSB(), dashboardUpdateMsg.getEntityGroupIdLSB());
            this.safeAddEntityToGroup(tenantId, new EntityGroupId(entityGroupUUID), (EntityId)dashboardId);
        }
    }
}

