/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.converter;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.ConverterId;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
@TbCoreComponent
public class ConverterEdgeProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConverterEdgeProcessor.class);

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        Converter converter;
        ConverterId converterId = new ConverterId(edgeEvent.getEntityId());
        UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
        if (msgType == UpdateMsgType.ENTITY_UPDATED_RPC_MESSAGE && (converter = this.edgeCtx.getConverterService().findConverterById(edgeEvent.getTenantId(), converterId)) != null) {
            return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addConverterMsg(EdgeMsgConstructorUtils.constructConverterUpdateMsg((UpdateMsgType)msgType, (Converter)converter)).build();
        }
        return null;
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.CONVERTER;
    }
}

