/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.asset;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.exception.DataValidationException;
import org.thingsboard.server.gen.edge.v1.AssetUpdateMsg;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.asset.AssetEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.asset.AssetProcessor;
import org.thingsboard.server.service.edge.rpc.processor.asset.BaseAssetProcessor;

@Component
@TbCoreComponent
public class AssetEdgeProcessor
extends BaseAssetProcessor
implements AssetProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetEdgeProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processAssetMsgFromEdge(TenantId tenantId, Edge edge, AssetUpdateMsg assetUpdateMsg) {
        log.trace("[{}] executing processAssetMsgFromEdge [{}] from edge [{}]", new Object[]{tenantId, assetUpdateMsg, edge.getId()});
        AssetId assetId = new AssetId(new UUID(assetUpdateMsg.getIdMSB(), assetUpdateMsg.getIdLSB()));
        try {
            ListenableFuture entityGroupId;
            this.edgeSynchronizationManager.getEdgeId().set(edge.getId());
            entityGroupId = switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[assetUpdateMsg.getMsgType().ordinal()]) {
                case 1, 2 -> {
                    this.saveOrUpdateAsset(tenantId, assetId, assetUpdateMsg, edge);
                    yield Futures.immediateFuture(null);
                }
                case 3 -> {
                    if (assetUpdateMsg.hasEntityGroupIdMSB() && assetUpdateMsg.hasEntityGroupIdLSB()) {
                        entityGroupId = new EntityGroupId(new UUID(assetUpdateMsg.getEntityGroupIdMSB(), assetUpdateMsg.getEntityGroupIdLSB()));
                        this.edgeCtx.getEntityGroupService().removeEntityFromEntityGroup(tenantId, (EntityGroupId)entityGroupId, (EntityId)assetId);
                    } else {
                        this.removeAssetFromEdgeAllAssetGroup(tenantId, edge, assetId);
                    }
                    yield Futures.immediateFuture(null);
                }
                default -> this.handleUnsupportedMsgType(assetUpdateMsg.getMsgType());
            };
            return entityGroupId;
        }
        catch (ThingsboardException | DataValidationException e) {
            if (e.getMessage().contains("limit reached")) {
                log.warn("[{}] Number of allowed asset violated {}", new Object[]{tenantId, assetUpdateMsg, e});
                ListenableFuture listenableFuture = Futures.immediateFuture(null);
                return listenableFuture;
            }
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)e);
            return listenableFuture;
        }
        finally {
            this.edgeSynchronizationManager.getEdgeId().remove();
        }
    }

    private void saveOrUpdateAsset(TenantId tenantId, AssetId assetId, AssetUpdateMsg assetUpdateMsg, Edge edge) throws ThingsboardException {
        Pair resultPair = super.saveOrUpdateAsset(tenantId, assetId, assetUpdateMsg);
        Boolean created = (Boolean)resultPair.getFirst();
        if (created.booleanValue()) {
            this.createRelationFromEdge(tenantId, edge.getId(), (EntityId)assetId);
            this.pushAssetCreatedEventToRuleEngine(tenantId, edge, assetId);
        }
        this.addAssetToEdgeAllAssetGroup(tenantId, edge, assetId);
        Boolean assetNameUpdated = (Boolean)resultPair.getSecond();
        if (assetNameUpdated.booleanValue()) {
            this.saveEdgeEvent(tenantId, edge.getId(), EdgeEventType.ASSET, EdgeEventActionType.UPDATED, (EntityId)assetId, null);
        }
    }

    private void pushAssetCreatedEventToRuleEngine(TenantId tenantId, Edge edge, AssetId assetId) {
        try {
            Asset asset = this.edgeCtx.getAssetService().findAssetById(tenantId, assetId);
            String assetAsString = JacksonUtil.toString((Object)asset);
            TbMsgMetaData msgMetaData = this.getEdgeActionTbMsgMetaData(edge, asset.getCustomerId());
            this.pushEntityEventToRuleEngine(tenantId, (EntityId)assetId, asset.getCustomerId(), TbMsgType.ENTITY_CREATED, assetAsString, msgMetaData);
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to push asset action to rule engine: {}", new Object[]{tenantId, assetId, TbMsgType.ENTITY_CREATED.name(), e});
        }
    }

    private void removeAssetFromEdgeAllAssetGroup(TenantId tenantId, Edge edge, AssetId assetId) {
        Asset assetToDelete = this.edgeCtx.getAssetService().findAssetById(tenantId, assetId);
        if (assetToDelete != null) {
            try {
                EntityGroup edgeAssetGroup = (EntityGroup)this.edgeCtx.getEntityGroupService().findOrCreateEdgeAllGroupAsync(tenantId, edge, edge.getName(), assetToDelete.getOwnerId().getEntityType(), EntityType.ASSET).get();
                if (edgeAssetGroup != null) {
                    this.edgeCtx.getEntityGroupService().removeEntityFromEntityGroup(tenantId, edgeAssetGroup.getId(), (EntityId)assetToDelete.getId());
                }
            }
            catch (Exception e) {
                log.warn("[{}] Can't delete asset from edge asset 'All' group, asset id [{}]", new Object[]{tenantId, assetId, e});
                throw new RuntimeException(e);
            }
        }
    }

    private void addAssetToEdgeAllAssetGroup(TenantId tenantId, Edge edge, AssetId assetId) {
        try {
            Asset asset = this.edgeCtx.getAssetService().findAssetById(tenantId, assetId);
            EntityGroup edgeAssetGroup = (EntityGroup)this.edgeCtx.getEntityGroupService().findOrCreateEdgeAllGroupAsync(tenantId, edge, edge.getName(), asset.getOwnerId().getEntityType(), EntityType.ASSET).get();
            if (edgeAssetGroup != null) {
                this.edgeCtx.getEntityGroupService().addEntityToEntityGroup(tenantId, edgeAssetGroup.getId(), (EntityId)assetId);
            }
        }
        catch (Exception e) {
            log.warn("Can't add asset to edge asset group, asset id [{}]", (Object)assetId, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        AssetId assetId = new AssetId(edgeEvent.getEntityId());
        EntityGroupId entityGroupId = edgeEvent.getEntityGroupId() != null ? new EntityGroupId(edgeEvent.getEntityGroupId()) : null;
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[edgeEvent.getAction().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                Asset asset = this.edgeCtx.getAssetService().findAssetById(edgeEvent.getTenantId(), assetId);
                if (asset == null) break;
                UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
                AssetUpdateMsg assetUpdateMsg = EdgeMsgConstructorUtils.constructAssetUpdatedMsg((UpdateMsgType)msgType, (Asset)asset, (EntityGroupId)entityGroupId);
                DownlinkMsg.Builder builder = DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addAssetUpdateMsg(assetUpdateMsg);
                if (UpdateMsgType.ENTITY_CREATED_RPC_MESSAGE.equals((Object)msgType)) {
                    AssetProfile assetProfile = this.edgeCtx.getAssetProfileService().findAssetProfileById(edgeEvent.getTenantId(), asset.getAssetProfileId());
                    builder.addAssetProfileUpdateMsg(EdgeMsgConstructorUtils.constructAssetProfileUpdatedMsg((UpdateMsgType)msgType, (AssetProfile)assetProfile));
                }
                return builder.build();
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addAssetUpdateMsg(EdgeMsgConstructorUtils.constructAssetDeleteMsg((AssetId)assetId, (EntityGroupId)entityGroupId)).build();
            }
        }
        return null;
    }

    protected void setCustomerId(TenantId tenantId, CustomerId customerId, Asset asset, AssetUpdateMsg assetUpdateMsg) {
        CustomerId customerUUID = asset.getCustomerId() != null ? asset.getCustomerId() : customerId;
        asset.setCustomerId(customerUUID);
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.ASSET;
    }
}

