/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.GroupPermission;
import org.thingsboard.server.dao.grouppermission.GroupPermissionService;
import org.thingsboard.server.service.edge.rpc.fetch.EdgeEventFetcher;

public class EntityGroupPermissionsEdgeEventFetcher
implements EdgeEventFetcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityGroupPermissionsEdgeEventFetcher.class);
    private final GroupPermissionService groupPermissionService;
    private final EntityType groupType;
    private final EntityGroupId entityGroupId;

    public PageLink getPageLink(int pageSize) {
        return new PageLink(pageSize);
    }

    public PageData<EdgeEvent> fetchEdgeEvents(TenantId tenantId, Edge edge, PageLink pageLink) {
        log.trace("[{}] start fetching edge events [{}], groupType {}, entityGroupId {}, pageLink {}", new Object[]{tenantId, edge.getId(), this.groupType, this.entityGroupId, pageLink});
        PageData pageData = EntityType.USER.equals((Object)this.groupType) ? this.groupPermissionService.findGroupPermissionByTenantIdAndUserGroupId(edge.getTenantId(), this.entityGroupId, pageLink) : this.groupPermissionService.findGroupPermissionByTenantIdAndEntityGroupId(edge.getTenantId(), this.entityGroupId, pageLink);
        ArrayList<EdgeEvent> result = new ArrayList<EdgeEvent>();
        if (!pageData.getData().isEmpty()) {
            for (GroupPermission groupPermission : pageData.getData()) {
                result.add(EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edge.getId(), (EdgeEventType)EdgeEventType.GROUP_PERMISSION, (EdgeEventActionType)EdgeEventActionType.ADDED, (EntityId)groupPermission.getId(), null, null));
            }
        }
        return new PageData(result, pageData.getTotalPages(), pageData.getTotalElements(), pageData.hasNext());
    }

    @ConstructorProperties(value={"groupPermissionService", "groupType", "entityGroupId"})
    @Generated
    public EntityGroupPermissionsEdgeEventFetcher(GroupPermissionService groupPermissionService, EntityType groupType, EntityGroupId entityGroupId) {
        this.groupPermissionService = groupPermissionService;
        this.groupType = groupType;
        this.entityGroupId = entityGroupId;
    }
}

