/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.AttributesSaveResult;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.data.limit.LimitedApi;
import org.thingsboard.server.common.data.notification.rule.trigger.EdgeCommunicationFailureTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTrigger;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.common.msg.edge.EdgeEventUpdateMsg;
import org.thingsboard.server.dao.edge.stats.EdgeStatsKey;
import org.thingsboard.server.gen.edge.v1.AlarmCommentUpdateMsg;
import org.thingsboard.server.gen.edge.v1.AlarmUpdateMsg;
import org.thingsboard.server.gen.edge.v1.AssetProfileUpdateMsg;
import org.thingsboard.server.gen.edge.v1.AssetUpdateMsg;
import org.thingsboard.server.gen.edge.v1.AttributesRequestMsg;
import org.thingsboard.server.gen.edge.v1.CalculatedFieldRequestMsg;
import org.thingsboard.server.gen.edge.v1.CalculatedFieldUpdateMsg;
import org.thingsboard.server.gen.edge.v1.ConnectRequestMsg;
import org.thingsboard.server.gen.edge.v1.ConnectResponseCode;
import org.thingsboard.server.gen.edge.v1.ConnectResponseMsg;
import org.thingsboard.server.gen.edge.v1.DashboardUpdateMsg;
import org.thingsboard.server.gen.edge.v1.DeviceCredentialsRequestMsg;
import org.thingsboard.server.gen.edge.v1.DeviceCredentialsUpdateMsg;
import org.thingsboard.server.gen.edge.v1.DeviceProfileUpdateMsg;
import org.thingsboard.server.gen.edge.v1.DeviceRpcCallMsg;
import org.thingsboard.server.gen.edge.v1.DeviceUpdateMsg;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.DownlinkResponseMsg;
import org.thingsboard.server.gen.edge.v1.EdgeConfiguration;
import org.thingsboard.server.gen.edge.v1.EdgeUpdateMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.EntityDataProto;
import org.thingsboard.server.gen.edge.v1.EntityGroupRequestMsg;
import org.thingsboard.server.gen.edge.v1.EntityViewUpdateMsg;
import org.thingsboard.server.gen.edge.v1.EntityViewsRequestMsg;
import org.thingsboard.server.gen.edge.v1.RelationRequestMsg;
import org.thingsboard.server.gen.edge.v1.RelationUpdateMsg;
import org.thingsboard.server.gen.edge.v1.RequestMsg;
import org.thingsboard.server.gen.edge.v1.ResourceUpdateMsg;
import org.thingsboard.server.gen.edge.v1.ResponseMsg;
import org.thingsboard.server.gen.edge.v1.RuleChainMetadataRequestMsg;
import org.thingsboard.server.gen.edge.v1.RuleChainMetadataUpdateMsg;
import org.thingsboard.server.gen.edge.v1.RuleChainUpdateMsg;
import org.thingsboard.server.gen.edge.v1.SyncCompletedMsg;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.gen.edge.v1.UplinkResponseMsg;
import org.thingsboard.server.gen.edge.v1.UserCredentialsRequestMsg;
import org.thingsboard.server.gen.edge.v1.WidgetBundleTypesRequestMsg;
import org.thingsboard.server.service.edge.EdgeContextComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.EdgeGrpcSession;
import org.thingsboard.server.service.edge.rpc.EdgeSessionState;
import org.thingsboard.server.service.edge.rpc.EdgeSyncCursor;
import org.thingsboard.server.service.edge.rpc.fetch.EdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.GeneralEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.utils.EdgeVersionUtils;

public abstract class EdgeGrpcSession
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdgeGrpcSession.class);
    private static final String QUEUE_START_TS_ATTR_KEY = "queueStartTs";
    private static final String QUEUE_START_SEQ_ID_ATTR_KEY = "queueStartSeqId";
    private static final int MAX_DOWNLINK_ATTEMPTS = 3;
    public static final String RATE_LIMIT_REACHED = "Rate limit reached";
    protected final ConcurrentLinkedQueue<EdgeEvent> highPriorityQueue = new ConcurrentLinkedQueue();
    protected UUID sessionId;
    private BiConsumer<EdgeId, EdgeGrpcSession> sessionOpenListener;
    private BiConsumer<Edge, UUID> sessionCloseListener;
    private final EdgeSessionState sessionState = new EdgeSessionState();
    private final ReentrantLock downlinkMsgLock = new ReentrantLock();
    protected EdgeContextComponent ctx;
    protected Edge edge;
    protected TenantId tenantId;
    private Long newStartTs;
    private Long previousStartTs;
    private Long newStartSeqId;
    private Long previousStartSeqId;
    private StreamObserver<RequestMsg> inputStream;
    private StreamObserver<ResponseMsg> outputStream;
    private volatile boolean connected;
    private volatile boolean syncInProgress;
    private EdgeVersion edgeVersion;
    private int maxInboundMessageSize;
    private int clientMaxInboundMessageSize;
    private int maxHighPriorityQueueSizePerSession;
    private ScheduledExecutorService sendDownlinkExecutorService;

    public EdgeGrpcSession(EdgeContextComponent ctx, StreamObserver<ResponseMsg> outputStream, BiConsumer<EdgeId, EdgeGrpcSession> sessionOpenListener, BiConsumer<Edge, UUID> sessionCloseListener, ScheduledExecutorService sendDownlinkExecutorService, int maxInboundMessageSize, int maxHighPriorityQueueSizePerSession) {
        this.sessionId = UUID.randomUUID();
        this.ctx = ctx;
        this.outputStream = outputStream;
        this.sessionOpenListener = sessionOpenListener;
        this.sessionCloseListener = sessionCloseListener;
        this.sendDownlinkExecutorService = sendDownlinkExecutorService;
        this.maxInboundMessageSize = maxInboundMessageSize;
        this.maxHighPriorityQueueSizePerSession = maxHighPriorityQueueSizePerSession;
        this.initInputStream();
    }

    protected abstract ListenableFuture<Boolean> migrateEdgeEvents() throws Exception;

    public void initInputStream() {
        this.inputStream = new /* Unavailable Anonymous Inner Class!! */;
    }

    public void onConfigurationUpdate(Edge edge) {
        log.debug("[{}] onConfigurationUpdate [{}]", (Object)this.sessionId, (Object)edge);
        this.tenantId = edge.getTenantId();
        this.edge = edge;
        EdgeUpdateMsg edgeConfig = EdgeUpdateMsg.newBuilder().setConfiguration(EdgeMsgConstructorUtils.constructEdgeConfiguration((Edge)edge)).build();
        ResponseMsg edgeConfigMsg = ResponseMsg.newBuilder().setEdgeUpdateMsg(edgeConfig).build();
        this.sendDownlinkMsg(edgeConfigMsg);
    }

    public void startSyncProcess(boolean fullSync) {
        if (!this.syncInProgress) {
            log.info("[{}][{}][{}] Staring edge sync process", new Object[]{this.tenantId, this.edge.getId(), this.sessionId});
            this.syncInProgress = true;
            this.interruptGeneralProcessingOnSync();
            this.doSync(new EdgeSyncCursor(this.ctx, this.edge, fullSync));
        } else {
            log.info("[{}][{}][{}] Sync is already started, skipping starting it now", new Object[]{this.tenantId, this.edge.getId(), this.sessionId});
        }
    }

    private void doSync(EdgeSyncCursor cursor) {
        if (cursor.hasNext()) {
            EdgeEventFetcher next = cursor.getNext();
            log.debug("[{}][{}] starting sync process, cursor current idx = {}, class = {}", new Object[]{this.tenantId, this.edge.getId(), cursor.getCurrentIdx(), next.getClass().getSimpleName()});
            ListenableFuture future = this.startProcessingEdgeEvents(next);
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)this.ctx.getGrpcCallbackExecutorService());
        } else {
            log.info("[{}][{}] sync process completed", (Object)this.tenantId, (Object)this.edge.getId());
            DownlinkMsg syncCompleteDownlinkMsg = DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).setSyncCompletedMsg(SyncCompletedMsg.newBuilder().build()).build();
            Futures.addCallback((ListenableFuture)this.sendDownlinkMsgsPack(Collections.singletonList(syncCompleteDownlinkMsg)), (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)this.ctx.getGrpcCallbackExecutorService());
        }
    }

    protected void processEdgeEvents(EdgeEventFetcher fetcher, PageLink pageLink, SettableFuture<Pair<Long, Long>> result) {
        try {
            log.trace("[{}] Start processing edge events, fetcher = {}, pageLink = {}", new Object[]{this.edge.getId(), fetcher.getClass().getSimpleName(), pageLink});
            this.processHighPriorityEvents();
            PageData pageData = fetcher.fetchEdgeEvents(this.edge.getTenantId(), this.edge, pageLink);
            if (this.isConnected() && !pageData.getData().isEmpty()) {
                if (fetcher instanceof GeneralEdgeEventFetcher) {
                    long queueSize = pageData.getTotalElements() - (long)pageLink.getPageSize() * (long)pageLink.getPage();
                    this.ctx.getStatsCounterService().ifPresent(statsCounterService -> statsCounterService.setDownlinkMsgsLag(this.edge.getTenantId(), this.edge.getId(), queueSize));
                }
                log.trace("[{}][{}][{}] event(s) are going to be processed.", new Object[]{this.tenantId, this.edge.getId(), pageData.getData().size()});
                List downlinkMsgsPack = this.convertToDownlinkMsgsPack(pageData.getData());
                Futures.addCallback((ListenableFuture)this.sendDownlinkMsgsPack(downlinkMsgsPack), (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)this.ctx.getGrpcCallbackExecutorService());
            } else {
                log.trace("[{}] no event(s) found. Stop processing edge events, fetcher = {}, pageLink = {}", new Object[]{this.edge.getId(), fetcher.getClass().getSimpleName(), pageLink});
                result.set(null);
            }
        }
        catch (Exception e) {
            log.error("[{}] Failed to fetch edge events", (Object)this.edge.getId(), (Object)e);
            result.setException((Throwable)e);
        }
    }

    private ConnectResponseMsg processConnect(ConnectRequestMsg request) {
        log.trace("[{}] processConnect [{}]", (Object)this.sessionId, (Object)request);
        Optional optional = this.ctx.getEdgeService().findEdgeByRoutingKey(TenantId.SYS_TENANT_ID, request.getEdgeRoutingKey());
        if (optional.isPresent()) {
            this.edge = (Edge)optional.get();
            this.tenantId = this.edge.getTenantId();
            try {
                if (this.edge.getSecret().equals(request.getEdgeSecret())) {
                    this.sessionOpenListener.accept(this.edge.getId(), this);
                    this.edgeVersion = request.getEdgeVersion();
                    this.processSaveEdgeVersionAsAttribute(request.getEdgeVersion().name());
                    return ConnectResponseMsg.newBuilder().setResponseCode(ConnectResponseCode.ACCEPTED).setErrorMsg("").setConfiguration(EdgeMsgConstructorUtils.constructEdgeConfiguration((Edge)this.edge)).setMaxInboundMessageSize(this.maxInboundMessageSize).build();
                }
                String error = "Failed to validate the edge!";
                String failureMsg = String.format("%s Provided request secret: %s", error, request.getEdgeSecret());
                this.ctx.getRuleProcessor().process((NotificationRuleTrigger)EdgeCommunicationFailureTrigger.builder().tenantId(this.tenantId).edgeId(this.edge.getId()).customerId(this.edge.getCustomerId()).edgeName(this.edge.getName()).failureMsg(failureMsg).error(error).build());
                return ConnectResponseMsg.newBuilder().setResponseCode(ConnectResponseCode.BAD_CREDENTIALS).setErrorMsg(failureMsg).setConfiguration(EdgeConfiguration.getDefaultInstance()).build();
            }
            catch (Exception e) {
                String failureMsg = "Failed to process edge connection!";
                this.ctx.getRuleProcessor().process((NotificationRuleTrigger)EdgeCommunicationFailureTrigger.builder().tenantId(this.tenantId).edgeId(this.edge.getId()).customerId(this.edge.getCustomerId()).edgeName(this.edge.getName()).failureMsg(failureMsg).error(e.getMessage()).build());
                log.error(failureMsg, (Throwable)e);
                return ConnectResponseMsg.newBuilder().setResponseCode(ConnectResponseCode.SERVER_UNAVAILABLE).setErrorMsg(failureMsg).setConfiguration(EdgeConfiguration.getDefaultInstance()).build();
            }
        }
        return ConnectResponseMsg.newBuilder().setResponseCode(ConnectResponseCode.BAD_CREDENTIALS).setErrorMsg("Failed to find the edge! Routing key: " + request.getEdgeRoutingKey()).setConfiguration(EdgeConfiguration.getDefaultInstance()).build();
    }

    private void processSaveEdgeVersionAsAttribute(String edgeVersion) {
        BaseAttributeKvEntry attributeKvEntry = new BaseAttributeKvEntry((KvEntry)new StringDataEntry("edgeVersion", edgeVersion), System.currentTimeMillis());
        this.ctx.getAttributesService().save(this.tenantId, (EntityId)this.edge.getId(), AttributeScope.SERVER_SCOPE, (AttributeKvEntry)attributeKvEntry);
    }

    private void interruptGeneralProcessingOnSync() {
        log.debug("[{}][{}][{}] Sync process started. General processing interrupted!", new Object[]{this.tenantId, this.edge.getId(), this.sessionId});
        this.stopCurrentSendDownlinkMsgsTask(Boolean.valueOf(true));
    }

    protected ListenableFuture<Boolean> sendDownlinkMsgsPack(List<DownlinkMsg> downlinkMsgsPack) {
        this.interruptPreviousSendDownlinkMsgsTask();
        this.sessionState.setSendDownlinkMsgsFuture(SettableFuture.create());
        this.sessionState.getPendingMsgsMap().clear();
        downlinkMsgsPack.forEach(msg -> this.sessionState.getPendingMsgsMap().put(msg.getDownlinkMsgId(), msg));
        this.scheduleDownlinkMsgsPackSend(1);
        return this.sessionState.getSendDownlinkMsgsFuture();
    }

    private void interruptPreviousSendDownlinkMsgsTask() {
        if (this.sessionState.getSendDownlinkMsgsFuture() != null && !this.sessionState.getSendDownlinkMsgsFuture().isDone() || this.sessionState.getScheduledSendDownlinkTask() != null && !this.sessionState.getScheduledSendDownlinkTask().isCancelled()) {
            log.debug("[{}][{}][{}] Previous send downlink future was not properly completed, stopping it now!", new Object[]{this.tenantId, this.edge.getId(), this.sessionId});
            this.stopCurrentSendDownlinkMsgsTask(Boolean.valueOf(true));
        } else {
            log.trace("[{}][{}][{}] Previous send downlink future is not active", new Object[]{this.tenantId, this.edge.getId(), this.sessionId});
        }
    }

    private void onUplinkMsg(UplinkMsg uplinkMsg) {
        if (this.isRateLimitViolated(uplinkMsg)) {
            return;
        }
        ListenableFuture future = this.processUplinkMsg(uplinkMsg);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)this.ctx.getGrpcCallbackExecutorService());
    }

    private boolean isRateLimitViolated(UplinkMsg uplinkMsg) {
        if (!this.ctx.getRateLimitService().checkRateLimit(LimitedApi.EDGE_UPLINK_MESSAGES, this.tenantId) || !this.ctx.getRateLimitService().checkRateLimit(LimitedApi.EDGE_UPLINK_MESSAGES_PER_EDGE, this.tenantId, (Object)this.edge.getId())) {
            String errorMsg = String.format("Failed to process uplink message. %s", RATE_LIMIT_REACHED);
            this.sendResponseMessage(uplinkMsg.getUplinkMsgId(), false, errorMsg);
            return true;
        }
        return false;
    }

    private void scheduleDownlinkMsgsPackSend(int attempt) {
        Runnable sendDownlinkMsgsTask = () -> {
            try {
                if (!this.isConnected()) {
                    this.stopCurrentSendDownlinkMsgsTask(Boolean.valueOf(true));
                    return;
                }
                if (!this.sessionState.getPendingMsgsMap().values().isEmpty()) {
                    ArrayList copy = new ArrayList(this.sessionState.getPendingMsgsMap().values());
                    if (attempt > 1) {
                        String error = "Failed to deliver the batch";
                        String failureMsg = String.format("{%s} (size: {%s})", error, copy.size());
                        if (attempt == 2) {
                            this.ctx.getRuleProcessor().process((NotificationRuleTrigger)EdgeCommunicationFailureTrigger.builder().tenantId(this.tenantId).edgeId(this.edge.getId()).customerId(this.edge.getCustomerId()).edgeName(this.edge.getName()).failureMsg(failureMsg).error(error).build());
                        }
                        this.ctx.getStatsCounterService().ifPresent(statsCounterService -> statsCounterService.recordEvent(EdgeStatsKey.DOWNLINK_MSGS_TMP_FAILED, this.edge.getTenantId(), this.edge.getId(), 1L));
                        log.warn("[{}][{}] {} on attempt {}", new Object[]{this.tenantId, this.edge.getId(), failureMsg, attempt});
                        log.debug("[{}][{}] entities in failed batch: {}", new Object[]{this.tenantId, this.edge.getId(), copy});
                    }
                    log.trace("[{}][{}][{}] downlink msg(s) are going to be send.", new Object[]{this.tenantId, this.edge.getId(), copy.size()});
                    for (DownlinkMsg downlinkMsg : copy) {
                        if (this.clientMaxInboundMessageSize != 0 && downlinkMsg.getSerializedSize() > this.clientMaxInboundMessageSize) {
                            String error = String.format("Client max inbound message size %s is exceeded. Please increase value of CLOUD_RPC_MAX_INBOUND_MESSAGE_SIZE env variable on the edge and restart it.", this.clientMaxInboundMessageSize);
                            String message = String.format("Downlink msg size %s exceeds client max inbound message size %s. Please increase value of CLOUD_RPC_MAX_INBOUND_MESSAGE_SIZE env variable on the edge and restart it.", downlinkMsg.getSerializedSize(), this.clientMaxInboundMessageSize);
                            log.error("[{}][{}][{}] {} Message {}", new Object[]{this.tenantId, this.edge.getId(), this.sessionId, message, downlinkMsg});
                            this.ctx.getRuleProcessor().process((NotificationRuleTrigger)EdgeCommunicationFailureTrigger.builder().tenantId(this.tenantId).edgeId(this.edge.getId()).customerId(this.edge.getCustomerId()).edgeName(this.edge.getName()).failureMsg(message).error(error).build());
                            this.ctx.getStatsCounterService().ifPresent(statsCounterService -> statsCounterService.recordEvent(EdgeStatsKey.DOWNLINK_MSGS_PERMANENTLY_FAILED, this.edge.getTenantId(), this.edge.getId(), 1L));
                            this.sessionState.getPendingMsgsMap().remove(downlinkMsg.getDownlinkMsgId());
                            continue;
                        }
                        this.sendDownlinkMsg(ResponseMsg.newBuilder().setDownlinkMsg(downlinkMsg).build());
                    }
                    if (attempt < 3) {
                        this.scheduleDownlinkMsgsPackSend(attempt + 1);
                    } else {
                        String failureMsg = String.format("Failed to deliver messages: %s", copy);
                        log.warn("[{}][{}] Failed to deliver the batch after {} attempts. Next messages are going to be discarded {}", new Object[]{this.tenantId, this.edge.getId(), 3, copy});
                        this.ctx.getRuleProcessor().process((NotificationRuleTrigger)EdgeCommunicationFailureTrigger.builder().tenantId(this.tenantId).edgeId(this.edge.getId()).customerId(this.edge.getCustomerId()).edgeName(this.edge.getName()).failureMsg(failureMsg).error("Failed to deliver messages after 3 attempts").build());
                        this.ctx.getStatsCounterService().ifPresent(statsCounterService -> statsCounterService.recordEvent(EdgeStatsKey.DOWNLINK_MSGS_PERMANENTLY_FAILED, this.edge.getTenantId(), this.edge.getId(), (long)copy.size()));
                        this.stopCurrentSendDownlinkMsgsTask(Boolean.valueOf(false));
                    }
                } else {
                    this.stopCurrentSendDownlinkMsgsTask(Boolean.valueOf(false));
                }
            }
            catch (Exception e) {
                log.warn("[{}][{}] Failed to send downlink msgs. Error msg {}", new Object[]{this.tenantId, this.edge.getId(), e.getMessage(), e});
                this.stopCurrentSendDownlinkMsgsTask(Boolean.valueOf(true));
            }
        };
        if (attempt == 1) {
            this.sendDownlinkExecutorService.submit(sendDownlinkMsgsTask);
        } else {
            this.sessionState.setScheduledSendDownlinkTask(this.sendDownlinkExecutorService.schedule(sendDownlinkMsgsTask, this.ctx.getEdgeEventStorageSettings().getSleepIntervalBetweenBatches(), TimeUnit.MILLISECONDS));
        }
    }

    private void sendResponseMessage(int uplinkMsgId, boolean success, String errorMsg) {
        UplinkResponseMsg.Builder responseBuilder = UplinkResponseMsg.newBuilder().setUplinkMsgId(uplinkMsgId).setSuccess(success);
        if (errorMsg != null) {
            responseBuilder.setErrorMsg(errorMsg);
        }
        this.sendDownlinkMsg(ResponseMsg.newBuilder().setUplinkResponseMsg(responseBuilder.build()).build());
    }

    private void onDownlinkResponse(DownlinkResponseMsg msg) {
        try {
            if (msg.getSuccess()) {
                this.sessionState.getPendingMsgsMap().remove(msg.getDownlinkMsgId());
                this.ctx.getStatsCounterService().ifPresent(statsCounterService -> statsCounterService.recordEvent(EdgeStatsKey.DOWNLINK_MSGS_PUSHED, this.edge.getTenantId(), this.edge.getId(), 1L));
                log.debug("[{}][{}][{}] Msg has been processed successfully! Msg Id: [{}], Msg: {}", new Object[]{this.tenantId, this.edge.getId(), this.sessionId, msg.getDownlinkMsgId(), msg});
            } else {
                log.debug("[{}][{}][{}] Msg processing failed! Msg Id: [{}], Error msg: {}", new Object[]{this.tenantId, this.edge.getId(), this.sessionId, msg.getDownlinkMsgId(), msg.getErrorMsg()});
                DownlinkMsg downlinkMsg = (DownlinkMsg)this.sessionState.getPendingMsgsMap().get(msg.getDownlinkMsgId());
                if (downlinkMsg.getEntityDataCount() == 0) {
                    this.sessionState.getPendingMsgsMap().remove(msg.getDownlinkMsgId());
                }
            }
            if (this.sessionState.getPendingMsgsMap().isEmpty()) {
                log.debug("[{}][{}][{}] Pending msgs map is empty. Stopping current iteration", new Object[]{this.tenantId, this.edge.getId(), this.sessionId});
                this.stopCurrentSendDownlinkMsgsTask(Boolean.valueOf(false));
            }
        }
        catch (Exception e) {
            log.error("[{}][{}] Can't process downlink response message [{}]", new Object[]{this.tenantId, this.edge.getId(), msg, e});
        }
    }

    public void processHighPriorityEvents() {
        try {
            if (this.isConnected() && !this.isSyncInProgress()) {
                EdgeEvent event;
                if (this.highPriorityQueue.isEmpty()) {
                    return;
                }
                ArrayList<EdgeEvent> highPriorityEvents = new ArrayList<EdgeEvent>();
                while ((event = (EdgeEvent)this.highPriorityQueue.poll()) != null) {
                    highPriorityEvents.add(event);
                }
                log.trace("[{}][{}] Sending high priority events {}", new Object[]{this.tenantId, this.edge.getId(), highPriorityEvents.size()});
                List downlinkMsgsPack = this.convertToDownlinkMsgsPack(highPriorityEvents);
                this.sendDownlinkMsgsPack(downlinkMsgsPack).get();
            }
        }
        catch (Exception e) {
            log.error("[{}] Failed to process high priority events", (Object)this.edge.getId(), (Object)e);
        }
    }

    public ListenableFuture<Boolean> processEdgeEvents() throws Exception {
        SettableFuture result = SettableFuture.create();
        if (this.isConnected() && !this.isSyncInProgress()) {
            Pair startTsAndSeqId = (Pair)this.getQueueStartTsAndSeqId().get();
            this.previousStartTs = (Long)startTsAndSeqId.getFirst();
            this.previousStartSeqId = (Long)startTsAndSeqId.getSecond();
            GeneralEdgeEventFetcher fetcher = new GeneralEdgeEventFetcher(this.previousStartTs, this.previousStartSeqId, false, Long.valueOf(Integer.toUnsignedLong(this.ctx.getEdgeEventStorageSettings().getMaxReadRecordsCount())), this.ctx.getEdgeEventService());
            log.trace("[{}][{}] starting processing edge events, previousStartTs = {}, previousStartSeqId = {}", new Object[]{this.tenantId, this.edge.getId(), this.previousStartTs, this.previousStartSeqId});
            Futures.addCallback((ListenableFuture)this.startProcessingEdgeEvents((EdgeEventFetcher)fetcher), (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)this.ctx.getGrpcCallbackExecutorService());
        } else if (this.isSyncInProgress()) {
            log.trace("[{}][{}] edge sync is not completed yet. Skipping iteration", (Object)this.tenantId, (Object)this.edge.getId());
            result.set((Object)Boolean.TRUE);
        } else {
            log.trace("[{}][{}] edge is not connected. Skipping iteration", (Object)this.tenantId, (Object)this.edge.getId());
            result.set(null);
        }
        return result;
    }

    protected List<DownlinkMsg> convertToDownlinkMsgsPack(List<EdgeEvent> edgeEvents) {
        ArrayList<DownlinkMsg> result = new ArrayList<DownlinkMsg>();
        for (EdgeEvent edgeEvent : edgeEvents) {
            log.trace("[{}][{}] converting edge event to downlink msg [{}]", new Object[]{this.tenantId, this.edge.getId(), edgeEvent});
            DownlinkMsg downlinkMsg = null;
            try {
                switch (7.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[edgeEvent.getAction().ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        downlinkMsg = this.convertEntityEventToDownlink(edgeEvent);
                        if (downlinkMsg != null && downlinkMsg.getWidgetTypeUpdateMsgCount() > 0) {
                            log.trace("[{}][{}] widgetTypeUpdateMsg message processed, downlinkMsgId = {}", new Object[]{this.tenantId, this.edge.getId(), downlinkMsg.getDownlinkMsgId()});
                            break;
                        }
                        log.trace("[{}][{}] entity message processed [{}]", new Object[]{this.tenantId, this.edge.getId(), downlinkMsg});
                        break;
                    }
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: {
                        downlinkMsg = this.ctx.getTelemetryProcessor().convertTelemetryEventToDownlink(this.edge, edgeEvent);
                        break;
                    }
                    default: {
                        log.warn("[{}][{}] Unsupported action type [{}]", new Object[]{this.tenantId, this.edge.getId(), edgeEvent.getAction()});
                        break;
                    }
                }
            }
            catch (Exception e) {
                log.trace("[{}][{}] Exception during converting edge event to downlink msg", new Object[]{this.tenantId, this.edge.getId(), e});
            }
            if (downlinkMsg == null) continue;
            result.add(downlinkMsg);
        }
        return result;
    }

    private ListenableFuture<Pair<Long, Long>> getQueueStartTsAndSeqId() {
        ListenableFuture future = this.ctx.getAttributesService().find(this.edge.getTenantId(), (EntityId)this.edge.getId(), AttributeScope.SERVER_SCOPE, Arrays.asList(QUEUE_START_TS_ATTR_KEY, QUEUE_START_SEQ_ID_ATTR_KEY));
        return Futures.transform((ListenableFuture)future, attributeKvEntries -> {
            long startTs = 0L;
            long startSeqId = 0L;
            for (AttributeKvEntry attributeKvEntry : attributeKvEntries) {
                if (QUEUE_START_TS_ATTR_KEY.equals(attributeKvEntry.getKey())) {
                    long l = startTs = attributeKvEntry.getLongValue().isPresent() ? (Long)attributeKvEntry.getLongValue().get() : 0L;
                }
                if (!QUEUE_START_SEQ_ID_ATTR_KEY.equals(attributeKvEntry.getKey())) continue;
                startSeqId = attributeKvEntry.getLongValue().isPresent() ? (Long)attributeKvEntry.getLongValue().get() : 0L;
            }
            if (startSeqId == 0L) {
                startSeqId = this.findStartSeqIdFromOldestEventIfAny();
            }
            return Pair.of((Object)startTs, (Object)startSeqId);
        }, (Executor)this.ctx.getGrpcCallbackExecutorService());
    }

    private boolean isSeqIdStartedNewCycle() {
        try {
            log.trace("[{}][{}][{}] Checking if seq id started new cycle", new Object[]{this.tenantId, this.edge.getId(), this.sessionId});
            TimePageLink pageLink = new TimePageLink(this.ctx.getEdgeEventStorageSettings().getMaxReadRecordsCount(), 0, null, null, this.newStartTs, Long.valueOf(System.currentTimeMillis()));
            PageData edgeEvents = this.ctx.getEdgeEventService().findEdgeEvents(this.edge.getTenantId(), this.edge.getId(), Long.valueOf(0L), this.previousStartSeqId == 0L ? null : Long.valueOf(this.previousStartSeqId - 1L), pageLink);
            boolean result = !edgeEvents.getData().isEmpty();
            log.trace("[{}][{}][{}] Result of check if seq id started new cycle, result = {}", new Object[]{this.tenantId, this.edge.getId(), this.sessionId, result});
            return result;
        }
        catch (Exception e) {
            log.error("[{}][{}][{}] Failed to execute isSeqIdStartedNewCycle", new Object[]{this.tenantId, this.edge.getId(), this.sessionId, e});
            return false;
        }
    }

    private boolean isNewEdgeEventsAvailable() {
        try {
            log.trace("[{}][{}][{}] Checking if new edge events available", new Object[]{this.tenantId, this.edge.getId(), this.sessionId});
            TimePageLink pageLink = new TimePageLink(this.ctx.getEdgeEventStorageSettings().getMaxReadRecordsCount(), 0, null, null, this.newStartTs, Long.valueOf(System.currentTimeMillis()));
            PageData edgeEvents = this.ctx.getEdgeEventService().findEdgeEvents(this.edge.getTenantId(), this.edge.getId(), this.newStartSeqId, null, pageLink);
            boolean result = !edgeEvents.getData().isEmpty() || !this.highPriorityQueue.isEmpty();
            log.trace("[{}][{}][{}] Result of check if new edge events available, result = {}", new Object[]{this.tenantId, this.edge.getId(), this.sessionId, result});
            return result;
        }
        catch (Exception e) {
            log.error("[{}][{}][{}] Failed to execute isNewEdgeEventsAvailable", new Object[]{this.tenantId, this.edge.getId(), this.sessionId, e});
            return false;
        }
    }

    private long findStartSeqIdFromOldestEventIfAny() {
        long startSeqId = 0L;
        try {
            TimePageLink pageLink = new TimePageLink(1, 0, null, null, null, null);
            PageData edgeEvents = this.ctx.getEdgeEventService().findEdgeEvents(this.edge.getTenantId(), this.edge.getId(), null, null, pageLink);
            if (!edgeEvents.getData().isEmpty()) {
                startSeqId = ((EdgeEvent)edgeEvents.getData().get(0)).getSeqId() - 1L;
            }
        }
        catch (Exception e) {
            log.error("[{}][{}][{}] Failed to execute findStartSeqIdFromOldestEventIfAny", new Object[]{this.tenantId, this.edge.getId(), this.sessionId, e});
        }
        return startSeqId;
    }

    private ListenableFuture<AttributesSaveResult> updateQueueStartTsAndSeqId(Pair<Long, Long> pair) {
        this.newStartTs = (Long)pair.getFirst();
        this.newStartSeqId = (Long)pair.getSecond();
        log.trace("[{}] updateQueueStartTsAndSeqId [{}][{}][{}]", new Object[]{this.sessionId, this.edge.getId(), this.newStartTs, this.newStartSeqId});
        List<BaseAttributeKvEntry> attributes = List.of(new BaseAttributeKvEntry((KvEntry)new LongDataEntry(QUEUE_START_TS_ATTR_KEY, this.newStartTs), System.currentTimeMillis()), new BaseAttributeKvEntry((KvEntry)new LongDataEntry(QUEUE_START_SEQ_ID_ATTR_KEY, this.newStartSeqId), System.currentTimeMillis()));
        return this.ctx.getAttributesService().save(this.edge.getTenantId(), (EntityId)this.edge.getId(), AttributeScope.SERVER_SCOPE, attributes);
    }

    protected ListenableFuture<Pair<Long, Long>> startProcessingEdgeEvents(EdgeEventFetcher fetcher) {
        SettableFuture result = SettableFuture.create();
        PageLink pageLink = fetcher.getPageLink(this.ctx.getEdgeEventStorageSettings().getMaxReadRecordsCount());
        this.processEdgeEvents(fetcher, pageLink, result);
        return result;
    }

    private void markSyncCompletedSendEdgeEventUpdate() {
        this.syncInProgress = false;
        this.ctx.getClusterService().onEdgeEventUpdate(new EdgeEventUpdateMsg(this.edge.getTenantId(), this.edge.getId()));
    }

    private void stopCurrentSendDownlinkMsgsTask(Boolean isInterrupted) {
        if (this.sessionState.getSendDownlinkMsgsFuture() != null && !this.sessionState.getSendDownlinkMsgsFuture().isDone()) {
            this.sessionState.getSendDownlinkMsgsFuture().set((Object)isInterrupted);
        }
        if (this.sessionState.getScheduledSendDownlinkTask() != null) {
            this.sessionState.getScheduledSendDownlinkTask().cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDownlinkMsg(ResponseMsg responseMsg) {
        if (this.isConnected()) {
            String responseMsgStr = StringUtils.truncate((String)responseMsg.toString(), (int)10000);
            log.trace("[{}][{}] Sending downlink msg [{}]", new Object[]{this.tenantId, this.edge.getId(), responseMsgStr});
            this.downlinkMsgLock.lock();
            String downlinkMsgStr = responseMsg.hasDownlinkMsg() ? String.valueOf(responseMsg.getDownlinkMsg().getDownlinkMsgId()) : responseMsgStr;
            try {
                this.outputStream.onNext((Object)responseMsg);
            }
            catch (Exception e) {
                log.trace("[{}][{}] Failed to send downlink message [{}]", new Object[]{this.tenantId, this.edge.getId(), downlinkMsgStr, e});
                this.connected = false;
                this.sessionCloseListener.accept(this.edge, this.sessionId);
            }
            finally {
                this.downlinkMsgLock.unlock();
            }
            log.trace("[{}][{}] downlink msg successfully sent [{}]", new Object[]{this.tenantId, this.edge.getId(), downlinkMsgStr});
        }
    }

    protected DownlinkMsg convertEntityEventToDownlink(EdgeEvent edgeEvent) {
        log.trace("[{}] Executing convertEntityEventToDownlink, edgeEvent [{}], action [{}]", new Object[]{edgeEvent.getTenantId(), edgeEvent, edgeEvent.getAction()});
        if (!this.isValidEdgeEvent(edgeEvent)) {
            return null;
        }
        return this.ctx.getProcessor(edgeEvent.getType()).convertEdgeEventToDownlink(edgeEvent, this.edgeVersion);
    }

    private boolean isValidEdgeEvent(EdgeEvent edgeEvent) {
        EdgeEventType eventType = edgeEvent.getType();
        if ((EdgeEventType.OAUTH2_CLIENT.equals((Object)eventType) || EdgeEventType.DOMAIN.equals((Object)eventType) || EdgeEventType.CUSTOM_MENU.equals((Object)eventType)) && EdgeVersionUtils.isEdgeVersionOlderThan((EdgeVersion)this.edgeVersion, (EdgeVersion)EdgeVersion.V_3_8_0)) {
            return false;
        }
        return !EdgeEventType.CUSTOM_TRANSLATION.equals((Object)eventType) || !EdgeVersionUtils.isEdgeVersionOlderThan((EdgeVersion)this.edgeVersion, (EdgeVersion)EdgeVersion.V_3_7_0);
    }

    public void addEventToHighPriorityQueue(EdgeEvent edgeEvent) {
        while (this.highPriorityQueue.size() > this.maxHighPriorityQueueSizePerSession) {
            EdgeEvent oldestHighPriority = (EdgeEvent)this.highPriorityQueue.poll();
            if (oldestHighPriority == null) continue;
            log.warn("[{}][{}][{}] High priority queue is full. Removing oldest high priority event from queue {}", new Object[]{this.tenantId, this.edge.getId(), this.sessionId, oldestHighPriority});
        }
        this.highPriorityQueue.add(edgeEvent);
        this.ctx.getStatsCounterService().ifPresent(statsCounterService -> statsCounterService.recordEvent(EdgeStatsKey.DOWNLINK_MSGS_ADDED, this.edge.getTenantId(), edgeEvent.getEdgeId(), 1L));
    }

    protected ListenableFuture<List<Void>> processUplinkMsg(UplinkMsg uplinkMsg) {
        ArrayList<ListenableFuture> result = new ArrayList<ListenableFuture>();
        try {
            if (uplinkMsg.getDeviceProfileUpdateMsgCount() > 0) {
                for (DeviceProfileUpdateMsg deviceProfileUpdateMsg : uplinkMsg.getDeviceProfileUpdateMsgList()) {
                    result.add(this.ctx.getDeviceProfileProcessor().processDeviceProfileMsgFromEdge(this.edge.getTenantId(), this.edge, deviceProfileUpdateMsg));
                }
            }
            if (uplinkMsg.getDeviceUpdateMsgCount() > 0) {
                for (DeviceUpdateMsg deviceUpdateMsg : uplinkMsg.getDeviceUpdateMsgList()) {
                    result.add(this.ctx.getDeviceProcessor().processDeviceMsgFromEdge(this.edge.getTenantId(), this.edge, deviceUpdateMsg));
                }
            }
            if (uplinkMsg.getDeviceCredentialsUpdateMsgCount() > 0) {
                for (DeviceCredentialsUpdateMsg deviceCredentialsUpdateMsg : uplinkMsg.getDeviceCredentialsUpdateMsgList()) {
                    result.add(this.ctx.getDeviceProcessor().processDeviceCredentialsMsgFromEdge(this.edge.getTenantId(), this.edge.getId(), deviceCredentialsUpdateMsg));
                }
            }
            if (uplinkMsg.getAssetProfileUpdateMsgCount() > 0) {
                for (AssetProfileUpdateMsg assetProfileUpdateMsg : uplinkMsg.getAssetProfileUpdateMsgList()) {
                    result.add(this.ctx.getAssetProfileProcessor().processAssetProfileMsgFromEdge(this.edge.getTenantId(), this.edge, assetProfileUpdateMsg));
                }
            }
            if (uplinkMsg.getAssetUpdateMsgCount() > 0) {
                for (AssetUpdateMsg assetUpdateMsg : uplinkMsg.getAssetUpdateMsgList()) {
                    result.add(this.ctx.getAssetProcessor().processAssetMsgFromEdge(this.edge.getTenantId(), this.edge, assetUpdateMsg));
                }
            }
            if (uplinkMsg.getRuleChainUpdateMsgCount() > 0) {
                for (RuleChainUpdateMsg ruleChainUpdateMsg : uplinkMsg.getRuleChainUpdateMsgList()) {
                    result.add(this.ctx.getRuleChainProcessor().processRuleChainMsgFromEdge(this.edge.getTenantId(), this.edge, ruleChainUpdateMsg));
                }
            }
            if (uplinkMsg.getRuleChainMetadataUpdateMsgCount() > 0) {
                for (RuleChainMetadataUpdateMsg ruleChainMetadataUpdateMsg : uplinkMsg.getRuleChainMetadataUpdateMsgList()) {
                    result.add(this.ctx.getRuleChainProcessor().processRuleChainMetadataMsgFromEdge(this.edge.getTenantId(), this.edge, ruleChainMetadataUpdateMsg));
                }
            }
            if (uplinkMsg.getEntityViewUpdateMsgCount() > 0) {
                for (EntityViewUpdateMsg entityViewUpdateMsg : uplinkMsg.getEntityViewUpdateMsgList()) {
                    result.add(this.ctx.getEntityViewProcessor().processEntityViewMsgFromEdge(this.edge.getTenantId(), this.edge, entityViewUpdateMsg));
                }
            }
            if (uplinkMsg.getEntityDataCount() > 0) {
                for (EntityDataProto entityData : uplinkMsg.getEntityDataList()) {
                    result.addAll(this.ctx.getTelemetryProcessor().processTelemetryMsg(this.edge.getTenantId(), entityData));
                }
            }
            if (uplinkMsg.getAlarmUpdateMsgCount() > 0) {
                for (AlarmUpdateMsg alarmUpdateMsg : uplinkMsg.getAlarmUpdateMsgList()) {
                    result.add(this.ctx.getAlarmProcessor().processAlarmMsgFromEdge(this.edge.getTenantId(), this.edge.getId(), alarmUpdateMsg));
                }
            }
            if (uplinkMsg.getAlarmCommentUpdateMsgCount() > 0) {
                for (AlarmCommentUpdateMsg alarmCommentUpdateMsg : uplinkMsg.getAlarmCommentUpdateMsgList()) {
                    result.add(this.ctx.getAlarmCommentProcessor().processAlarmCommentMsgFromEdge(this.edge.getTenantId(), this.edge.getId(), alarmCommentUpdateMsg));
                }
            }
            if (uplinkMsg.getRelationUpdateMsgCount() > 0) {
                for (RelationUpdateMsg relationUpdateMsg : uplinkMsg.getRelationUpdateMsgList()) {
                    result.add(this.ctx.getRelationProcessor().processRelationMsgFromEdge(this.edge.getTenantId(), this.edge, relationUpdateMsg));
                }
            }
            if (uplinkMsg.getDashboardUpdateMsgCount() > 0) {
                for (DashboardUpdateMsg dashboardUpdateMsg : uplinkMsg.getDashboardUpdateMsgList()) {
                    result.add(this.ctx.getDashboardProcessor().processDashboardMsgFromEdge(this.edge.getTenantId(), this.edge, dashboardUpdateMsg));
                }
            }
            if (uplinkMsg.getResourceUpdateMsgCount() > 0) {
                for (ResourceUpdateMsg resourceUpdateMsg : uplinkMsg.getResourceUpdateMsgList()) {
                    result.add(this.ctx.getResourceProcessor().processResourceMsgFromEdge(this.edge.getTenantId(), this.edge, resourceUpdateMsg));
                }
            }
            if (uplinkMsg.getRuleChainMetadataRequestMsgCount() > 0) {
                for (RuleChainMetadataRequestMsg ruleChainMetadataRequestMsg : uplinkMsg.getRuleChainMetadataRequestMsgList()) {
                    result.add(this.ctx.getEdgeRequestsService().processRuleChainMetadataRequestMsg(this.edge.getTenantId(), this.edge, ruleChainMetadataRequestMsg));
                }
            }
            if (uplinkMsg.getAttributesRequestMsgCount() > 0) {
                for (AttributesRequestMsg attributesRequestMsg : uplinkMsg.getAttributesRequestMsgList()) {
                    result.add(this.ctx.getEdgeRequestsService().processAttributesRequestMsg(this.edge.getTenantId(), this.edge, attributesRequestMsg));
                }
            }
            if (uplinkMsg.getRelationRequestMsgCount() > 0) {
                for (RelationRequestMsg relationRequestMsg : uplinkMsg.getRelationRequestMsgList()) {
                    result.add(this.ctx.getEdgeRequestsService().processRelationRequestMsg(this.edge.getTenantId(), this.edge, relationRequestMsg));
                }
            }
            if (uplinkMsg.getCalculatedFieldRequestMsgCount() > 0) {
                for (CalculatedFieldRequestMsg calculatedFieldRequestMsg : uplinkMsg.getCalculatedFieldRequestMsgList()) {
                    result.add(this.ctx.getEdgeRequestsService().processCalculatedFieldRequestMsg(this.edge.getTenantId(), this.edge, calculatedFieldRequestMsg));
                }
            }
            if (uplinkMsg.getUserCredentialsRequestMsgCount() > 0) {
                for (UserCredentialsRequestMsg userCredentialsRequestMsg : uplinkMsg.getUserCredentialsRequestMsgList()) {
                    result.add(this.ctx.getEdgeRequestsService().processUserCredentialsRequestMsg(this.edge.getTenantId(), this.edge, userCredentialsRequestMsg));
                }
            }
            if (uplinkMsg.getDeviceCredentialsRequestMsgCount() > 0) {
                for (DeviceCredentialsRequestMsg deviceCredentialsRequestMsg : uplinkMsg.getDeviceCredentialsRequestMsgList()) {
                    result.add(this.ctx.getEdgeRequestsService().processDeviceCredentialsRequestMsg(this.edge.getTenantId(), this.edge, deviceCredentialsRequestMsg));
                }
            }
            if (uplinkMsg.getDeviceRpcCallMsgCount() > 0) {
                for (DeviceRpcCallMsg deviceRpcCallMsg : uplinkMsg.getDeviceRpcCallMsgList()) {
                    result.add(this.ctx.getDeviceProcessor().processDeviceRpcCallFromEdge(this.edge.getTenantId(), this.edge, deviceRpcCallMsg));
                }
            }
            if (uplinkMsg.getWidgetBundleTypesRequestMsgCount() > 0) {
                for (WidgetBundleTypesRequestMsg widgetBundleTypesRequestMsg : uplinkMsg.getWidgetBundleTypesRequestMsgList()) {
                    result.add(this.ctx.getEdgeRequestsService().processWidgetBundleTypesRequestMsg(this.edge.getTenantId(), this.edge, widgetBundleTypesRequestMsg));
                }
            }
            if (uplinkMsg.getEntityViewsRequestMsgCount() > 0) {
                for (EntityViewsRequestMsg entityViewRequestMsg : uplinkMsg.getEntityViewsRequestMsgList()) {
                    result.add(this.ctx.getEdgeRequestsService().processEntityViewsRequestMsg(this.edge.getTenantId(), this.edge, entityViewRequestMsg));
                }
            }
            if (uplinkMsg.getEntityGroupEntitiesRequestMsgCount() > 0) {
                for (EntityGroupRequestMsg entityGroupEntitiesRequestMsg : uplinkMsg.getEntityGroupEntitiesRequestMsgList()) {
                    result.add(this.ctx.getEdgeRequestsService().processEntityGroupEntitiesRequest(this.edge.getTenantId(), this.edge, entityGroupEntitiesRequestMsg));
                }
            }
            if (uplinkMsg.getEntityGroupPermissionsRequestMsgCount() > 0) {
                for (EntityGroupRequestMsg userGroupPermissionsRequestMsg : uplinkMsg.getEntityGroupPermissionsRequestMsgList()) {
                    result.add(this.ctx.getEdgeRequestsService().processEntityGroupPermissionsRequest(this.edge.getTenantId(), this.edge, userGroupPermissionsRequestMsg));
                }
            }
            if (uplinkMsg.getCalculatedFieldUpdateMsgCount() > 0) {
                for (CalculatedFieldUpdateMsg calculatedFieldUpdateMsg : uplinkMsg.getCalculatedFieldUpdateMsgList()) {
                    result.add(this.ctx.getCalculatedFieldProcessor().processCalculatedFieldMsgFromEdge(this.edge.getTenantId(), this.edge, calculatedFieldUpdateMsg));
                }
            }
        }
        catch (Exception e) {
            String failureMsg = String.format("Can't process uplink msg [%s] from edge", uplinkMsg);
            log.trace("[{}][{}] Can't process uplink msg [{}]", new Object[]{this.tenantId, this.edge.getId(), uplinkMsg, e});
            this.ctx.getRuleProcessor().process((NotificationRuleTrigger)EdgeCommunicationFailureTrigger.builder().tenantId(this.tenantId).edgeId(this.edge.getId()).customerId(this.edge.getCustomerId()).edgeName(this.edge.getName()).failureMsg(failureMsg).error(e.getMessage()).build());
            return Futures.immediateFailedFuture((Throwable)e);
        }
        return Futures.allAsList(result);
    }

    protected boolean destroy() {
        return true;
    }

    protected void cleanUp() {
    }

    @Override
    public void close() {
        log.debug("[{}][{}] Closing session", (Object)this.tenantId, (Object)this.sessionId);
        this.connected = false;
        try {
            this.outputStream.onCompleted();
        }
        catch (Exception e) {
            log.debug("[{}][{}] Failed to close output stream: {}", new Object[]{this.tenantId, this.sessionId, e.getMessage()});
        }
    }

    @Generated
    public ConcurrentLinkedQueue<EdgeEvent> getHighPriorityQueue() {
        return this.highPriorityQueue;
    }

    @Generated
    public UUID getSessionId() {
        return this.sessionId;
    }

    @Generated
    public BiConsumer<EdgeId, EdgeGrpcSession> getSessionOpenListener() {
        return this.sessionOpenListener;
    }

    @Generated
    public BiConsumer<Edge, UUID> getSessionCloseListener() {
        return this.sessionCloseListener;
    }

    @Generated
    public EdgeSessionState getSessionState() {
        return this.sessionState;
    }

    @Generated
    public ReentrantLock getDownlinkMsgLock() {
        return this.downlinkMsgLock;
    }

    @Generated
    public EdgeContextComponent getCtx() {
        return this.ctx;
    }

    @Generated
    public Edge getEdge() {
        return this.edge;
    }

    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public Long getNewStartTs() {
        return this.newStartTs;
    }

    @Generated
    public Long getPreviousStartTs() {
        return this.previousStartTs;
    }

    @Generated
    public Long getNewStartSeqId() {
        return this.newStartSeqId;
    }

    @Generated
    public Long getPreviousStartSeqId() {
        return this.previousStartSeqId;
    }

    @Generated
    public StreamObserver<RequestMsg> getInputStream() {
        return this.inputStream;
    }

    @Generated
    public StreamObserver<ResponseMsg> getOutputStream() {
        return this.outputStream;
    }

    @Generated
    public boolean isConnected() {
        return this.connected;
    }

    @Generated
    public boolean isSyncInProgress() {
        return this.syncInProgress;
    }

    @Generated
    public EdgeVersion getEdgeVersion() {
        return this.edgeVersion;
    }

    @Generated
    public int getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    @Generated
    public int getClientMaxInboundMessageSize() {
        return this.clientMaxInboundMessageSize;
    }

    @Generated
    public int getMaxHighPriorityQueueSizePerSession() {
        return this.maxHighPriorityQueueSizePerSession;
    }

    @Generated
    public ScheduledExecutorService getSendDownlinkExecutorService() {
        return this.sendDownlinkExecutorService;
    }

    @Generated
    public void setSessionId(UUID sessionId) {
        this.sessionId = sessionId;
    }

    @Generated
    public void setSessionOpenListener(BiConsumer<EdgeId, EdgeGrpcSession> sessionOpenListener) {
        this.sessionOpenListener = sessionOpenListener;
    }

    @Generated
    public void setSessionCloseListener(BiConsumer<Edge, UUID> sessionCloseListener) {
        this.sessionCloseListener = sessionCloseListener;
    }

    @Generated
    public void setCtx(EdgeContextComponent ctx) {
        this.ctx = ctx;
    }

    @Generated
    public void setEdge(Edge edge) {
        this.edge = edge;
    }

    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setNewStartTs(Long newStartTs) {
        this.newStartTs = newStartTs;
    }

    @Generated
    public void setPreviousStartTs(Long previousStartTs) {
        this.previousStartTs = previousStartTs;
    }

    @Generated
    public void setNewStartSeqId(Long newStartSeqId) {
        this.newStartSeqId = newStartSeqId;
    }

    @Generated
    public void setPreviousStartSeqId(Long previousStartSeqId) {
        this.previousStartSeqId = previousStartSeqId;
    }

    @Generated
    public void setInputStream(StreamObserver<RequestMsg> inputStream) {
        this.inputStream = inputStream;
    }

    @Generated
    public void setOutputStream(StreamObserver<ResponseMsg> outputStream) {
        this.outputStream = outputStream;
    }

    @Generated
    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    @Generated
    public void setSyncInProgress(boolean syncInProgress) {
        this.syncInProgress = syncInProgress;
    }

    @Generated
    public void setEdgeVersion(EdgeVersion edgeVersion) {
        this.edgeVersion = edgeVersion;
    }

    @Generated
    public void setMaxInboundMessageSize(int maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    @Generated
    public void setClientMaxInboundMessageSize(int clientMaxInboundMessageSize) {
        this.clientMaxInboundMessageSize = clientMaxInboundMessageSize;
    }

    @Generated
    public void setMaxHighPriorityQueueSizePerSession(int maxHighPriorityQueueSizePerSession) {
        this.maxHighPriorityQueueSizePerSession = maxHighPriorityQueueSizePerSession;
    }

    @Generated
    public void setSendDownlinkExecutorService(ScheduledExecutorService sendDownlinkExecutorService) {
        this.sendDownlinkExecutorService = sendDownlinkExecutorService;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EdgeGrpcSession)) {
            return false;
        }
        EdgeGrpcSession other = (EdgeGrpcSession)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isConnected() != other.isConnected()) {
            return false;
        }
        if (this.isSyncInProgress() != other.isSyncInProgress()) {
            return false;
        }
        if (this.getMaxInboundMessageSize() != other.getMaxInboundMessageSize()) {
            return false;
        }
        if (this.getClientMaxInboundMessageSize() != other.getClientMaxInboundMessageSize()) {
            return false;
        }
        if (this.getMaxHighPriorityQueueSizePerSession() != other.getMaxHighPriorityQueueSizePerSession()) {
            return false;
        }
        Long this$newStartTs = this.getNewStartTs();
        Long other$newStartTs = other.getNewStartTs();
        if (this$newStartTs == null ? other$newStartTs != null : !((Object)this$newStartTs).equals(other$newStartTs)) {
            return false;
        }
        Long this$previousStartTs = this.getPreviousStartTs();
        Long other$previousStartTs = other.getPreviousStartTs();
        if (this$previousStartTs == null ? other$previousStartTs != null : !((Object)this$previousStartTs).equals(other$previousStartTs)) {
            return false;
        }
        Long this$newStartSeqId = this.getNewStartSeqId();
        Long other$newStartSeqId = other.getNewStartSeqId();
        if (this$newStartSeqId == null ? other$newStartSeqId != null : !((Object)this$newStartSeqId).equals(other$newStartSeqId)) {
            return false;
        }
        Long this$previousStartSeqId = this.getPreviousStartSeqId();
        Long other$previousStartSeqId = other.getPreviousStartSeqId();
        if (this$previousStartSeqId == null ? other$previousStartSeqId != null : !((Object)this$previousStartSeqId).equals(other$previousStartSeqId)) {
            return false;
        }
        ConcurrentLinkedQueue this$highPriorityQueue = this.getHighPriorityQueue();
        ConcurrentLinkedQueue other$highPriorityQueue = other.getHighPriorityQueue();
        if (this$highPriorityQueue == null ? other$highPriorityQueue != null : !this$highPriorityQueue.equals(other$highPriorityQueue)) {
            return false;
        }
        UUID this$sessionId = this.getSessionId();
        UUID other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !((Object)this$sessionId).equals(other$sessionId)) {
            return false;
        }
        BiConsumer this$sessionOpenListener = this.getSessionOpenListener();
        BiConsumer other$sessionOpenListener = other.getSessionOpenListener();
        if (this$sessionOpenListener == null ? other$sessionOpenListener != null : !this$sessionOpenListener.equals(other$sessionOpenListener)) {
            return false;
        }
        BiConsumer this$sessionCloseListener = this.getSessionCloseListener();
        BiConsumer other$sessionCloseListener = other.getSessionCloseListener();
        if (this$sessionCloseListener == null ? other$sessionCloseListener != null : !this$sessionCloseListener.equals(other$sessionCloseListener)) {
            return false;
        }
        EdgeSessionState this$sessionState = this.getSessionState();
        EdgeSessionState other$sessionState = other.getSessionState();
        if (this$sessionState == null ? other$sessionState != null : !this$sessionState.equals(other$sessionState)) {
            return false;
        }
        ReentrantLock this$downlinkMsgLock = this.getDownlinkMsgLock();
        ReentrantLock other$downlinkMsgLock = other.getDownlinkMsgLock();
        if (this$downlinkMsgLock == null ? other$downlinkMsgLock != null : !this$downlinkMsgLock.equals(other$downlinkMsgLock)) {
            return false;
        }
        EdgeContextComponent this$ctx = this.getCtx();
        EdgeContextComponent other$ctx = other.getCtx();
        if (this$ctx == null ? other$ctx != null : !this$ctx.equals(other$ctx)) {
            return false;
        }
        Edge this$edge = this.getEdge();
        Edge other$edge = other.getEdge();
        if (this$edge == null ? other$edge != null : !this$edge.equals(other$edge)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        StreamObserver this$inputStream = this.getInputStream();
        StreamObserver other$inputStream = other.getInputStream();
        if (this$inputStream == null ? other$inputStream != null : !this$inputStream.equals(other$inputStream)) {
            return false;
        }
        StreamObserver this$outputStream = this.getOutputStream();
        StreamObserver other$outputStream = other.getOutputStream();
        if (this$outputStream == null ? other$outputStream != null : !this$outputStream.equals(other$outputStream)) {
            return false;
        }
        EdgeVersion this$edgeVersion = this.getEdgeVersion();
        EdgeVersion other$edgeVersion = other.getEdgeVersion();
        if (this$edgeVersion == null ? other$edgeVersion != null : !this$edgeVersion.equals(other$edgeVersion)) {
            return false;
        }
        ScheduledExecutorService this$sendDownlinkExecutorService = this.getSendDownlinkExecutorService();
        ScheduledExecutorService other$sendDownlinkExecutorService = other.getSendDownlinkExecutorService();
        return !(this$sendDownlinkExecutorService == null ? other$sendDownlinkExecutorService != null : !this$sendDownlinkExecutorService.equals(other$sendDownlinkExecutorService));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EdgeGrpcSession;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isConnected() ? 79 : 97);
        result = result * 59 + (this.isSyncInProgress() ? 79 : 97);
        result = result * 59 + this.getMaxInboundMessageSize();
        result = result * 59 + this.getClientMaxInboundMessageSize();
        result = result * 59 + this.getMaxHighPriorityQueueSizePerSession();
        Long $newStartTs = this.getNewStartTs();
        result = result * 59 + ($newStartTs == null ? 43 : ((Object)$newStartTs).hashCode());
        Long $previousStartTs = this.getPreviousStartTs();
        result = result * 59 + ($previousStartTs == null ? 43 : ((Object)$previousStartTs).hashCode());
        Long $newStartSeqId = this.getNewStartSeqId();
        result = result * 59 + ($newStartSeqId == null ? 43 : ((Object)$newStartSeqId).hashCode());
        Long $previousStartSeqId = this.getPreviousStartSeqId();
        result = result * 59 + ($previousStartSeqId == null ? 43 : ((Object)$previousStartSeqId).hashCode());
        ConcurrentLinkedQueue $highPriorityQueue = this.getHighPriorityQueue();
        result = result * 59 + ($highPriorityQueue == null ? 43 : $highPriorityQueue.hashCode());
        UUID $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : ((Object)$sessionId).hashCode());
        BiConsumer $sessionOpenListener = this.getSessionOpenListener();
        result = result * 59 + ($sessionOpenListener == null ? 43 : $sessionOpenListener.hashCode());
        BiConsumer $sessionCloseListener = this.getSessionCloseListener();
        result = result * 59 + ($sessionCloseListener == null ? 43 : $sessionCloseListener.hashCode());
        EdgeSessionState $sessionState = this.getSessionState();
        result = result * 59 + ($sessionState == null ? 43 : $sessionState.hashCode());
        ReentrantLock $downlinkMsgLock = this.getDownlinkMsgLock();
        result = result * 59 + ($downlinkMsgLock == null ? 43 : $downlinkMsgLock.hashCode());
        EdgeContextComponent $ctx = this.getCtx();
        result = result * 59 + ($ctx == null ? 43 : $ctx.hashCode());
        Edge $edge = this.getEdge();
        result = result * 59 + ($edge == null ? 43 : $edge.hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        StreamObserver $inputStream = this.getInputStream();
        result = result * 59 + ($inputStream == null ? 43 : $inputStream.hashCode());
        StreamObserver $outputStream = this.getOutputStream();
        result = result * 59 + ($outputStream == null ? 43 : $outputStream.hashCode());
        EdgeVersion $edgeVersion = this.getEdgeVersion();
        result = result * 59 + ($edgeVersion == null ? 43 : $edgeVersion.hashCode());
        ScheduledExecutorService $sendDownlinkExecutorService = this.getSendDownlinkExecutorService();
        result = result * 59 + ($sendDownlinkExecutorService == null ? 43 : $sendDownlinkExecutorService.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EdgeGrpcSession(highPriorityQueue=" + String.valueOf(this.getHighPriorityQueue()) + ", sessionId=" + String.valueOf(this.getSessionId()) + ", sessionOpenListener=" + String.valueOf(this.getSessionOpenListener()) + ", sessionCloseListener=" + String.valueOf(this.getSessionCloseListener()) + ", sessionState=" + String.valueOf(this.getSessionState()) + ", downlinkMsgLock=" + String.valueOf(this.getDownlinkMsgLock()) + ", ctx=" + String.valueOf(this.getCtx()) + ", edge=" + String.valueOf(this.getEdge()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", newStartTs=" + this.getNewStartTs() + ", previousStartTs=" + this.getPreviousStartTs() + ", newStartSeqId=" + this.getNewStartSeqId() + ", previousStartSeqId=" + this.getPreviousStartSeqId() + ", inputStream=" + String.valueOf(this.getInputStream()) + ", outputStream=" + String.valueOf(this.getOutputStream()) + ", connected=" + this.isConnected() + ", syncInProgress=" + this.isSyncInProgress() + ", edgeVersion=" + String.valueOf(this.getEdgeVersion()) + ", maxInboundMessageSize=" + this.getMaxInboundMessageSize() + ", clientMaxInboundMessageSize=" + this.getClientMaxInboundMessageSize() + ", maxHighPriorityQueueSizePerSession=" + this.getMaxHighPriorityQueueSizePerSession() + ", sendDownlinkExecutorService=" + String.valueOf(this.getSendDownlinkExecutorService()) + ")";
    }
}

