/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.custommenu;

import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.event.TransactionalEventListener;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.CustomMenuDeleteResult;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.menu.CMAssigneeType;
import org.thingsboard.server.common.data.menu.CustomMenu;
import org.thingsboard.server.common.data.menu.CustomMenuInfo;
import org.thingsboard.server.dao.menu.CustomMenuCacheEvictEvent;
import org.thingsboard.server.dao.menu.CustomMenuCacheKey;
import org.thingsboard.server.dao.menu.CustomMenuService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.custommenu.TbCustomMenuService;
import org.thingsboard.server.service.entitiy.AbstractEtagCacheService;

@Service
@TbCoreComponent
public class DefaultTbCustomMenuService
extends AbstractEtagCacheService<CustomMenuCacheKey>
implements TbCustomMenuService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbCustomMenuService.class);
    private final CustomMenuService customMenuService;
    private final TbClusterService clusterService;

    public DefaultTbCustomMenuService(TbClusterService clusterService, CustomMenuService customMenuService, @Value(value="${cache.customMenu.etag.timeToLiveInMinutes:44640}") int cacheTtl, @Value(value="${cache.customMenu.etag.maxSize:1000000}") int cacheMaxSize) {
        super(cacheTtl, cacheMaxSize);
        this.clusterService = clusterService;
        this.customMenuService = customMenuService;
    }

    public CustomMenu createCustomMenu(CustomMenuInfo customMenuInfo, List<EntityId> assignToList, boolean force) throws ThingsboardException {
        return this.customMenuService.createCustomMenu(customMenuInfo, assignToList, force);
    }

    public CustomMenu updateCustomMenu(CustomMenu customMenu, boolean force) throws ThingsboardException {
        return this.customMenuService.updateCustomMenu(customMenu, force);
    }

    public void updateAssigneeList(CustomMenu oldCustomMenu, CMAssigneeType newAssigneeType, List<EntityId> newAssignToList, boolean force) throws ThingsboardException {
        this.customMenuService.updateAssigneeList(oldCustomMenu, newAssigneeType, newAssignToList, force);
    }

    public CustomMenuDeleteResult deleteCustomMenu(CustomMenu customMenu, boolean force) {
        return this.customMenuService.deleteCustomMenu(customMenu, force);
    }

    public void evictETags(CustomMenuCacheKey cacheKey) {
        if (cacheKey.getUserId() != null) {
            this.invalidateByFilter(key -> cacheKey.getUserId().equals((Object)key.getUserId()));
        } else if (cacheKey.getCustomerId() != null) {
            this.invalidateByFilter(key -> cacheKey.getCustomerId().equals((Object)key.getCustomerId()));
        } else if (cacheKey.getTenantId().isSysTenantId()) {
            this.etagCache.invalidateAll();
        } else {
            this.invalidateByFilter(key -> cacheKey.getTenantId().equals((Object)key.getTenantId()));
        }
    }

    private void evictFromCache(TenantId tenantId) {
        this.evictETags(CustomMenuCacheKey.forTenant((TenantId)tenantId));
        this.clusterService.broadcastToCore(TransportProtos.ToCoreNotificationMsg.newBuilder().setCustomMenuCacheInvalidateMsg(TransportProtos.CustomMenuCacheInvalidateMsg.newBuilder().setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).build()).build());
    }

    @TransactionalEventListener(classes={CustomMenuCacheEvictEvent.class}, fallbackExecution=true)
    public void handleEvictEvent(CustomMenuCacheEvictEvent event) {
        this.evictFromCache(event.tenantId());
    }
}

