/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.WidgetsBundleId;
import org.thingsboard.server.common.data.widget.WidgetsBundle;
import org.thingsboard.server.gen.edge.v1.WidgetsBundleUpdateMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.WidgetBundleCloudProcessor;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
@TbCoreComponent
public class WidgetBundleCloudProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WidgetBundleCloudProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListenableFuture<Void> processWidgetsBundleMsgFromCloud(TenantId tenantId, WidgetsBundleUpdateMsg widgetsBundleUpdateMsg) {
        WidgetsBundleId widgetsBundleId = new WidgetsBundleId(new UUID(widgetsBundleUpdateMsg.getIdMSB(), widgetsBundleUpdateMsg.getIdLSB()));
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[widgetsBundleUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    widgetCreationLock.lock();
                    try {
                        WidgetsBundle widgetsBundle = (WidgetsBundle)JacksonUtil.fromString((String)widgetsBundleUpdateMsg.getEntity(), WidgetsBundle.class, (boolean)true);
                        if (widgetsBundle == null) {
                            throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] widgetsBundleUpdateMsg {" + String.valueOf(widgetsBundleUpdateMsg) + "} cannot be converted to widget bundle");
                        }
                        this.deleteSystemWidgetBundleIfAlreadyExists(widgetsBundle.getAlias(), widgetsBundleId);
                        this.edgeCtx.getWidgetsBundleService().saveWidgetsBundle(widgetsBundle, false);
                        String[] widgetFqns = (String[])JacksonUtil.fromString((String)widgetsBundleUpdateMsg.getWidgets(), String[].class);
                        if (widgetFqns == null) return Futures.immediateFuture(null);
                        if (widgetFqns.length <= 0) return Futures.immediateFuture(null);
                        this.edgeCtx.getWidgetTypeService().updateWidgetsBundleWidgetFqns(widgetsBundle.getTenantId(), widgetsBundleId, Arrays.asList(widgetFqns));
                        return Futures.immediateFuture(null);
                    }
                    finally {
                        widgetCreationLock.unlock();
                    }
                }
                case 3: {
                    WidgetsBundle widgetsBundle = this.edgeCtx.getWidgetsBundleService().findWidgetsBundleById(tenantId, widgetsBundleId);
                    if (widgetsBundle == null) return Futures.immediateFuture(null);
                    this.edgeCtx.getWidgetsBundleService().deleteWidgetsBundle(tenantId, widgetsBundle.getId());
                    return Futures.immediateFuture(null);
                }
                case 4: {
                    ListenableFuture listenableFuture = this.handleUnsupportedMsgType(widgetsBundleUpdateMsg.getMsgType());
                    return listenableFuture;
                }
            }
            return Futures.immediateFuture(null);
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    private void deleteSystemWidgetBundleIfAlreadyExists(String bundleAlias, WidgetsBundleId widgetsBundleId) {
        try {
            WidgetsBundle widgetsBundle = this.edgeCtx.getWidgetsBundleService().findWidgetsBundleByTenantIdAndAlias(TenantId.SYS_TENANT_ID, bundleAlias);
            if (widgetsBundle != null && !widgetsBundleId.equals((Object)widgetsBundle.getId())) {
                this.edgeCtx.getWidgetsBundleService().deleteWidgetsBundle(TenantId.SYS_TENANT_ID, widgetsBundle.getId());
            }
        }
        catch (IncorrectResultSizeDataAccessException e) {
            List systemWidgetsBundles = this.edgeCtx.getWidgetsBundleService().findSystemWidgetsBundles(TenantId.SYS_TENANT_ID);
            for (WidgetsBundle systemWidgetsBundle : systemWidgetsBundles) {
                if (!systemWidgetsBundle.getAlias().equals(bundleAlias) || systemWidgetsBundle.getId().equals((Object)widgetsBundleId)) continue;
                this.edgeCtx.getWidgetsBundleService().deleteWidgetsBundle(TenantId.SYS_TENANT_ID, systemWidgetsBundle.getId());
            }
            log.warn("Duplicate widgets bundle found, alias {}. Removed all duplicates!", (Object)bundleAlias);
        }
    }
}

