/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.wl.LoginWhiteLabelingParams;
import org.thingsboard.server.common.data.wl.WhiteLabeling;
import org.thingsboard.server.common.data.wl.WhiteLabelingParams;
import org.thingsboard.server.common.data.wl.WhiteLabelingType;
import org.thingsboard.server.dao.exception.IncorrectParameterException;
import org.thingsboard.server.dao.wl.WhiteLabelingService;
import org.thingsboard.server.gen.edge.v1.WhiteLabelingProto;
import org.thingsboard.server.service.cloud.rpc.processor.WhiteLabelingCloudProcessor;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
public class WhiteLabelingCloudProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WhiteLabelingCloudProcessor.class);
    @Autowired
    private WhiteLabelingService whiteLabelingService;

    public ListenableFuture<Void> processWhiteLabelingMsgFromCloud(TenantId tenantId, WhiteLabelingProto whiteLabelingProto) throws Exception {
        WhiteLabeling whiteLabeling = (WhiteLabeling)JacksonUtil.fromString((String)whiteLabelingProto.getEntity(), WhiteLabeling.class, (boolean)true);
        if (whiteLabeling == null) {
            throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] whiteLabelingProto {" + String.valueOf(whiteLabelingProto) + " } cannot be converted to white labeling");
        }
        boolean isSysAdmin = TenantId.SYS_TENANT_ID.equals((Object)whiteLabeling.getTenantId());
        boolean isLogin = WhiteLabelingType.LOGIN.equals((Object)whiteLabeling.getType());
        boolean isGeneral = WhiteLabelingType.GENERAL.equals((Object)whiteLabeling.getType());
        switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[whiteLabelingProto.getMsgType().ordinal()]) {
            case 1: 
            case 2: {
                if (whiteLabeling.getCustomerId() == null || whiteLabeling.getCustomerId().isNullUid()) {
                    if (isLogin) {
                        if (isSysAdmin) {
                            this.whiteLabelingService.saveSystemLoginWhiteLabelingParams(this.constructLoginWlParams(whiteLabeling.getSettings()));
                            break;
                        }
                        LoginWhiteLabelingParams loginWhiteLabelingParams = this.constructLoginWlParams(whiteLabeling.getSettings());
                        this.whiteLabelingService.saveTenantLoginWhiteLabelingParams(tenantId, loginWhiteLabelingParams);
                        break;
                    }
                    if (isGeneral) {
                        if (isSysAdmin) {
                            this.whiteLabelingService.saveSystemWhiteLabelingParams(this.constructWlParams(whiteLabeling.getSettings(), true));
                            break;
                        }
                        this.whiteLabelingService.saveTenantWhiteLabelingParams(tenantId, this.constructWlParams(whiteLabeling.getSettings(), false));
                        break;
                    }
                    if (!WhiteLabelingType.MAIL_TEMPLATES.equals((Object)whiteLabeling.getType())) break;
                    this.whiteLabelingService.saveMailTemplates(isSysAdmin ? TenantId.SYS_TENANT_ID : tenantId, whiteLabeling.getSettings());
                    break;
                }
                if (isLogin) {
                    LoginWhiteLabelingParams loginWhiteLabelingParams = this.constructLoginWlParams(whiteLabeling.getSettings());
                    this.whiteLabelingService.saveCustomerLoginWhiteLabelingParams(tenantId, whiteLabeling.getCustomerId(), loginWhiteLabelingParams);
                    break;
                }
                if (!isGeneral) break;
                this.whiteLabelingService.saveCustomerWhiteLabelingParams(tenantId, whiteLabeling.getCustomerId(), this.constructWlParams(whiteLabeling.getSettings(), false));
                break;
            }
            case 3: {
                this.whiteLabelingService.deleteWhiteLabeling(whiteLabeling.getTenantId(), whiteLabeling.getCustomerId(), whiteLabeling.getType());
            }
        }
        return Futures.immediateFuture(null);
    }

    private LoginWhiteLabelingParams constructLoginWlParams(JsonNode json) {
        LoginWhiteLabelingParams result = null;
        if (json != null) {
            try {
                result = (LoginWhiteLabelingParams)JacksonUtil.treeToValue((JsonNode)json, LoginWhiteLabelingParams.class, (boolean)true);
            }
            catch (IllegalArgumentException e) {
                log.error("Unable to read Login White Labeling Params from JSON!", (Throwable)e);
                throw new IncorrectParameterException("Unable to read Login White Labeling Params from JSON!");
            }
        }
        if (result == null) {
            result = new LoginWhiteLabelingParams();
        }
        return result;
    }

    private WhiteLabelingParams constructWlParams(JsonNode json, boolean isSystem) {
        WhiteLabelingParams result = null;
        if (json != null) {
            try {
                result = (WhiteLabelingParams)JacksonUtil.treeToValue((JsonNode)json, WhiteLabelingParams.class, (boolean)true);
                if (isSystem) {
                    if (!json.has("helpLinkBaseUrl")) {
                        result.setHelpLinkBaseUrl("https://thingsboard.io");
                    }
                    if (!json.has("uiHelpBaseUrl")) {
                        result.setUiHelpBaseUrl(null);
                    }
                    if (!json.has("enableHelpLinks")) {
                        result.setEnableHelpLinks(Boolean.valueOf(true));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                log.error("Unable to read White Labeling Params from JSON!", (Throwable)e);
                throw new IncorrectParameterException("Unable to read White Labeling Params from JSON!");
            }
        }
        if (result == null) {
            result = new WhiteLabelingParams();
            if (isSystem) {
                result.setHelpLinkBaseUrl("https://thingsboard.io");
                result.setUiHelpBaseUrl(null);
                result.setEnableHelpLinks(Boolean.valueOf(true));
            }
        }
        return result;
    }
}

