/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.security.UserCredentials;
import org.thingsboard.server.gen.edge.v1.UserCredentialsUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UserUpdateMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.UserCloudProcessor;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;
import org.thingsboard.server.service.security.permission.UserPermissionsService;

@Component
@TbCoreComponent
public class UserCloudProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserCloudProcessor.class);
    private final Lock userCreationLock = new ReentrantLock();
    @Autowired
    private UserPermissionsService userPermissionsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processUserMsgFromCloud(TenantId tenantId, UserUpdateMsg userUpdateMsg) throws ThingsboardException {
        UserId userId = new UserId(new UUID(userUpdateMsg.getIdMSB(), userUpdateMsg.getIdLSB()));
        this.cloudSynchronizationManager.getSync().set(true);
        switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[userUpdateMsg.getMsgType().ordinal()]) {
            case 1: 
            case 2: {
                User user;
                this.userCreationLock.lock();
                try {
                    boolean created;
                    user = (User)JacksonUtil.fromString((String)userUpdateMsg.getEntity(), User.class, (boolean)true);
                    if (user == null) {
                        throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] userUpdateMsg {" + String.valueOf(userUpdateMsg) + "} cannot be converted to user");
                    }
                    User userById = this.edgeCtx.getUserService().findUserById(tenantId, userId);
                    boolean bl = created = userById == null;
                    if (!created) {
                        this.changeOwnerIfRequired(tenantId, user.getCustomerId(), (EntityId)userId);
                    }
                    if (this.isCustomerNotExists(tenantId, user.getCustomerId())) {
                        user.setCustomerId(null);
                    }
                    User savedUser = this.edgeCtx.getUserService().saveUser(tenantId, user, false);
                    if (created) {
                        this.createDefaultUserCredentials(savedUser.getTenantId(), savedUser.getId());
                        if (!user.getTenantId().isNullUid()) {
                            this.edgeCtx.getEntityGroupService().addEntityToEntityGroupAll(user.getTenantId(), savedUser.getOwnerId(), (EntityId)savedUser.getId());
                        }
                    }
                    this.safeAddEntityToGroup(tenantId, userUpdateMsg, savedUser);
                    this.userPermissionsService.onUserUpdatedOrRemoved(savedUser);
                }
                finally {
                    this.userCreationLock.unlock();
                }
                user = this.requestForAdditionalData(tenantId, (EntityId)userId);
                return user;
            }
            case 3: {
                this.userCreationLock.lock();
                if (userUpdateMsg.hasEntityGroupIdMSB() && userUpdateMsg.hasEntityGroupIdLSB()) {
                    UUID entityGroupUUID = this.safeGetUUID(userUpdateMsg.getEntityGroupIdMSB(), userUpdateMsg.getEntityGroupIdLSB());
                    EntityGroupId entityGroupId = new EntityGroupId(entityGroupUUID);
                    this.edgeCtx.getEntityGroupService().removeEntityFromEntityGroup(tenantId, entityGroupId, (EntityId)userId);
                    ListenableFuture listenableFuture = this.removeEntityIfInSingleAllGroup(tenantId, (EntityId)userId, () -> this.edgeCtx.getUserService().deleteUser(tenantId, userId));
                    return listenableFuture;
                }
                User userToDelete = this.edgeCtx.getUserService().findUserById(tenantId, userId);
                if (userToDelete != null) {
                    this.edgeCtx.getUserService().deleteUser(tenantId, userToDelete);
                }
                ListenableFuture listenableFuture = Futures.immediateFuture(null);
                return listenableFuture;
                finally {
                    this.userCreationLock.unlock();
                }
            }
        }
        ListenableFuture listenableFuture = this.handleUnsupportedMsgType(userUpdateMsg.getMsgType());
        return listenableFuture;
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    private void safeAddEntityToGroup(TenantId tenantId, UserUpdateMsg userUpdateMsg, User savedUser) {
        if (userUpdateMsg.hasEntityGroupIdMSB() && userUpdateMsg.hasEntityGroupIdLSB()) {
            UUID entityGroupUUID = this.safeGetUUID(userUpdateMsg.getEntityGroupIdMSB(), userUpdateMsg.getEntityGroupIdLSB());
            EntityGroupId entityGroupId = new EntityGroupId(entityGroupUUID);
            this.safeAddEntityToGroup(tenantId, entityGroupId, (EntityId)savedUser.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processUserCredentialsMsgFromCloud(TenantId tenantId, UserCredentialsUpdateMsg userCredentialsUpdateMsg) {
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            UserCredentials userCredentialsMsg = (UserCredentials)JacksonUtil.fromString((String)userCredentialsUpdateMsg.getEntity(), UserCredentials.class, (boolean)true);
            if (userCredentialsMsg == null) {
                throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] userCredentialsUpdateMsg {" + String.valueOf(userCredentialsUpdateMsg) + "} cannot be converted to user credentials");
            }
            User user = this.edgeCtx.getUserService().findUserById(tenantId, userCredentialsMsg.getUserId());
            if (user != null) {
                UserCredentials userCredentialsByUserId = this.edgeCtx.getUserService().findUserCredentialsByUserId(tenantId, user.getId());
                if (userCredentialsByUserId == null) {
                    userCredentialsByUserId = this.createDefaultUserCredentials(tenantId, userCredentialsMsg.getUserId());
                }
                userCredentialsByUserId.setEnabled(userCredentialsMsg.isEnabled());
                userCredentialsByUserId.setPassword(userCredentialsMsg.getPassword());
                userCredentialsByUserId.setActivateToken(userCredentialsMsg.getActivateToken());
                userCredentialsByUserId.setResetToken(userCredentialsMsg.getResetToken());
                userCredentialsByUserId.setAdditionalInfo(userCredentialsMsg.getAdditionalInfo());
                this.edgeCtx.getUserService().saveUserCredentials(tenantId, userCredentialsByUserId);
            }
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
        return Futures.immediateFuture(null);
    }

    private UserCredentials createDefaultUserCredentials(TenantId tenantId, UserId userId) {
        UserCredentials userCredentials = new UserCredentials();
        userCredentials.setEnabled(false);
        userCredentials.setActivateToken(StringUtils.randomAlphanumeric((int)30));
        userCredentials.setUserId(userId);
        userCredentials.setAdditionalInfo((JsonNode)JacksonUtil.newObjectNode());
        return this.edgeCtx.getUserService().saveUserCredentials(tenantId, userCredentials, false);
    }
}

