/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.wl.LoginWhiteLabelingParams;
import org.thingsboard.server.common.data.wl.WhiteLabelingParams;
import org.thingsboard.server.dao.usagerecord.ApiUsageStateService;
import org.thingsboard.server.dao.wl.WhiteLabelingService;
import org.thingsboard.server.gen.edge.v1.TenantUpdateMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.TenantCloudProcessor;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
@TbCoreComponent
public class TenantCloudProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantCloudProcessor.class);
    @Autowired
    private ApiUsageStateService apiUsageStateService;
    @Autowired
    private WhiteLabelingService whiteLabelingService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTenantIfNotExists(TenantId tenantId) throws Exception {
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            Tenant tenant = this.edgeCtx.getTenantService().findTenantById(tenantId);
            if (tenant != null) {
                return;
            }
            tenant = new Tenant();
            tenant.setTitle("Tenant");
            tenant.setId((UUIDBased)tenantId);
            tenant.setCreatedTime(Uuids.unixTimestamp((UUID)tenantId.getId()));
            Tenant savedTenant = this.edgeCtx.getTenantService().saveTenant(tenant, null, false);
            try {
                this.apiUsageStateService.createDefaultApiUsageState(savedTenant.getId(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.tryCreateEntityGroupAll(savedTenant, EntityType.CUSTOMER);
            this.tryCreateEntityGroupAll(savedTenant, EntityType.ASSET);
            this.tryCreateEntityGroupAll(savedTenant, EntityType.DEVICE);
            this.tryCreateEntityGroupAll(savedTenant, EntityType.ENTITY_VIEW);
            this.tryCreateEntityGroupAll(savedTenant, EntityType.EDGE);
            this.tryCreateEntityGroupAll(savedTenant, EntityType.DASHBOARD);
            this.tryCreateEntityGroupAll(savedTenant, EntityType.USER);
            this.requestForAdditionalData(tenantId, (EntityId)tenantId).get();
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    private void tryCreateEntityGroupAll(Tenant tenant, EntityType entityType) {
        try {
            this.edgeCtx.getEntityGroupService().createEntityGroupAll(tenant.getId(), (EntityId)tenant.getId(), entityType);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListenableFuture<Void> processTenantMsgFromCloud(TenantUpdateMsg tenantUpdateMsg) {
        Tenant tenant = (Tenant)JacksonUtil.fromString((String)tenantUpdateMsg.getEntity(), Tenant.class, (boolean)true);
        if (tenant == null) {
            throw new RuntimeException("[{" + String.valueOf(TenantId.SYS_TENANT_ID) + "}] tenantUpdateMsg {" + String.valueOf(tenantUpdateMsg) + "} cannot be converted to tenant");
        }
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[tenantUpdateMsg.getMsgType().ordinal()]) {
                case 1: {
                    this.edgeCtx.getTenantService().saveTenant(tenant, null, false);
                    return Futures.immediateFuture(null);
                }
                case 2: {
                    ListenableFuture listenableFuture = this.handleUnsupportedMsgType(tenantUpdateMsg.getMsgType());
                    return listenableFuture;
                }
            }
            return Futures.immediateFuture(null);
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            log.debug("Starting clean up procedure");
            PageData tenants = this.edgeCtx.getTenantService().findTenants(new PageLink(Integer.MAX_VALUE));
            for (Tenant tenant : tenants.getData()) {
                this.removeTenantAttributes(tenant.getId());
                this.edgeCtx.getTenantService().deleteTenant(tenant.getId());
            }
            this.cleanUpSystemTenant();
            log.debug("Clean up procedure successfully finished!");
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    private void cleanUpSystemTenant() {
        this.edgeCtx.getAdminSettingsService().deleteByTenantId(TenantId.SYS_TENANT_ID);
        this.edgeCtx.getQueueService().deleteQueuesByTenantId(TenantId.SYS_TENANT_ID);
        this.edgeCtx.getWidgetTypeService().deleteWidgetTypesByTenantId(TenantId.SYS_TENANT_ID);
        this.edgeCtx.getWidgetsBundleService().deleteWidgetsBundlesByTenantId(TenantId.SYS_TENANT_ID);
        this.removeTenantAttributes(TenantId.SYS_TENANT_ID);
        this.edgeCtx.getRoleService().deleteRolesByTenantId(TenantId.SYS_TENANT_ID);
        this.whiteLabelingService.saveSystemLoginWhiteLabelingParams(new LoginWhiteLabelingParams());
        this.whiteLabelingService.saveSystemWhiteLabelingParams(new WhiteLabelingParams());
        this.edgeCtx.getCustomTranslationService().deleteCustomTranslationByTenantId(TenantId.SYS_TENANT_ID);
    }

    private void removeTenantAttributes(TenantId tenantId) {
        try {
            List attributeKvEntries = (List)this.edgeCtx.getAttributesService().findAll(tenantId, (EntityId)tenantId, AttributeScope.SERVER_SCOPE).get();
            List attrKeys = attributeKvEntries.stream().map(KvEntry::getKey).collect(Collectors.toList());
            this.edgeCtx.getAttributesService().removeAll(tenantId, (EntityId)tenantId, AttributeScope.SERVER_SCOPE, attrKeys);
        }
        catch (Exception e) {
            log.error("Unable to remove tenant attributes", (Throwable)e);
        }
    }
}

