/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.id.SecretId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.secret.Secret;
import org.thingsboard.server.common.data.secret.SecretInfo;
import org.thingsboard.server.gen.edge.v1.SecretUpdateMsg;
import org.thingsboard.server.service.cloud.rpc.processor.SecretCloudProcessor;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
public class SecretCloudProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecretCloudProcessor.class);

    public ListenableFuture<Void> processSecretMsgFromCloud(TenantId tenantId, SecretUpdateMsg secretUpdateMsg) {
        SecretId secretId = new SecretId(new UUID(secretUpdateMsg.getIdMSB(), secretUpdateMsg.getIdLSB()));
        switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[secretUpdateMsg.getMsgType().ordinal()]) {
            case 1: 
            case 2: {
                try {
                    Secret secret = (Secret)JacksonUtil.fromString((String)secretUpdateMsg.getEntity(), Secret.class, (boolean)true);
                    if (secret == null) {
                        throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] SecretUpdateMsg {" + String.valueOf(secretUpdateMsg) + " } cannot be converted to secret");
                    }
                    this.edgeCtx.getSecretService().saveSecret(tenantId, secret, false);
                    break;
                }
                catch (Exception e) {
                    log.error("[{}] Failed to process SecretUpdateMsg [{}]", new Object[]{tenantId, secretUpdateMsg, e});
                    throw e;
                }
            }
            case 3: {
                SecretInfo secretInfo = new SecretInfo(secretId);
                this.edgeCtx.getSecretService().deleteSecret(tenantId, secretInfo);
                break;
            }
            default: {
                log.warn("[{}] Unsupported msg type [{}] for secret", (Object)tenantId, (Object)secretUpdateMsg.getMsgType());
            }
        }
        return Futures.immediateFuture(null);
    }
}

