/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.id.SchedulerEventId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.scheduler.SchedulerEvent;
import org.thingsboard.server.common.data.scheduler.SchedulerEventInfo;
import org.thingsboard.server.dao.service.validator.SchedulerEventDataValidator;
import org.thingsboard.server.gen.edge.v1.SchedulerEventUpdateMsg;
import org.thingsboard.server.service.cloud.rpc.processor.SchedulerEventCloudProcessor;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;
import org.thingsboard.server.service.scheduler.SchedulerService;

@Component
public class SchedulerEventCloudProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchedulerEventCloudProcessor.class);
    @Autowired
    private SchedulerEventDataValidator schedulerEventValidator;
    @Autowired
    private SchedulerService schedulerService;

    public ListenableFuture<Void> processScheduleEventFromCloud(TenantId tenantId, SchedulerEventUpdateMsg schedulerEventUpdateMsg) {
        try {
            SchedulerEventId schedulerEventId = new SchedulerEventId(new UUID(schedulerEventUpdateMsg.getIdMSB(), schedulerEventUpdateMsg.getIdLSB()));
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[schedulerEventUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    SchedulerEvent schedulerEvent = (SchedulerEvent)JacksonUtil.fromString((String)schedulerEventUpdateMsg.getEntity(), SchedulerEvent.class, (boolean)true);
                    if (schedulerEvent == null) {
                        throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] schedulerEventUpdateMsg {" + String.valueOf(schedulerEventUpdateMsg) + "} cannot be converted to scheduler event");
                    }
                    SchedulerEvent schedulerEventById = this.edgeCtx.getSchedulerEventService().findSchedulerEventById(tenantId, schedulerEventId);
                    boolean created = false;
                    if (schedulerEventById == null) {
                        created = true;
                        schedulerEvent.setId(null);
                    }
                    this.schedulerEventValidator.validate((BaseData)schedulerEvent, SchedulerEventInfo::getTenantId);
                    if (created) {
                        schedulerEvent.setId((UUIDBased)schedulerEventId);
                    }
                    if (this.isCustomerNotExists(tenantId, schedulerEvent.getCustomerId())) {
                        schedulerEvent.setCustomerId(null);
                    }
                    this.edgeCtx.getSchedulerEventService().saveSchedulerEvent(schedulerEvent, false);
                    if (created) {
                        this.schedulerService.onSchedulerEventAdded((SchedulerEventInfo)schedulerEvent);
                        break;
                    }
                    this.schedulerService.onSchedulerEventUpdated((SchedulerEventInfo)schedulerEvent);
                    break;
                }
                case 3: {
                    SchedulerEventInfo schedulerEventInfo = this.edgeCtx.getSchedulerEventService().findSchedulerEventInfoById(tenantId, schedulerEventId);
                    if (schedulerEventInfo == null) break;
                    this.edgeCtx.getSchedulerEventService().deleteSchedulerEvent(tenantId, schedulerEventId);
                    this.schedulerService.onSchedulerEventDeleted(schedulerEventInfo);
                    break;
                }
                case 4: {
                    return this.handleUnsupportedMsgType(schedulerEventUpdateMsg.getMsgType());
                }
            }
        }
        catch (Exception e) {
            String errMsg = String.format("Can't process SchedulerEventUpdateMsg [%s]", schedulerEventUpdateMsg);
            log.error(errMsg, (Throwable)e);
            return Futures.immediateFailedFuture((Throwable)new RuntimeException(errMsg, e));
        }
        return Futures.immediateFuture(null);
    }
}

