/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.id.QueueId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.queue.Queue;
import org.thingsboard.server.gen.edge.v1.QueueUpdateMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.QueueCloudProcessor;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;
import org.thingsboard.server.service.entitiy.queue.TbQueueService;

@Component
@TbCoreComponent
public class QueueCloudProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueueCloudProcessor.class);
    @Autowired
    private TbQueueService tbQueueService;
    private final Lock queueCreationLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListenableFuture<Void> processQueueMsgFromCloud(TenantId tenantId, QueueUpdateMsg queueUpdateMsg) {
        QueueId queueId = new QueueId(new UUID(queueUpdateMsg.getIdMSB(), queueUpdateMsg.getIdLSB()));
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[queueUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    this.queueCreationLock.lock();
                    try {
                        Queue queue = (Queue)JacksonUtil.fromString((String)queueUpdateMsg.getEntity(), Queue.class, (boolean)true);
                        if (queue == null) {
                            throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] queueUpdateMsg {" + String.valueOf(queueUpdateMsg) + "} cannot be converted to queue");
                        }
                        this.deleteMainQueueIfIdMismatches(queue);
                        Queue queueById = this.edgeCtx.getQueueService().findQueueById(tenantId, queueId);
                        boolean create = queueById == null;
                        this.edgeCtx.getQueueService().saveQueue(queue, false);
                        this.tbQueueService.saveQueue(queue, create);
                        return Futures.immediateFuture(null);
                    }
                    finally {
                        this.queueCreationLock.unlock();
                    }
                }
                case 3: {
                    Queue queue = this.edgeCtx.getQueueService().findQueueById(tenantId, queueId);
                    if (queue == null) return Futures.immediateFuture(null);
                    this.tbQueueService.deleteQueue(tenantId, queueId);
                    return Futures.immediateFuture(null);
                }
                case 4: {
                    ListenableFuture listenableFuture = this.handleUnsupportedMsgType(queueUpdateMsg.getMsgType());
                    return listenableFuture;
                }
            }
            return Futures.immediateFuture(null);
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    private void deleteMainQueueIfIdMismatches(Queue cloudQueue) {
        Queue mainEdgeQueue;
        if ("Main".equals(cloudQueue.getName()) && (mainEdgeQueue = this.edgeCtx.getQueueService().findQueueByTenantIdAndName(TenantId.SYS_TENANT_ID, "Main")) != null && !((QueueId)mainEdgeQueue.getId()).equals((Object)cloudQueue.getId())) {
            this.tbQueueService.deleteQueue(mainEdgeQueue.getTenantId(), (QueueId)mainEdgeQueue.getId());
        }
    }
}

