/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.GroupPermissionId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.permission.GroupPermission;
import org.thingsboard.server.common.data.role.Role;
import org.thingsboard.server.dao.group.EntityGroupService;
import org.thingsboard.server.dao.grouppermission.GroupPermissionService;
import org.thingsboard.server.dao.role.RoleService;
import org.thingsboard.server.exception.DataValidationException;
import org.thingsboard.server.gen.edge.v1.EntityGroupRequestMsg;
import org.thingsboard.server.gen.edge.v1.GroupPermissionProto;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.service.cloud.rpc.processor.GroupPermissionCloudProcessor;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;
import org.thingsboard.server.service.security.permission.UserPermissionsService;

@Component
public class GroupPermissionCloudProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GroupPermissionCloudProcessor.class);
    @Autowired
    private GroupPermissionService groupPermissionService;
    @Autowired
    private UserPermissionsService userPermissionsService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private EntityGroupService entityGroupService;

    public ListenableFuture<Void> processGroupPermissionMsgFromCloud(TenantId tenantId, GroupPermissionProto groupPermissionProto) {
        try {
            GroupPermissionId groupPermissionId = new GroupPermissionId(new UUID(groupPermissionProto.getIdMSB(), groupPermissionProto.getIdLSB()));
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[groupPermissionProto.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    GroupPermission groupPermission = (GroupPermission)JacksonUtil.fromString((String)groupPermissionProto.getEntity(), GroupPermission.class, (boolean)true);
                    if (groupPermission == null) {
                        throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] groupPermissionProto {" + String.valueOf(groupPermissionProto) + "} cannot be converted to group permission");
                    }
                    if (!this.isGroupPermissionValid(tenantId, groupPermission)) {
                        return Futures.immediateFuture(null);
                    }
                    GroupPermission saveGroupPermission = this.groupPermissionService.saveGroupPermission(tenantId, groupPermission);
                    this.userPermissionsService.onGroupPermissionUpdated(saveGroupPermission);
                    break;
                }
                case 3: {
                    GroupPermission groupPermissionById = this.groupPermissionService.findGroupPermissionById(tenantId, groupPermissionId);
                    if (groupPermissionById == null) break;
                    this.groupPermissionService.deleteGroupPermission(tenantId, groupPermissionId);
                    break;
                }
                case 4: {
                    return this.handleUnsupportedMsgType(groupPermissionProto.getMsgType());
                }
            }
        }
        catch (Exception e) {
            if (e instanceof DataValidationException && e.getMessage().contains("Group Permission is referencing to non-existent")) {
                String warnMsg = String.format("Group Permission is referencing to non-existent entity group, role or user group! This permission will be saved with an appropriate entity group on next messages [%s]", groupPermissionProto);
                log.warn(warnMsg, (Throwable)e);
            }
            String errMsg = String.format("Can't process groupPermissionProto [%s]", groupPermissionProto);
            log.error(errMsg, (Throwable)e);
            return Futures.immediateFailedFuture((Throwable)new RuntimeException(errMsg, e));
        }
        return Futures.immediateFuture(null);
    }

    private boolean isGroupPermissionValid(TenantId tenantId, GroupPermission groupPermission) {
        EntityGroup entityGroupById;
        EntityGroup userGroupById;
        Role roleById;
        if (groupPermission.getRoleId() != null && (roleById = this.roleService.findRoleById(tenantId, groupPermission.getRoleId())) == null) {
            return false;
        }
        if (groupPermission.getUserGroupId() != null && (userGroupById = this.entityGroupService.findEntityGroupById(tenantId, groupPermission.getUserGroupId())) == null) {
            return false;
        }
        return groupPermission.getEntityGroupId() == null || (entityGroupById = this.entityGroupService.findEntityGroupById(tenantId, groupPermission.getEntityGroupId())) != null;
    }

    public UplinkMsg processEntityGroupPermissionsRequestMsgToCloud(CloudEvent cloudEvent) {
        EntityId entityGroupId = EntityIdFactory.getByCloudEventTypeAndUuid((CloudEventType)cloudEvent.getType(), (UUID)cloudEvent.getEntityId());
        String type = cloudEvent.getEntityBody().get("type").asText();
        EntityGroupRequestMsg entityGroupPermissionsRequestMsg = EntityGroupRequestMsg.newBuilder().setEntityGroupIdMSB(entityGroupId.getId().getMostSignificantBits()).setEntityGroupIdLSB(entityGroupId.getId().getLeastSignificantBits()).setType(type).build();
        UplinkMsg.Builder builder = UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addEntityGroupPermissionsRequestMsg(entityGroupPermissionsRequestMsg);
        return builder.build();
    }
}

