/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.gen.edge.v1.EdgeConfiguration;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
@TbCoreComponent
public class EdgeCloudProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdgeCloudProcessor.class);
    private final Lock edgeCreationLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processEdgeConfigurationMsgFromCloud(TenantId tenantId, EdgeConfiguration edgeConfiguration) throws ThingsboardException {
        EdgeId edgeId = new EdgeId(new UUID(edgeConfiguration.getEdgeIdMSB(), edgeConfiguration.getEdgeIdLSB()));
        this.edgeCreationLock.lock();
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            Edge edge = this.edgeCtx.getEdgeService().findEdgeById(tenantId, edgeId);
            CustomerId customerId = this.safeGetCustomerId(edgeConfiguration.getCustomerIdMSB(), edgeConfiguration.getCustomerIdLSB());
            if (edge == null) {
                edge = new Edge();
                edge.setId((UUIDBased)edgeId);
                edge.setTenantId(tenantId);
                edge.setCreatedTime(Uuids.unixTimestamp((UUID)edgeId.getId()));
            } else {
                this.changeOwnerIfRequired(tenantId, customerId, (EntityId)edgeId);
            }
            edge.setCustomerId(customerId);
            edge.setName(edgeConfiguration.getName());
            edge.setType(edgeConfiguration.getType());
            edge.setRoutingKey(edgeConfiguration.getRoutingKey());
            edge.setSecret(edgeConfiguration.getSecret());
            edge.setEdgeLicenseKey(edgeConfiguration.getEdgeLicenseKey());
            edge.setCloudEndpoint(edgeConfiguration.getCloudEndpoint());
            edge.setAdditionalInfo(JacksonUtil.toJsonNode((String)edgeConfiguration.getAdditionalInfo()));
            this.edgeCtx.getEdgeService().saveEdge(edge, false);
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
            this.edgeCreationLock.unlock();
        }
        return Futures.immediateFuture(null);
    }
}

