/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.ota.DeviceGroupOtaPackage;
import org.thingsboard.server.common.data.rpc.RpcError;
import org.thingsboard.server.common.data.rpc.ToDeviceRpcRequestBody;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.common.data.subscription.SubscriptionException;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.rpc.FromDeviceRpcResponse;
import org.thingsboard.server.common.msg.rpc.ToDeviceRpcRequest;
import org.thingsboard.server.dao.ota.DeviceGroupOtaPackageService;
import org.thingsboard.server.gen.edge.v1.DeviceCredentialsUpdateMsg;
import org.thingsboard.server.gen.edge.v1.DeviceGroupOtaPackageUpdateMsg;
import org.thingsboard.server.gen.edge.v1.DeviceRpcCallMsg;
import org.thingsboard.server.gen.edge.v1.DeviceUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.DeviceCloudProcessor;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.device.BaseDeviceProcessor;
import org.thingsboard.server.service.rpc.TbCoreDeviceRpcService;
import org.thingsboard.server.service.security.model.SecurityUser;

@Component
@TbCoreComponent
public class DeviceCloudProcessor
extends BaseDeviceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceCloudProcessor.class);
    @Autowired
    protected DeviceGroupOtaPackageService deviceGroupOtaPackageService;
    @Autowired
    private TbCoreDeviceRpcService tbCoreDeviceRpcService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processDeviceMsgFromCloud(TenantId tenantId, DeviceUpdateMsg deviceUpdateMsg) throws ThingsboardException {
        DeviceId deviceId = new DeviceId(new UUID(deviceUpdateMsg.getIdMSB(), deviceUpdateMsg.getIdLSB()));
        try {
            ListenableFuture listenableFuture;
            ListenableFuture listenableFuture2;
            this.cloudSynchronizationManager.getSync().set(true);
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[deviceUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    Pair limitReachedCreated = this.saveOrUpdateDeviceFromCloud(tenantId, deviceId, deviceUpdateMsg);
                    boolean limitReached = (Boolean)limitReachedCreated.getFirst();
                    if (limitReached) {
                        listenableFuture = listenableFuture2 = Futures.immediateFuture(null);
                        break;
                    }
                    boolean created = (Boolean)limitReachedCreated.getSecond();
                    if (created) {
                        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
                        futures.add(this.requestForAdditionalData(tenantId, (EntityId)deviceId));
                        futures.add(this.requestForCalculatedFieldData(tenantId, (EntityId)deviceId));
                        listenableFuture = listenableFuture2 = Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)this.dbCallbackExecutorService);
                        break;
                    }
                    listenableFuture = listenableFuture2 = Futures.immediateFuture(null);
                    break;
                }
                case 3: {
                    deviceCreationLock.lock();
                    if (deviceUpdateMsg.hasEntityGroupIdMSB() && deviceUpdateMsg.hasEntityGroupIdLSB()) {
                        UUID entityGroupUUID = this.safeGetUUID(deviceUpdateMsg.getEntityGroupIdMSB(), deviceUpdateMsg.getEntityGroupIdLSB());
                        EntityGroupId entityGroupId = new EntityGroupId(entityGroupUUID);
                        this.edgeCtx.getEntityGroupService().removeEntityFromEntityGroup(tenantId, entityGroupId, (EntityId)deviceId);
                        listenableFuture2 = this.removeEntityIfInSingleAllGroup(tenantId, (EntityId)deviceId, () -> this.edgeCtx.getDeviceService().deleteDevice(tenantId, deviceId));
                        listenableFuture = listenableFuture2;
                        break;
                    }
                    Device deviceById = this.edgeCtx.getDeviceService().findDeviceById(tenantId, deviceId);
                    if (deviceById != null) {
                        this.edgeCtx.getDeviceService().deleteDevice(tenantId, deviceId);
                        this.pushDeviceDeletedEventToRuleEngine(tenantId, deviceById);
                    }
                    listenableFuture2 = Futures.immediateFuture(null);
                    listenableFuture = listenableFuture2;
                    break;
                    finally {
                        deviceCreationLock.unlock();
                    }
                }
                default: {
                    listenableFuture = listenableFuture2 = this.handleUnsupportedMsgType(deviceUpdateMsg.getMsgType());
                }
            }
            listenableFuture2 = listenableFuture;
            return listenableFuture2;
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    private Pair<Boolean, Boolean> saveOrUpdateDeviceFromCloud(TenantId tenantId, DeviceId deviceId, DeviceUpdateMsg deviceUpdateMsg) throws ThingsboardException {
        boolean created;
        try {
            Boolean deviceNameUpdated;
            Pair resultPair = super.saveOrUpdateDevice(tenantId, deviceId, deviceUpdateMsg);
            created = (Boolean)resultPair.getFirst();
            if (created) {
                this.pushDeviceCreatedEventToRuleEngine(tenantId, deviceId);
            }
            if ((deviceNameUpdated = (Boolean)resultPair.getSecond()).booleanValue()) {
                this.cloudEventService.saveCloudEventAsync(tenantId, CloudEventType.DEVICE, EdgeEventActionType.UPDATED, (EntityId)deviceId, null, null);
            }
        }
        catch (SubscriptionException e) {
            log.error("[{}][{}] Subscription error occurred for msg {}", new Object[]{tenantId, deviceId, deviceUpdateMsg, e});
            if (e.getMessage().contains("limit reached")) {
                return Pair.of((Object)true, (Object)false);
            }
            throw e;
        }
        return Pair.of((Object)false, (Object)created);
    }

    private void pushDeviceCreatedEventToRuleEngine(TenantId tenantId, DeviceId deviceId) {
        Device device = this.edgeCtx.getDeviceService().findDeviceById(tenantId, deviceId);
        this.pushDeviceEventToRuleEngine(tenantId, device, TbMsgType.ENTITY_CREATED);
    }

    private void pushDeviceDeletedEventToRuleEngine(TenantId tenantId, Device device) {
        this.pushDeviceEventToRuleEngine(tenantId, device, TbMsgType.ENTITY_DELETED);
    }

    private void pushDeviceEventToRuleEngine(TenantId tenantId, Device device, TbMsgType msgType) {
        try {
            String deviceAsString = JacksonUtil.toString((Object)device);
            this.pushEntityEventToRuleEngine(tenantId, (EntityId)device.getId(), device.getCustomerId(), msgType, deviceAsString, new TbMsgMetaData());
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to push device action to rule engine: {}", new Object[]{tenantId, device.getId(), msgType.name(), e});
        }
    }

    public ListenableFuture<Void> processDeviceCredentialsMsgFromCloud(TenantId tenantId, DeviceCredentialsUpdateMsg deviceCredentialsUpdateMsg) {
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            this.updateDeviceCredentials(tenantId, deviceCredentialsUpdateMsg);
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
        return Futures.immediateFuture(null);
    }

    public ListenableFuture<Void> processDeviceRpcCallFromCloud(TenantId tenantId, DeviceRpcCallMsg deviceRpcCallMsg) {
        log.trace("[{}] processDeviceRpcCallFromCloud [{}]", (Object)tenantId, (Object)deviceRpcCallMsg);
        if (deviceRpcCallMsg.hasResponseMsg()) {
            return this.processDeviceRpcResponseFromCloud(deviceRpcCallMsg);
        }
        if (deviceRpcCallMsg.hasRequestMsg()) {
            return this.processDeviceRpcRequestFromCloud(tenantId, deviceRpcCallMsg);
        }
        return Futures.immediateFuture(null);
    }

    private ListenableFuture<Void> processDeviceRpcResponseFromCloud(DeviceRpcCallMsg deviceRpcCallMsg) {
        UUID sessionId = UUID.fromString(deviceRpcCallMsg.getSessionId());
        String serviceId = deviceRpcCallMsg.getServiceId();
        int requestId = deviceRpcCallMsg.getRequestId();
        TransportProtos.ToServerRpcResponseMsg.Builder responseMsgBuilder = TransportProtos.ToServerRpcResponseMsg.newBuilder().setRequestId(requestId);
        if (StringUtils.isNotBlank((String)deviceRpcCallMsg.getResponseMsg().getError())) {
            responseMsgBuilder.setError(deviceRpcCallMsg.getResponseMsg().getError());
        } else {
            responseMsgBuilder.setPayload(deviceRpcCallMsg.getResponseMsg().getResponse());
        }
        TransportProtos.ToTransportMsg msg = TransportProtos.ToTransportMsg.newBuilder().setSessionIdMSB(sessionId.getMostSignificantBits()).setSessionIdLSB(sessionId.getLeastSignificantBits()).setToServerResponse(responseMsgBuilder.build()).build();
        this.edgeCtx.getClusterService().pushNotificationToTransport(serviceId, msg, null);
        return Futures.immediateFuture(null);
    }

    private ListenableFuture<Void> processDeviceRpcRequestFromCloud(TenantId tenantId, DeviceRpcCallMsg deviceRpcCallMsg) {
        DeviceId deviceId = new DeviceId(new UUID(deviceRpcCallMsg.getDeviceIdMSB(), deviceRpcCallMsg.getDeviceIdLSB()));
        UUID requestUUID = new UUID(deviceRpcCallMsg.getRequestUuidMSB(), deviceRpcCallMsg.getRequestUuidLSB());
        boolean oneWay = deviceRpcCallMsg.getOneway();
        long expTime = deviceRpcCallMsg.getExpirationTime();
        boolean persisted = deviceRpcCallMsg.hasPersisted() && deviceRpcCallMsg.getPersisted();
        int retries = deviceRpcCallMsg.hasRetries() ? deviceRpcCallMsg.getRetries() : 1;
        String additionalInfo = deviceRpcCallMsg.hasAdditionalInfo() ? deviceRpcCallMsg.getAdditionalInfo() : null;
        ToDeviceRpcRequestBody body = new ToDeviceRpcRequestBody(deviceRpcCallMsg.getRequestMsg().getMethod(), deviceRpcCallMsg.getRequestMsg().getParams());
        ToDeviceRpcRequest rpcRequest = new ToDeviceRpcRequest(requestUUID, tenantId, deviceId, oneWay, expTime, body, persisted, Integer.valueOf(retries), additionalInfo);
        SecurityUser dummySecurityUser = new SecurityUser();
        this.tbCoreDeviceRpcService.processRestApiRpcRequest(rpcRequest, fromDeviceRpcResponse -> this.reply(rpcRequest, deviceRpcCallMsg.getRequestId(), fromDeviceRpcResponse), dummySecurityUser);
        return Futures.immediateFuture(null);
    }

    private void reply(ToDeviceRpcRequest rpcRequest, int requestId, FromDeviceRpcResponse response) {
        try {
            Optional rpcError = response.getError();
            ObjectNode body = JacksonUtil.newObjectNode();
            body.put("requestUUID", rpcRequest.getId().toString());
            body.put("expirationTime", rpcRequest.getExpirationTime());
            body.put("oneway", rpcRequest.isOneway());
            body.put("requestId", requestId);
            if (rpcError.isPresent()) {
                RpcError error = (RpcError)rpcError.get();
                body.put("error", error.name());
            } else {
                body.put("response", response.getResponse().orElse("{}"));
            }
            this.cloudEventService.saveCloudEvent(rpcRequest.getTenantId(), CloudEventType.DEVICE, EdgeEventActionType.RPC_CALL, (EntityId)rpcRequest.getDeviceId(), (JsonNode)body, null);
        }
        catch (Exception e) {
            log.debug("Can't process RPC response [{}] [{}]", new Object[]{rpcRequest, response, e});
        }
    }

    public UplinkMsg convertRpcCallEventToUplink(CloudEvent cloudEvent) {
        log.trace("Executing convertRpcCallEventToUplink, cloudEvent [{}]", (Object)cloudEvent);
        DeviceRpcCallMsg rpcResponseMsg = EdgeMsgConstructorUtils.constructDeviceRpcCallMsg((UUID)cloudEvent.getEntityId(), (JsonNode)cloudEvent.getEntityBody());
        return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addDeviceRpcCallMsg(rpcResponseMsg).build();
    }

    public UplinkMsg convertCloudEventToUplink(CloudEvent cloudEvent) {
        DeviceId deviceId = new DeviceId(cloudEvent.getEntityId());
        EntityGroupId entityGroupId = cloudEvent.getEntityGroupId() != null ? new EntityGroupId(cloudEvent.getEntityGroupId()) : null;
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[cloudEvent.getAction().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                Device device = this.edgeCtx.getDeviceService().findDeviceById(cloudEvent.getTenantId(), deviceId);
                if (device != null) {
                    UpdateMsgType msgType = this.getUpdateMsgType(cloudEvent.getAction());
                    DeviceUpdateMsg deviceUpdateMsg = EdgeMsgConstructorUtils.constructDeviceUpdatedMsg((UpdateMsgType)msgType, (Device)device, (EntityGroupId)entityGroupId);
                    UplinkMsg.Builder builder = UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addDeviceUpdateMsg(deviceUpdateMsg);
                    DeviceCredentials deviceCredentials = this.edgeCtx.getDeviceCredentialsService().findDeviceCredentialsByDeviceId(cloudEvent.getTenantId(), deviceId);
                    DeviceCredentialsUpdateMsg deviceCredentialsUpdateMsg = EdgeMsgConstructorUtils.constructDeviceCredentialsUpdatedMsg((DeviceCredentials)deviceCredentials);
                    builder.addDeviceCredentialsUpdateMsg(deviceCredentialsUpdateMsg).build();
                    if (UpdateMsgType.ENTITY_CREATED_RPC_MESSAGE.equals((Object)msgType)) {
                        DeviceProfile deviceProfile = this.edgeCtx.getDeviceProfileService().findDeviceProfileById(cloudEvent.getTenantId(), device.getDeviceProfileId());
                        builder.addDeviceProfileUpdateMsg(EdgeMsgConstructorUtils.constructDeviceProfileUpdatedMsg((UpdateMsgType)msgType, (DeviceProfile)deviceProfile));
                    }
                    return builder.build();
                }
                log.info("Skipping event as device was not found [{}]", (Object)cloudEvent);
                break;
            }
            case 4: 
            case 5: {
                DeviceUpdateMsg deviceUpdateMsg = EdgeMsgConstructorUtils.constructDeviceDeleteMsg((DeviceId)deviceId, (EntityGroupId)entityGroupId);
                return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addDeviceUpdateMsg(deviceUpdateMsg).build();
            }
            case 6: {
                DeviceCredentials deviceCredentials = this.edgeCtx.getDeviceCredentialsService().findDeviceCredentialsByDeviceId(cloudEvent.getTenantId(), deviceId);
                if (deviceCredentials != null) {
                    DeviceCredentialsUpdateMsg deviceCredentialsUpdateMsg = EdgeMsgConstructorUtils.constructDeviceCredentialsUpdatedMsg((DeviceCredentials)deviceCredentials);
                    return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addDeviceCredentialsUpdateMsg(deviceCredentialsUpdateMsg).build();
                }
                log.info("Skipping event as device credentials was not found [{}]", (Object)cloudEvent);
            }
        }
        return null;
    }

    protected void setCustomerId(TenantId tenantId, CustomerId customerId, Device device, DeviceUpdateMsg deviceUpdateMsg) {
        if (this.isCustomerNotExists(tenantId, device.getCustomerId())) {
            device.setCustomerId(null);
        }
    }

    public ListenableFuture<Void> processDeviceGroupOtaPackageFromCloud(TenantId tenantId, DeviceGroupOtaPackageUpdateMsg deviceGroupOtaPackageUpdateMsg) {
        log.trace("[{}] processDeviceGroupOtaPackageFromCloud [{}]", (Object)tenantId, (Object)deviceGroupOtaPackageUpdateMsg);
        DeviceGroupOtaPackage deviceGroupOtaPackage = (DeviceGroupOtaPackage)JacksonUtil.fromString((String)deviceGroupOtaPackageUpdateMsg.getEntity(), DeviceGroupOtaPackage.class, (boolean)true);
        if (deviceGroupOtaPackage == null) {
            throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] deviceGroupOtaPackageUpdateMsg {" + String.valueOf(deviceGroupOtaPackageUpdateMsg) + "} cannot be converted to device group ota package");
        }
        switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[deviceGroupOtaPackageUpdateMsg.getMsgType().ordinal()]) {
            case 1: 
            case 2: {
                this.deviceGroupOtaPackageService.saveDeviceGroupOtaPackage(tenantId, deviceGroupOtaPackage, false);
                break;
            }
            case 3: {
                this.deviceGroupOtaPackageService.deleteDeviceGroupOtaPackage(tenantId, deviceGroupOtaPackage);
                break;
            }
            default: {
                return this.handleUnsupportedMsgType(deviceGroupOtaPackageUpdateMsg.getMsgType());
            }
        }
        return Futures.immediateFuture(null);
    }

    public CloudEventType getCloudEventType() {
        return CloudEventType.DEVICE;
    }
}

