/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.gen.edge.v1.DashboardUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.DashboardCloudProcessor;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.dashboard.BaseDashboardProcessor;

@Component
@TbCoreComponent
public class DashboardCloudProcessor
extends BaseDashboardProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DashboardCloudProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processDashboardMsgFromCloud(TenantId tenantId, DashboardUpdateMsg dashboardUpdateMsg) throws ThingsboardException {
        DashboardId dashboardId = new DashboardId(new UUID(dashboardUpdateMsg.getIdMSB(), dashboardUpdateMsg.getIdLSB()));
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[dashboardUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    boolean created = super.saveOrUpdateDashboard(tenantId, dashboardId, dashboardUpdateMsg);
                    if (created) {
                        this.pushDashboardCreatedEventToRuleEngine(tenantId, dashboardId);
                        ListenableFuture listenableFuture = this.requestForAdditionalData(tenantId, (EntityId)dashboardId);
                        return listenableFuture;
                    }
                    ListenableFuture listenableFuture = Futures.immediateFuture(null);
                    return listenableFuture;
                }
                case 3: {
                    if (dashboardUpdateMsg.hasEntityGroupIdMSB() && dashboardUpdateMsg.hasEntityGroupIdLSB()) {
                        UUID entityGroupUUID = this.safeGetUUID(dashboardUpdateMsg.getEntityGroupIdMSB(), dashboardUpdateMsg.getEntityGroupIdLSB());
                        EntityGroupId entityGroupId = new EntityGroupId(entityGroupUUID);
                        this.edgeCtx.getEntityGroupService().removeEntityFromEntityGroup(tenantId, entityGroupId, (EntityId)dashboardId);
                    } else {
                        Dashboard dashboardById = this.edgeCtx.getDashboardService().findDashboardById(tenantId, dashboardId);
                        if (dashboardById != null) {
                            this.edgeCtx.getDashboardService().deleteDashboard(tenantId, dashboardId);
                            this.pushDashboardDeletedEventToRuleEngine(tenantId, dashboardById);
                        }
                    }
                    ListenableFuture listenableFuture = Futures.immediateFuture(null);
                    return listenableFuture;
                }
            }
            ListenableFuture listenableFuture = this.handleUnsupportedMsgType(dashboardUpdateMsg.getMsgType());
            return listenableFuture;
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    private void pushDashboardCreatedEventToRuleEngine(TenantId tenantId, DashboardId dashboardId) {
        Dashboard dashboard = this.edgeCtx.getDashboardService().findDashboardById(tenantId, dashboardId);
        this.pushDashboardEventToRuleEngine(tenantId, dashboard, TbMsgType.ENTITY_CREATED);
    }

    private void pushDashboardDeletedEventToRuleEngine(TenantId tenantId, Dashboard dashboard) {
        this.pushDashboardEventToRuleEngine(tenantId, dashboard, TbMsgType.ENTITY_DELETED);
    }

    private void pushDashboardEventToRuleEngine(TenantId tenantId, Dashboard dashboard, TbMsgType msgType) {
        try {
            String dashboardAsString = JacksonUtil.toString((Object)dashboard);
            this.pushEntityEventToRuleEngine(tenantId, (EntityId)dashboard.getId(), null, msgType, dashboardAsString, new TbMsgMetaData());
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to push dashboard action to rule engine: {}", new Object[]{tenantId, dashboard.getId(), msgType.name(), e});
        }
    }

    public UplinkMsg convertCloudEventToUplink(CloudEvent cloudEvent) {
        DashboardId dashboardId = new DashboardId(cloudEvent.getEntityId());
        EntityGroupId entityGroupId = cloudEvent.getEntityGroupId() != null ? new EntityGroupId(cloudEvent.getEntityGroupId()) : null;
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[cloudEvent.getAction().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                Dashboard dashboard = this.edgeCtx.getDashboardService().findDashboardById(cloudEvent.getTenantId(), dashboardId);
                if (dashboard != null) {
                    UpdateMsgType msgType = this.getUpdateMsgType(cloudEvent.getAction());
                    DashboardUpdateMsg dashboardUpdateMsg = EdgeMsgConstructorUtils.constructDashboardUpdatedMsg((UpdateMsgType)msgType, (Dashboard)dashboard, (EntityGroupId)entityGroupId);
                    return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addDashboardUpdateMsg(dashboardUpdateMsg).build();
                }
                log.info("Skipping event as dashboard was not found [{}]", (Object)cloudEvent);
                break;
            }
            case 4: 
            case 5: {
                DashboardUpdateMsg dashboardUpdateMsg = EdgeMsgConstructorUtils.constructDashboardDeleteMsg((DashboardId)dashboardId, (EntityGroupId)entityGroupId);
                return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addDashboardUpdateMsg(dashboardUpdateMsg).build();
            }
        }
        return null;
    }

    public CloudEventType getCloudEventType() {
        return CloudEventType.DASHBOARD;
    }
}

