/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.common.data.id.ConverterId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.dao.service.validator.ConverterDataValidator;
import org.thingsboard.server.gen.edge.v1.ConverterUpdateMsg;
import org.thingsboard.server.service.cloud.rpc.processor.ConverterCloudProcessor;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
public class ConverterCloudProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConverterCloudProcessor.class);
    @Autowired
    private ConverterDataValidator converterValidator;

    public ListenableFuture<Void> processConverterMsgFromCloud(TenantId tenantId, ConverterUpdateMsg converterUpdateMsg) {
        try {
            ConverterId converterId = new ConverterId(new UUID(converterUpdateMsg.getIdMSB(), converterUpdateMsg.getIdLSB()));
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[converterUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    Converter converter = (Converter)JacksonUtil.fromString((String)converterUpdateMsg.getEntity(), Converter.class, (boolean)true);
                    if (converter == null) {
                        throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] converterUpdateMsg {" + String.valueOf(converterUpdateMsg) + "} cannot be converted to convertor");
                    }
                    Converter converterById = this.edgeCtx.getConverterService().findConverterById(tenantId, converterId);
                    boolean created = false;
                    if (converterById == null) {
                        created = true;
                        converter.setId(null);
                    }
                    converter.setEdgeTemplate(false);
                    this.converterValidator.validate((BaseData)converter, Converter::getTenantId);
                    if (created) {
                        converter.setId((UUIDBased)converterId);
                    }
                    Converter savedConverter = this.edgeCtx.getConverterService().saveConverter(converter, false);
                    this.edgeCtx.getClusterService().broadcastEntityStateChangeEvent(savedConverter.getTenantId(), (EntityId)savedConverter.getId(), created ? ComponentLifecycleEvent.CREATED : ComponentLifecycleEvent.UPDATED);
                    break;
                }
                case 3: {
                    String errMsg = "Unsupported msg type " + String.valueOf(converterUpdateMsg.getMsgType());
                    log.error(errMsg);
                    return Futures.immediateFailedFuture((Throwable)new RuntimeException(errMsg));
                }
            }
        }
        catch (Exception e) {
            String errMsg = String.format("Can't process converter msg [%s]", converterUpdateMsg);
            log.error(errMsg, (Throwable)e);
            return Futures.immediateFailedFuture((Throwable)new RuntimeException(errMsg, e));
        }
        return Futures.immediateFuture(null);
    }
}

