/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.AdminSettings;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.gen.edge.v1.AdminSettingsUpdateMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
@TbCoreComponent
public class AdminSettingsCloudProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminSettingsCloudProcessor.class);

    public ListenableFuture<Void> processAdminSettingsMsgFromCloud(TenantId tenantId, AdminSettingsUpdateMsg adminSettingsUpdateMsg) {
        AdminSettings adminSettingsMsg = (AdminSettings)JacksonUtil.fromString((String)adminSettingsUpdateMsg.getEntity(), AdminSettings.class, (boolean)true);
        if (adminSettingsMsg == null) {
            throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] adminSettingsUpdateMsg {" + String.valueOf(adminSettingsUpdateMsg) + " } cannot be converted to admin settings");
        }
        if (TenantId.SYS_TENANT_ID.equals((Object)adminSettingsMsg.getTenantId())) {
            AdminSettings adminSettings = this.edgeCtx.getAdminSettingsService().findAdminSettingsByKey(TenantId.SYS_TENANT_ID, adminSettingsMsg.getKey());
            if (adminSettings != null) {
                adminSettings.setJsonValue(adminSettingsMsg.getJsonValue());
                this.edgeCtx.getAdminSettingsService().saveAdminSettings(TenantId.SYS_TENANT_ID, adminSettings);
            } else {
                this.edgeCtx.getAdminSettingsService().saveAdminSettings(TenantId.SYS_TENANT_ID, adminSettingsMsg);
            }
        } else {
            ArrayList<BaseAttributeKvEntry> attributes = new ArrayList<BaseAttributeKvEntry>();
            attributes.add(new BaseAttributeKvEntry((KvEntry)new StringDataEntry(adminSettingsMsg.getKey(), JacksonUtil.toString((Object)adminSettingsMsg.getJsonValue())), System.currentTimeMillis()));
            this.edgeCtx.getAttributesService().save(tenantId, (EntityId)tenantId, AttributeScope.SERVER_SCOPE, attributes);
        }
        return Futures.immediateFuture(null);
    }
}

