/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud;

import jakarta.annotation.PostConstruct;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.dao.cloud.CloudEventService;
import org.thingsboard.server.queue.discovery.event.PartitionChangeEvent;
import org.thingsboard.server.service.cloud.BaseCloudManagerService;
import org.thingsboard.server.service.cloud.rpc.CloudEventStorageSettings;

@Service
@ConditionalOnExpression(value="'${queue.type:null}'!='kafka'")
public class PostgresCloudManagerService
extends BaseCloudManagerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostgresCloudManagerService.class);
    @Autowired
    private CloudEventStorageSettings cloudEventStorageSettings;
    @Autowired
    private CloudEventService cloudEventService;
    private ExecutorService executor;
    private ExecutorService tsExecutor;

    protected void onTbApplicationEvent(PartitionChangeEvent event) {
        if (ServiceType.TB_CORE.equals((Object)event.getServiceType())) {
            this.establishRpcConnection();
        }
    }

    @PostConstruct
    private void onInit() {
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"postgres-cloud-manager"));
        this.tsExecutor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"postgres-ts-cloud-manager"));
    }

    @PreDestroy
    protected void onDestroy() throws InterruptedException {
        super.destroy();
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (this.tsExecutor != null) {
            this.tsExecutor.shutdownNow();
        }
    }

    protected void launchUplinkProcessing() {
        this.executor.submit(() -> this.launchUplinkProcessing("queueStartTs", "queueSeqIdOffset", true, (tenantId, seqIdStart, seqIdEnd, pageLink) -> this.cloudEventService.findCloudEvents(tenantId, seqIdStart, seqIdEnd, pageLink)));
        this.tsExecutor.submit(() -> this.launchUplinkProcessing("queueTsKvStartTs", "queueTsKvSeqIdOffset", false, (tenantId, seqIdStart, seqIdEnd, pageLink) -> this.cloudEventService.findTsKvCloudEvents(tenantId, seqIdStart, seqIdEnd, pageLink)));
    }

    private void launchUplinkProcessing(String queueStartTsAttrKey, String queueSeqIdAttrKey, boolean isGeneralMsg, BaseCloudManagerService.CloudEventFinder finder) {
        while (!Thread.interrupted()) {
            try {
                if (this.initialized && !this.syncInProgress) {
                    if (!isGeneralMsg && this.isGeneralProcessInProgress) continue;
                    Long queueSeqIdStart = (Long)this.getLongAttrByKey(this.tenantId, queueSeqIdAttrKey).get();
                    TimePageLink pageLink = this.newCloudEventsAvailable(this.tenantId, queueSeqIdStart, queueStartTsAttrKey, finder);
                    if (pageLink != null) {
                        this.processUplinkMessages(pageLink, queueSeqIdStart, queueStartTsAttrKey, queueSeqIdAttrKey, isGeneralMsg, finder);
                        continue;
                    }
                    log.trace("no new cloud events found for queue, isGeneralMsg = {}", (Object)isGeneralMsg);
                    this.sleep();
                    continue;
                }
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (Exception e) {
                log.warn("Failed to process messages handling!", (Throwable)e);
            }
        }
    }

    private void sleep() {
        try {
            Thread.sleep(this.cloudEventStorageSettings.getNoRecordsSleepInterval());
        }
        catch (InterruptedException e) {
            log.error("Error during sleep", (Throwable)e);
        }
    }
}

