/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud;

import jakarta.annotation.PreDestroy;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.common.consumer.QueueConsumerManager;
import org.thingsboard.server.queue.discovery.event.PartitionChangeEvent;
import org.thingsboard.server.queue.provider.TbCloudEventQueueFactory;
import org.thingsboard.server.queue.settings.TbQueueCloudEventSettings;
import org.thingsboard.server.queue.settings.TbQueueCloudEventTSSettings;
import org.thingsboard.server.service.cloud.BaseCloudManagerService;

@Service
@Primary
@ConditionalOnExpression(value="'${queue.type:null}'=='kafka'")
public class KafkaCloudManagerService
extends BaseCloudManagerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaCloudManagerService.class);
    private QueueConsumerManager<TbProtoQueueMsg<TransportProtos.ToCloudEventMsg>> consumer;
    private QueueConsumerManager<TbProtoQueueMsg<TransportProtos.ToCloudEventMsg>> tsConsumer;
    private ExecutorService consumerExecutor;
    private ExecutorService tsConsumerExecutor;
    @Autowired
    private TbCloudEventQueueFactory tbCloudEventQueueProvider;
    @Autowired
    private TbQueueCloudEventTSSettings tbQueueCloudEventTSSettings;
    @Autowired
    private TbQueueCloudEventSettings tbQueueCloudEventSettings;

    protected void onTbApplicationEvent(PartitionChangeEvent event) {
        if (ServiceType.TB_CORE.equals((Object)event.getServiceType())) {
            this.establishRpcConnection();
        }
    }

    protected void launchUplinkProcessing() {
        if (this.consumer == null) {
            this.consumerExecutor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"cloud-event-consumer"));
            this.consumer = QueueConsumerManager.builder().name("TB Cloud Events").msgPackProcessor((arg_0, arg_1) -> this.processUplinkMessages(arg_0, arg_1)).pollInterval(this.tbQueueCloudEventSettings.getPollInterval().longValue()).consumerCreator(() -> ((TbCloudEventQueueFactory)this.tbCloudEventQueueProvider).createCloudEventMsgConsumer()).consumerExecutor(this.consumerExecutor).threadPrefix("cloud-events").build();
            this.consumer.subscribe();
            this.consumer.launch();
        }
        if (this.tsConsumer == null) {
            this.tsConsumerExecutor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"ts-cloud-event-consumer"));
            this.tsConsumer = QueueConsumerManager.builder().name("TB TS Cloud Events").msgPackProcessor((arg_0, arg_1) -> this.processTsUplinkMessages(arg_0, arg_1)).pollInterval(this.tbQueueCloudEventTSSettings.getPollInterval().longValue()).consumerCreator(() -> ((TbCloudEventQueueFactory)this.tbCloudEventQueueProvider).createCloudEventTSMsgConsumer()).consumerExecutor(this.tsConsumerExecutor).threadPrefix("ts-cloud-events").build();
            this.tsConsumer.subscribe();
            this.tsConsumer.launch();
        }
    }

    protected void resetQueueOffset() {
    }

    @PreDestroy
    protected void onDestroy() throws InterruptedException {
        super.destroy();
        if (this.consumer != null) {
            this.consumer.stop();
            this.consumer = null;
            this.consumerExecutor.shutdown();
        }
        if (this.tsConsumer != null) {
            this.tsConsumer.stop();
            this.tsConsumer = null;
            this.tsConsumerExecutor.shutdown();
        }
    }

    private void processUplinkMessages(List<TbProtoQueueMsg<TransportProtos.ToCloudEventMsg>> msgs, TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToCloudEventMsg>> consumer) {
        boolean isProcessed = false;
        do {
            log.trace("[{}] Trying to process general uplink messages", (Object)this.tenantId);
            if (this.initialized && !this.syncInProgress) {
                this.isGeneralProcessInProgress = true;
                isProcessed = this.processMessages(msgs, consumer, true);
                this.isGeneralProcessInProgress = false;
            } else {
                log.debug("[{}] Waiting: initialized={}, syncInProgress={}", new Object[]{this.tenantId, this.initialized, this.syncInProgress});
            }
            if (isProcessed) continue;
            this.sleep();
        } while (!isProcessed);
    }

    private void processTsUplinkMessages(List<TbProtoQueueMsg<TransportProtos.ToCloudEventMsg>> msgs, TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToCloudEventMsg>> consumer) {
        boolean isProcessed = false;
        do {
            log.trace("[{}] Trying to process TS uplink messages", (Object)this.tenantId);
            if (this.initialized && !this.syncInProgress && !this.isGeneralProcessInProgress) {
                isProcessed = this.processMessages(msgs, consumer, false);
            } else {
                log.debug("[{}] Waiting: initialized={}, syncInProgress={}, generalInProgress={}", new Object[]{this.tenantId, this.initialized, this.syncInProgress, this.isGeneralProcessInProgress});
            }
            if (isProcessed) continue;
            this.sleep();
        } while (!isProcessed);
    }

    private void sleep() {
        try {
            Thread.sleep(this.cloudEventStorageSettings.getNoRecordsSleepInterval());
        }
        catch (InterruptedException interruptedException) {
            log.trace("Interrupted while waiting to retry uplink processing", (Throwable)interruptedException);
        }
    }

    private boolean processMessages(List<TbProtoQueueMsg<TransportProtos.ToCloudEventMsg>> msgs, TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToCloudEventMsg>> consumer, boolean isGeneralMsg) {
        boolean isInterrupted;
        List<CloudEvent> cloudEvents = msgs.stream().map(msg -> ProtoUtils.fromProto((TransportProtos.CloudEventMsgProto)((TransportProtos.ToCloudEventMsg)msg.getValue()).getCloudEventMsg())).toList();
        try {
            isInterrupted = (Boolean)this.processCloudEvents(cloudEvents, isGeneralMsg).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Failed to process all uplink messages", (Throwable)e);
            return false;
        }
        if (isInterrupted) {
            log.warn("[{}] Send uplink messages task was interrupted", (Object)this.tenantId);
            return false;
        }
        consumer.commit();
        log.trace("[{}] Successfully processed {} uplink messages (type={})", new Object[]{this.tenantId, cloudEvents.size(), isGeneralMsg ? "GENERAL" : "TS"});
        return true;
    }
}

