/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.GeneratedMessageV3;
import java.beans.ConstructorProperties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.dao.cloud.CloudEventService;
import org.thingsboard.server.dao.edge.stats.CloudStatsCounterService;
import org.thingsboard.server.dao.service.DataValidator;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.provider.TbCloudEventProvider;

@Service
@Primary
@ConditionalOnExpression(value="'${queue.type:null}'=='kafka'")
public class KafkaCloudEventService
implements CloudEventService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaCloudEventService.class);
    private final CloudStatsCounterService statsCounterService;
    private final TbCloudEventProvider tbCloudEventProvider;
    private final DataValidator<CloudEvent> cloudEventValidator;

    public void saveCloudEvent(TenantId tenantId, CloudEventType cloudEventType, EdgeEventActionType cloudEventAction, EntityId entityId, JsonNode entityBody, EntityGroupId entityGroupId) throws ExecutionException, InterruptedException {
        this.saveCloudEventAsync(tenantId, cloudEventType, cloudEventAction, entityId, entityBody, entityGroupId).get();
    }

    public ListenableFuture<Void> saveCloudEventAsync(TenantId tenantId, CloudEventType cloudEventType, EdgeEventActionType cloudEventAction, EntityId entityId, JsonNode entityBody, EntityGroupId entityGroupId) {
        CloudEvent cloudEvent = new CloudEvent(tenantId, cloudEventAction, entityId != null ? entityId.getId() : null, cloudEventType, entityBody, entityGroupId != null ? entityGroupId.getId() : null);
        return this.saveAsync(cloudEvent);
    }

    public ListenableFuture<Void> saveAsync(CloudEvent cloudEvent) {
        return this.saveCloudEventToTopic(cloudEvent, this.tbCloudEventProvider.getCloudEventMsgProducer());
    }

    public ListenableFuture<Void> saveTsKvAsync(CloudEvent cloudEvent) {
        return this.saveCloudEventToTopic(cloudEvent, this.tbCloudEventProvider.getCloudEventTSMsgProducer());
    }

    private ListenableFuture<Void> saveCloudEventToTopic(CloudEvent cloudEvent, TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCloudEventMsg>> producer) {
        this.cloudEventValidator.validate((BaseData)cloudEvent, CloudEvent::getTenantId);
        log.trace("Save cloud event {}", (Object)cloudEvent);
        SettableFuture futureToSet = SettableFuture.create();
        this.saveCloudEventToTopic(cloudEvent, producer, (TbQueueCallback)new /* Unavailable Anonymous Inner Class!! */);
        return futureToSet;
    }

    private void saveCloudEventToTopic(CloudEvent cloudEvent, TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCloudEventMsg>> producer, TbQueueCallback callback) {
        TopicPartitionInfo tpi = TopicPartitionInfo.builder().topic(producer.getDefaultTopic()).build();
        TransportProtos.ToCloudEventMsg toCloudEventMsg = TransportProtos.ToCloudEventMsg.newBuilder().setCloudEventMsg(ProtoUtils.toProto((CloudEvent)cloudEvent)).build();
        producer.send(tpi, (TbQueueMsg)new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)toCloudEventMsg), callback);
    }

    public PageData<CloudEvent> findCloudEvents(TenantId tenantId, Long seqIdStart, Long seqIdEnd, TimePageLink pageLink) {
        throw new RuntimeException("Not implemented!");
    }

    public PageData<CloudEvent> findTsKvCloudEvents(TenantId tenantId, Long seqIdStart, Long seqIdEnd, TimePageLink pageLink) {
        throw new RuntimeException("Not implemented!");
    }

    @ConstructorProperties(value={"statsCounterService", "tbCloudEventProvider", "cloudEventValidator"})
    @Generated
    public KafkaCloudEventService(CloudStatsCounterService statsCounterService, TbCloudEventProvider tbCloudEventProvider, DataValidator<CloudEvent> cloudEventValidator) {
        this.statsCounterService = statsCounterService;
        this.tbCloudEventProvider = tbCloudEventProvider;
        this.cloudEventValidator = cloudEventValidator;
    }
}

