/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.dao.cloud.CloudEventService;
import org.thingsboard.server.queue.discovery.event.PartitionChangeEvent;
import org.thingsboard.server.service.cloud.BaseCloudManagerService;
import org.thingsboard.server.service.cloud.CloudEventMigrationService;

@Service
@ConditionalOnExpression(value="'${queue.type:null}'=='kafka'")
public class KafkaCloudEventMigrationService
extends BaseCloudManagerService
implements CloudEventMigrationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaCloudEventMigrationService.class);
    @Autowired
    private CloudEventService kafkaEventService;
    @Autowired
    @Qualifier(value="postgresCloudEventService")
    private CloudEventService postgresCloudEventService;
    private volatile boolean isMigrated = false;
    private volatile boolean isTsMigrated = false;
    private ExecutorService executor;

    @PostConstruct
    private void onInit() {
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"postgres-cloud-migrator"));
    }

    public void migrateUnprocessedEventToKafka() {
        this.executor.submit(() -> {
            try {
                while (!Thread.interrupted()) {
                    if (!this.initialized) {
                        TimeUnit.SECONDS.sleep(1L);
                        continue;
                    }
                    this.processMigration();
                    if (!this.isMigrated || !this.isTsMigrated) continue;
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            catch (Exception e) {
                log.warn("Failed to process messages handling!", (Throwable)e);
            }
            finally {
                if (this.executor != null && !this.executor.isShutdown()) {
                    this.executor.shutdown();
                }
            }
        });
    }

    private void processMigration() throws Exception {
        BaseCloudManagerService.CloudEventFinder finder;
        if (!this.isMigrated) {
            finder = (tenantId, seqIdStart, seqIdEnd, link) -> this.postgresCloudEventService.findCloudEvents(tenantId, seqIdStart, seqIdEnd, link);
            this.isMigrated = this.launchCloudEventProcessing("queueSeqIdOffset", "queueStartTs", true, finder);
        }
        if (!this.isTsMigrated) {
            finder = (tenantId, seqIdStart, seqIdEnd, link) -> this.postgresCloudEventService.findTsKvCloudEvents(tenantId, seqIdStart, seqIdEnd, link);
            this.isTsMigrated = this.launchCloudEventProcessing("queueTsKvSeqIdOffset", "queueTsKvStartTs", false, finder);
        }
    }

    private boolean launchCloudEventProcessing(String seqIdKey, String startTsKey, boolean isGeneralMsg, BaseCloudManagerService.CloudEventFinder finder) throws Exception {
        Long queueSeqIdStart = (Long)this.getLongAttrByKey(this.tenantId, seqIdKey).get();
        TimePageLink pageLink = this.newCloudEventsAvailable(this.tenantId, queueSeqIdStart, startTsKey, finder);
        if (pageLink != null) {
            this.processUplinkMessages(pageLink, queueSeqIdStart, startTsKey, seqIdKey, isGeneralMsg, finder);
            return false;
        }
        return true;
    }

    protected ListenableFuture<Boolean> processCloudEvents(List<CloudEvent> cloudEvents, boolean isGeneralMsg) {
        for (CloudEvent cloudEvent : cloudEvents) {
            if (isGeneralMsg) {
                this.kafkaEventService.saveAsync(cloudEvent);
                continue;
            }
            this.kafkaEventService.saveTsKvAsync(cloudEvent);
        }
        return Futures.immediateFuture((Object)Boolean.FALSE);
    }

    protected void onTbApplicationEvent(PartitionChangeEvent event) {
    }

    protected void launchUplinkProcessing() {
    }

    @PreDestroy
    protected void onDestroy() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    @Generated
    public boolean isMigrated() {
        return this.isMigrated;
    }

    @Generated
    public boolean isTsMigrated() {
        return this.isTsMigrated;
    }
}

