/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.data.CloudUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmComment;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.dao.alarm.AlarmService;
import org.thingsboard.server.dao.cloud.CloudEventService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.CloudNotificationService;
import org.thingsboard.server.service.cloud.DefaultCloudNotificationService;

@Service
@TbCoreComponent
public class DefaultCloudNotificationService
implements CloudNotificationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultCloudNotificationService.class);
    @Autowired
    private AlarmService alarmService;
    @Autowired
    private CloudEventService cloudEventService;
    private ExecutorService dbCallBackExecutor;

    @PostConstruct
    public void initExecutor() {
        this.dbCallBackExecutor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"cloud-notifications"));
    }

    @PreDestroy
    public void shutdownExecutor() {
        if (this.dbCallBackExecutor != null) {
            this.dbCallBackExecutor.shutdownNow();
        }
    }

    public void pushNotificationToCloud(TransportProtos.CloudNotificationMsgProto cloudNotificationMsg, TbCallback callback) {
        try {
            TenantId tenantId = TenantId.fromUUID((UUID)new UUID(cloudNotificationMsg.getTenantIdMSB(), cloudNotificationMsg.getTenantIdLSB()));
            CloudEventType cloudEventType = CloudEventType.valueOf((String)cloudNotificationMsg.getCloudEventType());
            Futures.addCallback((ListenableFuture)(switch (2.$SwitchMap$org$thingsboard$server$common$data$cloud$CloudEventType[cloudEventType.ordinal()]) {
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> this.processEntity(tenantId, cloudNotificationMsg);
                case 11 -> this.processAlarm(tenantId, cloudNotificationMsg);
                case 12 -> this.processRelation(tenantId, cloudNotificationMsg);
                case 13 -> this.processAlarmComment(tenantId, cloudNotificationMsg);
                default -> {
                    log.warn("Cloud event type [{}] is not designed to be pushed to cloud", (Object)cloudEventType);
                    yield Futures.immediateFuture(null);
                }
            }), (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)this.dbCallBackExecutor);
        }
        catch (Exception e) {
            this.callBackFailure(cloudNotificationMsg, callback, (Throwable)e);
        }
    }

    private void callBackFailure(TransportProtos.CloudNotificationMsgProto cloudNotificationMsg, TbCallback callback, Throwable throwable) {
        log.error("Can't push to cloud updates, cloudNotificationMsg [{}]", (Object)cloudNotificationMsg, (Object)throwable);
        callback.onFailure(throwable);
    }

    private ListenableFuture<Void> processEntity(TenantId tenantId, TransportProtos.CloudNotificationMsgProto cloudNotificationMsg) {
        EdgeEventActionType cloudEventActionType = EdgeEventActionType.valueOf((String)cloudNotificationMsg.getCloudEventAction());
        CloudEventType cloudEventType = CloudEventType.valueOf((String)cloudNotificationMsg.getCloudEventType());
        EntityId entityId = EntityIdFactory.getByCloudEventTypeAndUuid((CloudEventType)cloudEventType, (UUID)new UUID(cloudNotificationMsg.getEntityIdMSB(), cloudNotificationMsg.getEntityIdLSB()));
        return switch (2.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[cloudEventActionType.ordinal()]) {
            case 1, 2, 3, 4, 5, 6 -> {
                EntityGroupId entityGroupId = null;
                if (cloudNotificationMsg.getEntityGroupIdMSB() != 0L && cloudNotificationMsg.getEntityGroupIdLSB() != 0L) {
                    entityGroupId = new EntityGroupId(new UUID(cloudNotificationMsg.getEntityGroupIdMSB(), cloudNotificationMsg.getEntityGroupIdLSB()));
                }
                yield this.cloudEventService.saveCloudEventAsync(tenantId, cloudEventType, cloudEventActionType, entityId, null, entityGroupId);
            }
            default -> Futures.immediateFuture(null);
        };
    }

    private ListenableFuture<Void> processAlarm(TenantId tenantId, TransportProtos.CloudNotificationMsgProto cloudNotificationMsg) {
        EdgeEventActionType actionType = EdgeEventActionType.valueOf((String)cloudNotificationMsg.getCloudEventAction());
        AlarmId alarmId = new AlarmId(new UUID(cloudNotificationMsg.getEntityIdMSB(), cloudNotificationMsg.getEntityIdLSB()));
        if (EdgeEventActionType.DELETED.equals((Object)actionType) || EdgeEventActionType.ALARM_DELETE.equals((Object)actionType)) {
            Alarm deletedAlarm = (Alarm)JacksonUtil.fromString((String)cloudNotificationMsg.getEntityBody(), Alarm.class);
            return this.cloudEventService.saveCloudEventAsync(tenantId, CloudEventType.ALARM, actionType, (EntityId)alarmId, JacksonUtil.valueToTree((Object)deletedAlarm), null);
        }
        ListenableFuture future = this.alarmService.findAlarmByIdAsync(tenantId, alarmId);
        return Futures.transformAsync((ListenableFuture)future, alarm -> {
            CloudEventType cloudEventType;
            if (alarm != null && (cloudEventType = CloudUtils.getCloudEventTypeByEntityType((EntityType)alarm.getOriginator().getEntityType())) != null) {
                return this.cloudEventService.saveCloudEventAsync(tenantId, CloudEventType.ALARM, EdgeEventActionType.valueOf((String)cloudNotificationMsg.getCloudEventAction()), (EntityId)alarmId, null, null);
            }
            return Futures.immediateFuture(null);
        }, (Executor)this.dbCallBackExecutor);
    }

    public ListenableFuture<Void> processAlarmComment(TenantId tenantId, TransportProtos.CloudNotificationMsgProto cloudNotificationMsg) {
        EdgeEventActionType actionType = EdgeEventActionType.valueOf((String)cloudNotificationMsg.getCloudEventAction());
        AlarmId alarmId = new AlarmId(new UUID(cloudNotificationMsg.getEntityIdMSB(), cloudNotificationMsg.getEntityIdLSB()));
        AlarmComment alarmComment = (AlarmComment)JacksonUtil.fromString((String)cloudNotificationMsg.getEntityBody(), AlarmComment.class);
        if (alarmComment == null) {
            return Futures.immediateFuture(null);
        }
        return this.cloudEventService.saveCloudEventAsync(tenantId, CloudEventType.ALARM_COMMENT, actionType, (EntityId)alarmId, JacksonUtil.valueToTree((Object)alarmComment), null);
    }

    private ListenableFuture<Void> processRelation(TenantId tenantId, TransportProtos.CloudNotificationMsgProto cloudNotificationMsg) {
        EntityRelation relation = (EntityRelation)JacksonUtil.fromString((String)cloudNotificationMsg.getEntityBody(), EntityRelation.class);
        return this.cloudEventService.saveCloudEventAsync(tenantId, CloudEventType.RELATION, EdgeEventActionType.valueOf((String)cloudNotificationMsg.getCloudEventAction()), null, JacksonUtil.valueToTree((Object)relation), null);
    }
}

