/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.dao.cloud.CloudEventService;
import org.thingsboard.server.dao.cloud.EdgeSettingsService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.CloudEventStorageSettings;
import org.thingsboard.server.service.cloud.rpc.processor.CalculatedFieldCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.CustomerCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.DeviceCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.EdgeCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.RelationCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.TelemetryCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.TenantCloudProcessor;
import org.thingsboard.server.service.edge.rpc.processor.EdgeProcessor;
import org.thingsboard.server.service.executors.DbCallbackExecutorService;

@Lazy
@Component
@TbCoreComponent
public class CloudContextComponent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudContextComponent.class);
    private Map<CloudEventType, EdgeProcessor> processorMap = new EnumMap(CloudEventType.class);
    @Autowired
    private CloudEventService cloudEventService;
    @Autowired
    private CustomerCloudProcessor customerProcessor;
    @Autowired
    private DeviceCloudProcessor deviceProcessor;
    @Autowired
    private EdgeCloudProcessor edgeProcessor;
    @Autowired
    private RelationCloudProcessor relationProcessor;
    @Autowired
    private TelemetryCloudProcessor telemetryProcessor;
    @Autowired
    private TenantCloudProcessor tenantProcessor;
    @Autowired
    private EdgeSettingsService edgeSettingsService;
    @Autowired
    private CloudEventStorageSettings cloudEventStorageSettings;
    @Autowired
    private CalculatedFieldCloudProcessor calculatedFieldProcessor;
    @Autowired
    private DbCallbackExecutorService dbCallbackExecutorService;

    @Autowired
    public CloudContextComponent(List<EdgeProcessor> processors) {
        processors.forEach(processor -> {
            CloudEventType eventType = processor.getCloudEventType();
            if (eventType != null) {
                this.processorMap.put(eventType, processor);
            }
        });
    }

    public EdgeProcessor getProcessor(CloudEventType cloudEventType) {
        EdgeProcessor processor = (EdgeProcessor)this.processorMap.get(cloudEventType);
        if (processor == null) {
            throw new UnsupportedOperationException("No processor found for CloudEventType: " + String.valueOf(cloudEventType));
        }
        return processor;
    }

    @Generated
    public Map<CloudEventType, EdgeProcessor> getProcessorMap() {
        return this.processorMap;
    }

    @Generated
    public CloudEventService getCloudEventService() {
        return this.cloudEventService;
    }

    @Generated
    public CustomerCloudProcessor getCustomerProcessor() {
        return this.customerProcessor;
    }

    @Generated
    public DeviceCloudProcessor getDeviceProcessor() {
        return this.deviceProcessor;
    }

    @Generated
    public EdgeCloudProcessor getEdgeProcessor() {
        return this.edgeProcessor;
    }

    @Generated
    public RelationCloudProcessor getRelationProcessor() {
        return this.relationProcessor;
    }

    @Generated
    public TelemetryCloudProcessor getTelemetryProcessor() {
        return this.telemetryProcessor;
    }

    @Generated
    public TenantCloudProcessor getTenantProcessor() {
        return this.tenantProcessor;
    }

    @Generated
    public EdgeSettingsService getEdgeSettingsService() {
        return this.edgeSettingsService;
    }

    @Generated
    public CloudEventStorageSettings getCloudEventStorageSettings() {
        return this.cloudEventStorageSettings;
    }

    @Generated
    public CalculatedFieldCloudProcessor getCalculatedFieldProcessor() {
        return this.calculatedFieldProcessor;
    }

    @Generated
    public DbCallbackExecutorService getDbCallbackExecutorService() {
        return this.dbCallbackExecutorService;
    }

    @Generated
    public void setProcessorMap(Map<CloudEventType, EdgeProcessor> processorMap) {
        this.processorMap = processorMap;
    }

    @Generated
    public void setCloudEventService(CloudEventService cloudEventService) {
        this.cloudEventService = cloudEventService;
    }

    @Generated
    public void setCustomerProcessor(CustomerCloudProcessor customerProcessor) {
        this.customerProcessor = customerProcessor;
    }

    @Generated
    public void setDeviceProcessor(DeviceCloudProcessor deviceProcessor) {
        this.deviceProcessor = deviceProcessor;
    }

    @Generated
    public void setEdgeProcessor(EdgeCloudProcessor edgeProcessor) {
        this.edgeProcessor = edgeProcessor;
    }

    @Generated
    public void setRelationProcessor(RelationCloudProcessor relationProcessor) {
        this.relationProcessor = relationProcessor;
    }

    @Generated
    public void setTelemetryProcessor(TelemetryCloudProcessor telemetryProcessor) {
        this.telemetryProcessor = telemetryProcessor;
    }

    @Generated
    public void setTenantProcessor(TenantCloudProcessor tenantProcessor) {
        this.tenantProcessor = tenantProcessor;
    }

    @Generated
    public void setEdgeSettingsService(EdgeSettingsService edgeSettingsService) {
        this.edgeSettingsService = edgeSettingsService;
    }

    @Generated
    public void setCloudEventStorageSettings(CloudEventStorageSettings cloudEventStorageSettings) {
        this.cloudEventStorageSettings = cloudEventStorageSettings;
    }

    @Generated
    public void setCalculatedFieldProcessor(CalculatedFieldCloudProcessor calculatedFieldProcessor) {
        this.calculatedFieldProcessor = calculatedFieldProcessor;
    }

    @Generated
    public void setDbCallbackExecutorService(DbCallbackExecutorService dbCallbackExecutorService) {
        this.dbCallbackExecutorService = dbCallbackExecutorService;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudContextComponent)) {
            return false;
        }
        CloudContextComponent other = (CloudContextComponent)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Map this$processorMap = this.getProcessorMap();
        Map other$processorMap = other.getProcessorMap();
        if (this$processorMap == null ? other$processorMap != null : !((Object)this$processorMap).equals(other$processorMap)) {
            return false;
        }
        CloudEventService this$cloudEventService = this.getCloudEventService();
        CloudEventService other$cloudEventService = other.getCloudEventService();
        if (this$cloudEventService == null ? other$cloudEventService != null : !this$cloudEventService.equals(other$cloudEventService)) {
            return false;
        }
        CustomerCloudProcessor this$customerProcessor = this.getCustomerProcessor();
        CustomerCloudProcessor other$customerProcessor = other.getCustomerProcessor();
        if (this$customerProcessor == null ? other$customerProcessor != null : !this$customerProcessor.equals(other$customerProcessor)) {
            return false;
        }
        DeviceCloudProcessor this$deviceProcessor = this.getDeviceProcessor();
        DeviceCloudProcessor other$deviceProcessor = other.getDeviceProcessor();
        if (this$deviceProcessor == null ? other$deviceProcessor != null : !this$deviceProcessor.equals(other$deviceProcessor)) {
            return false;
        }
        EdgeCloudProcessor this$edgeProcessor = this.getEdgeProcessor();
        EdgeCloudProcessor other$edgeProcessor = other.getEdgeProcessor();
        if (this$edgeProcessor == null ? other$edgeProcessor != null : !this$edgeProcessor.equals(other$edgeProcessor)) {
            return false;
        }
        RelationCloudProcessor this$relationProcessor = this.getRelationProcessor();
        RelationCloudProcessor other$relationProcessor = other.getRelationProcessor();
        if (this$relationProcessor == null ? other$relationProcessor != null : !this$relationProcessor.equals(other$relationProcessor)) {
            return false;
        }
        TelemetryCloudProcessor this$telemetryProcessor = this.getTelemetryProcessor();
        TelemetryCloudProcessor other$telemetryProcessor = other.getTelemetryProcessor();
        if (this$telemetryProcessor == null ? other$telemetryProcessor != null : !this$telemetryProcessor.equals(other$telemetryProcessor)) {
            return false;
        }
        TenantCloudProcessor this$tenantProcessor = this.getTenantProcessor();
        TenantCloudProcessor other$tenantProcessor = other.getTenantProcessor();
        if (this$tenantProcessor == null ? other$tenantProcessor != null : !this$tenantProcessor.equals(other$tenantProcessor)) {
            return false;
        }
        EdgeSettingsService this$edgeSettingsService = this.getEdgeSettingsService();
        EdgeSettingsService other$edgeSettingsService = other.getEdgeSettingsService();
        if (this$edgeSettingsService == null ? other$edgeSettingsService != null : !this$edgeSettingsService.equals(other$edgeSettingsService)) {
            return false;
        }
        CloudEventStorageSettings this$cloudEventStorageSettings = this.getCloudEventStorageSettings();
        CloudEventStorageSettings other$cloudEventStorageSettings = other.getCloudEventStorageSettings();
        if (this$cloudEventStorageSettings == null ? other$cloudEventStorageSettings != null : !this$cloudEventStorageSettings.equals(other$cloudEventStorageSettings)) {
            return false;
        }
        CalculatedFieldCloudProcessor this$calculatedFieldProcessor = this.getCalculatedFieldProcessor();
        CalculatedFieldCloudProcessor other$calculatedFieldProcessor = other.getCalculatedFieldProcessor();
        if (this$calculatedFieldProcessor == null ? other$calculatedFieldProcessor != null : !this$calculatedFieldProcessor.equals(other$calculatedFieldProcessor)) {
            return false;
        }
        DbCallbackExecutorService this$dbCallbackExecutorService = this.getDbCallbackExecutorService();
        DbCallbackExecutorService other$dbCallbackExecutorService = other.getDbCallbackExecutorService();
        return !(this$dbCallbackExecutorService == null ? other$dbCallbackExecutorService != null : !this$dbCallbackExecutorService.equals(other$dbCallbackExecutorService));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CloudContextComponent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map $processorMap = this.getProcessorMap();
        result = result * 59 + ($processorMap == null ? 43 : ((Object)$processorMap).hashCode());
        CloudEventService $cloudEventService = this.getCloudEventService();
        result = result * 59 + ($cloudEventService == null ? 43 : $cloudEventService.hashCode());
        CustomerCloudProcessor $customerProcessor = this.getCustomerProcessor();
        result = result * 59 + ($customerProcessor == null ? 43 : $customerProcessor.hashCode());
        DeviceCloudProcessor $deviceProcessor = this.getDeviceProcessor();
        result = result * 59 + ($deviceProcessor == null ? 43 : $deviceProcessor.hashCode());
        EdgeCloudProcessor $edgeProcessor = this.getEdgeProcessor();
        result = result * 59 + ($edgeProcessor == null ? 43 : $edgeProcessor.hashCode());
        RelationCloudProcessor $relationProcessor = this.getRelationProcessor();
        result = result * 59 + ($relationProcessor == null ? 43 : $relationProcessor.hashCode());
        TelemetryCloudProcessor $telemetryProcessor = this.getTelemetryProcessor();
        result = result * 59 + ($telemetryProcessor == null ? 43 : $telemetryProcessor.hashCode());
        TenantCloudProcessor $tenantProcessor = this.getTenantProcessor();
        result = result * 59 + ($tenantProcessor == null ? 43 : $tenantProcessor.hashCode());
        EdgeSettingsService $edgeSettingsService = this.getEdgeSettingsService();
        result = result * 59 + ($edgeSettingsService == null ? 43 : $edgeSettingsService.hashCode());
        CloudEventStorageSettings $cloudEventStorageSettings = this.getCloudEventStorageSettings();
        result = result * 59 + ($cloudEventStorageSettings == null ? 43 : $cloudEventStorageSettings.hashCode());
        CalculatedFieldCloudProcessor $calculatedFieldProcessor = this.getCalculatedFieldProcessor();
        result = result * 59 + ($calculatedFieldProcessor == null ? 43 : $calculatedFieldProcessor.hashCode());
        DbCallbackExecutorService $dbCallbackExecutorService = this.getDbCallbackExecutorService();
        result = result * 59 + ($dbCallbackExecutorService == null ? 43 : $dbCallbackExecutorService.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CloudContextComponent(processorMap=" + String.valueOf(this.getProcessorMap()) + ", cloudEventService=" + String.valueOf(this.getCloudEventService()) + ", customerProcessor=" + String.valueOf(this.getCustomerProcessor()) + ", deviceProcessor=" + String.valueOf(this.getDeviceProcessor()) + ", edgeProcessor=" + String.valueOf(this.getEdgeProcessor()) + ", relationProcessor=" + String.valueOf(this.getRelationProcessor()) + ", telemetryProcessor=" + String.valueOf(this.getTelemetryProcessor()) + ", tenantProcessor=" + String.valueOf(this.getTenantProcessor()) + ", edgeSettingsService=" + String.valueOf(this.getEdgeSettingsService()) + ", cloudEventStorageSettings=" + String.valueOf(this.getCloudEventStorageSettings()) + ", calculatedFieldProcessor=" + String.valueOf(this.getCalculatedFieldProcessor()) + ", dbCallbackExecutorService=" + String.valueOf(this.getDbCallbackExecutorService()) + ")";
    }
}

