/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.edge.rpc.EdgeRpcClient;
import org.thingsboard.rule.engine.api.AttributesSaveRequest;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeSettings;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.BooleanDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.cloud.EdgeSettingsService;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.dao.edge.stats.CloudStatsCounterService;
import org.thingsboard.server.dao.edge.stats.CloudStatsKey;
import org.thingsboard.server.dao.subscription.SubscriptionService;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeConfiguration;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.gen.edge.v1.UplinkResponseMsg;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.TbApplicationEventListener;
import org.thingsboard.server.queue.discovery.event.PartitionChangeEvent;
import org.thingsboard.server.service.cloud.BaseCloudManagerService;
import org.thingsboard.server.service.cloud.CloudContextComponent;
import org.thingsboard.server.service.cloud.CloudEventMigrationService;
import org.thingsboard.server.service.cloud.DownlinkMessageService;
import org.thingsboard.server.service.cloud.rpc.CloudEventStorageSettings;
import org.thingsboard.server.service.cloud.rpc.processor.EntityGroupCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.GroupPermissionCloudProcessor;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.executors.DbCallbackExecutorService;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;

public abstract class BaseCloudManagerService
extends TbApplicationEventListener<PartitionChangeEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseCloudManagerService.class);
    protected static final String QUEUE_START_TS_ATTR_KEY = "queueStartTs";
    protected static final String QUEUE_SEQ_ID_OFFSET_ATTR_KEY = "queueSeqIdOffset";
    protected static final String QUEUE_TS_KV_START_TS_ATTR_KEY = "queueTsKvStartTs";
    protected static final String QUEUE_TS_KV_SEQ_ID_OFFSET_ATTR_KEY = "queueTsKvSeqIdOffset";
    private static final int MAX_SEND_UPLINK_ATTEMPTS = 3;
    @Value(value="${cloud.routingKey}")
    private String routingKey;
    @Value(value="${cloud.secret}")
    private String routingSecret;
    @Value(value="${cloud.reconnect_timeout}")
    private long reconnectTimeoutMs;
    @Value(value="${cloud.uplink_pack_timeout_sec:60}")
    private long uplinkPackTimeoutSec;
    @Value(value="${cloud.rpc.host}")
    private String rpcHost;
    @Autowired
    private CloudContextComponent cloudCtx;
    @Autowired
    private PartitionService partitionService;
    @Autowired
    private EdgeService edgeService;
    @Autowired
    private AttributesService attributesService;
    @Autowired
    protected CloudEventStorageSettings cloudEventStorageSettings;
    @Autowired
    private TelemetrySubscriptionService tsSubService;
    @Autowired
    private EntityGroupCloudProcessor entityGroupProcessor;
    @Autowired
    private GroupPermissionCloudProcessor groupPermissionProcessor;
    @Autowired
    private DownlinkMessageService downlinkMessageService;
    @Autowired
    private EdgeRpcClient edgeRpcClient;
    @Autowired
    private EdgeSettingsService edgeSettingsService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private ConfigurableApplicationContext context;
    @Autowired
    private DbCallbackExecutorService dbCallbackExecutorService;
    @Autowired(required=false)
    private CloudEventMigrationService cloudEventMigrationService;
    @Autowired
    protected CloudStatsCounterService statsCounterService;
    private ScheduledExecutorService uplinkExecutor;
    private ScheduledFuture<?> sendUplinkFuture;
    private ScheduledExecutorService shutdownExecutor;
    private ScheduledExecutorService reconnectExecutor;
    private ScheduledExecutorService connectExecutor;
    private ScheduledFuture<?> reconnectFuture;
    private ScheduledFuture<?> connectFuture;
    private EdgeSettings currentEdgeSettings;
    protected TenantId tenantId;
    private CustomerId customerId;
    private final ConcurrentMap<Integer, UplinkMsg> pendingMsgMap = new ConcurrentHashMap();
    private CountDownLatch latch;
    private SettableFuture<Boolean> sendUplinkFutureResult;
    private final Lock uplinkSendLock = new ReentrantLock();
    protected volatile boolean initialized;
    protected volatile boolean offlineInitialized;
    protected volatile boolean isGeneralProcessInProgress = false;
    protected volatile boolean syncInProgress = false;
    private volatile boolean sendingInProgress = false;
    private volatile boolean isRateLimitViolated = false;
    private volatile boolean initInProgress = false;
    private volatile boolean shouldPerformInitialSync = true;

    protected void establishRpcConnection() {
        if (this.connectFuture != null) {
            this.connectFuture.cancel(true);
            this.connectFuture = null;
        }
        if (this.connectExecutor == null) {
            this.connectExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"cloud-manager-connect"));
        }
        this.connectFuture = this.connectExecutor.schedule(() -> {
            try {
                BaseCloudManagerService baseCloudManagerService = this;
                synchronized (baseCloudManagerService) {
                    if (!this.isSystemTenantPartitionMine()) {
                        this.onDestroy();
                        return;
                    }
                    if (!this.initialized && !this.initInProgress && this.validateRoutingKeyAndSecret()) {
                        this.initInProgress = true;
                        try {
                            log.info("Starting Cloud Edge service");
                            this.edgeRpcClient.connect(this.routingKey, this.routingSecret, arg_0 -> this.onUplinkResponse(arg_0), arg_0 -> this.onEdgeUpdate(arg_0), arg_0 -> this.onDownlink(arg_0), arg_0 -> this.scheduleReconnect(arg_0));
                            this.uplinkExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"cloud-manager-uplink"));
                            this.reconnectExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"cloud-manager-reconnect"));
                            this.launchUplinkProcessing();
                        }
                        catch (Exception e) {
                            this.initInProgress = false;
                            log.error("Failed to establish connection to cloud", (Throwable)e);
                            this.connectExecutor.schedule(() -> this.establishRpcConnection(), this.reconnectTimeoutMs, TimeUnit.MILLISECONDS);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error("Failed to establish Cloud Edge service", (Throwable)e);
            }
        }, this.reconnectTimeoutMs, TimeUnit.MILLISECONDS);
    }

    protected abstract void launchUplinkProcessing();

    protected abstract void onDestroy() throws InterruptedException;

    protected void resetQueueOffset() {
        this.updateQueueStartTsSeqIdOffset(this.tenantId, QUEUE_START_TS_ATTR_KEY, QUEUE_SEQ_ID_OFFSET_ATTR_KEY, Long.valueOf(System.currentTimeMillis()), Long.valueOf(0L));
        this.updateQueueStartTsSeqIdOffset(this.tenantId, QUEUE_TS_KV_START_TS_ATTR_KEY, QUEUE_TS_KV_SEQ_ID_OFFSET_ATTR_KEY, Long.valueOf(System.currentTimeMillis()), Long.valueOf(0L));
    }

    protected void updateQueueStartTsSeqIdOffset(TenantId tenantId, String attrStartTsKey, String attrSeqIdKey, Long startTs, Long seqIdOffset) {
        log.trace("updateQueueStartTsSeqIdOffset [{}][{}][{}][{}]", new Object[]{attrStartTsKey, attrSeqIdKey, startTs, seqIdOffset});
        List<AttributeKvEntry> attributes = Arrays.asList(new BaseAttributeKvEntry((KvEntry)new LongDataEntry(attrStartTsKey, startTs), System.currentTimeMillis()), new BaseAttributeKvEntry((KvEntry)new LongDataEntry(attrSeqIdKey, seqIdOffset), System.currentTimeMillis()));
        try {
            this.attributesService.save(tenantId, (EntityId)tenantId, AttributeScope.SERVER_SCOPE, attributes).get();
        }
        catch (Exception e) {
            log.error("Failed to update queueStartTsSeqIdOffset [{}][{}]", new Object[]{attrStartTsKey, attrSeqIdKey, e});
        }
    }

    protected void destroy() throws InterruptedException {
        this.initInProgress = false;
        this.initialized = false;
        if (this.shutdownExecutor != null) {
            this.shutdownExecutor.shutdownNow();
        }
        this.updateConnectivityStatus(false);
        String edgeId = this.currentEdgeSettings != null ? this.currentEdgeSettings.getEdgeId() : "";
        log.info("[{}] Starting destroying process", (Object)edgeId);
        try {
            this.edgeRpcClient.disconnect(false);
        }
        catch (Exception e) {
            log.error("Exception during disconnect", (Throwable)e);
        }
        if (this.uplinkExecutor != null && !this.uplinkExecutor.isShutdown()) {
            this.uplinkExecutor.shutdownNow();
            this.uplinkExecutor = null;
        }
        if (this.reconnectExecutor != null) {
            this.reconnectExecutor.shutdownNow();
            this.reconnectExecutor = null;
        }
        log.info("[{}] Destroy was successful", (Object)edgeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processUplinkMessages(TimePageLink pageLink, Long queueSeqIdStart, String queueStartTsAttrKey, String queueSeqIdAttrKey, boolean isGeneralMsg, CloudEventFinder finder) {
        try {
            PageData cloudEvents;
            boolean isInterrupted;
            if (isGeneralMsg) {
                this.isGeneralProcessInProgress = true;
            }
            do {
                if (!isGeneralMsg) {
                    this.waitForGeneralProcessingCompleteIfInProgress();
                }
                if ((cloudEvents = finder.find(this.tenantId, queueSeqIdStart, null, pageLink)).getData().isEmpty()) {
                    log.info("seqId column of table started new cycle. queueSeqIdStart={}, queueStartTsAttrKey={}, queueSeqIdAttrKey={}, isGeneralMsg={}", new Object[]{queueSeqIdStart, queueStartTsAttrKey, queueSeqIdAttrKey, isGeneralMsg});
                    cloudEvents = this.findCloudEventsFromBeginning(this.tenantId, pageLink, finder);
                }
                if (!(isInterrupted = ((Boolean)this.processCloudEvents(cloudEvents.getData(), isGeneralMsg).get()).booleanValue()) && cloudEvents.getTotalElements() > 0L) {
                    CloudEvent latestCloudEvent = (CloudEvent)cloudEvents.getData().get(cloudEvents.getData().size() - 1);
                    try {
                        Long newStartTs = Uuids.unixTimestamp((UUID)latestCloudEvent.getUuidId());
                        this.updateQueueStartTsSeqIdOffset(this.tenantId, queueStartTsAttrKey, queueSeqIdAttrKey, newStartTs, Long.valueOf(latestCloudEvent.getSeqId()));
                        log.info("Queue offset was updated [{}][{}][{}]", new Object[]{latestCloudEvent.getUuidId(), newStartTs, latestCloudEvent.getSeqId()});
                    }
                    catch (Exception e) {
                        log.error("Failed to update queue offset [{}]", (Object)latestCloudEvent);
                    }
                }
                if (!isInterrupted) {
                    pageLink = pageLink.nextPageLink();
                    if (cloudEvents.hasNext()) {
                        String queueName = isGeneralMsg ? "Cloud Event" : "TSKv Cloud Event";
                        long queueSize = Math.max(cloudEvents.getTotalElements() - (long)pageLink.getPage() * (long)pageLink.getPageSize(), 0L);
                        this.statsCounterService.setUplinkMsgsLag(this.tenantId, queueSize);
                        log.info("[{}] Uplink Processing Lag Stats: queue size = [{}], current page = [{}], total pages = [{}]", new Object[]{queueName, queueSize, pageLink.getPage(), cloudEvents.getTotalPages()});
                    }
                }
                if (!isGeneralMsg) {
                    this.waitForGeneralProcessingCompleteIfInProgress();
                }
                log.trace("processUplinkMessages state isInterrupted={},total={},hasNext={},isGeneralMsg={},isGeneralProcessInProgress={}", new Object[]{isInterrupted, cloudEvents.getTotalElements(), cloudEvents.hasNext(), isGeneralMsg, this.isGeneralProcessInProgress});
            } while (isInterrupted || cloudEvents.hasNext());
        }
        catch (Exception e) {
            log.error("Failed to process cloud event messages handling!", (Throwable)e);
        }
        finally {
            if (isGeneralMsg) {
                this.isGeneralProcessInProgress = false;
            }
        }
    }

    private void waitForGeneralProcessingCompleteIfInProgress() {
        if (!this.isGeneralProcessInProgress) {
            return;
        }
        do {
            try {
                TimeUnit.MILLISECONDS.sleep(25L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        } while (this.isGeneralProcessInProgress);
    }

    protected TimePageLink newCloudEventsAvailable(TenantId tenantId, Long queueSeqIdStart, String key, CloudEventFinder finder) {
        try {
            long queueStartTs = (Long)this.getLongAttrByKey(tenantId, key).get();
            queueStartTs = queueStartTs > 0L ? queueStartTs - EdgeUtils.MISORDERING_COMPENSATION_MILLIS : 0L;
            long queueEndTs = queueStartTs > 0L ? queueStartTs + TimeUnit.DAYS.toMillis(1L) : System.currentTimeMillis();
            log.trace("newCloudEventsAvailable, queueSeqIdStart = {}, key = {}, queueStartTs = {}, queueEndTs = {}", new Object[]{queueSeqIdStart, key, queueStartTs, queueEndTs});
            TimePageLink pageLink = new TimePageLink(this.cloudEventStorageSettings.getMaxReadRecordsCount(), 0, null, null, Long.valueOf(queueStartTs), Long.valueOf(queueEndTs));
            PageData cloudEvents = finder.find(tenantId, queueSeqIdStart, null, pageLink);
            if (cloudEvents.getData().isEmpty()) {
                if (queueSeqIdStart > (long)this.cloudEventStorageSettings.getMaxReadRecordsCount() && (cloudEvents = this.findCloudEventsFromBeginning(tenantId, pageLink, finder)).getData().stream().anyMatch(ce -> ce.getSeqId() == 1L)) {
                    log.info("newCloudEventsAvailable: new cycle started (seq_id starts from '1')!");
                    return pageLink;
                }
                while (queueEndTs < System.currentTimeMillis()) {
                    log.trace("newCloudEventsAvailable: queueEndTs < System.currentTimeMillis() [{}] [{}]", (Object)queueEndTs, (Object)System.currentTimeMillis());
                    queueStartTs = queueEndTs;
                    pageLink = new TimePageLink(this.cloudEventStorageSettings.getMaxReadRecordsCount(), 0, null, null, Long.valueOf(queueStartTs), Long.valueOf(queueEndTs += TimeUnit.DAYS.toMillis(1L)));
                    cloudEvents = finder.find(tenantId, queueSeqIdStart, null, pageLink);
                    if (cloudEvents.getData().isEmpty()) continue;
                    return pageLink;
                }
                return null;
            }
            return pageLink;
        }
        catch (Exception e) {
            log.warn("Failed to check newCloudEventsAvailable!", (Throwable)e);
            return null;
        }
    }

    protected PageData<CloudEvent> findCloudEventsFromBeginning(TenantId tenantId, TimePageLink pageLink, CloudEventFinder finder) {
        long seqIdEnd = Integer.toUnsignedLong(this.cloudEventStorageSettings.getMaxReadRecordsCount());
        seqIdEnd = Math.max(seqIdEnd, 50L);
        return finder.find(tenantId, Long.valueOf(0L), Long.valueOf(seqIdEnd), pageLink);
    }

    protected ListenableFuture<Long> getLongAttrByKey(TenantId tenantId, String attrKey) {
        ListenableFuture future = this.attributesService.find(tenantId, (EntityId)tenantId, AttributeScope.SERVER_SCOPE, attrKey);
        return Futures.transform((ListenableFuture)future, attributeKvEntryOpt -> {
            if (attributeKvEntryOpt != null && attributeKvEntryOpt.isPresent()) {
                AttributeKvEntry attributeKvEntry = (AttributeKvEntry)attributeKvEntryOpt.get();
                return attributeKvEntry.getLongValue().isPresent() ? (Long)attributeKvEntry.getLongValue().get() : 0L;
            }
            return 0L;
        }, (Executor)this.dbCallbackExecutorService);
    }

    private boolean validateRoutingKeyAndSecret() {
        if (StringUtils.isBlank((CharSequence)this.routingKey) || StringUtils.isBlank((CharSequence)this.routingSecret)) {
            this.shutdownExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"cloud-manager-shutdown"));
            this.shutdownExecutor.scheduleAtFixedRate(() -> log.error("Routing Key and Routing Secret must be provided! Please configure Routing Key and Routing Secret in the tb-edge.yml file or add CLOUD_ROUTING_KEY and CLOUD_ROUTING_SECRET variable to the tb-edge.conf file. ThingsBoard Edge is not going to connect to cloud!"), 0L, 10L, TimeUnit.SECONDS);
            return false;
        }
        return true;
    }

    private void onUplinkResponse(UplinkResponseMsg msg) {
        try {
            if (this.sendingInProgress) {
                if (msg.getSuccess()) {
                    this.statsCounterService.recordEvent(CloudStatsKey.UPLINK_MSGS_PUSHED, this.tenantId, 1L);
                    this.pendingMsgMap.remove(msg.getUplinkMsgId());
                    log.debug("uplink msg has been processed successfully! {}", (Object)msg);
                } else {
                    this.statsCounterService.recordEvent(CloudStatsKey.UPLINK_MSGS_TMP_FAILED, this.tenantId, 1L);
                    if (msg.getErrorMsg().contains("Rate limit reached")) {
                        log.warn("uplink msg processing failed! {}", (Object)"Rate limit reached");
                        this.isRateLimitViolated = true;
                    } else {
                        log.error("uplink msg processing failed! Error msg: {}", (Object)msg.getErrorMsg());
                    }
                }
                this.latch.countDown();
            }
        }
        catch (Exception e) {
            log.error("Can't process uplink msg response [{}]", (Object)msg, (Object)e);
        }
    }

    private void onEdgeUpdate(EdgeConfiguration edgeConfiguration) {
        try {
            this.interruptPreviousSendUplinkMsgsTask();
            if (this.reconnectFuture != null) {
                this.reconnectFuture.cancel(true);
                this.reconnectFuture = null;
            }
            if ("PE".equals(edgeConfiguration.getCloudType())) {
                String cloudEndpoint;
                EdgeId edgeId = new EdgeId(new UUID(edgeConfiguration.getEdgeIdMSB(), edgeConfiguration.getEdgeIdLSB()));
                TenantId tenantId = new TenantId(new UUID(edgeConfiguration.getTenantIdMSB(), edgeConfiguration.getTenantIdLSB()));
                String string = cloudEndpoint = "host.docker.internal".equals(this.rpcHost) ? edgeConfiguration.getCloudEndpoint().replace("localhost", "host.docker.internal") : edgeConfiguration.getCloudEndpoint();
                if (this.subscriptionService.init(tenantId, edgeId, edgeConfiguration.getEdgeLicenseKey(), cloudEndpoint)) {
                    log.debug("Subscription service was initialized successfully!");
                    this.initAndUpdateEdgeSettings(edgeConfiguration);
                } else {
                    log.debug("Failed to initialize subscription service!");
                }
            } else {
                new Thread(() -> {
                    int exitCode;
                    log.error("Terminating application. PE edge can be connected only to PE server version...");
                    int appExitCode = exitCode = -1;
                    try {
                        appExitCode = SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> exitCode});
                    }
                    finally {
                        System.exit(appExitCode);
                    }
                }, "Shutdown Thread").start();
            }
        }
        catch (Exception e) {
            log.error("Can't process edge configuration message [{}]", (Object)edgeConfiguration, (Object)e);
        }
        this.initInProgress = false;
    }

    private void initAndUpdateEdgeSettings(EdgeConfiguration edgeConfiguration) throws Exception {
        if (!this.isSystemTenantPartitionMine()) {
            return;
        }
        this.tenantId = TenantId.fromUUID((UUID)new UUID(edgeConfiguration.getTenantIdMSB(), edgeConfiguration.getTenantIdLSB()));
        this.currentEdgeSettings = this.edgeSettingsService.findEdgeSettings();
        EdgeSettings newEdgeSettings = this.constructEdgeSettings(edgeConfiguration);
        if (this.currentEdgeSettings != null && !newEdgeSettings.getEdgeId().equals(this.currentEdgeSettings.getEdgeId())) {
            this.cloudCtx.getTenantProcessor().cleanUp();
            this.resetQueueOffset();
            this.currentEdgeSettings = null;
        }
        if (this.currentEdgeSettings == null) {
            this.currentEdgeSettings = newEdgeSettings;
        } else {
            log.trace("Using edge settings from DB {}", (Object)this.currentEdgeSettings);
            this.currentEdgeSettings.setName(newEdgeSettings.getName());
            this.currentEdgeSettings.setType(newEdgeSettings.getType());
            this.currentEdgeSettings.setRoutingKey(newEdgeSettings.getRoutingKey());
            this.currentEdgeSettings.setMaxAssets(newEdgeSettings.getMaxAssets());
            this.currentEdgeSettings.setMaxDevices(newEdgeSettings.getMaxDevices());
        }
        this.cloudCtx.getTenantProcessor().createTenantIfNotExists(this.tenantId);
        boolean edgeCustomerIdUpdated = this.setOrUpdateCustomerId(edgeConfiguration);
        if (edgeCustomerIdUpdated) {
            this.cloudCtx.getCustomerProcessor().createCustomerIfNotExists(this.tenantId, edgeConfiguration);
        }
        if (this.shouldPerformInitialSync) {
            log.trace("Sending sync request, fullSyncRequired {}", (Object)this.currentEdgeSettings.isFullSyncRequired());
            this.edgeRpcClient.sendSyncRequestMsg(this.currentEdgeSettings.isFullSyncRequired());
            this.syncInProgress = true;
            this.shouldPerformInitialSync = false;
        }
        this.edgeSettingsService.saveEdgeSettings(this.tenantId, this.currentEdgeSettings);
        this.saveOrUpdateEdge(this.tenantId, edgeConfiguration);
        this.updateConnectivityStatus(true);
        if (!(this.cloudEventMigrationService == null || this.cloudEventMigrationService.isMigrated() && this.cloudEventMigrationService.isTsMigrated())) {
            this.cloudEventMigrationService.migrateUnprocessedEventToKafka();
        }
        this.initialized = true;
        this.offlineInitialized = true;
    }

    private boolean setOrUpdateCustomerId(EdgeConfiguration edgeConfiguration) {
        EdgeId edgeId = this.getEdgeId(edgeConfiguration);
        Edge edge = this.edgeService.findEdgeById(this.tenantId, edgeId);
        CustomerId previousCustomerId = null;
        if (edge != null) {
            previousCustomerId = edge.getCustomerId();
        }
        if (edgeConfiguration.getCustomerIdMSB() != 0L && edgeConfiguration.getCustomerIdLSB() != 0L) {
            UUID customerUUID = new UUID(edgeConfiguration.getCustomerIdMSB(), edgeConfiguration.getCustomerIdLSB());
            this.customerId = new CustomerId(customerUUID);
            return !this.customerId.equals((Object)previousCustomerId);
        }
        this.customerId = null;
        return false;
    }

    private EdgeId getEdgeId(EdgeConfiguration edgeConfiguration) {
        UUID edgeUUID = new UUID(edgeConfiguration.getEdgeIdMSB(), edgeConfiguration.getEdgeIdLSB());
        return new EdgeId(edgeUUID);
    }

    private void saveOrUpdateEdge(TenantId tenantId, EdgeConfiguration edgeConfiguration) throws Exception {
        EdgeId edgeId = this.getEdgeId(edgeConfiguration);
        this.cloudCtx.getEdgeProcessor().processEdgeConfigurationMsgFromCloud(tenantId, edgeConfiguration);
        this.cloudCtx.getCloudEventService().saveCloudEvent(tenantId, CloudEventType.EDGE, EdgeEventActionType.ATTRIBUTES_REQUEST, (EntityId)edgeId, null, null);
        this.cloudCtx.getCloudEventService().saveCloudEvent(tenantId, CloudEventType.EDGE, EdgeEventActionType.RELATION_REQUEST, (EntityId)edgeId, null, null);
    }

    private EdgeSettings constructEdgeSettings(EdgeConfiguration edgeConfiguration) {
        EdgeSettings edgeSettings = new EdgeSettings();
        UUID edgeUUID = new UUID(edgeConfiguration.getEdgeIdMSB(), edgeConfiguration.getEdgeIdLSB());
        edgeSettings.setEdgeId(edgeUUID.toString());
        UUID tenantUUID = new UUID(edgeConfiguration.getTenantIdMSB(), edgeConfiguration.getTenantIdLSB());
        edgeSettings.setTenantId(tenantUUID.toString());
        edgeSettings.setName(edgeConfiguration.getName());
        edgeSettings.setType(edgeConfiguration.getType());
        edgeSettings.setRoutingKey(edgeConfiguration.getRoutingKey());
        edgeSettings.setFullSyncRequired(true);
        edgeSettings.setMaxDevices(this.subscriptionService.maxDevices());
        edgeSettings.setMaxAssets(this.subscriptionService.maxAssets());
        return edgeSettings;
    }

    private void onDownlink(DownlinkMsg downlinkMsg) {
        boolean edgeCustomerIdUpdated = this.updateCustomerIdIfRequired(downlinkMsg);
        if (this.syncInProgress && downlinkMsg.hasSyncCompletedMsg()) {
            log.trace("[{}] downlinkMsg hasSyncCompletedMsg = true", (Object)downlinkMsg);
            this.syncInProgress = false;
        }
        ListenableFuture future = this.downlinkMessageService.processDownlinkMsg(this.tenantId, this.customerId, downlinkMsg, this.currentEdgeSettings);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)MoreExecutors.directExecutor());
    }

    private boolean updateCustomerIdIfRequired(DownlinkMsg downlinkMsg) {
        if (downlinkMsg.hasEdgeConfiguration()) {
            return this.setOrUpdateCustomerId(downlinkMsg.getEdgeConfiguration());
        }
        return false;
    }

    private void updateConnectivityStatus(boolean activityState) {
        if (this.tenantId != null) {
            this.save("active", activityState);
            if (activityState) {
                this.save("lastConnectTime", System.currentTimeMillis());
            } else {
                this.save("lastDisconnectTime", System.currentTimeMillis());
            }
        }
    }

    private void scheduleReconnect(Exception e) {
        this.initialized = false;
        this.updateConnectivityStatus(false);
        if (this.reconnectFuture == null) {
            this.reconnectFuture = this.reconnectExecutor.scheduleAtFixedRate(() -> {
                log.info("Trying to reconnect due to the error: {}!", (Object)e.getMessage());
                try {
                    this.edgeRpcClient.disconnect(true);
                    this.tryInitOfflineMode();
                }
                catch (Exception ex) {
                    log.error("Exception during disconnect: {}", (Object)ex.getMessage());
                }
                try {
                    this.edgeRpcClient.connect(this.routingKey, this.routingSecret, arg_0 -> this.onUplinkResponse(arg_0), arg_0 -> this.onEdgeUpdate(arg_0), arg_0 -> this.onDownlink(arg_0), arg_0 -> this.scheduleReconnect(arg_0));
                }
                catch (Exception ex) {
                    log.error("Exception during connect: {}", (Object)ex.getMessage());
                }
            }, this.reconnectTimeoutMs, this.reconnectTimeoutMs, TimeUnit.MILLISECONDS);
        }
    }

    private void tryInitOfflineMode() {
        EdgeSettings edgeSettings;
        if (!this.offlineInitialized && (edgeSettings = this.edgeSettingsService.findEdgeSettings()) != null) {
            this.subscriptionService.init(TenantId.fromUUID((UUID)UUID.fromString(edgeSettings.getTenantId())), new EdgeId(UUID.fromString(edgeSettings.getEdgeId())), "OFFLINE_KEY", "OFFLINE_CLOUD_ENDPOINT");
            this.offlineInitialized = true;
        }
    }

    private void save(String key, long value) {
        this.tsSubService.saveAttributes(AttributesSaveRequest.builder().tenantId(TenantId.SYS_TENANT_ID).entityId((EntityId)this.tenantId).scope(AttributeScope.SERVER_SCOPE).entry((KvEntry)new LongDataEntry(key, Long.valueOf(value))).notifyDevice(true).callback((FutureCallback)new AttributeSaveCallback(key, (Object)value)).build());
    }

    private void save(String key, boolean value) {
        this.tsSubService.saveAttributes(AttributesSaveRequest.builder().tenantId(TenantId.SYS_TENANT_ID).entityId((EntityId)this.tenantId).scope(AttributeScope.SERVER_SCOPE).entry((KvEntry)new BooleanDataEntry(key, Boolean.valueOf(value))).notifyDevice(true).callback((FutureCallback)new AttributeSaveCallback(key, (Object)value)).build());
    }

    private UplinkMsg convertEventToUplink(CloudEvent cloudEvent) {
        log.trace("Converting cloud event [{}]", (Object)cloudEvent);
        try {
            return switch (2.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[cloudEvent.getAction().ordinal()]) {
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14 -> this.convertEntityEventToUplink(cloudEvent);
                case 15, 16, 17, 18 -> this.cloudCtx.getTelemetryProcessor().convertTelemetryEventToUplink(cloudEvent.getTenantId(), cloudEvent);
                case 19 -> this.cloudCtx.getTelemetryProcessor().convertAttributesRequestEventToUplink(cloudEvent);
                case 20 -> this.cloudCtx.getCalculatedFieldProcessor().convertCalculatedFieldRequestEventToUplink(cloudEvent);
                case 21 -> this.entityGroupProcessor.processGroupEntitiesRequestMsgToCloud(cloudEvent);
                case 22 -> this.groupPermissionProcessor.processEntityGroupPermissionsRequestMsgToCloud(cloudEvent);
                case 23 -> this.cloudCtx.getRelationProcessor().convertRelationRequestEventToUplink(cloudEvent);
                case 24 -> this.cloudCtx.getDeviceProcessor().convertRpcCallEventToUplink(cloudEvent);
                default -> {
                    log.warn("Unsupported action type [{}]", (Object)cloudEvent);
                    yield null;
                }
            };
        }
        catch (Exception e) {
            log.error("Exception during converting events from queue, skipping event [{}]", (Object)cloudEvent, (Object)e);
            return null;
        }
    }

    private UplinkMsg convertEntityEventToUplink(CloudEvent cloudEvent) {
        log.trace("Executing convertEntityEventToUplink cloudEvent [{}], edgeEventAction [{}]", (Object)cloudEvent, (Object)cloudEvent.getAction());
        return this.cloudCtx.getProcessor(cloudEvent.getType()).convertCloudEventToUplink(cloudEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ListenableFuture<Boolean> processCloudEvents(List<CloudEvent> cloudEvents, boolean isGeneralMsg) {
        this.uplinkSendLock.lock();
        try {
            if (!isGeneralMsg && this.isGeneralProcessInProgress) {
                ListenableFuture listenableFuture = Futures.immediateFuture((Object)true);
                return listenableFuture;
            }
            this.interruptPreviousSendUplinkMsgsTask();
            this.sendUplinkFutureResult = SettableFuture.create();
            cloudEvents = EdgeMsgConstructorUtils.mergeUplinkDuplicates(cloudEvents);
            log.trace("[{}] event(s) are going to be converted.", (Object)cloudEvents.size());
            List<UplinkMsg> uplinkMsgPack = cloudEvents.stream().map(arg_0 -> this.convertEventToUplink(arg_0)).filter(Objects::nonNull).toList();
            if (uplinkMsgPack.isEmpty()) {
                ListenableFuture listenableFuture = Futures.immediateFuture((Object)false);
                return listenableFuture;
            }
            this.processMsgPack(uplinkMsgPack, isGeneralMsg);
        }
        finally {
            this.uplinkSendLock.unlock();
        }
        return this.sendUplinkFutureResult;
    }

    private void interruptPreviousSendUplinkMsgsTask() {
        if (this.sendUplinkFutureResult != null) {
            try {
                this.sendUplinkFutureResult.get(10L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.sendUplinkFutureResult.isDone()) {
                log.debug("[{}] Stopping send uplink future now!", (Object)this.tenantId);
                this.sendUplinkFutureResult.set((Object)true);
            }
        }
        if (this.sendUplinkFuture != null && !this.sendUplinkFuture.isCancelled()) {
            this.sendUplinkFuture.cancel(true);
            this.sendUplinkFuture = null;
        }
    }

    private void processMsgPack(List<UplinkMsg> uplinkMsgPack, boolean isGeneralMsg) {
        this.pendingMsgMap.clear();
        uplinkMsgPack.forEach(msg -> this.pendingMsgMap.put(msg.getUplinkMsgId(), msg));
        this.sendUplinkFuture = this.uplinkExecutor.schedule(() -> {
            try {
                boolean success;
                int attempt = 1;
                do {
                    log.trace("[{}] uplink msg(s) are going to be send.", (Object)this.pendingMsgMap.values().size());
                    long startTime = System.currentTimeMillis();
                    boolean bl = success = this.sendUplinkMsgPack(new LinkedBlockingQueue(this.pendingMsgMap.values())) && this.pendingMsgMap.isEmpty();
                    if (!success) {
                        String batchPrefix = isGeneralMsg ? "General" : "Timeseries";
                        log.warn("Failed to deliver {} batch (size: {}) on attempt {}", new Object[]{batchPrefix, this.pendingMsgMap.values().size(), attempt});
                        log.trace("Entities in failed batch: {}", this.pendingMsgMap.values());
                        try {
                            Thread.sleep(this.cloudEventStorageSettings.getSleepIntervalBetweenBatches());
                            if (this.isRateLimitViolated) {
                                this.isRateLimitViolated = false;
                                TimeUnit.SECONDS.sleep(60L);
                            }
                        }
                        catch (InterruptedException e) {
                            log.error("Error during sleep between batches or on rate limit violation", (Throwable)e);
                        }
                    } else {
                        log.info("Sending of [{}] uplink msg(s) took {} ms.", (Object)uplinkMsgPack.size(), (Object)(System.currentTimeMillis() - startTime));
                    }
                    if (!isGeneralMsg || ++attempt <= 3) continue;
                    log.warn("Failed to deliver the batch: after {} attempts. Next messages are going to be discarded {}", (Object)3, this.pendingMsgMap.values());
                    this.statsCounterService.recordEvent(CloudStatsKey.UPLINK_MSGS_PERMANENTLY_FAILED, this.tenantId, (long)this.pendingMsgMap.size());
                    this.sendUplinkFutureResult.set((Object)false);
                    return;
                } while (!success);
                this.sendUplinkFutureResult.set((Object)false);
            }
            catch (Exception e) {
                this.sendUplinkFutureResult.set((Object)true);
                log.error("Error during send uplink msg", (Throwable)e);
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendUplinkMsgPack(LinkedBlockingQueue<UplinkMsg> orderedPendingMsgQueue) {
        this.sendingInProgress = true;
        try {
            this.latch = new CountDownLatch(this.pendingMsgMap.values().size());
            orderedPendingMsgQueue.forEach(arg_0 -> this.sendUplinkMsg(arg_0));
            boolean bl = this.latch.await(this.uplinkPackTimeoutSec, TimeUnit.SECONDS);
            return bl;
        }
        catch (Exception e) {
            log.error("Interrupted while waiting for latch, isGeneralProcessInProgress={}", (Object)this.isGeneralProcessInProgress, (Object)e);
            for (UplinkMsg value : this.pendingMsgMap.values()) {
                log.warn("Message not send due to exception: {}", (Object)value);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.sendingInProgress = false;
        }
    }

    private void sendUplinkMsg(UplinkMsg uplinkMsg) {
        if (this.edgeRpcClient.getServerMaxInboundMessageSize() == 0 || uplinkMsg.getSerializedSize() <= this.edgeRpcClient.getServerMaxInboundMessageSize()) {
            this.edgeRpcClient.sendUplinkMsg(uplinkMsg);
        } else {
            log.error("Uplink msg size [{}] exceeds server max inbound message size [{}]. Skipping this message. Please increase value of EDGES_RPC_MAX_INBOUND_MESSAGE_SIZE env variable on the server and restart it. Message {}", new Object[]{uplinkMsg.getSerializedSize(), this.edgeRpcClient.getServerMaxInboundMessageSize(), uplinkMsg});
            this.statsCounterService.recordEvent(CloudStatsKey.UPLINK_MSGS_PERMANENTLY_FAILED, this.tenantId, 1L);
            this.pendingMsgMap.remove(uplinkMsg.getUplinkMsgId());
            this.latch.countDown();
        }
    }

    private boolean isSystemTenantPartitionMine() {
        return this.partitionService.resolve(ServiceType.TB_CORE, TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID).isMyPartition();
    }
}

