/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.script.api.tbel.TbelCfArg;
import org.thingsboard.script.api.tbel.TbelCfTsDoubleVal;
import org.thingsboard.script.api.tbel.TbelCfTsRollingArg;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntryType;
import org.thingsboard.server.service.cf.ctx.state.SingleValueArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.TsRollingArgumentEntry;

/*
 * Exception performing whole class analysis ignored.
 */
public class TsRollingArgumentEntry
implements ArgumentEntry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TsRollingArgumentEntry.class);
    private Integer limit;
    private Long timeWindow;
    private TreeMap<Long, Double> tsRecords = new TreeMap();
    private boolean forceResetPrevious;

    public TsRollingArgumentEntry(List<TsKvEntry> kvEntries, int limit, long timeWindow) {
        this.limit = limit;
        this.timeWindow = timeWindow;
        kvEntries.forEach(tsKvEntry -> this.addTsRecord(Long.valueOf(tsKvEntry.getTs()), (KvEntry)tsKvEntry));
    }

    public TsRollingArgumentEntry(TreeMap<Long, Double> tsRecords, int limit, long timeWindow) {
        this.tsRecords = tsRecords;
        this.limit = limit;
        this.timeWindow = timeWindow;
    }

    public TsRollingArgumentEntry(int limit, long timeWindow) {
        this.tsRecords = new TreeMap();
        this.limit = limit;
        this.timeWindow = timeWindow;
    }

    public TsRollingArgumentEntry(Integer limit, Long timeWindow, TreeMap<Long, Double> tsRecords) {
        this.limit = limit;
        this.timeWindow = timeWindow;
        this.tsRecords = tsRecords;
    }

    public ArgumentEntryType getType() {
        return ArgumentEntryType.TS_ROLLING;
    }

    public boolean isEmpty() {
        return this.tsRecords.isEmpty();
    }

    @JsonIgnore
    public Object getValue() {
        return this.tsRecords;
    }

    public long getLatestTs() {
        Map.Entry lastEntry = this.tsRecords.lastEntry();
        return lastEntry != null ? (Long)lastEntry.getKey() : -1L;
    }

    public TbelCfArg toTbelCfArg() {
        ArrayList<TbelCfTsDoubleVal> values = new ArrayList<TbelCfTsDoubleVal>(this.tsRecords.size());
        for (Map.Entry e : this.tsRecords.entrySet()) {
            values.add(new TbelCfTsDoubleVal(((Long)e.getKey()).longValue(), ((Double)e.getValue()).doubleValue()));
        }
        return new TbelCfTsRollingArg(this.timeWindow.longValue(), values);
    }

    public boolean updateEntry(ArgumentEntry entry) {
        if (entry instanceof TsRollingArgumentEntry) {
            TsRollingArgumentEntry tsRollingEntry = (TsRollingArgumentEntry)entry;
            this.updateTsRollingEntry(tsRollingEntry);
        } else if (entry instanceof SingleValueArgumentEntry) {
            SingleValueArgumentEntry singleValueEntry = (SingleValueArgumentEntry)entry;
            this.updateSingleValueEntry(singleValueEntry);
        } else {
            throw new IllegalArgumentException("Unsupported argument entry type for rolling argument entry: " + String.valueOf(entry.getType()));
        }
        return true;
    }

    private void updateTsRollingEntry(TsRollingArgumentEntry tsRollingEntry) {
        for (Map.Entry tsRecordEntry : tsRollingEntry.getTsRecords().entrySet()) {
            this.addTsRecord((Long)tsRecordEntry.getKey(), ((Double)tsRecordEntry.getValue()).doubleValue());
        }
    }

    private void updateSingleValueEntry(SingleValueArgumentEntry singleValueEntry) {
        this.addTsRecord(Long.valueOf(singleValueEntry.getTs()), (KvEntry)singleValueEntry.getKvEntryValue());
    }

    private void addTsRecord(Long ts, KvEntry value) {
        Double recordValue = TsRollingArgumentEntry.getValueForTsRecord((KvEntry)value);
        if (recordValue != null) {
            this.tsRecords.put(ts, recordValue);
        }
        this.cleanupExpiredRecords();
    }

    private void addTsRecord(Long ts, double value) {
        this.tsRecords.put(ts, value);
        this.cleanupExpiredRecords();
    }

    private void cleanupExpiredRecords() {
        if (this.tsRecords.size() > this.limit) {
            this.tsRecords.pollFirstEntry();
        }
        long timeWindowEndTs = Optional.ofNullable(this.tsRecords.lastEntry()).map(Map.Entry::getKey).orElse(System.currentTimeMillis());
        this.tsRecords.entrySet().removeIf(tsRecord -> (Long)tsRecord.getKey() < timeWindowEndTs - this.timeWindow);
    }

    public static Double getValueForTsRecord(KvEntry value) {
        try {
            return switch (1.$SwitchMap$org$thingsboard$server$common$data$kv$DataType[value.getDataType().ordinal()]) {
                default -> throw new IncompatibleClassChangeError();
                case 1 -> value.getLongValue().map(Long::doubleValue).orElse(null);
                case 2 -> value.getDoubleValue().orElse(null);
                case 3 -> value.getBooleanValue().map(b -> b != false ? 1.0 : 0.0).orElse(null);
                case 4 -> value.getStrValue().map(Double::parseDouble).orElse(null);
                case 5 -> value.getJsonValue().map(Double::parseDouble).orElse(null);
            };
        }
        catch (Exception e) {
            log.debug("Invalid value '{}' for time series rolling arguments. Only numeric values are supported.", value.getValue());
            return Double.NaN;
        }
    }

    @Generated
    public Integer getLimit() {
        return this.limit;
    }

    @Generated
    public Long getTimeWindow() {
        return this.timeWindow;
    }

    @Generated
    public TreeMap<Long, Double> getTsRecords() {
        return this.tsRecords;
    }

    @Generated
    public boolean isForceResetPrevious() {
        return this.forceResetPrevious;
    }

    @Generated
    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @Generated
    public void setTimeWindow(Long timeWindow) {
        this.timeWindow = timeWindow;
    }

    @Generated
    public void setTsRecords(TreeMap<Long, Double> tsRecords) {
        this.tsRecords = tsRecords;
    }

    @Generated
    public void setForceResetPrevious(boolean forceResetPrevious) {
        this.forceResetPrevious = forceResetPrevious;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TsRollingArgumentEntry)) {
            return false;
        }
        TsRollingArgumentEntry other = (TsRollingArgumentEntry)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isForceResetPrevious() != other.isForceResetPrevious()) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Long this$timeWindow = this.getTimeWindow();
        Long other$timeWindow = other.getTimeWindow();
        if (this$timeWindow == null ? other$timeWindow != null : !((Object)this$timeWindow).equals(other$timeWindow)) {
            return false;
        }
        TreeMap this$tsRecords = this.getTsRecords();
        TreeMap other$tsRecords = other.getTsRecords();
        return !(this$tsRecords == null ? other$tsRecords != null : !((Object)this$tsRecords).equals(other$tsRecords));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TsRollingArgumentEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isForceResetPrevious() ? 79 : 97);
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Long $timeWindow = this.getTimeWindow();
        result = result * 59 + ($timeWindow == null ? 43 : ((Object)$timeWindow).hashCode());
        TreeMap $tsRecords = this.getTsRecords();
        result = result * 59 + ($tsRecords == null ? 43 : ((Object)$tsRecords).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TsRollingArgumentEntry(limit=" + this.getLimit() + ", timeWindow=" + this.getTimeWindow() + ", tsRecords=" + String.valueOf(this.getTsRecords()) + ", forceResetPrevious=" + this.isForceResetPrevious() + ")";
    }

    @Generated
    public TsRollingArgumentEntry() {
    }

    @ConstructorProperties(value={"limit", "timeWindow", "tsRecords", "forceResetPrevious"})
    @Generated
    public TsRollingArgumentEntry(Integer limit, Long timeWindow, TreeMap<Long, Double> tsRecords, boolean forceResetPrevious) {
        this.limit = limit;
        this.timeWindow = timeWindow;
        this.tsRecords = tsRecords;
        this.forceResetPrevious = forceResetPrevious;
    }
}

