/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.rule.engine.api.TimeseriesSaveRequest;
import org.thingsboard.script.api.tbel.TbelInvokeService;
import org.thingsboard.server.common.adaptor.JsonConverter;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.configuration.Argument;
import org.thingsboard.server.common.data.cf.configuration.ArgumentType;
import org.thingsboard.server.common.data.cf.configuration.CFArgumentDynamicSourceType;
import org.thingsboard.server.common.data.cf.configuration.OutputType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.job.task.CfReprocessingTask;
import org.thingsboard.server.common.data.kv.Aggregation;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseReadTsKvQuery;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.ReadTsKvQuery;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.common.data.util.TbPair;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.dao.usagerecord.ApiLimitService;
import org.thingsboard.server.queue.util.TbRuleEngineComponent;
import org.thingsboard.server.service.cf.CalculatedFieldReprocessingService;
import org.thingsboard.server.service.cf.CalculatedFieldResult;
import org.thingsboard.server.service.cf.DefaultCalculatedFieldReprocessingService;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldState;
import org.thingsboard.server.service.security.permission.OwnersCacheService;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;
import org.thingsboard.server.utils.CalculatedFieldArgumentUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@TbRuleEngineComponent
@Service
public class DefaultCalculatedFieldReprocessingService
implements CalculatedFieldReprocessingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultCalculatedFieldReprocessingService.class);
    private static final Set<EntityType> supportedReprocessingEntities = EnumSet.of(EntityType.DEVICE, EntityType.ASSET);
    @Value(value="${actors.calculated_fields.calculation_timeout:5}")
    private long cfCalculationResultTimeout;
    @Value(value="${queue.calculated_fields.telemetry_fetch_pack_size:2000}")
    private int telemetryFetchPackSize;
    private final TimeseriesService timeseriesService;
    private final AttributesService attributesService;
    private final TbelInvokeService tbelInvokeService;
    private final ApiLimitService apiLimitService;
    private final TelemetrySubscriptionService telemetrySubscriptionService;
    private final OwnersCacheService ownersCacheService;
    private ListeningExecutorService calculatedFieldCallbackExecutor;

    @PostConstruct
    public void init() {
        this.calculatedFieldCallbackExecutor = MoreExecutors.listeningDecorator((ExecutorService)ThingsBoardExecutors.newWorkStealingPool((int)Math.max(4, Runtime.getRuntime().availableProcessors()), (String)"calculated-field-reprocessing-callback"));
    }

    @PreDestroy
    public void stop() {
        if (this.calculatedFieldCallbackExecutor != null) {
            this.calculatedFieldCallbackExecutor.shutdownNow();
        }
    }

    public void reprocess(CfReprocessingTask task) throws Exception {
        CfReprocessingCtx ctx;
        TenantId tenantId = task.getTenantId();
        EntityId entityId = task.getEntityId();
        log.debug("[{}] Received reprocessing request: {}", (Object)tenantId, (Object)task);
        if (!supportedReprocessingEntities.contains(entityId.getEntityType())) {
            throw new IllegalArgumentException("EntityType '" + String.valueOf(entityId.getEntityType()) + "' is not supported for reprocessing");
        }
        CalculatedField calculatedField = task.getCalculatedField();
        if (OutputType.ATTRIBUTES.equals((Object)calculatedField.getConfiguration().getOutput().getType())) {
            throw new IllegalArgumentException("'ATTRIBUTES' output type is not supported for reprocessing");
        }
        long startTs = task.getStartTs();
        long endTs = task.getEndTs();
        CalculatedFieldCtx cfCtx = new CalculatedFieldCtx(calculatedField, this.tbelInvokeService, this.apiLimitService);
        cfCtx.setUseLatestTs(false);
        CalculatedFieldState state = this.initState(tenantId, entityId, cfCtx, startTs);
        cfCtx.init();
        try (CfReprocessingCtx cfReprocessingCtx = ctx = CfReprocessingCtx.builder().tenantId(tenantId).entityId(entityId).cfCtx(cfCtx).state(state).build();){
            ctx.checkStateSize();
            this.processStateIfReady(ctx, startTs).get();
            for (Map.Entry e : ctx.getCfCtx().getArguments().entrySet()) {
                LinkedList batch;
                String argName = (String)e.getKey();
                Argument arg = (Argument)e.getValue();
                if (ArgumentType.ATTRIBUTE.equals((Object)arg.getRefEntityKey().getType()) || (batch = new LinkedList(this.fetchTelemetryBatch(tenantId, entityId, arg, startTs, endTs, this.telemetryFetchPackSize))).isEmpty()) continue;
                ctx.getTelemetryBuffers().put(argName, batch);
                ctx.getCursors().put(argName, ((TsKvEntry)batch.getLast()).getTs());
            }
            while (true) {
                Future result;
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                OptionalLong minTs = ctx.getTelemetryBuffers().values().stream().filter(buffer -> !buffer.isEmpty()).mapToLong(buffer -> ((TsKvEntry)buffer.get(0)).getTs()).min();
                if (minTs.isEmpty()) {
                    TbPair latestResult = ctx.getLatestResult();
                    if (latestResult == null) break;
                    result = this.saveResult(ctx, (CalculatedFieldResult)latestResult.getSecond(), ((Long)latestResult.getFirst()).longValue(), TimeseriesSaveRequest.Strategy.LATEST_AND_WS);
                    ctx.addResult(result, this.telemetryFetchPackSize);
                    break;
                }
                Map updatedArgs = this.getUpdatedArgs(ctx, minTs.getAsLong(), startTs, endTs);
                result = this.processArgumentValuesUpdate(ctx, updatedArgs, minTs.getAsLong());
                ctx.addResult(result, this.telemetryFetchPackSize);
            }
            ctx.awaitResults();
        }
    }

    private Map<String, ArgumentEntry> getUpdatedArgs(CfReprocessingCtx ctx, long minTs, long startTs, long endTs) throws InterruptedException {
        HashMap<String, ArgumentEntry> updatedArgs = new HashMap<String, ArgumentEntry>();
        for (Map.Entry entry : ctx.getTelemetryBuffers().entrySet()) {
            String argName = (String)entry.getKey();
            LinkedList buffer = (LinkedList)entry.getValue();
            if (buffer.isEmpty() || ((TsKvEntry)buffer.getFirst()).getTs() != minTs) continue;
            TsKvEntry tsEntry = (TsKvEntry)buffer.removeFirst();
            updatedArgs.put(argName, ArgumentEntry.createSingleValueArgument((KvEntry)tsEntry));
            if (!buffer.isEmpty()) continue;
            Argument arg = (Argument)ctx.getCfCtx().getArguments().get(argName);
            Long cursorTs = ctx.getCursors().getOrDefault(argName, startTs);
            LinkedList nextBatch = this.fetchTelemetryBatch(ctx.getTenantId(), ctx.getEntityId(), arg, cursorTs.longValue(), endTs, this.telemetryFetchPackSize).stream().filter(tsKvEntry -> tsKvEntry.getTs() > cursorTs).collect(Collectors.toCollection(LinkedList::new));
            if (nextBatch.isEmpty()) continue;
            ctx.getTelemetryBuffers().put(argName, nextBatch);
            ctx.getCursors().put(argName, ((TsKvEntry)nextBatch.getLast()).getTs());
        }
        return updatedArgs;
    }

    private Future<Void> processStateIfReady(CfReprocessingCtx ctx, long ts) throws Exception {
        CalculatedFieldState state = ctx.getState();
        if (ctx.getCfCtx().isInitialized() && state.isReady()) {
            log.trace("[{}][{}] Performing calculation for CF {}", new Object[]{ctx.getTenantId(), ctx.getEntityId(), ctx.getCfId()});
            CalculatedFieldResult calculationResult = (CalculatedFieldResult)state.performCalculation(ctx.getCfCtx()).get(this.cfCalculationResultTimeout, TimeUnit.SECONDS);
            ctx.checkStateSize();
            if (!calculationResult.isEmpty()) {
                ctx.setLatestResult(new TbPair((Object)ts, (Object)calculationResult));
                return this.saveResult(ctx, calculationResult, ts, TimeseriesSaveRequest.Strategy.TIME_SERIES_ONLY);
            }
        } else {
            ctx.checkStateSize();
        }
        return Futures.immediateVoidFuture();
    }

    private Future<Void> processArgumentValuesUpdate(CfReprocessingCtx ctx, Map<String, ArgumentEntry> newArgValues, long ts) throws Exception {
        if (newArgValues.isEmpty()) {
            log.info("[{}] No argument values to process for CF.", (Object)ctx.getCfId());
        }
        if (ctx.getState().updateState(ctx.getCfCtx(), newArgValues)) {
            return this.processStateIfReady(ctx, ts);
        }
        return Futures.immediateVoidFuture();
    }

    private CalculatedFieldState initState(TenantId tenantId, EntityId entityId, CalculatedFieldCtx ctx, long startTs) throws InterruptedException {
        CalculatedFieldState state;
        ListenableFuture stateFuture = this.fetchStateFromDb(ctx, entityId, startTs);
        try {
            state = (CalculatedFieldState)stateFuture.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw new RuntimeException(cause.getMessage(), cause);
        }
        log.debug("[{}][{}] Initialized state for CF {}", new Object[]{tenantId, entityId, ctx.getCfId()});
        return state;
    }

    private ListenableFuture<CalculatedFieldState> fetchStateFromDb(CalculatedFieldCtx ctx, EntityId entityId, long startTs) {
        HashMap<String, ListenableFuture> argFutures = new HashMap<String, ListenableFuture>();
        for (Map.Entry entry : ctx.getArguments().entrySet()) {
            EntityId argEntityId = this.resolveEntityId(ctx.getTenantId(), entityId, (Argument)entry.getValue());
            ListenableFuture argValueFuture = this.fetchArgumentValue(ctx.getTenantId(), argEntityId, (Argument)entry.getValue(), startTs);
            argFutures.put((String)entry.getKey(), argValueFuture);
        }
        return Futures.whenAllComplete(argFutures.values()).call(() -> {
            CalculatedFieldState result = CalculatedFieldArgumentUtils.createStateByType((CalculatedFieldCtx)ctx);
            result.updateState(ctx, argFutures.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                try {
                    return (ArgumentEntry)((ListenableFuture)entry.getValue()).get();
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    throw new RuntimeException("Failed to fetch " + (String)entry.getKey() + ": " + cause.getMessage(), cause);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Failed to fetch" + (String)entry.getKey(), e);
                }
            })));
            return result;
        }, (Executor)this.calculatedFieldCallbackExecutor);
    }

    private ListenableFuture<ArgumentEntry> fetchArgumentValue(TenantId tenantId, EntityId entityId, Argument argument, long startTs) {
        return switch (2.$SwitchMap$org$thingsboard$server$common$data$cf$configuration$ArgumentType[argument.getRefEntityKey().getType().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.fetchTsRolling(tenantId, entityId, argument, startTs);
            case 2 -> this.fetchAttribute(tenantId, entityId, argument, startTs);
            case 3 -> this.fetchTsLatest(tenantId, entityId, argument, startTs);
        };
    }

    private ListenableFuture<ArgumentEntry> fetchAttribute(TenantId tenantId, EntityId entityId, Argument argument, long reprocessingStartTs) {
        log.trace("[{}][{}] Fetching attribute for key {}", new Object[]{tenantId, entityId, argument.getRefEntityKey()});
        ListenableFuture attributeOptFuture = this.attributesService.find(tenantId, entityId, argument.getRefEntityKey().getScope(), argument.getRefEntityKey().getKey());
        return Futures.transform((ListenableFuture)attributeOptFuture, attrOpt -> {
            log.debug("[{}][{}] Fetched attribute for key {}: {}", new Object[]{tenantId, entityId, argument.getRefEntityKey(), attrOpt});
            BaseAttributeKvEntry attributeKvEntry = attrOpt.isEmpty() ? CalculatedFieldArgumentUtils.createDefaultAttributeEntry((Argument)argument, (long)reprocessingStartTs) : new BaseAttributeKvEntry((KvEntry)attrOpt.get(), reprocessingStartTs, ((AttributeKvEntry)attrOpt.get()).getVersion());
            return CalculatedFieldArgumentUtils.transformSingleValueArgument((KvEntry)attributeKvEntry);
        }, (Executor)this.calculatedFieldCallbackExecutor);
    }

    private ListenableFuture<ArgumentEntry> fetchTsLatest(TenantId tenantId, EntityId entityId, Argument argument, long reprocessingStartTs) {
        BaseReadTsKvQuery query = new BaseReadTsKvQuery(argument.getRefEntityKey().getKey(), 0L, reprocessingStartTs, 0L, 1, Aggregation.NONE);
        log.trace("[{}][{}] Fetching timeseries for latest for query {}", new Object[]{tenantId, entityId, query});
        ListenableFuture tsKvListFuture = this.timeseriesService.findAll(tenantId, entityId, List.of(query));
        return Futures.transform((ListenableFuture)tsKvListFuture, arg_0 -> DefaultCalculatedFieldReprocessingService.lambda$fetchTsLatest$6(tenantId, entityId, (ReadTsKvQuery)query, argument, reprocessingStartTs, arg_0), (Executor)this.calculatedFieldCallbackExecutor);
    }

    private ListenableFuture<ArgumentEntry> fetchTsRolling(TenantId tenantId, EntityId entityId, Argument argument, long startTs) {
        long argTimeWindow = argument.getTimeWindow() == 0L ? startTs : argument.getTimeWindow();
        long startInterval = startTs - argTimeWindow;
        long maxDataPoints = this.apiLimitService.getLimit(tenantId, DefaultTenantProfileConfiguration::getMaxDataPointsPerRollingArg);
        int argumentLimit = argument.getLimit();
        int limit = argumentLimit == 0 || (long)argumentLimit > maxDataPoints ? (int)maxDataPoints : argument.getLimit();
        BaseReadTsKvQuery query = new BaseReadTsKvQuery(argument.getRefEntityKey().getKey(), startInterval, startTs, 0L, limit, Aggregation.NONE);
        log.trace("[{}][{}] Fetching timeseries for query {}", new Object[]{tenantId, entityId, query});
        ListenableFuture tsRollingFuture = this.timeseriesService.findAll(tenantId, entityId, List.of(query));
        return Futures.transform((ListenableFuture)tsRollingFuture, arg_0 -> DefaultCalculatedFieldReprocessingService.lambda$fetchTsRolling$7(tenantId, entityId, (ReadTsKvQuery)query, limit, argTimeWindow, arg_0), (Executor)this.calculatedFieldCallbackExecutor);
    }

    private List<TsKvEntry> fetchTelemetryBatch(TenantId tenantId, EntityId entityId, Argument argument, long startTs, long endTs, int limit) throws InterruptedException {
        List result;
        EntityId sourceEntityId = this.resolveEntityId(tenantId, entityId, argument);
        BaseReadTsKvQuery query = new BaseReadTsKvQuery(argument.getRefEntityKey().getKey(), startTs, endTs, 0L, limit, Aggregation.NONE, "ASC");
        log.trace("[{}][{}] Fetching telemetry batch for query {}", new Object[]{tenantId, entityId, query});
        try {
            result = (List)this.timeseriesService.findAll(tenantId, sourceEntityId, List.of(query)).get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to fetch telemetry for " + String.valueOf(sourceEntityId) + " for key " + argument.getRefEntityKey().getKey() + ": " + e.getCause().getMessage(), e.getCause());
        }
        log.debug("[{}][{}] Fetched {} timeseries for query {}", new Object[]{tenantId, entityId, result.size(), query});
        return result;
    }

    private EntityId resolveEntityId(TenantId tenantId, EntityId entityId, Argument argument) {
        if (argument.getRefEntityId() != null) {
            return argument.getRefEntityId();
        }
        CFArgumentDynamicSourceType refDynamicSource = argument.getRefDynamicSource();
        if (refDynamicSource == null) {
            return entityId;
        }
        switch (2.$SwitchMap$org$thingsboard$server$common$data$cf$configuration$CFArgumentDynamicSourceType[refDynamicSource.ordinal()]) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 1: 
        }
        return this.ownersCacheService.getOwner(tenantId, entityId);
    }

    private Future<Void> saveResult(CfReprocessingCtx ctx, CalculatedFieldResult calculatedFieldResult, long ts, TimeseriesSaveRequest.Strategy strategy) throws InterruptedException {
        JsonElement result = JsonParser.parseString((String)Objects.requireNonNull(JacksonUtil.toString((Object)calculatedFieldResult.getResult())));
        log.trace("[{}][{}] Saving CF result: {}", new Object[]{ctx.getTenantId(), ctx.getEntityId(), result});
        SettableFuture future = SettableFuture.create();
        Map tsKvMap = JsonConverter.convertToTelemetry((JsonElement)result, (long)ts);
        ArrayList<BasicTsKvEntry> tsKvEntryList = new ArrayList<BasicTsKvEntry>();
        for (Map.Entry tsKvEntry : tsKvMap.entrySet()) {
            for (KvEntry kvEntry : (List)tsKvEntry.getValue()) {
                tsKvEntryList.add(new BasicTsKvEntry(((Long)tsKvEntry.getKey()).longValue(), kvEntry));
            }
        }
        this.telemetrySubscriptionService.saveTimeseriesInternal(TimeseriesSaveRequest.builder().tenantId(ctx.getTenantId()).entityId(ctx.getEntityId()).entries(tsKvEntryList).strategy(strategy).future(future).build());
        if (log.isTraceEnabled()) {
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)MoreExecutors.directExecutor());
        }
        return future;
    }

    @ConstructorProperties(value={"timeseriesService", "attributesService", "tbelInvokeService", "apiLimitService", "telemetrySubscriptionService", "ownersCacheService"})
    @Generated
    public DefaultCalculatedFieldReprocessingService(TimeseriesService timeseriesService, AttributesService attributesService, TbelInvokeService tbelInvokeService, ApiLimitService apiLimitService, TelemetrySubscriptionService telemetrySubscriptionService, OwnersCacheService ownersCacheService) {
        this.timeseriesService = timeseriesService;
        this.attributesService = attributesService;
        this.tbelInvokeService = tbelInvokeService;
        this.apiLimitService = apiLimitService;
        this.telemetrySubscriptionService = telemetrySubscriptionService;
        this.ownersCacheService = ownersCacheService;
    }

    private static /* synthetic */ ArgumentEntry lambda$fetchTsRolling$7(TenantId tenantId, EntityId entityId, ReadTsKvQuery query, int limit, long argTimeWindow, List tsRolling) {
        log.debug("[{}][{}] Fetched {} timeseries for query {}", new Object[]{tenantId, entityId, tsRolling.size(), query});
        return ArgumentEntry.createTsRollingArgument((List)tsRolling, (int)limit, (long)argTimeWindow);
    }

    private static /* synthetic */ ArgumentEntry lambda$fetchTsLatest$6(TenantId tenantId, EntityId entityId, ReadTsKvQuery query, Argument argument, long reprocessingStartTs, List tsKvList) {
        log.debug("[{}][{}] Fetched timeseries for latest for query {}: {}", new Object[]{tenantId, entityId, query, tsKvList});
        boolean noValidEntry = tsKvList.isEmpty() || tsKvList.get(0) == null || ((TsKvEntry)tsKvList.get(0)).getValue() == null;
        TsKvEntry tsKvEntry = noValidEntry ? CalculatedFieldArgumentUtils.createDefaultTsKvEntry((Argument)argument, (long)reprocessingStartTs) : (TsKvEntry)tsKvList.get(0);
        return CalculatedFieldArgumentUtils.transformSingleValueArgument((KvEntry)tsKvEntry);
    }
}

