/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.thingsboard.server.data.RecaptchaErrorCode;

public class RecaptchaValidationResult {
    private boolean success;
    private List<RecaptchaErrorCode> errorCodes = new ArrayList();

    @JsonCreator
    public RecaptchaValidationResult(@JsonProperty(value="success") boolean success, @JsonProperty(value="error-codes") List<RecaptchaErrorCode> errorCodes) {
        this.success = success;
        this.errorCodes = errorCodes == null ? new ArrayList() : errorCodes;
    }

    public boolean isSuccess() {
        return this.success;
    }

    @JsonIgnore
    public boolean isFailure() {
        return !this.success;
    }

    public List<RecaptchaErrorCode> getErrorCodes() {
        return Collections.unmodifiableList(this.errorCodes);
    }

    public boolean hasError(RecaptchaErrorCode error) {
        return this.errorCodes.contains(error);
    }

    public String toString() {
        return "RecaptchaValidationResult{success=" + this.success + ", errorCodes=" + String.valueOf(this.errorCodes) + "}";
    }
}

