/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.WidgetTypeId;
import org.thingsboard.server.common.data.id.WidgetsBundleId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.widget.DeprecatedFilter;
import org.thingsboard.server.common.data.widget.WidgetType;
import org.thingsboard.server.common.data.widget.WidgetTypeDetails;
import org.thingsboard.server.common.data.widget.WidgetTypeFilter;
import org.thingsboard.server.common.data.widget.WidgetTypeInfo;
import org.thingsboard.server.common.data.widget.WidgetsBundle;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.AutoCommitController;
import org.thingsboard.server.dao.model.ModelConstants;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.widgets.type.TbWidgetTypeService;
import org.thingsboard.server.service.resource.TbResourceService;
import org.thingsboard.server.service.security.model.SecurityUser;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class WidgetTypeController
extends AutoCommitController {
    private final TbWidgetTypeService tbWidgetTypeService;
    private final TbResourceService tbResourceService;
    private static final String WIDGET_TYPE_DESCRIPTION = "Widget Type represents the template for widget creation. Widget Type and Widget are similar to class and object in OOP theory.";
    private static final String WIDGET_TYPE_DETAILS_DESCRIPTION = "Widget Type Details extend Widget Type and add image and description properties. Those properties are useful to edit the Widget Type but they are not required for Dashboard rendering. ";
    private static final String WIDGET_TYPE_INFO_DESCRIPTION = "Widget Type Info is a lightweight object that represents Widget Type but does not contain the heavyweight widget descriptor JSON";
    private static final String TENANT_ONLY_PARAM_DESCRIPTION = "Optional boolean parameter indicating whether only tenant widget types should be returned";
    private static final String FULL_SEARCH_PARAM_DESCRIPTION = "Optional boolean parameter indicating whether search widgets by description not only by name";
    private static final String SCADA_FIRST_PARAM_DESCRIPTION = "Optional boolean parameter indicating whether to fetch SCADA symbol widgets first";
    private static final String DEPRECATED_FILTER_PARAM_DESCRIPTION = "Optional string parameter indicating whether to include deprecated widgets";
    private static final String UPDATE_EXISTING_BY_FQN_PARAM_DESCRIPTION = "Optional boolean parameter indicating whether to update existing widget type by FQN if present instead of creating new one";
    private static final String WIDGET_TYPE_ARRAY_DESCRIPTION = "A list of string values separated by comma ',' representing one of the widget type value";

    @ApiOperation(value="Get Widget Type Details (getWidgetTypeById)", notes="Get the Widget Type Details based on the provided Widget Type Id. Widget Type Details extend Widget Type and add image and description properties. Those properties are useful to edit the Widget Type but they are not required for Dashboard rendering. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/widgetType/{widgetTypeId}"})
    public WidgetTypeDetails getWidgetTypeById(@Parameter(description="A string value representing the widget type id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="widgetTypeId") String strWidgetTypeId, @Parameter(description="Export used resources and replace resource links with resource metadata") @RequestParam(value="includeResources", required=false) boolean includeResources) throws ThingsboardException {
        this.checkParameter("widgetTypeId", strWidgetTypeId);
        WidgetTypeId widgetTypeId = new WidgetTypeId(this.toUUID(strWidgetTypeId));
        WidgetTypeDetails widgetTypeDetails = this.checkWidgetTypeId(widgetTypeId, Operation.READ);
        if (includeResources) {
            widgetTypeDetails.setResources(this.tbResourceService.exportResources(widgetTypeDetails, this.getCurrentUser()));
        }
        return widgetTypeDetails;
    }

    @ApiOperation(value="Get Widget Type Info (getWidgetTypeInfoById)", notes="Get the Widget Type Info based on the provided Widget Type Id. Widget Type Details extend Widget Type and add image and description properties. Those properties are useful to edit the Widget Type but they are not required for Dashboard rendering. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @RequestMapping(value={"/widgetTypeInfo/{widgetTypeId}"}, method={RequestMethod.GET})
    @ResponseBody
    public WidgetTypeInfo getWidgetTypeInfoById(@Parameter(description="A string value representing the widget type id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="widgetTypeId") String strWidgetTypeId) throws ThingsboardException {
        this.checkParameter("widgetTypeId", strWidgetTypeId);
        WidgetTypeId widgetTypeId = new WidgetTypeId(this.toUUID(strWidgetTypeId));
        return this.checkWidgetTypeInfoId(widgetTypeId, Operation.READ);
    }

    @ApiOperation(value="Create Or Update Widget Type (saveWidgetType)", notes="Create or update the Widget Type. Widget Type represents the template for widget creation. Widget Type and Widget are similar to class and object in OOP theory. When creating the Widget Type, platform generates Widget Type Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created Widget Type Id will be present in the response. Specify existing Widget Type id to update the Widget Type. Referencing non-existing Widget Type Id will cause 'Not Found' error.\n\nWidget Type fqn is unique in the scope of System or Tenant. Special Tenant Id '13814000-1dd2-11b2-8080-808080808080' is automatically used if the create request is sent by user with 'SYS_ADMIN' authority.Remove 'id', 'tenantId' rom the request body example (below) to create new Widget Type entity.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @RequestMapping(value={"/widgetType"}, method={RequestMethod.POST})
    @ResponseBody
    public WidgetTypeDetails saveWidgetType(@Parameter(description="A JSON value representing the Widget Type Details.", required=true) @RequestBody WidgetTypeDetails widgetTypeDetails, @Parameter(description="Optional boolean parameter indicating whether to update existing widget type by FQN if present instead of creating new one") @RequestParam(required=false) Boolean updateExistingByFqn) throws Exception {
        SecurityUser currentUser = this.getCurrentUser();
        if (Authority.SYS_ADMIN.equals((Object)currentUser.getAuthority())) {
            widgetTypeDetails.setTenantId(TenantId.SYS_TENANT_ID);
        } else {
            widgetTypeDetails.setTenantId(currentUser.getTenantId());
        }
        this.checkEntity((EntityId)widgetTypeDetails.getId(), (TenantEntity)widgetTypeDetails, Resource.WIDGET_TYPE, null);
        return this.tbWidgetTypeService.save(widgetTypeDetails, updateExistingByFqn != null && updateExistingByFqn != false, currentUser);
    }

    @ApiOperation(value="Delete widget type (deleteWidgetType)", notes="Deletes the  Widget Type. Referencing non-existing Widget Type Id will cause an error.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @RequestMapping(value={"/widgetType/{widgetTypeId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteWidgetType(@Parameter(description="A string value representing the widget type id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="widgetTypeId") String strWidgetTypeId) throws Exception {
        this.checkParameter("widgetTypeId", strWidgetTypeId);
        WidgetTypeId widgetTypeId = new WidgetTypeId(this.toUUID(strWidgetTypeId));
        WidgetTypeDetails wtd = this.checkWidgetTypeId(widgetTypeId, Operation.DELETE);
        this.tbWidgetTypeService.delete(wtd, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Widget Types (getWidgetTypes)", notes="Returns a page of Widget Type objects available for current user. Widget Type represents the template for widget creation. Widget Type and Widget are similar to class and object in OOP theory. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for any authorized user. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/widgetTypes"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<WidgetTypeInfo> getWidgetTypes(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the widget type name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "deprecated", "tenantId"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC, DESC"})) @RequestParam(required=false) String sortOrder, @Parameter(description="Optional boolean parameter indicating whether only tenant widget types should be returned") @RequestParam(required=false) Boolean tenantOnly, @Parameter(description="Optional boolean parameter indicating whether search widgets by description not only by name") @RequestParam(required=false) Boolean fullSearch, @Parameter(description="Optional string parameter indicating whether to include deprecated widgets", schema=@Schema(allowableValues={"ALL", "ACTUAL", "DEPRECATED"})) @RequestParam(required=false) String deprecatedFilter, @Parameter(description="A list of string values separated by comma ',' representing one of the widget type value", array=@ArraySchema(schema=@Schema(type="string", allowableValues={"timeseries", "latest", "control", "alarm", "static"}))) @RequestParam(required=false) String[] widgetTypeList, @Parameter(description="Optional boolean parameter indicating whether to fetch SCADA symbol widgets first") @RequestParam(required=false) Boolean scadaFirst) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        List<Object> widgetTypes = widgetTypeList != null ? Arrays.asList(widgetTypeList) : Collections.emptyList();
        DeprecatedFilter widgetTypeDeprecatedFilter = StringUtils.isNotEmpty((String)deprecatedFilter) ? DeprecatedFilter.valueOf((String)deprecatedFilter) : DeprecatedFilter.ALL;
        WidgetTypeFilter widgetTypeFilter = WidgetTypeFilter.builder().tenantId(this.getTenantId()).widgetTypes(widgetTypes).deprecatedFilter(widgetTypeDeprecatedFilter).fullSearch(fullSearch != null && fullSearch != false).scadaFirst(scadaFirst != null && scadaFirst != false).build();
        if (Authority.SYS_ADMIN.equals((Object)this.getCurrentUser().getAuthority())) {
            return (PageData)this.checkNotNull((Object)this.widgetTypeService.findSystemWidgetTypesByPageLink(widgetTypeFilter, pageLink));
        }
        if (tenantOnly != null && tenantOnly.booleanValue()) {
            return (PageData)this.checkNotNull((Object)this.widgetTypeService.findTenantWidgetTypesByTenantIdAndPageLink(widgetTypeFilter, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.widgetTypeService.findAllTenantWidgetTypesByTenantIdAndPageLink(widgetTypeFilter, pageLink));
    }

    @ApiOperation(value="Get all Widget types for specified Bundle (getBundleWidgetTypesByBundleAlias) (Deprecated)", notes="Returns an array of Widget Type objects that belong to specified Widget Bundle.Widget Type represents the template for widget creation. Widget Type and Widget are similar to class and object in OOP theory. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @RequestMapping(value={"/widgetTypes"}, params={"isSystem", "bundleAlias"}, method={RequestMethod.GET})
    @ResponseBody
    @Deprecated
    public List<WidgetType> getBundleWidgetTypesByBundleAlias(@Parameter(description="System or Tenant", required=true) @RequestParam boolean isSystem, @Parameter(description="Widget Bundle alias", required=true) @RequestParam String bundleAlias) throws ThingsboardException {
        TenantId tenantId = isSystem ? TenantId.SYS_TENANT_ID : this.getCurrentUser().getTenantId();
        WidgetsBundle widgetsBundle = (WidgetsBundle)this.checkNotNull((Object)this.widgetsBundleService.findWidgetsBundleByTenantIdAndAlias(tenantId, bundleAlias));
        return (List)this.checkNotNull((Object)this.widgetTypeService.findWidgetTypesByWidgetsBundleId(this.getTenantId(), widgetsBundle.getId()));
    }

    @ApiOperation(value="Get all Widget types for specified Bundle (getBundleWidgetTypes)", notes="Returns an array of Widget Type objects that belong to specified Widget Bundle.Widget Type represents the template for widget creation. Widget Type and Widget are similar to class and object in OOP theory. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/widgetTypes"}, params={"widgetsBundleId"}, method={RequestMethod.GET})
    @ResponseBody
    public List<WidgetType> getBundleWidgetTypes(@Parameter(description="Widget Bundle Id", required=true) @RequestParam(value="widgetsBundleId") String strWidgetsBundleId) throws ThingsboardException {
        WidgetsBundleId widgetsBundleId = new WidgetsBundleId(this.toUUID(strWidgetsBundleId));
        return (List)this.checkNotNull((Object)this.widgetTypeService.findWidgetTypesByWidgetsBundleId(this.getTenantId(), widgetsBundleId));
    }

    @ApiOperation(value="Get all Widget types details for specified Bundle (getBundleWidgetTypesDetailsByBundleAlias) (Deprecated)", notes="Returns an array of Widget Type Details objects that belong to specified Widget Bundle.Widget Type Details extend Widget Type and add image and description properties. Those properties are useful to edit the Widget Type but they are not required for Dashboard rendering.  \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @RequestMapping(value={"/widgetTypesDetails"}, params={"isSystem", "bundleAlias"}, method={RequestMethod.GET})
    @ResponseBody
    @Deprecated
    public List<WidgetTypeDetails> getBundleWidgetTypesDetailsByBundleAlias(@Parameter(description="System or Tenant", required=true) @RequestParam boolean isSystem, @Parameter(description="Widget Bundle alias", required=true) @RequestParam String bundleAlias) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.WIDGET_TYPE, Operation.READ);
        TenantId tenantId = isSystem ? TenantId.SYS_TENANT_ID : this.getCurrentUser().getTenantId();
        WidgetsBundle widgetsBundle = (WidgetsBundle)this.checkNotNull((Object)this.widgetsBundleService.findWidgetsBundleByTenantIdAndAlias(tenantId, bundleAlias));
        return (List)this.checkNotNull((Object)this.widgetTypeService.findWidgetTypesDetailsByWidgetsBundleId(this.getTenantId(), widgetsBundle.getId()));
    }

    @ApiOperation(value="Get all Widget types details for specified Bundle (getBundleWidgetTypesDetails)", notes="Returns an array of Widget Type Details objects that belong to specified Widget Bundle.Widget Type Details extend Widget Type and add image and description properties. Those properties are useful to edit the Widget Type but they are not required for Dashboard rendering.  \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/widgetTypesDetails"}, params={"widgetsBundleId"}, method={RequestMethod.GET})
    @ResponseBody
    public List<WidgetTypeDetails> getBundleWidgetTypesDetails(@Parameter(description="Widget Bundle Id", required=true) @RequestParam(value="widgetsBundleId") String strWidgetsBundleId, @Parameter(description="Export used resources and replace resource links with resource metadata") @RequestParam(value="includeResources", required=false) boolean includeResources) throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        WidgetsBundleId widgetsBundleId = new WidgetsBundleId(this.toUUID(strWidgetsBundleId));
        List result = (List)this.checkNotNull((Object)this.widgetTypeService.findWidgetTypesDetailsByWidgetsBundleId(this.getTenantId(), widgetsBundleId));
        if (includeResources) {
            for (WidgetTypeDetails widgetTypeDetails : result) {
                widgetTypeDetails.setResources(this.tbResourceService.exportResources(widgetTypeDetails, user));
            }
        }
        return result;
    }

    @ApiOperation(value="Get all Widget type fqns for specified Bundle (getBundleWidgetTypeFqns)", notes="Returns an array of Widget Type fqns that belong to specified Widget Bundle.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @RequestMapping(value={"/widgetTypeFqns"}, params={"widgetsBundleId"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getBundleWidgetTypeFqns(@Parameter(description="Widget Bundle Id", required=true) @RequestParam(value="widgetsBundleId") String strWidgetsBundleId) throws ThingsboardException {
        WidgetsBundleId widgetsBundleId = new WidgetsBundleId(this.toUUID(strWidgetsBundleId));
        return (List)this.checkNotNull((Object)this.widgetTypeService.findWidgetFqnsByWidgetsBundleId(this.getTenantId(), widgetsBundleId));
    }

    @ApiOperation(value="Get Widget Type Info objects (getBundleWidgetTypesInfosByBundleAlias) (Deprecated)", notes="Get the Widget Type Info objects based on the provided parameters. Widget Type Info is a lightweight object that represents Widget Type but does not contain the heavyweight widget descriptor JSON\n\nAvailable for any authorized user. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/widgetTypesInfos"}, params={"isSystem", "bundleAlias"}, method={RequestMethod.GET})
    @ResponseBody
    @Deprecated
    public List<WidgetTypeInfo> getBundleWidgetTypesInfosByBundleAlias(@Parameter(description="System or Tenant", required=true) @RequestParam boolean isSystem, @Parameter(description="Widget Bundle alias", required=true) @RequestParam String bundleAlias) throws ThingsboardException {
        TenantId tenantId = isSystem ? TenantId.SYS_TENANT_ID : this.getCurrentUser().getTenantId();
        WidgetsBundle widgetsBundle = (WidgetsBundle)this.checkNotNull((Object)this.widgetsBundleService.findWidgetsBundleByTenantIdAndAlias(tenantId, bundleAlias));
        return ((PageData)this.checkNotNull((Object)this.widgetTypeService.findWidgetTypesInfosByWidgetsBundleId(this.getTenantId(), widgetsBundle.getId(), false, DeprecatedFilter.ALL, null, new PageLink(1024)))).getData();
    }

    @ApiOperation(value="Get Widget Type Info objects (getBundleWidgetTypesInfos)", notes="Get the Widget Type Info objects based on the provided parameters. Widget Type Info is a lightweight object that represents Widget Type but does not contain the heavyweight widget descriptor JSON\n\nAvailable for any authorized user. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/widgetTypesInfos"}, params={"widgetsBundleId", "pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<WidgetTypeInfo> getBundleWidgetTypesInfos(@Parameter(description="Widget Bundle Id", required=true) @RequestParam(value="widgetsBundleId") String strWidgetsBundleId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the widget type name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "deprecated", "tenantId"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder, @Parameter(description="Optional boolean parameter indicating whether search widgets by description not only by name") @RequestParam(required=false) Boolean fullSearch, @Parameter(description="Optional string parameter indicating whether to include deprecated widgets", schema=@Schema(allowableValues={"ALL", "ACTUAL", "DEPRECATED"})) @RequestParam(required=false) String deprecatedFilter, @Parameter(description="A list of string values separated by comma ',' representing one of the widget type value", array=@ArraySchema(schema=@Schema(allowableValues={"timeseries", "latest", "control", "alarm", "static"}))) @RequestParam(required=false) String[] widgetTypeList) throws ThingsboardException {
        WidgetsBundleId widgetsBundleId = new WidgetsBundleId(this.toUUID(strWidgetsBundleId));
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        List<Object> widgetTypes = widgetTypeList != null ? Arrays.asList(widgetTypeList) : Collections.emptyList();
        DeprecatedFilter widgetTypeDeprecatedFilter = StringUtils.isNotEmpty((String)deprecatedFilter) ? DeprecatedFilter.valueOf((String)deprecatedFilter) : DeprecatedFilter.ALL;
        return (PageData)this.checkNotNull((Object)this.widgetTypeService.findWidgetTypesInfosByWidgetsBundleId(this.getTenantId(), widgetsBundleId, fullSearch != null && fullSearch != false, widgetTypeDeprecatedFilter, widgetTypes, pageLink));
    }

    @ApiOperation(value="Get Widget Type (getWidgetTypeByBundleAliasAndTypeAlias) (Deprecated)", notes="Get the Widget Type based on the provided parameters. Widget Type represents the template for widget creation. Widget Type and Widget are similar to class and object in OOP theory.\n\nAvailable for any authorized user. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/widgetType"}, params={"isSystem", "bundleAlias", "alias"}, method={RequestMethod.GET})
    @ResponseBody
    @Deprecated
    public WidgetType getWidgetTypeByBundleAliasAndTypeAlias(@Parameter(description="System or Tenant", required=true) @RequestParam boolean isSystem, @Parameter(description="Widget Bundle alias", required=true) @RequestParam String bundleAlias, @Parameter(description="Widget Type alias", required=true) @RequestParam String alias) throws ThingsboardException {
        TenantId tenantId = isSystem ? TenantId.fromUUID((UUID)ModelConstants.NULL_UUID) : this.getCurrentUser().getTenantId();
        WidgetType widgetType = this.widgetTypeService.findWidgetTypeByTenantIdAndFqn(tenantId, bundleAlias + "." + alias);
        this.checkNotNull((Object)widgetType);
        return widgetType;
    }

    @ApiOperation(value="Get Widget Type (getWidgetType)", notes="Get the Widget Type by FQN. Widget Type represents the template for widget creation. Widget Type and Widget are similar to class and object in OOP theory.\n\nAvailable for any authorized user. ", hidden=true)
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/widgetType"}, params={"fqn"}, method={RequestMethod.GET})
    @ResponseBody
    public WidgetType getWidgetType(@Parameter(description="Widget Type fqn", required=true) @RequestParam String fqn) throws ThingsboardException {
        MergedUserPermissions userPermissions;
        String scopeQualifier;
        String[] parts = fqn.split("\\.");
        String string = scopeQualifier = parts.length > 0 ? parts[0] : null;
        if (parts.length < 2 || !scopeQualifier.equals("system") && !scopeQualifier.equals("tenant")) {
            throw new ThingsboardException("Invalid fqn!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        TenantId tenantId = "system".equals(scopeQualifier) ? TenantId.fromUUID((UUID)ModelConstants.NULL_UUID) : this.getCurrentUser().getTenantId();
        String typeFqn = fqn.substring(scopeQualifier.length() + 1);
        WidgetType widgetType = this.widgetTypeService.findWidgetTypeByTenantIdAndFqn(tenantId, typeFqn);
        this.checkNotNull((Object)widgetType);
        if (!this.accessControlService.hasPermission(this.getCurrentUser(), Resource.WIDGET_TYPE, Operation.READ, (EntityId)widgetType.getId(), (TenantEntity)widgetType) && !(userPermissions = this.getCurrentUser().getUserPermissions()).hasGenericPermission(Resource.DASHBOARD, Operation.READ) && userPermissions.getGroupPermissionsByEntityTypeAndOperation(EntityType.DASHBOARD, Operation.READ).getEntityGroupIds().isEmpty()) {
            throw new ThingsboardException("You don't have permission to perform '" + String.valueOf(Operation.READ) + "' operation with " + widgetType.getEntityType().toString(), ThingsboardErrorCode.PERMISSION_DENIED);
        }
        return widgetType;
    }

    @ConstructorProperties(value={"tbWidgetTypeService", "tbResourceService"})
    @Generated
    public WidgetTypeController(TbWidgetTypeService tbWidgetTypeService, TbResourceService tbResourceService) {
        this.tbWidgetTypeService = tbWidgetTypeService;
        this.tbResourceService = tbResourceService;
    }
}

