/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import java.util.HashMap;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.permission.AllowedPermissionsInfo;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class UserPermissionsController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserPermissionsController.class);

    @ApiOperation(value="Get Permissions (getAllowedPermissions)", notes="Returns a complex object that describes:\n\n * all possible (both granted and not granted) permissions for the authority of the user (Tenant or Customer);\n * all granted permissions for the user;\n\n The result impacts UI behavior and hides certain UI elements if user has no permissions to invoke the related operations. Nevertheless, all API calls check the permissions each time they are executed on the server side.You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/permissions/allowedPermissions"})
    public AllowedPermissionsInfo getAllowedPermissions() throws ThingsboardException {
        Set allowedResources = (Set)Resource.resourcesByAuthority.get(this.getCurrentUser().getAuthority());
        HashMap operationsByResource = new HashMap();
        allowedResources.forEach(resource -> operationsByResource.put(resource, (Set)Resource.operationsByResource.get(resource)));
        return new AllowedPermissionsInfo(operationsByResource, Operation.allowedForGroupRoleOperations, Operation.allowedForGroupOwnerOnlyOperations, Operation.allowedForGroupOwnerOnlyGroupOperations, allowedResources, this.getCurrentUser().getUserPermissions(), this.getCurrentUser().getOwnerId());
    }
}

