/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.MailService;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.UserActivationLink;
import org.thingsboard.server.common.data.UserEmailInfo;
import org.thingsboard.server.common.data.UserInfo;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.group.EntityGroupInfo;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.mobile.MobileSessionInfo;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.query.EntityDataPageLink;
import org.thingsboard.server.common.data.query.EntityDataQuery;
import org.thingsboard.server.common.data.query.EntityFilter;
import org.thingsboard.server.common.data.query.EntityKey;
import org.thingsboard.server.common.data.query.EntityKeyType;
import org.thingsboard.server.common.data.query.EntityTypeFilter;
import org.thingsboard.server.common.data.query.TsValue;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.security.UserCredentials;
import org.thingsboard.server.common.data.security.event.UserCredentialsInvalidationEvent;
import org.thingsboard.server.common.data.security.model.JwtPair;
import org.thingsboard.server.common.data.settings.UserDashboardAction;
import org.thingsboard.server.common.data.settings.UserDashboardsInfo;
import org.thingsboard.server.common.data.settings.UserSettings;
import org.thingsboard.server.common.data.settings.UserSettingsType;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.entity.BaseEntityService;
import org.thingsboard.server.dao.entity.EntityService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.user.TbUserService;
import org.thingsboard.server.service.query.EntityQueryService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.UserPrincipal;
import org.thingsboard.server.service.security.model.token.JwtTokenFactory;
import org.thingsboard.server.service.security.permission.UserPermissionsService;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class UserController
extends BaseController {
    public static final String USER_ID = "userId";
    public static final String PATHS = "paths";
    public static final String YOU_DON_T_HAVE_PERMISSION_TO_PERFORM_THIS_OPERATION = "You don't have permission to perform this operation!";
    public static final String MOBILE_TOKEN_HEADER = "X-Mobile-Token";
    @Value(value="${security.user_token_access_enabled}")
    private boolean userTokenAccessEnabled;
    private final MailService mailService;
    private final UserPermissionsService userPermissionsService;
    private final JwtTokenFactory tokenFactory;
    private final ApplicationEventPublisher eventPublisher;
    private final TbUserService tbUserService;
    private final EntityQueryService entityQueryService;
    private final EntityService entityService;

    @ApiOperation(value="Get User (getUserById)", notes="Fetch the User object based on the provided User Id. If the user has the authority of 'SYS_ADMIN', the server does not perform additional checks. If the user has the authority of 'TENANT_ADMIN', the server checks that the requested user is owned by the same tenant. If the user has the authority of 'CUSTOMER_USER', the server checks that the requested user is owned by the same customer.\n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/user/{userId}"}, method={RequestMethod.GET})
    @ResponseBody
    public User getUserById(@Parameter(description="A string value representing the user id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="userId") String strUserId) throws ThingsboardException {
        this.checkParameter(USER_ID, strUserId);
        UserId userId = new UserId(this.toUUID(strUserId));
        User user = this.checkUserId(userId, Operation.READ);
        this.checkUserInfo(user);
        return user;
    }

    @ApiOperation(value="Get User info (getUserInfoById)", notes="Fetch the User info object based on the provided User Id. If the user has the authority of 'SYS_ADMIN', the server does not perform additional checks. If the user has the authority of 'TENANT_ADMIN', the server checks that the requested user is owned by the same tenant. If the user has the authority of 'CUSTOMER_USER', the server checks that the requested user is owned by the same customer.\n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/user/info/{userId}"}, method={RequestMethod.GET})
    @ResponseBody
    public UserInfo getUserInfoById(@Parameter(description="A string value representing the user id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="userId") String strUserId) throws ThingsboardException {
        this.checkParameter(USER_ID, strUserId);
        UserId userId = new UserId(this.toUUID(strUserId));
        UserInfo user = this.checkUserInfoId(userId, Operation.READ);
        this.checkUserInfo((User)user);
        return user;
    }

    @ApiOperation(value="Check Token Access Enabled (isUserTokenAccessEnabled)", notes="Checks that the system is configured to allow administrators to impersonate themself as other users. If the user who performs the request has the authority of 'SYS_ADMIN', it is possible to login as any tenant administrator. If the user who performs the request has the authority of 'TENANT_ADMIN', it is possible to login as any customer user.\n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/user/tokenAccessEnabled"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean isUserTokenAccessEnabled() {
        return this.userTokenAccessEnabled;
    }

    @ApiOperation(value="Get User Token (getUserToken)", notes="Returns the token of the User based on the provided User Id. If the user who performs the request has the authority of 'SYS_ADMIN', it is possible to get the token of any tenant administrator. If the user who performs the request has the authority of 'TENANT_ADMIN', it is possible to get the token of any customer user that belongs to the same tenant. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/user/{userId}/token"}, method={RequestMethod.GET})
    @ResponseBody
    public JwtPair getUserToken(@Parameter(description="A string value representing the user id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="userId") String strUserId) throws ThingsboardException {
        this.checkParameter(USER_ID, strUserId);
        if (!this.userTokenAccessEnabled) {
            throw new ThingsboardException(YOU_DON_T_HAVE_PERMISSION_TO_PERFORM_THIS_OPERATION, ThingsboardErrorCode.PERMISSION_DENIED);
        }
        UserId userId = new UserId(this.toUUID(strUserId));
        SecurityUser authUser = this.getCurrentUser();
        User user = this.checkUserId(userId, Operation.IMPERSONATE);
        UserPrincipal principal = new UserPrincipal(UserPrincipal.Type.USER_NAME, user.getEmail());
        UserCredentials credentials = this.userService.findUserCredentialsByUserId(authUser.getTenantId(), userId);
        MergedUserPermissions userPermissions = this.userPermissionsService.getMergedPermissions((User)authUser, false);
        SecurityUser securityUser = new SecurityUser(user, credentials.isEnabled(), principal, userPermissions);
        return this.tokenFactory.createTokenPair(securityUser);
    }

    @ApiOperation(value="Save Or update User (saveUser)", notes="Create or update the User. When creating user, platform generates User Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created User Id will be present in the response. Specify existing User Id to update the device. Referencing non-existing User Id will cause 'Not Found' error.\n\nDevice email is unique for entire platform setup.\n\nRemove 'id', 'tenantId' and optionally 'customerId' from the request body example (below) to create new User entity. Security check is performed to verify that the user has 'WRITE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/user"}, method={RequestMethod.POST})
    @ResponseBody
    public User saveUser(@Parameter(description="A JSON value representing the User.", required=true) @RequestBody User user, @Parameter(description="Send activation email (or use activation link)", schema=@Schema(defaultValue="true")) @RequestParam(required=false, defaultValue="true") boolean sendActivationMail, @RequestParam(name="entityGroupId", required=false) String strEntityGroupId, @Parameter(description="A list of entity group ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string"))) @RequestParam(name="entityGroupIds", required=false) String[] strEntityGroupIds, HttpServletRequest request) throws ThingsboardException {
        if (!Authority.SYS_ADMIN.equals((Object)this.getCurrentUser().getAuthority())) {
            user.setTenantId(this.getCurrentUser().getTenantId());
        }
        ArrayList<EntityGroupId> entityGroupIds = new ArrayList<EntityGroupId>();
        ArrayList<EntityGroupInfo> entityGroups = new ArrayList<EntityGroupInfo>();
        String[] groupIds = null;
        if (!StringUtils.isEmpty((String)strEntityGroupId)) {
            groupIds = new String[]{strEntityGroupId};
        } else if (strEntityGroupIds != null && strEntityGroupIds.length > 0) {
            groupIds = strEntityGroupIds;
        }
        if (groupIds != null) {
            for (String id : groupIds) {
                EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(id));
                EntityGroupInfo entityGroup = this.checkEntityGroupId(entityGroupId, Operation.READ);
                entityGroupIds.add(entityGroupId);
                entityGroups.add(entityGroup);
            }
        }
        if (user.getId() == null && this.getCurrentUser().getAuthority() != Authority.SYS_ADMIN && (user.getCustomerId() == null || user.getCustomerId().isNullUid())) {
            if (!entityGroups.isEmpty() && ((EntityGroup)entityGroups.get(0)).getOwnerId().getEntityType() == EntityType.CUSTOMER) {
                user.setOwnerId((EntityId)new CustomerId(((EntityGroup)entityGroups.get(0)).getOwnerId().getId()));
            } else if (this.getCurrentUser().getAuthority() == Authority.CUSTOMER_USER) {
                user.setOwnerId((EntityId)this.getCurrentUser().getCustomerId());
            }
        }
        if (this.getCurrentUser().getId().equals((Object)user.getId())) {
            this.accessControlService.checkPermission(this.getCurrentUser(), Resource.PROFILE, Operation.WRITE);
        } else {
            this.checkEntityWithGroupIds((EntityId)user.getId(), (TenantEntity)user, Resource.USER, entityGroupIds);
        }
        if (!this.accessControlService.hasPermission(this.getCurrentUser(), Resource.WHITE_LABELING, Operation.WRITE)) {
            JsonNode additionalInfo;
            User prevUser;
            JsonNode additionalInfo2;
            String prevHomeDashboardId = null;
            boolean prevHideDashboardToolbar = true;
            if (user.getId() != null && (additionalInfo2 = (prevUser = this.userService.findUserById(this.getTenantId(), user.getId())).getAdditionalInfo()) != null && additionalInfo2.hasNonNull("homeDashboardId")) {
                prevHomeDashboardId = additionalInfo2.get("homeDashboardId").asText();
                if (additionalInfo2.has("homeDashboardHideToolbar")) {
                    prevHideDashboardToolbar = additionalInfo2.get("homeDashboardHideToolbar").asBoolean();
                }
            }
            if ((additionalInfo = user.getAdditionalInfo()) == null) {
                additionalInfo = JacksonUtil.newObjectNode();
                user.setAdditionalInfo(additionalInfo);
            }
            ((ObjectNode)additionalInfo).put("homeDashboardId", prevHomeDashboardId);
            ((ObjectNode)additionalInfo).put("homeDashboardHideToolbar", prevHideDashboardToolbar);
        }
        return this.tbUserService.save(this.getTenantId(), this.getCurrentUser().getCustomerId(), this.getCurrentUser().getAuthority(), user, sendActivationMail, request, entityGroups, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Send or re-send the activation email", notes="Force send the activation email to the user. Useful to resend the email if user has accidentally deleted it.\n\n Security check is performed to verify that the user has 'DELETE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/user/sendActivationMail"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void sendActivationEmail(@Parameter(description="Email of the user", required=true) @RequestParam(value="email") String email, HttpServletRequest request) throws ThingsboardException {
        SecurityUser securityUser = this.getCurrentUser();
        User user = (User)this.checkNotNull((Object)this.userService.findUserByEmail(securityUser.getTenantId(), email));
        this.accessControlService.checkPermission(securityUser, Resource.USER, Operation.READ, (EntityId)user.getId(), (TenantEntity)user);
        UserActivationLink activationLink = this.tbUserService.getActivationLink(securityUser.getTenantId(), securityUser.getCustomerId(), securityUser.getAuthority(), user.getId(), request);
        try {
            this.mailService.sendActivationEmail(securityUser.getTenantId(), activationLink.value(), activationLink.ttlMs(), email);
        }
        catch (Exception e) {
            throw new ThingsboardException("Couldn't send user activation email", ThingsboardErrorCode.GENERAL);
        }
    }

    @ApiOperation(value="Get activation link (getActivationLink)", notes="Get the activation link for the user. The base url for activation link is configurable in the general settings of system administrator. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/user/{userId}/activationLink"}, produces={"text/plain"})
    public String getActivationLink(@Parameter(description="A string value representing the user id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="userId") String strUserId, HttpServletRequest request) throws ThingsboardException {
        return this.getActivationLinkInfo(strUserId, request).value();
    }

    @ApiOperation(value="Get activation link info (getActivationLinkInfo)", notes="Get the activation link info for the user. The base url for activation link is configurable in the general settings of system administrator. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/user/{userId}/activationLinkInfo"})
    public UserActivationLink getActivationLinkInfo(@Parameter(description="A string value representing the user id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="userId") String strUserId, HttpServletRequest request) throws ThingsboardException {
        this.checkParameter(USER_ID, strUserId);
        UserId userId = new UserId(this.toUUID(strUserId));
        this.checkUserId(userId, Operation.READ);
        SecurityUser securityUser = this.getCurrentUser();
        return this.tbUserService.getActivationLink(securityUser.getTenantId(), securityUser.getCustomerId(), securityUser.getAuthority(), userId, request);
    }

    @ApiOperation(value="Delete User (deleteUser)", notes="Deletes the User, it's credentials and all the relations (from and to the User). Referencing non-existing User Id will cause an error. \n\n Security check is performed to verify that the user has 'DELETE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/user/{userId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteUser(@Parameter(description="A string value representing the user id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="userId") String strUserId) throws ThingsboardException {
        this.checkParameter(USER_ID, strUserId);
        UserId userId = new UserId(this.toUUID(strUserId));
        User user = this.checkUserId(userId, Operation.DELETE);
        if (user.getAuthority() == Authority.SYS_ADMIN && this.getCurrentUser().getId().equals((Object)userId)) {
            throw new ThingsboardException("Sysadmin is not allowed to delete himself", ThingsboardErrorCode.PERMISSION_DENIED);
        }
        if (user.getAuthority() == Authority.TENANT_ADMIN && this.entityGroupService.containsLastTenantAdmin(user.getTenantId(), List.of(user.getId()))) {
            throw new ThingsboardException("At least one tenant administrator must remain!", ThingsboardErrorCode.INVALID_ARGUMENTS);
        }
        this.userPermissionsService.onUserUpdatedOrRemoved(user);
        this.tbUserService.delete(this.getTenantId(), this.getCurrentUser().getCustomerId(), user, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Tenant Users (getTenantAdmins)", notes="Returns a page of users owned by tenant. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'SYS_ADMIN' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAuthority('SYS_ADMIN')")
    @RequestMapping(value={"/tenant/{tenantId}/users"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<User> getTenantAdmins(@Parameter(description="A string value representing the tenant id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="tenantId") String strTenantId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the user email.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "firstName", "lastName", "email"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.checkParameter("tenantId", strTenantId);
        TenantId tenantId = new TenantId(this.toUUID(strTenantId));
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return (PageData)this.checkNotNull((Object)this.userService.findTenantAdmins(tenantId, pageLink));
    }

    @ApiOperation(value="Get Customer Users (getCustomerUsers)", notes="Returns a page of users owned by customer. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customer/{customerId}/users"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<User> getCustomerUsers(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="customerId") String strCustomerId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the user email.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "firstName", "lastName", "email"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        this.checkCustomerId(customerId, Operation.READ);
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.USER, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        return (PageData)this.checkNotNull((Object)this.userService.findCustomerUsers(tenantId, customerId, pageLink));
    }

    @ApiOperation(value="Find users by query (findUsersByQuery)", notes="Returns page of user data objects. Search is been executed by email, firstName and lastName fields. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/users/info"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<UserEmailInfo> findUsersByQuery(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the user email.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "firstName", "lastName", "email"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        SecurityUser securityUser = this.getCurrentUser();
        EntityTypeFilter entityFilter = new EntityTypeFilter();
        entityFilter.setEntityType(EntityType.USER);
        EntityDataPageLink pageLink = new EntityDataPageLink(pageSize, page, textSearch, this.createEntityDataSortOrder(sortProperty, sortOrder));
        List<EntityKey> entityFields = Arrays.asList(new EntityKey(EntityKeyType.ENTITY_FIELD, "firstName"), new EntityKey(EntityKeyType.ENTITY_FIELD, "lastName"), new EntityKey(EntityKeyType.ENTITY_FIELD, "email"));
        EntityDataQuery query = new EntityDataQuery((EntityFilter)entityFilter, pageLink, entityFields, null, null);
        return this.entityQueryService.findEntityDataByQuery(securityUser, query).mapData(entityData -> {
            Map fieldValues = (Map)entityData.getLatest().get(EntityKeyType.ENTITY_FIELD);
            return new UserEmailInfo(UserId.fromString((String)entityData.getEntityId().getId().toString()), ((TsValue)fieldValues.get("email")).getValue(), ((TsValue)fieldValues.get("firstName")).getValue(), ((TsValue)fieldValues.get("lastName")).getValue());
        });
    }

    @ApiOperation(value="Get Customer Users (getCustomerUsers)", notes="Returns a page of users for the current tenant with authority 'CUSTOMER_USER'. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/customer/users"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<User> getAllCustomerUsers(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the user email.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "firstName", "lastName", "email"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.USER, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        return (PageData)this.checkNotNull((Object)this.userService.findAllCustomerUsers(tenantId, pageLink));
    }

    @ApiOperation(value="Get Users (getUsers)", notes="Returns a page of user objects available for the current user. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/user/users"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<User> getUserUsers(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the user email.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "firstName", "lastName", "email"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        SecurityUser currentUser = this.getCurrentUser();
        MergedUserPermissions mergedUserPermissions = currentUser.getUserPermissions();
        return this.entityService.findUserEntities(currentUser.getTenantId(), currentUser.getCustomerId(), mergedUserPermissions, EntityType.USER, Operation.READ, null, pageLink);
    }

    @ApiOperation(value="Get All User Infos for current user (getAllUserInfos)", notes="Returns a page of user info objects owned by the tenant or the customer of a current user. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/userInfos/all"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<UserInfo> getAllUserInfos(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Include customer or sub-customer entities") @RequestParam(required=false) Boolean includeCustomers, @Parameter(description="The case insensitive 'substring' filter based on the user email.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "firstName", "lastName", "email"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.USER, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (Authority.TENANT_ADMIN.equals((Object)this.getCurrentUser().getAuthority())) {
            if (includeCustomers != null && includeCustomers.booleanValue()) {
                return (PageData)this.checkNotNull((Object)this.userService.findUserInfosByTenantId(tenantId, pageLink));
            }
            return (PageData)this.checkNotNull((Object)this.userService.findTenantUserInfosByTenantId(tenantId, pageLink));
        }
        CustomerId customerId = this.getCurrentUser().getCustomerId();
        if (includeCustomers != null && includeCustomers.booleanValue()) {
            return (PageData)this.checkNotNull((Object)this.userService.findUserInfosByTenantIdAndCustomerIdIncludingSubCustomers(tenantId, customerId, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.userService.findUserInfosByTenantIdAndCustomerId(tenantId, customerId, pageLink));
    }

    @ApiOperation(value="Get Customer user Infos (getCustomerUserInfos)", notes="Returns a page of user info objects owned by the specified customer. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customer/{customerId}/userInfos"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<UserInfo> getCustomerUserInfos(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="customerId") String strCustomerId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Include customer or sub-customer entities") @RequestParam(required=false) Boolean includeCustomers, @Parameter(description="The case insensitive 'substring' filter based on the user email.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "firstName", "lastName", "email"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.USER, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        this.checkCustomerId(customerId, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (includeCustomers != null && includeCustomers.booleanValue()) {
            return (PageData)this.checkNotNull((Object)this.userService.findUserInfosByTenantIdAndCustomerIdIncludingSubCustomers(tenantId, customerId, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.userService.findUserInfosByTenantIdAndCustomerId(tenantId, customerId, pageLink));
    }

    @ApiOperation(value="Get Users By Ids (getUsersByIds)", notes="Requested users must be owned by tenant or assigned to customer which user is performing the request. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/users"}, params={"userIds"}, method={RequestMethod.GET})
    @ResponseBody
    public List<User> getUsersByIds(@Parameter(description="A list of user ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string")), required=true) @RequestParam(value="userIds") String[] strUserIds) throws ThingsboardException, ExecutionException, InterruptedException {
        this.checkArrayParameter("userIds", strUserIds);
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ArrayList<UserId> userIds = new ArrayList<UserId>();
        for (String strUserId : strUserIds) {
            userIds.add(new UserId(this.toUUID(strUserId)));
        }
        List users = (List)this.checkNotNull((Object)((List)this.userService.findUsersByTenantIdAndIdsAsync(tenantId, userIds).get()));
        return this.filterUsersByReadPermission(users);
    }

    @ApiOperation(value="Enable/Disable User credentials (setUserCredentialsEnabled)", notes="Enables or Disables user credentials. Useful when you would like to block user account without deleting it. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'WRITE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/user/{userId}/userCredentialsEnabled"}, method={RequestMethod.POST})
    @ResponseBody
    public void setUserCredentialsEnabled(@Parameter(description="A string value representing the user id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="userId") String strUserId, @Parameter(description="Enable (\"true\") or disable (\"false\") the credentials.", schema=@Schema(defaultValue="true")) @RequestParam(required=false, defaultValue="true") boolean userCredentialsEnabled) throws ThingsboardException {
        this.checkParameter(USER_ID, strUserId);
        UserId userId = new UserId(this.toUUID(strUserId));
        this.checkUserId(userId, Operation.WRITE);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        this.userService.setUserCredentialsEnabled(tenantId, userId, userCredentialsEnabled);
        if (!userCredentialsEnabled) {
            this.eventPublisher.publishEvent((Object)new UserCredentialsInvalidationEvent(userId));
        }
    }

    @ApiOperation(value="Get usersForAssign (getUsersForAssign)", notes="Returns page of user data objects that can be assigned to provided alarmId. Search is been executed by email, firstName and lastName fields. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/users/assign/{alarmId}"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<UserEmailInfo> getUsersForAssign(@Parameter(description="A string value representing the alarm id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="alarmId") String strAlarmId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the user email.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "firstName", "lastName", "email"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        PageData pageData;
        this.checkParameter("alarmId", strAlarmId);
        AlarmId alarmEntityId = new AlarmId(this.toUUID(strAlarmId));
        Alarm alarm = this.checkAlarmId(alarmEntityId, Operation.WRITE);
        SecurityUser currentUser = this.getCurrentUser();
        TenantId tenantId = currentUser.getTenantId();
        CustomerId originatorCustomerId = this.entityService.fetchEntityCustomerId(tenantId, alarm.getOriginator()).orElse(BaseEntityService.NULL_CUSTOMER_ID);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (Authority.TENANT_ADMIN.equals((Object)currentUser.getAuthority())) {
            if (CustomerId.NULL_UUID.equals(originatorCustomerId.getId())) {
                pageData = this.userService.findTenantAdmins(tenantId, pageLink);
            } else {
                ArrayList<CustomerId> customerIds = new ArrayList<CustomerId>(Collections.singletonList(BaseEntityService.NULL_CUSTOMER_ID));
                if (!CustomerId.NULL_UUID.equals(originatorCustomerId.getId())) {
                    customerIds.add(originatorCustomerId);
                }
                pageData = this.userService.findUsersByCustomerIds(tenantId, customerIds, pageLink);
            }
        } else {
            ArrayList<CustomerId> customerIds = new ArrayList<CustomerId>(Collections.singletonList(currentUser.getCustomerId()));
            if (!currentUser.getCustomerId().equals((Object)originatorCustomerId)) {
                customerIds.add(originatorCustomerId);
            }
            pageData = this.userService.findUsersByCustomerIds(tenantId, customerIds, pageLink);
        }
        return pageData.mapData(user -> new UserEmailInfo(user.getId(), user.getEmail(), user.getFirstName(), user.getLastName()));
    }

    @ApiOperation(value="Get users by Entity Group Id (getUsersByEntityGroupId)", notes="Returns a page of user objects that belongs to specified Entity Group Id. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\n Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/entityGroup/{entityGroupId}/users"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<User> getUsersByEntityGroupId(@Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityGroupId") String strEntityGroupId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the user email.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "firstName", "lastName", "email"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.checkParameter("entityGroupId", strEntityGroupId);
        EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(strEntityGroupId));
        EntityGroupInfo entityGroup = this.checkEntityGroupId(entityGroupId, Operation.READ);
        this.checkEntityGroupType(EntityType.USER, entityGroup.getType());
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return (PageData)this.checkNotNull((Object)this.userService.findUsersByEntityGroupId(entityGroupId, pageLink));
    }

    private List<User> filterUsersByReadPermission(List<User> users) {
        return users.stream().filter(user -> {
            try {
                return this.accessControlService.hasPermission(this.getCurrentUser(), Resource.USER, Operation.READ, (EntityId)user.getId(), (TenantEntity)user);
            }
            catch (ThingsboardException e) {
                return false;
            }
        }).collect(Collectors.toList());
    }

    @ApiOperation(value="Save user settings (saveUserSettings)", notes="Save user settings represented in json format for authorized user. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/user/settings"})
    public JsonNode saveUserSettings(@RequestBody JsonNode settings) throws ThingsboardException {
        SecurityUser currentUser = this.getCurrentUser();
        UserSettings userSettings = new UserSettings();
        userSettings.setType(UserSettingsType.GENERAL);
        userSettings.setSettings(settings);
        userSettings.setUserId(currentUser.getId());
        return this.userSettingsService.saveUserSettings(currentUser.getTenantId(), userSettings).getSettings();
    }

    @ApiOperation(value="Update user settings (saveUserSettings)", notes="Update user settings for authorized user. Only specified json elements will be updated.Example: you have such settings: {A:5, B:{C:10, D:20}}. Updating it with {B:{C:10, D:30}} will result in{A:5, B:{C:10, D:30}}. The same could be achieved by putting {B.D:30}")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @PutMapping(value={"/user/settings"})
    public void putUserSettings(@RequestBody JsonNode settings) throws ThingsboardException {
        SecurityUser currentUser = this.getCurrentUser();
        this.userSettingsService.updateUserSettings(currentUser.getTenantId(), currentUser.getId(), UserSettingsType.GENERAL, settings);
    }

    @ApiOperation(value="Get user settings (getUserSettings)", notes="Fetch the User settings based on authorized user. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/user/settings"})
    public JsonNode getUserSettings() throws ThingsboardException {
        SecurityUser currentUser = this.getCurrentUser();
        UserSettings userSettings = this.userSettingsService.findUserSettings(currentUser.getTenantId(), currentUser.getId(), UserSettingsType.GENERAL);
        return userSettings == null ? JacksonUtil.newObjectNode() : userSettings.getSettings();
    }

    @ApiOperation(value="Delete user settings (deleteUserSettings)", notes="Delete user settings by specifying list of json element xpaths. \n Example: to delete B and C element in { \"A\": {\"B\": 5}, \"C\": 15} send A.B,C in jsonPaths request parameter")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/user/settings/{paths}"}, method={RequestMethod.DELETE})
    public void deleteUserSettings(@Parameter(description="paths") @PathVariable(value="paths") String paths) throws ThingsboardException {
        this.checkParameter(USER_ID, paths);
        SecurityUser currentUser = this.getCurrentUser();
        this.userSettingsService.deleteUserSettings(currentUser.getTenantId(), currentUser.getId(), UserSettingsType.GENERAL, Arrays.asList(paths.split(",")));
    }

    @ApiOperation(value="Update user settings (saveUserSettings)", notes="Update user settings for authorized user. Only specified json elements will be updated.Example: you have such settings: {A:5, B:{C:10, D:20}}. Updating it with {B:{C:10, D:30}} will result in{A:5, B:{C:10, D:30}}. The same could be achieved by putting {B.D:30}")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @PutMapping(value={"/user/settings/{type}"})
    public void putUserSettings(@Parameter(description="Settings type, case insensitive, one of: \"general\", \"quick_links\", \"doc_links\" or \"dashboards\".") @PathVariable(value="type") String strType, @RequestBody JsonNode settings) throws ThingsboardException {
        SecurityUser currentUser = this.getCurrentUser();
        UserSettingsType type = (UserSettingsType)this.checkEnumParameter("Settings type", strType, UserSettingsType::valueOf);
        this.checkNotReserved(strType, type);
        this.userSettingsService.updateUserSettings(currentUser.getTenantId(), currentUser.getId(), type, settings);
    }

    @ApiOperation(value="Get user settings (getUserSettings)", notes="Fetch the User settings based on authorized user. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/user/settings/{type}"})
    public JsonNode getUserSettings(@Parameter(description="Settings type, case insensitive, one of: \"general\", \"quick_links\", \"doc_links\" or \"dashboards\".") @PathVariable(value="type") String strType) throws ThingsboardException {
        SecurityUser currentUser = this.getCurrentUser();
        UserSettingsType type = (UserSettingsType)this.checkEnumParameter("Settings type", strType, UserSettingsType::valueOf);
        this.checkNotReserved(strType, type);
        UserSettings userSettings = this.userSettingsService.findUserSettings(currentUser.getTenantId(), currentUser.getId(), type);
        return userSettings == null ? JacksonUtil.newObjectNode() : userSettings.getSettings();
    }

    @ApiOperation(value="Delete user settings (deleteUserSettings)", notes="Delete user settings by specifying list of json element xpaths. \n Example: to delete B and C element in { \"A\": {\"B\": 5}, \"C\": 15} send A.B,C in jsonPaths request parameter")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/user/settings/{type}/{paths}"}, method={RequestMethod.DELETE})
    public void deleteUserSettings(@Parameter(description="paths") @PathVariable(value="paths") String paths, @Parameter(description="Settings type, case insensitive, one of: \"general\", \"quick_links\", \"doc_links\" or \"dashboards\".") @PathVariable(value="type") String strType) throws ThingsboardException {
        this.checkParameter(USER_ID, paths);
        UserSettingsType type = (UserSettingsType)this.checkEnumParameter("Settings type", strType, UserSettingsType::valueOf);
        this.checkNotReserved(strType, type);
        SecurityUser currentUser = this.getCurrentUser();
        this.userSettingsService.deleteUserSettings(currentUser.getTenantId(), currentUser.getId(), type, Arrays.asList(paths.split(",")));
    }

    @ApiOperation(value="Get information about last visited and starred dashboards (getLastVisitedDashboards)", notes="Fetch the list of last visited and starred dashboards. Both lists are limited to 10 items.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/user/dashboards"})
    public UserDashboardsInfo getUserDashboardsInfo() throws ThingsboardException {
        SecurityUser currentUser = this.getCurrentUser();
        return this.userSettingsService.findUserDashboardsInfo(currentUser.getTenantId(), currentUser.getId());
    }

    @ApiOperation(value="Report action of User over the dashboard (reportUserDashboardAction)", notes="Report action of User over the dashboard. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/user/dashboards/{dashboardId}/{action}"}, method={RequestMethod.GET})
    @ResponseBody
    public UserDashboardsInfo reportUserDashboardAction(@Parameter(description="A string value representing the dashboard id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="dashboardId") String strDashboardId, @Parameter(description="Dashboard action, one of: \"visit\", \"star\" or \"unstar\".") @PathVariable(value="action") String strAction) throws ThingsboardException {
        this.checkParameter("dashboardId", strDashboardId);
        this.checkParameter("action", strAction);
        UserDashboardAction action = (UserDashboardAction)this.checkEnumParameter("Action", strAction, UserDashboardAction::valueOf);
        DashboardId dashboardId = new DashboardId(this.toUUID(strDashboardId));
        this.checkDashboardInfoId(dashboardId, Operation.READ);
        SecurityUser currentUser = this.getCurrentUser();
        return this.userSettingsService.reportUserDashboardAction(currentUser.getTenantId(), currentUser.getId(), dashboardId, action);
    }

    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/user/mobile/session"})
    public MobileSessionInfo getMobileSession(@RequestHeader(value="X-Mobile-Token") String mobileToken, @AuthenticationPrincipal SecurityUser user) {
        return this.userService.findMobileSession(user.getTenantId(), user.getId(), mobileToken);
    }

    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/user/mobile/session"})
    public void saveMobileSession(@RequestBody MobileSessionInfo sessionInfo, @RequestHeader(value="X-Mobile-Token") String mobileToken, @AuthenticationPrincipal SecurityUser user) {
        this.userService.saveMobileSession(user.getTenantId(), user.getId(), mobileToken, sessionInfo);
    }

    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @DeleteMapping(value={"/user/mobile/session"})
    public void removeMobileSession(@RequestHeader(value="X-Mobile-Token") String mobileToken, @AuthenticationPrincipal SecurityUser user) {
        this.userService.removeMobileSession(user.getTenantId(), mobileToken);
    }

    private void checkNotReserved(String strType, UserSettingsType type) throws ThingsboardException {
        if (type.isReserved()) {
            throw new ThingsboardException("Settings with type: " + strType + " are reserved for internal use!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
    }

    @ConstructorProperties(value={"mailService", "userPermissionsService", "tokenFactory", "eventPublisher", "tbUserService", "entityQueryService", "entityService"})
    @Generated
    public UserController(MailService mailService, UserPermissionsService userPermissionsService, JwtTokenFactory tokenFactory, ApplicationEventPublisher eventPublisher, TbUserService tbUserService, EntityQueryService entityQueryService, EntityService entityService) {
        this.mailService = mailService;
        this.userPermissionsService = userPermissionsService;
        this.tokenFactory = tokenFactory;
        this.eventPublisher = eventPublisher;
        this.tbUserService = tbUserService;
        this.entityQueryService = entityQueryService;
        this.entityService = entityService;
    }
}

