/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.hash.Hashing;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.translation.TranslationInfo;
import org.thingsboard.server.common.data.wl.WhiteLabeling;
import org.thingsboard.server.common.data.wl.WhiteLabelingType;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.translation.TranslationCacheKey;
import org.thingsboard.server.dao.wl.WhiteLabelingService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.translation.TbCustomTranslationService;
import org.thingsboard.server.service.translation.TranslationService;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class TranslationController
extends BaseController {
    public static final List<String> LOCALE_CODES_TO_EXCLUDE = Arrays.asList("ru_UA", "ccp_IN", "ccp_BD", "ii_CN", "sat_IN");
    private static final String CUSTOM_TRANSLATION_INFO_EXAMPLE = "\n\n```json\n[\n  {\n    \"localeCode\": \"uk_UA\",\n    \"language\": \"Ukrainian (\u0443\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430)\",\n    \"country\": \"\u0423\u043a\u0440\u0430\u0457\u043d\u0430\",\n    \"progress\": 32\n  },\n  {\n    \"localeCode\": \"es_ES\",\n    \"language\": \"Spanish (espa\u00f1ol)\",\n    \"country\": \"Espa\u00f1a\",\n    \"progress\": 79\n  }]\n```";
    private static final ObjectNode AVAILABLE_JAVA_LOCALE_CODES = JacksonUtil.newObjectNode();
    private final TbCustomTranslationService tbCustomTranslationService;
    private final TranslationService translationService;
    private final WhiteLabelingService whiteLabelingService;

    @ApiOperation(value="Get Translation info (getTranslationInfos)", notes="Fetch the list of customized locales and corresponding details such as language display name, country display name and translation progress percentage.\n\n Response example: \n\n```json\n[\n  {\n    \"localeCode\": \"uk_UA\",\n    \"language\": \"Ukrainian (\u0443\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430)\",\n    \"country\": \"\u0423\u043a\u0440\u0430\u0457\u043d\u0430\",\n    \"progress\": 32\n  },\n  {\n    \"localeCode\": \"es_ES\",\n    \"language\": \"Spanish (espa\u00f1ol)\",\n    \"country\": \"Espa\u00f1a\",\n    \"progress\": 79\n  }]\n```\n\nSecurity check is performed to verify that the user has 'READ' permission for the white labeling resource.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/translation/info"})
    public List<TranslationInfo> getTranslationInfos() throws ThingsboardException {
        this.checkWhiteLabelingPermissions(Operation.READ);
        return this.translationService.getTranslationInfos(this.getCurrentUser().getTenantId(), this.getCurrentUser().getCustomerId());
    }

    @ApiOperation(value="Get list of available locales (getAvailableLocales)", notes="Fetch the list of customized locales from all levels\n\nSecurity check is performed to verify that the user has 'READ' permission for the white labeling resource.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/translation/availableLocales"})
    public JsonNode getAvailableLocales() throws ThingsboardException {
        ObjectNode result = JacksonUtil.newObjectNode();
        Set availableLocaleCodes = this.translationService.getAvailableLocaleCodes(this.getCurrentUser().getTenantId(), this.getCurrentUser().getCustomerId());
        for (String localeCode : availableLocaleCodes) {
            String[] locale_parts = localeCode.split("_");
            Locale locale = new Locale(locale_parts[0], locale_parts[1]);
            String displayLanguage = locale.getDisplayLanguage(locale);
            String displayCountry = locale.getDisplayCountry(locale).isBlank() ? "" : " (" + locale.getDisplayCountry(locale) + ")";
            result.put(localeCode, displayLanguage + displayCountry);
        }
        return result;
    }

    @ApiOperation(value="Get list of available java locales (getAvailableJavaLocales)", notes="The result is map where key is locale code and value is locale language and country")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/translation/availableJavaLocales"})
    public JsonNode getAvailableJavaLocales() {
        return AVAILABLE_JAVA_LOCALE_CODES;
    }

    @ApiOperation(value="Get system translation for login page", notes="Fetch the end-user translation for specified locale.")
    @GetMapping(value={"/noauth/translation/login/{localeCode}"})
    public void getLoginPageTranslation(@Parameter(description="Locale code (e.g. 'en_US').") @PathVariable(value="localeCode") String localeCode, @RequestHeader(name="If-None-Match", required=false) String etag, @RequestHeader(name="Accept-Encoding", required=false) String acceptEncodingHeader, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String domainName = request.getServerName();
        WhiteLabeling loginWL = this.whiteLabelingService.findWhiteLabelingByDomainAndType(domainName, WhiteLabelingType.LOGIN);
        TranslationCacheKey cacheKey = loginWL != null ? TranslationCacheKey.forLoginTranslation((TenantId)loginWL.getTenantId(), (CustomerId)loginWL.getCustomerId(), (String)localeCode, (String)domainName) : TranslationCacheKey.forLoginTranslation((String)localeCode, (String)domainName);
        if (StringUtils.isNotEmpty((CharSequence)etag) && StringUtils.remove((String)etag, (char)'\"').equals(this.tbCustomTranslationService.getETag((Object)cacheKey))) {
            response.setStatus(HttpStatus.NOT_MODIFIED.value());
        } else {
            JsonNode loginTranslation = this.translationService.getLoginTranslation(localeCode, domainName);
            String calculatedEtag = this.calculateTranslationEtag(loginTranslation);
            this.tbCustomTranslationService.putETag((Object)cacheKey, calculatedEtag);
            response.setHeader("Etag", calculatedEtag);
            response.setContentType("application/json");
            this.compressResponseWithGzipIFAccepted(acceptEncodingHeader, response, JacksonUtil.writeValueAsBytes((Object)loginTranslation));
        }
    }

    @ApiOperation(value="Get end-user all-to-one translation (getFullTranslation)", notes="Fetch the end-user translation for specified locale. The result is the merge of user custom translation, system language translation and default locale translation.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/translation/full/{localeCode}"})
    public void getFullTranslation(@Parameter(description="Locale code (e.g. 'en_US').") @PathVariable(value="localeCode") String localeCode, @RequestHeader(name="If-None-Match", required=false) String etag, @RequestHeader(name="Accept-Encoding", required=false) String acceptEncodingHeader, HttpServletResponse response) throws Exception {
        TenantId tenantId = this.getCurrentUser().getTenantId();
        CustomerId customerId = this.getCurrentUser().getCustomerId();
        TranslationCacheKey cacheKey = TranslationCacheKey.forFullTranslation((TenantId)tenantId, (CustomerId)customerId, (String)localeCode);
        if (StringUtils.isNotEmpty((CharSequence)etag) && StringUtils.remove((String)etag, (char)'\"').equals(this.tbCustomTranslationService.getETag((Object)cacheKey))) {
            response.setStatus(HttpStatus.NOT_MODIFIED.value());
        } else {
            JsonNode fullTranslation = this.translationService.getFullTranslation(tenantId, customerId, localeCode);
            String calculatedEtag = this.calculateTranslationEtag(fullTranslation);
            this.tbCustomTranslationService.putETag((Object)cacheKey, calculatedEtag);
            response.setHeader("Etag", calculatedEtag);
            response.setContentType("application/json");
            this.compressResponseWithGzipIFAccepted(acceptEncodingHeader, response, JacksonUtil.writeValueAsBytes((Object)fullTranslation));
        }
    }

    @ApiOperation(value="Get end-user multi-translation for basic edit (getTranslationForBasicEdit)", notes="Fetch the translation info map where value is info object containing key translation, origin translation, translation of parent level, translation status.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/translation/edit/basic/{localeCode}"}, produces={"application/json"})
    public JsonNode getTranslationForBasicEdit(@PathVariable(value="localeCode") String localeCode) throws Exception {
        this.checkWhiteLabelingPermissions(Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        CustomerId customerId = this.getCurrentUser().getCustomerId();
        return this.translationService.getTranslationForBasicEdit(tenantId, customerId, localeCode);
    }

    @ApiOperation(value="Download end-user all-to-one translation (downloadFullTranslation)", notes="Fetch the end-user translation for the specified locale. The result is a json file with merged user custom translation, system language translation and default locale translation.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/translation/full/{localeCode}/download"})
    public ResponseEntity<ByteArrayResource> downloadFullTranslation(@Parameter(description="Locale code (e.g. 'en_US').") @PathVariable(value="localeCode") String localeCode) throws Exception {
        this.checkWhiteLabelingPermissions(Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        CustomerId customerId = this.getCurrentUser().getCustomerId();
        JsonNode fullSystemTranslation = (JsonNode)this.checkNotNull((Object)this.translationService.getFullTranslation(tenantId, customerId, localeCode));
        String fileName = localeCode + "_custom_translation.json";
        ByteArrayResource translation = new ByteArrayResource(JacksonUtil.writeValueAsStringWithDefaultPrettyPrinter((Object)fullSystemTranslation).getBytes());
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment;filename=" + fileName})).header("x-filename", new String[]{fileName})).contentLength(translation.contentLength()).header("Content-Type", new String[]{MediaType.APPLICATION_JSON.toString()})).body((Object)translation);
    }

    protected String calculateTranslationEtag(JsonNode translation) {
        return Hashing.sha256().hashString((CharSequence)translation.toString(), StandardCharsets.UTF_8).toString();
    }

    private void checkWhiteLabelingPermissions(Operation operation) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.WHITE_LABELING, operation);
    }

    @ConstructorProperties(value={"tbCustomTranslationService", "translationService", "whiteLabelingService"})
    @Generated
    public TranslationController(TbCustomTranslationService tbCustomTranslationService, TranslationService translationService, WhiteLabelingService whiteLabelingService) {
        this.tbCustomTranslationService = tbCustomTranslationService;
        this.translationService = translationService;
        this.whiteLabelingService = whiteLabelingService;
    }

    static {
        List<Locale> availableLocales = Arrays.stream(DateFormat.getAvailableLocales()).filter(availableLocale -> StringUtils.countMatches((CharSequence)availableLocale.toString(), (CharSequence)"_") == 1 && !LOCALE_CODES_TO_EXCLUDE.contains(availableLocale.toString()) && !availableLocale.toString().matches(".*\\d+.*")).toList();
        for (Locale availableLocale2 : availableLocales) {
            String displayLanguage = availableLocale2.getDisplayLanguage(availableLocale2);
            String displayCountry = availableLocale2.getDisplayCountry(availableLocale2).isBlank() ? "" : " (" + availableLocale2.getDisplayCountry(availableLocale2) + ")";
            AVAILABLE_JAVA_LOCALE_CODES.put(availableLocale2.toString(), displayLanguage + displayCountry);
        }
    }
}

