/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.rule.engine.api.AttributesDeleteRequest;
import org.thingsboard.rule.engine.api.AttributesSaveRequest;
import org.thingsboard.rule.engine.api.TimeseriesDeleteRequest;
import org.thingsboard.rule.engine.api.TimeseriesSaveRequest;
import org.thingsboard.server.common.adaptor.JsonConverter;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.kv.Aggregation;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseDeleteTsKvQuery;
import org.thingsboard.server.common.data.kv.BaseReadTsKvQuery;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.DataType;
import org.thingsboard.server.common.data.kv.IntervalType;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.ReadTsKvQueryResult;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.AccessValidator;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.telemetry.TbTelemetryService;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@TbCoreComponent
@RequestMapping(value={"/api/plugins/telemetry"})
public class TelemetryController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelemetryController.class);
    @Autowired
    private TimeseriesService tsService;
    @Autowired
    private AccessValidator accessValidator;
    @Autowired
    private TbTelemetryService tbTelemetryService;
    private ExecutorService executor;

    @PostConstruct
    public void initExecutor() {
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"telemetry-controller"));
    }

    @PreDestroy
    public void shutdownExecutor() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    @ApiOperation(value="Get all attribute keys (getAttributeKeys)", notes="Returns a set of unique attribute key names for the selected entity. The response will include merged key names set for all attribute scopes:\n\n * SERVER_SCOPE - supported for all entity types;\n * CLIENT_SCOPE - supported for devices;\n * SHARED_SCOPE - supported for devices. \n\nReferencing a non-existing entity Id or invalid entity type will cause an error. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityType}/{entityId}/keys/attributes"}, method={RequestMethod.GET})
    @ResponseBody
    public DeferredResult<ResponseEntity> getAttributeKeys(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true, schema=@Schema(defaultValue="DEVICE")) @PathVariable(value="entityType") String entityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String entityIdStr) throws ThingsboardException {
        return this.accessValidator.validateEntityAndCallback(this.getCurrentUser(), Operation.READ_ATTRIBUTES, entityType, entityIdStr, (arg_0, arg_1, arg_2) -> this.getAttributeKeysCallback(arg_0, arg_1, arg_2));
    }

    @ApiOperation(value="Get all attribute keys by scope (getAttributeKeysByScope)", notes="Returns a set of unique attribute key names for the selected entity and attributes scope: \n\n * SERVER_SCOPE - supported for all entity types;\n * CLIENT_SCOPE - supported for devices;\n * SHARED_SCOPE - supported for devices. \n\nReferencing a non-existing entity Id or invalid entity type will cause an error. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityType}/{entityId}/keys/attributes/{scope}"}, method={RequestMethod.GET})
    @ResponseBody
    public DeferredResult<ResponseEntity> getAttributeKeysByScope(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true, schema=@Schema(defaultValue="DEVICE")) @PathVariable(value="entityType") String entityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String entityIdStr, @Parameter(description="A string value representing the attributes scope. For example, 'SERVER_SCOPE'.", required=true, schema=@Schema(allowableValues={"SERVER_SCOPE", "SHARED_SCOPE", "CLIENT_SCOPE"})) @PathVariable(value="scope") AttributeScope scope) throws ThingsboardException {
        return this.accessValidator.validateEntityAndCallback(this.getCurrentUser(), Operation.READ_ATTRIBUTES, entityType, entityIdStr, (result, tenantId, entityId) -> this.getAttributeKeysCallback(result, tenantId, entityId, scope));
    }

    @ApiOperation(value="Get attributes (getAttributes)", notes="Returns all attributes that belong to specified entity. Use optional 'keys' parameter to return specific attributes.\n Example of the result: \n\n```json\n[\n  {\"key\": \"stringAttributeKey\", \"value\": \"value\", \"lastUpdateTs\": 1609459200000},\n  {\"key\": \"booleanAttributeKey\", \"value\": false, \"lastUpdateTs\": 1609459200001},\n  {\"key\": \"doubleAttributeKey\", \"value\": 42.2, \"lastUpdateTs\": 1609459200002},\n  {\"key\": \"longKeyExample\", \"value\": 73, \"lastUpdateTs\": 1609459200003},\n  {\"key\": \"jsonKeyExample\",\n    \"value\": {\n      \"someNumber\": 42,\n      \"someArray\": [1,2,3],\n      \"someNestedObject\": {\"key\": \"value\"}\n    },\n    \"lastUpdateTs\": 1609459200004\n  }\n]\n```\n\n Referencing a non-existing entity Id or invalid entity type will cause an error. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityType}/{entityId}/values/attributes"}, method={RequestMethod.GET})
    @ResponseBody
    public DeferredResult<ResponseEntity> getAttributes(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true, schema=@Schema(defaultValue="DEVICE")) @PathVariable(value="entityType") String entityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String entityIdStr, @Parameter(description="A string value representing the comma-separated list of attributes keys. For example, 'active,inactivityAlarmTime'.") @RequestParam(name="keys", required=false) String keysStr) throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        return this.accessValidator.validateEntityAndCallback(this.getCurrentUser(), Operation.READ_ATTRIBUTES, entityType, entityIdStr, (result, tenantId, entityId) -> this.getAttributeValuesCallback(result, user, entityId, null, keysStr));
    }

    @ApiOperation(value="Get attributes by scope (getAttributesByScope)", notes="Returns all attributes of a specified scope that belong to specified entity. List of possible attribute scopes depends on the entity type: \n\n * SERVER_SCOPE - supported for all entity types;\n * SHARED_SCOPE - supported for devices;\n * CLIENT_SCOPE - supported for devices. \n\nUse optional 'keys' parameter to return specific attributes.\n Example of the result: \n\n```json\n[\n  {\"key\": \"stringAttributeKey\", \"value\": \"value\", \"lastUpdateTs\": 1609459200000},\n  {\"key\": \"booleanAttributeKey\", \"value\": false, \"lastUpdateTs\": 1609459200001},\n  {\"key\": \"doubleAttributeKey\", \"value\": 42.2, \"lastUpdateTs\": 1609459200002},\n  {\"key\": \"longKeyExample\", \"value\": 73, \"lastUpdateTs\": 1609459200003},\n  {\"key\": \"jsonKeyExample\",\n    \"value\": {\n      \"someNumber\": 42,\n      \"someArray\": [1,2,3],\n      \"someNestedObject\": {\"key\": \"value\"}\n    },\n    \"lastUpdateTs\": 1609459200004\n  }\n]\n```\n\n Referencing a non-existing entity Id or invalid entity type will cause an error. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityType}/{entityId}/values/attributes/{scope}"}, method={RequestMethod.GET})
    @ResponseBody
    public DeferredResult<ResponseEntity> getAttributesByScope(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true, schema=@Schema(defaultValue="DEVICE")) @PathVariable(value="entityType") String entityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String entityIdStr, @Parameter(description="A string value representing the attributes scope. For example, 'SERVER_SCOPE'.", schema=@Schema(allowableValues={"SERVER_SCOPE", "SHARED_SCOPE", "CLIENT_SCOPE"}, requiredMode=Schema.RequiredMode.REQUIRED)) @PathVariable(value="scope") AttributeScope scope, @Parameter(description="A string value representing the comma-separated list of attributes keys. For example, 'active,inactivityAlarmTime'.") @RequestParam(name="keys", required=false) String keysStr) throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        return this.accessValidator.validateEntityAndCallback(this.getCurrentUser(), Operation.READ_ATTRIBUTES, entityType, entityIdStr, (result, tenantId, entityId) -> this.getAttributeValuesCallback(result, user, entityId, scope, keysStr));
    }

    @ApiOperation(value="Get time series keys (getTimeseriesKeys)", notes="Returns a set of unique time series key names for the selected entity. \n\nReferencing a non-existing entity Id or invalid entity type will cause an error. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityType}/{entityId}/keys/timeseries"}, method={RequestMethod.GET})
    @ResponseBody
    public DeferredResult<ResponseEntity> getTimeseriesKeys(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true, schema=@Schema(defaultValue="DEVICE")) @PathVariable(value="entityType") String entityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String entityIdStr) throws ThingsboardException {
        return this.accessValidator.validateEntityAndCallback(this.getCurrentUser(), Operation.READ_TELEMETRY, entityType, entityIdStr, (result, tenantId, entityId) -> Futures.addCallback((ListenableFuture)this.tsService.findAllLatest(tenantId, entityId), (FutureCallback)this.getTsKeysToResponseCallback(result), (Executor)MoreExecutors.directExecutor()));
    }

    @ApiOperation(value="Get latest time series value (getLatestTimeseries)", notes="Returns all time series that belong to specified entity. Use optional 'keys' parameter to return specific time series. The result is a JSON object. The format of the values depends on the 'useStrictDataTypes' parameter. By default, all time series values are converted to strings: \n\n```json\n{\n  \"stringTsKey\": [{ \"value\": \"value\", \"ts\": 1609459200000}],\n  \"booleanTsKey\": [{ \"value\": \"false\", \"ts\": 1609459200000}],\n  \"doubleTsKey\": [{ \"value\": \"42.2\", \"ts\": 1609459200000}],\n  \"longTsKey\": [{ \"value\": \"73\", \"ts\": 1609459200000}],\n  \"jsonTsKey\": [{ \"value\": \"{\\\"someNumber\\\": 42,\\\"someArray\\\": [1,2,3],\\\"someNestedObject\\\": {\\\"key\\\": \\\"value\\\"}}\", \"ts\": 1609459200000}]\n}\n\n```\n\n However, it is possible to request the values without conversion ('useStrictDataTypes'=true): \n\n```json\n{\n  \"stringTsKey\": [{ \"value\": \"value\", \"ts\": 1609459200000}],\n  \"booleanTsKey\": [{ \"value\": false, \"ts\": 1609459200000}],\n  \"doubleTsKey\": [{ \"value\": 42.2, \"ts\": 1609459200000}],\n  \"longTsKey\": [{ \"value\": 73, \"ts\": 1609459200000}],\n  \"jsonTsKey\": [{ \n    \"value\": {\n      \"someNumber\": 42,\n      \"someArray\": [1,2,3],\n      \"someNestedObject\": {\"key\": \"value\"}\n    }, \n    \"ts\": 1609459200000}]\n}\n\n```\n\n Referencing a non-existing entity Id or invalid entity type will cause an error. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityType}/{entityId}/values/timeseries"}, method={RequestMethod.GET})
    @ResponseBody
    public DeferredResult<ResponseEntity> getLatestTimeseries(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true, schema=@Schema(defaultValue="DEVICE")) @PathVariable(value="entityType") String entityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String entityIdStr, @Parameter(description="A string value representing the comma-separated list of telemetry keys. If keys are not selected, the result will return all latest time series. For example, 'temperature,humidity'.") @RequestParam(name="keys", required=false) String keysStr, @Parameter(description="Enables/disables conversion of telemetry values to strings. Conversion is enabled by default. Set parameter to 'true' in order to disable the conversion.") @RequestParam(name="useStrictDataTypes", required=false, defaultValue="false") Boolean useStrictDataTypes) throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        return this.accessValidator.validateEntityAndCallback(this.getCurrentUser(), Operation.READ_TELEMETRY, entityType, entityIdStr, (result, tenantId, entityId) -> this.getLatestTimeseriesValuesCallback(result, user, entityId, keysStr, useStrictDataTypes));
    }

    @ApiOperation(value="Get time series data (getTimeseries)", notes="Returns a range of time series values for specified entity. Returns not aggregated data by default. Use aggregation function ('agg') and aggregation interval ('interval') to enable aggregation of the results on the database / server side. The aggregation is generally more efficient then fetching all records. \n\n```json\n{\n  \"temperature\": [\n    {\n      \"value\": 36.7,\n      \"ts\": 1609459200000\n    },\n    {\n      \"value\": 36.6,\n      \"ts\": 1609459201000\n    }\n  ]\n}\n```\n\nReferencing a non-existing entity Id or invalid entity type will cause an error. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityType}/{entityId}/values/timeseries"}, method={RequestMethod.GET}, params={"keys", "startTs", "endTs"})
    @ResponseBody
    public DeferredResult<ResponseEntity> getTimeseries(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true, schema=@Schema(defaultValue="DEVICE")) @PathVariable(value="entityType") String entityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String entityIdStr, @Parameter(description="A string value representing the comma-separated list of telemetry keys.", required=true) @RequestParam(name="keys") String keys, @Parameter(description="A long value representing the start timestamp of the time range in milliseconds, UTC.") @RequestParam(name="startTs") Long startTs, @Parameter(description="A long value representing the end timestamp of the time range in milliseconds, UTC.") @RequestParam(name="endTs") Long endTs, @Parameter(description="A string value representing the type fo the interval.", schema=@Schema(allowableValues={"MILLISECONDS", "WEEK", "WEEK_ISO", "MONTH", "QUARTER"})) @RequestParam(name="intervalType", required=false) IntervalType intervalType, @Parameter(description="A long value representing the aggregation interval range in milliseconds.") @RequestParam(name="interval", defaultValue="0") Long interval, @Parameter(description="A string value representing the timezone that will be used to calculate exact timestamps for 'WEEK', 'WEEK_ISO', 'MONTH' and 'QUARTER' interval types.") @RequestParam(name="timeZone", required=false) String timeZone, @Parameter(description="An integer value that represents a max number of time series data points to fetch. This parameter is used only in the case if 'agg' parameter is set to 'NONE'.", schema=@Schema(defaultValue="100")) @RequestParam(name="limit", defaultValue="100") Integer limit, @Parameter(description="A string value representing the aggregation function. If the interval is not specified, 'agg' parameter will use 'NONE' value.", schema=@Schema(allowableValues={"MIN", "MAX", "AVG", "SUM", "COUNT", "NONE"})) @RequestParam(name="agg", defaultValue="NONE") String aggStr, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(name="orderBy", defaultValue="DESC") String orderBy, @Parameter(description="Enables/disables conversion of telemetry values to strings. Conversion is enabled by default. Set parameter to 'true' in order to disable the conversion.") @RequestParam(name="useStrictDataTypes", required=false, defaultValue="false") Boolean useStrictDataTypes) throws ThingsboardException {
        DeferredResult response = new DeferredResult();
        Futures.addCallback((ListenableFuture)this.tbTelemetryService.getTimeseries(EntityIdFactory.getByTypeAndId((String)entityType, (String)entityIdStr), this.toKeysList(keys), startTs, endTs, intervalType, interval, timeZone, limit, Aggregation.valueOf((String)aggStr), orderBy, useStrictDataTypes, this.getCurrentUser()), (FutureCallback)this.getTsKvListCallback(response, useStrictDataTypes), (Executor)MoreExecutors.directExecutor());
        return response;
    }

    @ApiOperation(value="Get time series data by read queries (getTimeseriesByReadTsKvQueries)", notes="Returns aggregated time series values according to queries for specified entity. ```json\n[\n  {\n    \"queryId\": 49,\n    \"data\": [\n      {\n        \"ts\": 1751450399999,\n        \"kv\": {\n          \"key\": \"temperature\",\n          \"value\": 26,\n          \"doubleValue\": 26,\n          \"valueAsString\": \"26.0\",\n          \"dataType\": \"DOUBLE\",\n          \"longValue\": null,\n          \"booleanValue\": null,\n          \"jsonValue\": null,\n          \"strValue\": null\n        },\n        \"version\": null\n      }\n    ],\n    \"lastEntryTs\": 1750264592675\n  },\n  {\n    \"queryId\": 50,\n    \"data\": [],\n    \"lastEntryTs\": 1751317200000\n  }\n]\n```\n\nReferencing a non-existing entity Id or invalid entity type will cause an error. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/{entityType}/{entityId}/values/timeseries"})
    public DeferredResult<ResponseEntity> getTimeseriesByReadTsKvQueries(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true, schema=@Schema(defaultValue="DEVICE")) @PathVariable(value="entityType") String entityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String entityIdStr, @org.springframework.web.bind.annotation.RequestBody List<BaseReadTsKvQuery> queries) throws ThingsboardException {
        DeferredResult response = new DeferredResult();
        Futures.addCallback((ListenableFuture)this.tbTelemetryService.getTimeseriesByReadQueries(EntityIdFactory.getByTypeAndId((String)entityType, (String)entityIdStr), queries, this.getCurrentUser()), (FutureCallback)this.getReadTsKvQueryResult(response), (Executor)MoreExecutors.directExecutor());
        return response;
    }

    @ApiOperation(value="Save device attributes (saveDeviceAttributes)", notes="Creates or updates the device attributes based on device id and specified attribute scope. The request payload is a JSON object with key-value format of attributes to create or update. For example:\n\n```json\n{\n \"stringKey\":\"value1\", \n \"booleanKey\":true, \n \"doubleKey\":42.0, \n \"longKey\":73, \n \"jsonKey\": {\n    \"someNumber\": 42,\n    \"someArray\": [1,2,3],\n    \"someNestedObject\": {\"key\": \"value\"}\n }\n}\n```\n\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Attribute from the request was created or updated. Platform creates an audit log event about device attributes updates with action type 'ATTRIBUTES_UPDATED', and also sends event msg to the rule engine with msg type 'ATTRIBUTES_UPDATED'."), @ApiResponse(responseCode="400", description="Invalid structure of the request or invalid attributes scope provided."), @ApiResponse(responseCode="401", description="User is not authorized to save device attributes for selected device. Most likely, User belongs to different Customer or Tenant."), @ApiResponse(responseCode="500", description="The exception was thrown during processing the request. Platform creates an audit log event about device attributes updates with action type 'ATTRIBUTES_UPDATED' that includes an error stacktrace.")})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/{deviceId}/{scope}"})
    public DeferredResult<ResponseEntity> saveDeviceAttributes(@Parameter(description="A string value representing the device id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="deviceId") String deviceIdStr, @Parameter(description="A string value representing the attributes scope. For example, 'SERVER_SCOPE'.", schema=@Schema(allowableValues={"SERVER_SCOPE", "SHARED_SCOPE"}, requiredMode=Schema.RequiredMode.REQUIRED)) @PathVariable(value="scope") AttributeScope scope, @RequestBody(description="A string value representing the json object. For example, '{\"key\":\"value\"}'. See API call description for more details.", required=true) @org.springframework.web.bind.annotation.RequestBody String request) throws ThingsboardException {
        EntityId entityId = EntityIdFactory.getByTypeAndUuid((EntityType)EntityType.DEVICE, (String)deviceIdStr);
        return this.saveAttributes(this.getTenantId(), entityId, scope, request);
    }

    @ApiOperation(value="Save entity attributes (saveEntityAttributesV1)", notes="Creates or updates the entity attributes based on Entity Id and the specified attribute scope.  List of possible attribute scopes depends on the entity type: \n\n * SERVER_SCOPE - supported for all entity types;\n * SHARED_SCOPE - supported for devices.\n\nThe request payload is a JSON object with key-value format of attributes to create or update. For example:\n\n```json\n{\n \"stringKey\":\"value1\", \n \"booleanKey\":true, \n \"doubleKey\":42.0, \n \"longKey\":73, \n \"jsonKey\": {\n    \"someNumber\": 42,\n    \"someArray\": [1,2,3],\n    \"someNestedObject\": {\"key\": \"value\"}\n }\n}\n```\nReferencing a non-existing entity Id or invalid entity type will cause an error. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Attribute from the request was created or updated. Platform creates an audit log event about entity attributes updates with action type 'ATTRIBUTES_UPDATED', and also sends event msg to the rule engine with msg type 'ATTRIBUTES_UPDATED'."), @ApiResponse(responseCode="400", description="Invalid structure of the request or invalid attributes scope provided."), @ApiResponse(responseCode="401", description="User is not authorized to save entity attributes for selected entity. Most likely, User belongs to different Customer or Tenant."), @ApiResponse(responseCode="500", description="The exception was thrown during processing the request. Platform creates an audit log event about entity attributes updates with action type 'ATTRIBUTES_UPDATED' that includes an error stacktrace.")})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/{entityType}/{entityId}/{scope}"})
    public DeferredResult<ResponseEntity> saveEntityAttributesV1(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true, schema=@Schema(defaultValue="DEVICE")) @PathVariable(value="entityType") String entityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String entityIdStr, @Parameter(description="A string value representing the attributes scope. For example, 'SERVER_SCOPE'.", schema=@Schema(allowableValues={"SERVER_SCOPE", "SHARED_SCOPE"})) @PathVariable(value="scope") AttributeScope scope, @RequestBody(description="A string value representing the json object. For example, '{\"key\":\"value\"}'. See API call description for more details.", required=true) @org.springframework.web.bind.annotation.RequestBody String request) throws ThingsboardException {
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)entityType, (String)entityIdStr);
        return this.saveAttributes(this.getTenantId(), entityId, scope, request);
    }

    @ApiOperation(value="Save entity attributes (saveEntityAttributesV2)", notes="Creates or updates the entity attributes based on Entity Id and the specified attribute scope.  List of possible attribute scopes depends on the entity type: \n\n * SERVER_SCOPE - supported for all entity types;\n * SHARED_SCOPE - supported for devices.\n\nThe request payload is a JSON object with key-value format of attributes to create or update. For example:\n\n```json\n{\n \"stringKey\":\"value1\", \n \"booleanKey\":true, \n \"doubleKey\":42.0, \n \"longKey\":73, \n \"jsonKey\": {\n    \"someNumber\": 42,\n    \"someArray\": [1,2,3],\n    \"someNestedObject\": {\"key\": \"value\"}\n }\n}\n```\nReferencing a non-existing entity Id or invalid entity type will cause an error. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Attribute from the request was created or updated. Platform creates an audit log event about entity attributes updates with action type 'ATTRIBUTES_UPDATED', and also sends event msg to the rule engine with msg type 'ATTRIBUTES_UPDATED'."), @ApiResponse(responseCode="400", description="Invalid structure of the request or invalid attributes scope provided."), @ApiResponse(responseCode="401", description="User is not authorized to save entity attributes for selected entity. Most likely, User belongs to different Customer or Tenant."), @ApiResponse(responseCode="500", description="The exception was thrown during processing the request. Platform creates an audit log event about entity attributes updates with action type 'ATTRIBUTES_UPDATED' that includes an error stacktrace.")})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/{entityType}/{entityId}/attributes/{scope}"})
    public DeferredResult<ResponseEntity> saveEntityAttributesV2(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true, schema=@Schema(defaultValue="DEVICE")) @PathVariable(value="entityType") String entityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String entityIdStr, @Parameter(description="A string value representing the attributes scope. For example, 'SERVER_SCOPE'.", schema=@Schema(allowableValues={"SERVER_SCOPE", "SHARED_SCOPE"}, requiredMode=Schema.RequiredMode.REQUIRED)) @PathVariable(value="scope") AttributeScope scope, @RequestBody(description="A string value representing the json object. For example, '{\"key\":\"value\"}'. See API call description for more details.", required=true) @org.springframework.web.bind.annotation.RequestBody String request) throws ThingsboardException {
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)entityType, (String)entityIdStr);
        return this.saveAttributes(this.getTenantId(), entityId, scope, request);
    }

    @ApiOperation(value="Save or update time series data (saveEntityTelemetry)", notes="Creates or updates the entity time series data based on the Entity Id and request payload.The request payload is a JSON document with three possible formats:\n\nSimple format without timestamp. In such a case, current server time will be used: \n\n```json\n{\"temperature\": 26}\n```\n\n Single JSON object with timestamp: \n\n```json\n{\"ts\":1634712287000,\"values\":{\"temperature\":26, \"humidity\":87}}\n```\n\n JSON array with timestamps: \n\n```json\n[{\"ts\":1634712287000,\"values\":{\"temperature\":26, \"humidity\":87}}, {\"ts\":1634712588000,\"values\":{\"temperature\":25, \"humidity\":88}}]\n```\n\n The scope parameter is not used in the API call implementation but should be specified whatever value because it is used as a path variable. Referencing a non-existing entity Id or invalid entity type will cause an error. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Time series from the request was created or updated. Platform creates an audit log event about entity time series updates with action type 'TIMESERIES_UPDATED'."), @ApiResponse(responseCode="400", description="Invalid structure of the request"), @ApiResponse(responseCode="401", description="User is not authorized to save entity time series for selected entity. Most likely, User belongs to different Customer or Tenant."), @ApiResponse(responseCode="500", description="The exception was thrown during processing the request. Platform creates an audit log event about entity time series updates with action type 'TIMESERIES_UPDATED' that includes an error stacktrace.")})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityType}/{entityId}/timeseries/{scope}"}, method={RequestMethod.POST})
    @ResponseBody
    public DeferredResult<ResponseEntity> saveEntityTelemetry(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true, schema=@Schema(defaultValue="DEVICE")) @PathVariable(value="entityType") String entityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String entityIdStr, @Parameter(description="Value is deprecated, reserved for backward compatibility and not used in the API call implementation. Specify any scope for compatibility", required=true, schema=@Schema(allowableValues={"ANY"})) @PathVariable(value="scope") String scope, @RequestBody(description="A JSON with the telemetry values. See API call description for more details.", required=true) @org.springframework.web.bind.annotation.RequestBody String requestBody) throws ThingsboardException {
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)entityType, (String)entityIdStr);
        return this.saveTelemetry(this.getTenantId(), entityId, requestBody, 0L);
    }

    @ApiOperation(value="Save or update time series data with TTL (saveEntityTelemetryWithTTL)", notes="Creates or updates the entity time series data based on the Entity Id and request payload.The request payload is a JSON document with three possible formats:\n\nSimple format without timestamp. In such a case, current server time will be used: \n\n```json\n{\"temperature\": 26}\n```\n\n Single JSON object with timestamp: \n\n```json\n{\"ts\":1634712287000,\"values\":{\"temperature\":26, \"humidity\":87}}\n```\n\n JSON array with timestamps: \n\n```json\n[{\"ts\":1634712287000,\"values\":{\"temperature\":26, \"humidity\":87}}, {\"ts\":1634712588000,\"values\":{\"temperature\":25, \"humidity\":88}}]\n```\n\n The scope parameter is not used in the API call implementation but should be specified whatever value because it is used as a path variable. \n\nThe ttl parameter takes affect only in case of Cassandra DB.Referencing a non-existing entity Id or invalid entity type will cause an error. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Time series from the request was created or updated. Platform creates an audit log event about entity time series updates with action type 'TIMESERIES_UPDATED'."), @ApiResponse(responseCode="400", description="Invalid structure of the request"), @ApiResponse(responseCode="401", description="User is not authorized to save entity time series for selected entity. Most likely, User belongs to different Customer or Tenant."), @ApiResponse(responseCode="500", description="The exception was thrown during processing the request. Platform creates an audit log event about entity time series updates with action type 'TIMESERIES_UPDATED' that includes an error stacktrace.")})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityType}/{entityId}/timeseries/{scope}/{ttl}"}, method={RequestMethod.POST})
    @ResponseBody
    public DeferredResult<ResponseEntity> saveEntityTelemetryWithTTL(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true, schema=@Schema(defaultValue="DEVICE")) @PathVariable(value="entityType") String entityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String entityIdStr, @Parameter(description="Value is deprecated, reserved for backward compatibility and not used in the API call implementation. Specify any scope for compatibility", required=true, schema=@Schema(allowableValues={"ANY"})) @PathVariable(value="scope") String scope, @Parameter(description="A long value representing TTL (Time to Live) parameter.", required=true) @PathVariable(value="ttl") Long ttl, @RequestBody(description="A JSON with the telemetry values. See API call description for more details.", required=true) @org.springframework.web.bind.annotation.RequestBody String requestBody) throws ThingsboardException {
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)entityType, (String)entityIdStr);
        return this.saveTelemetry(this.getTenantId(), entityId, requestBody, ttl.longValue());
    }

    @ApiOperation(value="Delete entity time series data (deleteEntityTimeseries)", notes="Delete time series for selected entity based on entity id, entity type and keys. Use 'deleteAllDataForKeys' to delete all time series data. Use 'startTs' and 'endTs' to specify time-range instead.  Use 'deleteLatest' to delete latest value (stored in separate table for performance) if the value's timestamp matches the time-range.  Use 'rewriteLatestIfDeleted' to rewrite latest value (stored in separate table for performance) if the value's timestamp matches the time-range and 'deleteLatest' param is true. The replacement value will be fetched from the 'time series' table, and its timestamp will be the most recent one before the defined time-range. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Time series for the selected keys in the request was removed. Platform creates an audit log event about entity time series removal with action type 'TIMESERIES_DELETED'."), @ApiResponse(responseCode="400", description="Platform returns a bad request in case if keys list is empty or start and end timestamp values is empty when deleteAllDataForKeys is set to false."), @ApiResponse(responseCode="401", description="User is not authorized to delete entity time series for selected entity. Most likely, User belongs to different Customer or Tenant."), @ApiResponse(responseCode="500", description="The exception was thrown during processing the request. Platform creates an audit log event about entity time series removal with action type 'TIMESERIES_DELETED' that includes an error stacktrace.")})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityType}/{entityId}/timeseries/delete"}, method={RequestMethod.DELETE})
    @ResponseBody
    public DeferredResult<ResponseEntity> deleteEntityTimeseries(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true, schema=@Schema(defaultValue="DEVICE")) @PathVariable(value="entityType") String entityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String entityIdStr, @Parameter(description="A string value representing the comma-separated list of telemetry keys. If keys are not selected, the result will return all latest time series. For example, 'temperature,humidity'.", required=true) @RequestParam(name="keys") String keysStr, @Parameter(description="A boolean value to specify if should be deleted all data for selected keys or only data that are in the selected time range.") @RequestParam(name="deleteAllDataForKeys", defaultValue="false") boolean deleteAllDataForKeys, @Parameter(description="A long value representing the start timestamp of removal time range in milliseconds.") @RequestParam(name="startTs", required=false) Long startTs, @Parameter(description="A long value representing the end timestamp of removal time range in milliseconds.") @RequestParam(name="endTs", required=false) Long endTs, @Parameter(description="If the parameter is set to true, the latest telemetry can be removed, otherwise, in case that parameter is set to false the latest value will not removed.") @RequestParam(name="deleteLatest", required=false, defaultValue="true") boolean deleteLatest, @Parameter(description="If the parameter is set to true, the latest telemetry will be rewritten in case that current latest value was removed, otherwise, in case that parameter is set to false the new latest value will not set.") @RequestParam(name="rewriteLatestIfDeleted", defaultValue="false") boolean rewriteLatestIfDeleted) throws ThingsboardException {
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)entityType, (String)entityIdStr);
        return this.deleteTimeseries(entityId, keysStr, deleteAllDataForKeys, startTs, endTs, rewriteLatestIfDeleted, deleteLatest);
    }

    private DeferredResult<ResponseEntity> deleteTimeseries(EntityId entityIdStr, String keysStr, boolean deleteAllDataForKeys, Long startTs, Long endTs, boolean rewriteLatestIfDeleted, boolean deleteLatest) throws ThingsboardException {
        long deleteToTs;
        long deleteFromTs;
        List keys = this.toKeysList(keysStr);
        if (keys.isEmpty()) {
            return this.getImmediateDeferredResult("Empty keys: " + keysStr, HttpStatus.BAD_REQUEST);
        }
        SecurityUser user = this.getCurrentUser();
        if (deleteAllDataForKeys) {
            deleteFromTs = 0L;
            deleteToTs = System.currentTimeMillis();
        } else {
            if (startTs == null || endTs == null) {
                return this.getImmediateDeferredResult("When deleteAllDataForKeys is false, start and end timestamp values shouldn't be empty", HttpStatus.BAD_REQUEST);
            }
            deleteFromTs = startTs;
            deleteToTs = endTs;
        }
        return this.accessValidator.validateEntityAndCallback(user, Operation.WRITE_TELEMETRY, entityIdStr, (result, tenantId, entityId) -> {
            ArrayList<BaseDeleteTsKvQuery> deleteTsKvQueries = new ArrayList<BaseDeleteTsKvQuery>();
            for (String key : keys) {
                deleteTsKvQueries.add(new BaseDeleteTsKvQuery(key, deleteFromTs, deleteToTs, rewriteLatestIfDeleted, deleteLatest));
            }
            this.tsSubService.deleteTimeseries(TimeseriesDeleteRequest.builder().tenantId(tenantId).entityId(entityId).keys(keys).deleteHistoryQueries(deleteTsKvQueries).callback((FutureCallback)new /* Unavailable Anonymous Inner Class!! */).build());
        });
    }

    @ApiOperation(value="Delete device attributes (deleteDeviceAttributes)", notes="Delete device attributes using provided Device Id, scope and a list of keys. Referencing a non-existing Device Id will cause an error\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Device attributes was removed for the selected keys in the request. Platform creates an audit log event about device attributes removal with action type 'ATTRIBUTES_DELETED'."), @ApiResponse(responseCode="400", description="Platform returns a bad request in case if keys or scope are not specified."), @ApiResponse(responseCode="401", description="User is not authorized to delete device attributes for selected entity. Most likely, User belongs to different Customer or Tenant."), @ApiResponse(responseCode="500", description="The exception was thrown during processing the request. Platform creates an audit log event about device attributes removal with action type 'ATTRIBUTES_DELETED' that includes an error stacktrace.")})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{deviceId}/{scope}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public DeferredResult<ResponseEntity> deleteDeviceAttributes(@Parameter(description="A string value representing the device id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="deviceId") String deviceIdStr, @Parameter(description="A string value representing the attributes scope. For example, 'SERVER_SCOPE'.", schema=@Schema(allowableValues={"SERVER_SCOPE", "SHARED_SCOPE", "CLIENT_SCOPE"}, requiredMode=Schema.RequiredMode.REQUIRED)) @PathVariable(value="scope") AttributeScope scope, @Parameter(description="A string value representing the comma-separated list of attributes keys. For example, 'active,inactivityAlarmTime'.", required=true) @RequestParam(name="keys") String keysStr) throws ThingsboardException {
        EntityId entityId = EntityIdFactory.getByTypeAndUuid((EntityType)EntityType.DEVICE, (String)deviceIdStr);
        return this.deleteAttributes(entityId, scope, keysStr);
    }

    @ApiOperation(value="Delete entity attributes (deleteEntityAttributes)", notes="Delete entity attributes using provided Entity Id, scope and a list of keys. Referencing a non-existing entity Id or invalid entity type will cause an error. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Entity attributes was removed for the selected keys in the request. Platform creates an audit log event about entity attributes removal with action type 'ATTRIBUTES_DELETED'."), @ApiResponse(responseCode="400", description="Platform returns a bad request in case if keys or scope are not specified."), @ApiResponse(responseCode="401", description="User is not authorized to delete entity attributes for selected entity. Most likely, User belongs to different Customer or Tenant."), @ApiResponse(responseCode="500", description="The exception was thrown during processing the request. Platform creates an audit log event about entity attributes removal with action type 'ATTRIBUTES_DELETED' that includes an error stacktrace.")})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityType}/{entityId}/{scope}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public DeferredResult<ResponseEntity> deleteEntityAttributes(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true, schema=@Schema(defaultValue="DEVICE")) @PathVariable(value="entityType") String entityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String entityIdStr, @Parameter(description="A string value representing the attributes scope. For example, 'SERVER_SCOPE'.", required=true, schema=@Schema(allowableValues={"SERVER_SCOPE", "SHARED_SCOPE", "CLIENT_SCOPE"})) @PathVariable(value="scope") AttributeScope scope, @Parameter(description="A string value representing the comma-separated list of attributes keys. For example, 'active,inactivityAlarmTime'.", required=true) @RequestParam(name="keys") String keysStr) throws ThingsboardException {
        EntityId entityId = EntityIdFactory.getByTypeAndId((String)entityType, (String)entityIdStr);
        return this.deleteAttributes(entityId, scope, keysStr);
    }

    private DeferredResult<ResponseEntity> deleteAttributes(EntityId entityIdSrc, AttributeScope scope, String keysStr) throws ThingsboardException {
        List keys = this.toKeysList(keysStr);
        if (keys.isEmpty()) {
            return this.getImmediateDeferredResult("Empty keys: " + keysStr, HttpStatus.BAD_REQUEST);
        }
        SecurityUser user = this.getCurrentUser();
        return this.accessValidator.validateEntityAndCallback(this.getCurrentUser(), Operation.WRITE_ATTRIBUTES, entityIdSrc, (result, tenantId, entityId) -> this.tsSubService.deleteAttributes(AttributesDeleteRequest.builder().tenantId(tenantId).entityId(entityId).scope(scope).keys(keys).callback((FutureCallback)new /* Unavailable Anonymous Inner Class!! */).build()));
    }

    private DeferredResult<ResponseEntity> saveAttributes(TenantId srcTenantId, EntityId entityIdSrc, AttributeScope scope, String jsonStr) throws ThingsboardException {
        JsonElement json;
        if (AttributeScope.SERVER_SCOPE != scope && AttributeScope.SHARED_SCOPE != scope) {
            return this.getImmediateDeferredResult("Invalid scope: " + String.valueOf(scope), HttpStatus.BAD_REQUEST);
        }
        try {
            json = JsonParser.parseString((String)jsonStr);
        }
        catch (Exception e) {
            return this.getImmediateDeferredResult("Invalid JSON", HttpStatus.BAD_REQUEST);
        }
        if (json.isJsonObject()) {
            List attributes = JsonConverter.convertToAttributes((JsonElement)json);
            if (attributes.isEmpty()) {
                return this.getImmediateDeferredResult("No attributes data found in request body!", HttpStatus.BAD_REQUEST);
            }
            for (AttributeKvEntry attributeKvEntry : attributes) {
                if (!attributeKvEntry.getKey().isBlank()) continue;
                return this.getImmediateDeferredResult("Key cannot be blank", HttpStatus.BAD_REQUEST);
            }
            SecurityUser user = this.getCurrentUser();
            return this.accessValidator.validateEntityAndCallback(this.getCurrentUser(), Operation.WRITE_ATTRIBUTES, entityIdSrc, (result, tenantId, entityId) -> this.tsSubService.saveAttributes(AttributesSaveRequest.builder().tenantId(tenantId).entityId(entityId).scope(scope).entries(attributes).callback((FutureCallback)new /* Unavailable Anonymous Inner Class!! */).build()));
        }
        return this.getImmediateDeferredResult("Request is not a JSON object", HttpStatus.BAD_REQUEST);
    }

    private DeferredResult<ResponseEntity> saveTelemetry(TenantId curTenantId, EntityId entityIdSrc, String requestBody, long ttl) throws ThingsboardException {
        Map telemetryRequest;
        JsonElement telemetryJson;
        try {
            telemetryJson = JsonParser.parseString((String)requestBody);
        }
        catch (Exception e) {
            return this.getImmediateDeferredResult("Unable to parse time series payload: Invalid JSON body!", HttpStatus.BAD_REQUEST);
        }
        try {
            telemetryRequest = JsonConverter.convertToTelemetry((JsonElement)telemetryJson, (long)System.currentTimeMillis());
        }
        catch (Exception e) {
            return this.getImmediateDeferredResult("Unable to parse time series payload. Invalid JSON body: " + e.getMessage(), HttpStatus.BAD_REQUEST);
        }
        ArrayList<BasicTsKvEntry> entries = new ArrayList<BasicTsKvEntry>();
        for (Map.Entry entry : telemetryRequest.entrySet()) {
            for (KvEntry kv : (List)entry.getValue()) {
                entries.add(new BasicTsKvEntry(((Long)entry.getKey()).longValue(), kv));
            }
        }
        if (entries.isEmpty()) {
            return this.getImmediateDeferredResult("No time series data found in request body!", HttpStatus.BAD_REQUEST);
        }
        SecurityUser user = this.getCurrentUser();
        return this.accessValidator.validateEntityAndCallback(this.getCurrentUser(), Operation.WRITE_TELEMETRY, entityIdSrc, (result, tenantId, entityId) -> {
            long tenantTtl = ttl;
            if (!TenantId.SYS_TENANT_ID.equals(tenantId) && tenantTtl == 0L) {
                TenantProfile tenantProfile = this.tenantProfileCache.get(tenantId);
                tenantTtl = TimeUnit.DAYS.toSeconds(((DefaultTenantProfileConfiguration)tenantProfile.getProfileData().getConfiguration()).getDefaultStorageTtlDays());
            }
            this.tsSubService.saveTimeseries(TimeseriesSaveRequest.builder().tenantId(tenantId).customerId(user.getCustomerId()).entityId(entityId).entries(entries).ttl(tenantTtl).callback((FutureCallback)new /* Unavailable Anonymous Inner Class!! */).build());
        });
    }

    private void getLatestTimeseriesValuesCallback(@Nullable DeferredResult<ResponseEntity> result, SecurityUser user, EntityId entityId, String keys, Boolean useStrictDataTypes) {
        ListenableFuture future = StringUtils.isEmpty((String)keys) ? this.tsService.findAllLatest(user.getTenantId(), entityId) : this.tsService.findLatest(user.getTenantId(), entityId, (Collection)this.toKeysList(keys));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)this.getTsKvListCallback(result, useStrictDataTypes), (Executor)MoreExecutors.directExecutor());
    }

    private void getAttributeValuesCallback(@Nullable DeferredResult<ResponseEntity> result, SecurityUser user, EntityId entityId, AttributeScope scope, String keys) {
        List keyList = this.toKeysList(keys);
        FutureCallback callback = this.getAttributeValuesToResponseCallback(result, user, scope, entityId, keyList);
        if (scope != null) {
            if (keyList != null && !keyList.isEmpty()) {
                Futures.addCallback((ListenableFuture)this.attributesService.find(user.getTenantId(), entityId, scope, (Collection)keyList), (FutureCallback)callback, (Executor)MoreExecutors.directExecutor());
            } else {
                Futures.addCallback((ListenableFuture)this.attributesService.findAll(user.getTenantId(), entityId, scope), (FutureCallback)callback, (Executor)MoreExecutors.directExecutor());
            }
        } else {
            ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
            for (AttributeScope tmpScope : AttributeScope.values()) {
                if (keyList != null && !keyList.isEmpty()) {
                    futures.add(this.attributesService.find(user.getTenantId(), entityId, tmpScope, (Collection)keyList));
                    continue;
                }
                futures.add(this.attributesService.findAll(user.getTenantId(), entityId, tmpScope));
            }
            ListenableFuture future = this.mergeAllAttributesFutures(futures);
            Futures.addCallback((ListenableFuture)future, (FutureCallback)callback, (Executor)MoreExecutors.directExecutor());
        }
    }

    private void getAttributeKeysCallback(@Nullable DeferredResult<ResponseEntity> result, TenantId tenantId, EntityId entityId, AttributeScope scope) {
        Futures.addCallback((ListenableFuture)this.attributesService.findAll(tenantId, entityId, scope), (FutureCallback)this.getAttributeKeysToResponseCallback(result), (Executor)MoreExecutors.directExecutor());
    }

    private void getAttributeKeysCallback(@Nullable DeferredResult<ResponseEntity> result, TenantId tenantId, EntityId entityId) {
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        for (AttributeScope scope : AttributeScope.values()) {
            futures.add(this.attributesService.findAll(tenantId, entityId, scope));
        }
        ListenableFuture future = this.mergeAllAttributesFutures(futures);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)this.getAttributeKeysToResponseCallback(result), (Executor)MoreExecutors.directExecutor());
    }

    private FutureCallback<List<TsKvEntry>> getTsKeysToResponseCallback(DeferredResult<ResponseEntity> response) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private FutureCallback<List<AttributeKvEntry>> getAttributeKeysToResponseCallback(DeferredResult<ResponseEntity> response) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private FutureCallback<List<AttributeKvEntry>> getAttributeValuesToResponseCallback(DeferredResult<ResponseEntity> response, SecurityUser user, AttributeScope scope, EntityId entityId, List<String> keyList) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private FutureCallback<List<TsKvEntry>> getTsKvListCallback(DeferredResult<ResponseEntity> response, Boolean useStrictDataTypes) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private FutureCallback<List<ReadTsKvQueryResult>> getReadTsKvQueryResult(DeferredResult<ResponseEntity> response) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void logTimeseriesDeleted(SecurityUser user, EntityId entityId, List<String> keys, long startTs, long endTs, Throwable e) {
        this.logEntityActionService.logEntityAction(user.getTenantId(), entityId, ActionType.TIMESERIES_DELETED, (User)user, TelemetryController.toException((Throwable)e), new Object[]{keys, startTs, endTs});
    }

    private void logTelemetryUpdated(SecurityUser user, EntityId entityId, List<TsKvEntry> telemetry, Throwable e) {
        this.logEntityActionService.logEntityAction(user.getTenantId(), entityId, ActionType.TIMESERIES_UPDATED, (User)user, TelemetryController.toException((Throwable)e), new Object[]{telemetry});
    }

    private void logAttributesDeleted(SecurityUser user, EntityId entityId, AttributeScope scope, List<String> keys, Throwable e) {
        this.logEntityActionService.logEntityAction(user.getTenantId(), (EntityId)((UUIDBased)entityId), ActionType.ATTRIBUTES_DELETED, (User)user, TelemetryController.toException((Throwable)e), new Object[]{scope, keys});
    }

    private void logAttributesUpdated(SecurityUser user, EntityId entityId, AttributeScope scope, List<AttributeKvEntry> attributes, Throwable e) {
        this.logEntityActionService.logEntityAction(user.getTenantId(), entityId, ActionType.ATTRIBUTES_UPDATED, (User)user, TelemetryController.toException((Throwable)e), new Object[]{scope, attributes});
    }

    private void logAttributesRead(SecurityUser user, EntityId entityId, AttributeScope scope, List<String> keys, Throwable e) {
        this.logEntityActionService.logEntityAction(user.getTenantId(), entityId, ActionType.ATTRIBUTES_READ, (User)user, TelemetryController.toException((Throwable)e), new Object[]{scope, keys});
    }

    private ListenableFuture<List<AttributeKvEntry>> mergeAllAttributesFutures(List<ListenableFuture<List<AttributeKvEntry>>> futures) {
        return Futures.transform((ListenableFuture)Futures.successfulAsList(futures), input -> {
            ArrayList tmp = new ArrayList();
            if (input != null) {
                input.forEach(tmp::addAll);
            }
            return tmp;
        }, (Executor)this.executor);
    }

    private List<String> toKeysList(String keys) {
        List<String> keyList = null;
        if (!StringUtils.isEmpty((String)keys)) {
            keyList = Arrays.asList(keys.split(","));
        }
        return keyList;
    }

    private DeferredResult<ResponseEntity> getImmediateDeferredResult(String message, HttpStatus status) {
        DeferredResult result = new DeferredResult();
        result.setResult((Object)new ResponseEntity((Object)message, (HttpStatusCode)status));
        return result;
    }

    private JsonNode toJsonNode(String value) {
        try {
            return JacksonUtil.toJsonNode((String)value);
        }
        catch (IllegalArgumentException e) {
            throw new JsonParseException("Can't parse jsonValue: " + value, (Throwable)e);
        }
    }

    private Object getKvValue(KvEntry entry) {
        if (entry.getDataType() == DataType.JSON) {
            return this.toJsonNode((String)entry.getJsonValue().get());
        }
        return entry.getValue();
    }
}

