/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.info.BuildProperties;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.common.util.DebugModeUtil;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.SystemParams;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.mobile.qrCodeSettings.QRCodeConfig;
import org.thingsboard.server.common.data.mobile.qrCodeSettings.QrCodeSettings;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.settings.UserSettings;
import org.thingsboard.server.common.data.settings.UserSettingsType;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.mobile.QrCodeSettingService;
import org.thingsboard.server.dao.subscription.SubscriptionService;
import org.thingsboard.server.dao.trendz.TrendzSettingsService;
import org.thingsboard.server.dao.wl.WhiteLabelingService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.UserPrincipal;
import org.thingsboard.server.service.sync.vc.EntitiesVersionControlService;
import org.thingsboard.server.service.translation.TranslationService;
import org.thingsboard.server.utils.DebugModeRateLimitsConfig;

@Hidden
@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class SystemInfoController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemInfoController.class);
    @Value(value="${security.user_token_access_enabled}")
    private boolean userTokenAccessEnabled;
    @Value(value="${tbel.enabled:true}")
    private boolean tbelEnabled;
    @Value(value="${state.persistToTelemetry:false}")
    private boolean persistToTelemetry;
    @Value(value="${ui.dashboard.max_datapoints_limit}")
    private long maxDatapointsLimit;
    @Value(value="${debug.settings.default_duration:15}")
    private int defaultDebugDurationMinutes;
    @Autowired(required=false)
    private BuildProperties buildProperties;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private EntitiesVersionControlService versionControlService;
    @Autowired
    private WhiteLabelingService whiteLabelingService;
    @Autowired
    private TranslationService translationService;
    @Autowired
    private QrCodeSettingService qrCodeSettingService;
    @Autowired
    private DebugModeRateLimitsConfig debugModeRateLimitsConfig;
    @Autowired
    private TrendzSettingsService trendzSettingsService;

    @PostConstruct
    public void init() {
        JsonNode info = this.buildInfoObject();
        log.info("System build info: {}", (Object)info);
    }

    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/system/info"}, method={RequestMethod.GET})
    @ResponseBody
    public JsonNode getSystemVersionInfo() {
        return this.buildInfoObject();
    }

    @RequestMapping(value={"/noauth/system/development"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean isDevelopment() {
        return this.subscriptionService.isDevelopment(TenantId.SYS_TENANT_ID);
    }

    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/system/params"}, method={RequestMethod.GET})
    @ResponseBody
    public SystemParams getSystemParams() throws ThingsboardException {
        ObjectNode userSettingsNode;
        SystemParams systemParams = new SystemParams();
        SecurityUser currentUser = this.getCurrentUser();
        TenantId tenantId = currentUser.getTenantId();
        CustomerId customerId = currentUser.getCustomerId();
        MergedUserPermissions mergedUserPermissions = currentUser.getUserPermissions();
        systemParams.setUserTokenAccessEnabled(this.userTokenAccessEnabled);
        boolean forceFullscreen = this.isForceFullscreen(currentUser);
        if (forceFullscreen && (currentUser.isTenantAdmin() || currentUser.isCustomerUser())) {
            PageLink pageLink = new PageLink(100);
            PageData dashboardsPageData = this.entityService.findUserEntities(tenantId, customerId, mergedUserPermissions, EntityType.DASHBOARD, Operation.READ, null, pageLink, false, true);
            systemParams.setAllowedDashboardIds(dashboardsPageData.getData().stream().map(d -> d.getUuidId().toString()).collect(Collectors.toList()));
        } else {
            systemParams.setAllowedDashboardIds(Collections.emptyList());
        }
        systemParams.setEdgesSupportEnabled(this.edgesEnabled);
        if (currentUser.isTenantAdmin()) {
            systemParams.setHasRepository(this.versionControlService.getVersionControlSettings(tenantId) != null);
            systemParams.setTbelEnabled(this.tbelEnabled);
        } else {
            systemParams.setHasRepository(false);
            systemParams.setTbelEnabled(false);
        }
        if (currentUser.isTenantAdmin() || currentUser.isCustomerUser()) {
            systemParams.setPersistDeviceStateToTelemetry(this.persistToTelemetry);
            systemParams.setWhiteLabelingAllowed(this.whiteLabelingService.isWhiteLabelingAllowed(tenantId, customerId));
            if (currentUser.isTenantAdmin()) {
                systemParams.setCustomerWhiteLabelingAllowed(this.whiteLabelingService.isCustomerWhiteLabelingAllowed(tenantId));
            } else {
                systemParams.setCustomerWhiteLabelingAllowed(false);
            }
        } else {
            systemParams.setPersistDeviceStateToTelemetry(false);
            systemParams.setWhiteLabelingAllowed(false);
            systemParams.setCustomerWhiteLabelingAllowed(false);
        }
        UserSettings userSettings = this.userSettingsService.findUserSettings(currentUser.getTenantId(), currentUser.getId(), UserSettingsType.GENERAL);
        ObjectNode objectNode = userSettingsNode = userSettings == null ? JacksonUtil.newObjectNode() : (ObjectNode)userSettings.getSettings();
        if (!userSettingsNode.has("openedMenuSections")) {
            userSettingsNode.set("openedMenuSections", (JsonNode)JacksonUtil.newArrayNode());
        }
        systemParams.setUserSettings((JsonNode)userSettingsNode);
        systemParams.setMaxDatapointsLimit(this.maxDatapointsLimit);
        if (!currentUser.isSystemAdmin()) {
            DefaultTenantProfileConfiguration tenantProfileConfiguration = this.tenantProfileCache.get(tenantId).getDefaultProfileConfiguration();
            systemParams.setMaxResourceSize(tenantProfileConfiguration.getMaxResourceSize());
            systemParams.setMaxDebugModeDurationMinutes(DebugModeUtil.getMaxDebugAllDuration((int)tenantProfileConfiguration.getMaxDebugModeDurationMinutes(), (int)this.defaultDebugDurationMinutes));
            if (this.debugModeRateLimitsConfig.isRuleChainDebugPerTenantLimitsEnabled()) {
                systemParams.setRuleChainDebugPerTenantLimitsConfiguration(this.debugModeRateLimitsConfig.getRuleChainDebugPerTenantLimitsConfiguration());
            }
            if (this.debugModeRateLimitsConfig.isCalculatedFieldDebugPerTenantLimitsEnabled()) {
                systemParams.setCalculatedFieldDebugPerTenantLimitsConfiguration(this.debugModeRateLimitsConfig.getCalculatedFieldDebugPerTenantLimitsConfiguration());
            }
            if (this.debugModeRateLimitsConfig.isEventRateLimitsEnabled()) {
                systemParams.setIntegrationDebugPerTenantLimitsConfiguration(this.debugModeRateLimitsConfig.getIntegrationDebugPerTenantLimitsConfiguration());
                systemParams.setConverterDebugPerTenantLimitsConfiguration(this.debugModeRateLimitsConfig.getConverterDebugPerTenantLimitsConfiguration());
            }
            systemParams.setMaxArgumentsPerCF(tenantProfileConfiguration.getMaxArgumentsPerCF());
            systemParams.setMaxDataPointsPerRollingArg(tenantProfileConfiguration.getMaxDataPointsPerRollingArg());
            systemParams.setTrendzSettings(this.trendzSettingsService.findTrendzSettings(currentUser.getTenantId()));
        }
        systemParams.setAvailableLocales(this.translationService.getAvailableLocaleCodes(tenantId, customerId));
        systemParams.setMobileQrEnabled(Optional.ofNullable(this.qrCodeSettingService.getMergedQrCodeSettings(tenantId)).map(QrCodeSettings::getQrCodeConfig).map(QRCodeConfig::isShowOnHomePage).orElse(false).booleanValue());
        return systemParams;
    }

    private boolean isForceFullscreen(SecurityUser currentUser) {
        return UserPrincipal.Type.PUBLIC_ID.equals((Object)currentUser.getUserPrincipal().getType()) || currentUser.getAdditionalInfo() != null && currentUser.getAdditionalInfo().has("defaultDashboardFullscreen") && currentUser.getAdditionalInfo().get("defaultDashboardFullscreen").booleanValue();
    }

    private JsonNode buildInfoObject() {
        ObjectNode infoObject = JacksonUtil.newObjectNode();
        if (this.buildProperties != null) {
            infoObject.put("version", this.buildProperties.getVersion());
            infoObject.put("artifact", this.buildProperties.getArtifact());
            infoObject.put("name", this.buildProperties.getName());
        } else {
            infoObject.put("version", "unknown");
        }
        infoObject.put("type", "PE");
        return infoObject;
    }
}

