/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.TbSecretDeleteResult;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.SecretId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.secret.Secret;
import org.thingsboard.server.common.data.secret.SecretInfo;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.secret.TbSecretService;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class SecretController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecretController.class);
    private final TbSecretService tbSecretService;

    @ApiOperation(value="Save or Update Secret (saveSecret)", notes="Create or update the Secret. When creating secret, platform generates Secret Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created Secret Id will be present in the response. Specify existing Secret Id to update the secret. Secret name is not updatable, only value could be changed. Referencing non-existing Secret Id will cause 'Not Found' error.\n\nSecret name is unique in the scope of tenant.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @PostMapping(value={"/secret"})
    public SecretInfo saveSecret(@Parameter(description="A JSON value representing the Secret.", required=true) @RequestBody @Valid Secret secret) throws Exception {
        secret.setTenantId(this.getTenantId());
        this.checkEntity((EntityId)secret.getId(), (TenantEntity)secret, Resource.SECRET);
        return this.tbSecretService.save(secret, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Update Secret Description", notes="Updates the description of the existing Secret by secretId. Only the description can be updated. Referencing a non-existing Secret Id will cause a 'Not Found' error.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @PutMapping(value={"/secret/{id}/description"})
    public SecretInfo updateSecretDescription(@Parameter(description="Unique identifier of the Secret to update", required=true) @PathVariable UUID id, @Parameter(description="New description for the Secret", example="Description") @RequestBody Optional<String> description) throws Exception {
        SecretId secretId = new SecretId(id);
        Secret secret = new Secret(this.checkSecretId(secretId, Operation.WRITE));
        secret.setDescription((String)description.orElse(null));
        return this.tbSecretService.save(secret, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Update Secret value", notes="Updates the value of the existing Secret by secretId. Referencing a non-existing Secret Id will cause a 'Not Found' error.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @PutMapping(value={"/secret/{id}/value"})
    public SecretInfo updateSecretValue(@Parameter(description="Unique identifier of the Secret to update", required=true) @PathVariable UUID id, @Parameter(description="New value for the Secret", example="Description", required=true) @RequestBody String value) throws Exception {
        SecretId secretId = new SecretId(id);
        Secret secret = new Secret(this.checkSecretId(secretId, Operation.WRITE));
        secret.setValue(value);
        return this.tbSecretService.save(secret, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Delete secret by ID (deleteSecret)", notes="Deletes the secret. Referencing non-existing Secret Id will cause an error.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @DeleteMapping(value={"/secret/{id}"})
    public ResponseEntity<TbSecretDeleteResult> deleteSecret(@PathVariable UUID id) throws ThingsboardException {
        SecretId secretId = new SecretId(id);
        SecretInfo secretInfo = this.checkSecretId(secretId, Operation.DELETE);
        TbSecretDeleteResult result = this.tbSecretService.delete(secretInfo, (User)this.getCurrentUser());
        return (result.isSuccess() ? ResponseEntity.ok() : ResponseEntity.badRequest()).body((Object)result);
    }

    @ApiOperation(value="Get Tenant Secret infos (getSecretInfos)", notes="Returns a page of secret infos owned by tenant. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/secrets"}, params={"pageSize", "page"})
    public PageData<SecretInfo> getSecretInfos(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the secret name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"name"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.SECRET, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return (PageData)this.checkNotNull((Object)this.secretService.findSecretInfosByTenantId(this.getTenantId(), pageLink));
    }

    @ApiOperation(value="Get Tenant Secret names (getSecretNames)", notes="Returns a page of secret names owned by tenant. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/secret/names"})
    public List<String> getSecretNames() throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.SECRET, Operation.READ);
        return (List)this.checkNotNull((Object)this.secretService.findSecretNamesByTenantId(this.getTenantId()));
    }

    @ApiOperation(value="Get Secret info by Id (getSecretInfoById)", notes="\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/secret/{id}/info"})
    public SecretInfo getSecretInfoById(@PathVariable UUID id) throws ThingsboardException {
        SecretId secretId = new SecretId(id);
        return this.checkSecretId(secretId, Operation.READ);
    }

    @ApiOperation(value="Get Secret info by name (getSecretInfoByName)", notes="\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/secret"})
    public SecretInfo getSecretInfoByName(@RequestParam String name) throws ThingsboardException {
        this.checkParameter("name", name);
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.SECRET, Operation.READ);
        return (SecretInfo)this.checkNotNull((Object)this.secretService.findSecretInfoByName(this.getTenantId(), name));
    }

    @ConstructorProperties(value={"tbSecretService"})
    @Generated
    public SecretController(TbSecretService tbSecretService) {
        this.tbSecretService = tbSecretService;
    }
}

