/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.JobManager;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.ReportId;
import org.thingsboard.server.common.data.id.ReportTemplateId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.job.Job;
import org.thingsboard.server.common.data.job.task.ReportTask;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.report.Report;
import org.thingsboard.server.common.data.report.ReportData;
import org.thingsboard.server.common.data.report.ReportInfo;
import org.thingsboard.server.common.data.report.ReportInfoQuery;
import org.thingsboard.server.common.data.report.ReportRequest;
import org.thingsboard.server.common.data.report.configuration.ReportTemplateConfig;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.report.service.TbReportService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.token.AccessJwtToken;
import org.thingsboard.server.service.security.system.SystemSecurityService;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api/v2"})
public class ReportController
extends BaseController {
    @Value(value="${reports.generation_timeout_ms:120000}")
    private int timeoutMs;
    private static final String REPORT_DESCRIPTION = "The platform uses Report to store generated reports information.";
    private static final String INVALID_REPORT_ID = "Referencing non-existing Report Id will cause 'Not Found' error.";
    public static final String REPORT_ID = "reportId";
    private final JobManager jobManager;
    private final TbReportService tbReportService;
    private final SystemSecurityService systemSecurityService;

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/report"})
    public Report createReport(@RequestPart MultipartFile file, @RequestPart String info) throws Exception {
        Report report = (Report)JacksonUtil.fromString((String)info, Report.class);
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.REPORT, Operation.CREATE, null, (TenantEntity)report);
        return this.reportService.createReport(report, file.getBytes());
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/report/{reportId}/download"})
    public ResponseEntity<ByteArrayResource> downloadReport(@PathVariable(value="reportId") UUID id) throws ThingsboardException {
        ReportId reportId = new ReportId(id);
        Report report = this.checkReportId(reportId, Operation.READ);
        byte[] data = this.reportService.getReportData(this.getTenantId(), reportId);
        ByteArrayResource resource = new ByteArrayResource(data);
        ContentDisposition cd = ContentDisposition.attachment().filename(report.getName(), StandardCharsets.UTF_8).build();
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{cd.toString()})).header("x-filename", new String[]{report.getName()})).contentLength(resource.contentLength()).header("Content-Type", new String[]{report.getFormat().getContentType()})).body((Object)resource);
    }

    @ApiOperation(value="Get Report (getReportById)", notes="Fetch the Report object based on the provided report Id. The platform uses Report to store generated reports information.Referencing non-existing Report Id will cause 'Not Found' error.\n\nAvailable for users with 'TENANT_ADMIN' authority.\n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/report/{reportId}"})
    public Report getReportById(@Parameter(description="A string value representing the report id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="reportId") String strReportId) throws ThingsboardException {
        this.checkParameter(REPORT_ID, strReportId);
        ReportId reportId = new ReportId(this.toUUID(strReportId));
        return this.checkReportId(reportId, Operation.READ);
    }

    @ApiOperation(value="Delete Report (deleteReport)", notes="Deletes the report. Referencing non-existing Report Id will cause 'Not Found' error.\n\n Security check is performed to verify that the user has 'DELETE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @DeleteMapping(value={"/report/{reportId}"})
    public void deleteReport(@Parameter(description="A string value representing the report id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="reportId") String strReportId) throws Exception {
        this.checkParameter(REPORT_ID, strReportId);
        ReportId reportId = new ReportId(this.toUUID(strReportId));
        this.checkReportId(reportId, Operation.DELETE);
        this.reportService.deleteReport(this.getTenantId(), reportId);
    }

    @GetMapping(value={"/reports"})
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    public PageData<Report> getReports(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Case-insensitive 'substring' filter based on report's name or customer title") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)") @RequestParam(required=false) String sortOrder, @AuthenticationPrincipal SecurityUser user) throws ThingsboardException {
        this.accessControlService.checkPermission(user, Resource.REPORT, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return this.reportService.findReportsByTenantId(user.getTenantId(), pageLink);
    }

    @GetMapping(value={"/reportInfos"})
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    public List<ReportInfo> getReports(@Parameter(description="A list of report ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string")), required=true) @RequestParam(value="strReportIds") String[] strReportIds) throws ThingsboardException {
        this.checkArrayParameter("strReportIds", strReportIds);
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ArrayList<ReportId> reportIds = new ArrayList<ReportId>();
        for (String strReportTemplateId : strReportIds) {
            reportIds.add(new ReportId(this.toUUID(strReportTemplateId)));
        }
        List reportInfos = (List)this.checkNotNull((Object)this.reportService.findReportInfoByIds(tenantId, reportIds));
        return this.filterReportTemplatesByReadPermission(reportInfos);
    }

    @GetMapping(value={"/reportInfos/all"})
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    public PageData<ReportInfo> getReportInfos(@Parameter(description="Report template id") @RequestParam(required=false) UUID reportTemplateId, @Parameter(description="The user used for report generation.") @RequestParam(required=false) UUID userId, @Parameter(description="Include customer or sub-customer entities") @RequestParam(required=false) Boolean includeCustomers, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Case-insensitive 'substring' filter based on report's name or customer title") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)") @RequestParam(required=false) String sortOrder, @AuthenticationPrincipal SecurityUser user) throws ThingsboardException {
        this.accessControlService.checkPermission(user, Resource.REPORT, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        ReportInfoQuery query = ReportInfoQuery.builder().reportTemplateId(reportTemplateId).userId(userId).includeCustomers(includeCustomers != null && includeCustomers != false).pageLink(pageLink).build();
        if (Authority.TENANT_ADMIN.equals((Object)this.getCurrentUser().getAuthority())) {
            return (PageData)this.checkNotNull((Object)this.reportService.findReportInfos(tenantId, query));
        }
        CustomerId customerId = this.getCurrentUser().getCustomerId();
        return (PageData)this.checkNotNull((Object)this.reportService.findReportInfos(tenantId, customerId, query));
    }

    @ApiOperation(value="Download test report (downloadTestReport)", notes="Generate and download test report.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/report/test"})
    public ResponseEntity<ByteArrayResource> testReportAndDownload(@RequestBody ReportRequest reportRequest) throws Exception {
        TenantId tenantId = this.getTenantId();
        UserId userId = StringUtils.isNotEmpty((String)reportRequest.getUserId()) ? new UserId(UUID.fromString(reportRequest.getUserId())) : this.getCurrentUser().getId();
        EntityId userOwnerId = this.ownersCacheService.getOwner(tenantId, (EntityId)userId);
        AccessJwtToken accessToken = this.systemSecurityService.createUserAccessToken(tenantId, userId);
        ReportTemplateConfig configuration = reportRequest.getReportTemplateConfig();
        if (configuration == null) {
            configuration = this.checkReportTemplateId(reportRequest.getReportTemplateId(), Operation.READ).getConfiguration();
        }
        ReportTask reportTask = ((ReportTask.ReportTaskBuilder)ReportTask.builder().tenantId(tenantId)).reportTemplateConfig(configuration).timezone(reportRequest.getTimezone()).userId(userId).userOwnerId(userOwnerId).originator(reportRequest.getOriginator()).accessToken(accessToken.getToken()).accessTokenExpirationTs(accessToken.getClaims().getExpiration().getTime()).build();
        Future future = this.tbReportService.generateTestReport(reportTask);
        try {
            ReportData reportData = (ReportData)future.get(this.timeoutMs, TimeUnit.MILLISECONDS);
            ByteArrayResource resource = new ByteArrayResource(reportData.getData());
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment;filename=\"" + reportData.getName() + "\""})).header("x-filename", new String[]{reportData.getName()})).contentLength(resource.contentLength()).contentType(MediaType.parseMediaType((String)reportData.getContentType())).body((Object)resource);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw new ThingsboardException("Timeout for test report generation. Generation took more than " + this.timeoutMs + " milliseconds!", ThingsboardErrorCode.GENERAL);
        }
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/report/request"})
    public Job requestReport(@RequestBody ReportRequest reportRequest) throws Exception {
        ReportTemplateId reportTemplateId = reportRequest.getReportTemplateId();
        if (reportTemplateId == null) {
            throw new IllegalArgumentException("Report template id must be specified");
        }
        this.checkReportTemplateId(reportTemplateId, Operation.READ);
        UserId userId = StringUtils.isNotEmpty((String)reportRequest.getUserId()) ? new UserId(UUID.fromString(reportRequest.getUserId())) : this.getCurrentUser().getId();
        TenantId tenantId = this.getTenantId();
        return (Job)this.jobManager.submitJob(Job.newReportJob().tenantId(tenantId).reportTemplateId(reportTemplateId).userId(userId).timezone(reportRequest.getTimezone()).originator(reportRequest.getOriginator()).targets(reportRequest.getTargets()).notificationTemplateId(reportRequest.getNotificationTemplateId()).build()).get();
    }

    private List<ReportInfo> filterReportTemplatesByReadPermission(List<ReportInfo> reportInfos) {
        return reportInfos.stream().filter(report -> {
            try {
                return this.accessControlService.hasPermission(this.getCurrentUser(), Resource.REPORT, Operation.READ, (EntityId)((ReportId)report.getId()), (TenantEntity)report);
            }
            catch (ThingsboardException e) {
                return false;
            }
        }).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"jobManager", "tbReportService", "systemSecurityService"})
    @Generated
    public ReportController(JobManager jobManager, TbReportService tbReportService, SystemSecurityService systemSecurityService) {
        this.jobManager = jobManager;
        this.tbReportService = tbReportService;
        this.systemSecurityService = systemSecurityService;
    }
}

